
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#define MAXITEMS 512

/* hotlist manager for Arachne WWW browser.
   MIME.CFG fragment:

file/edithotlist.dgi  >HTM|[100]HOTLSMAN.EXE $s>$2
file/makehotlist.dgi  >HTM|[100]HOTLSMAN.EXE -q $q>$2
file/hotlistmgr.dgi   >HTM|[100]HOTLSMAN.EXE $b>$2

*/


void append(FILE *co,FILE *kam)
{
 int c;
 while(1)
 {
  c=fgetc(co);
  if(feof(co))
   break;
  putc(c,kam);
 }
}

void cat(FILE *co)
{
 int c;
 while(1)
 {
  c=fgetc(co);
  if(feof(co))
   break;
  putc(c,stdout);
 }
}


void main(int argc,char **argv)
{
 if(argc<2)
 {
  puts("HOTLSMAN.EXE in_file.htm");
  puts("HOTLSMAN.EXE -q file_with_query_string");
 }
 else if(argc==2)
 {
  FILE *in;
  char str[1001];
  int i=0;

  in=fopen(argv[1],"rt");
  puts("<TITLE>Arachne Hotlist Manager</TITLE>\n<BODY>\n");
  puts("<H1>Arachne Hotlist Manager</H1><HR SIZE=4>\n");
  puts("Tip: Remove URL (Ctrl+Y) to remove Hotlist entry.<P>");
  puts("<FORM ACTION=\"makehotlist.dgi\">\n");
  printf("Output new hotlist to file: <INPUT NAME=filename VALUE=\"%s\" SIZE=40><BR>\n",argv[1]);
  printf("Keep link to Hotlist manager (works only in Arachne): <INPUT TYPE=CHECKBOX NAME=manager CHECKED><HR><PRE>");
  if(in)
  {
   while(i<MAXITEMS)
   {
    fgets(str,1000,in);
    if(feof(in))
     break;
    if(!strncmpi(str,"<LI><A HREF=",12))
    {
     char *title,*href=&str[13];
     char *ptr;

     title=href;
     while(*title && *title!='\"')
      title++;

     *title='\0';

     title+=2; // ..">
     ptr=title;

     while(*ptr && *ptr!='<')
      ptr++;

     *ptr='\0';

     printf("%04d.   URL=<INPUT SIZE=60 NAME=H VALUE=\"%s\">\n",i,href);
     printf("      Title=<INPUT SIZE=60 NAME=T VALUE=\"%s\"><P>\n",title);
     i++;
    }

   }//loop
  }

  puts("<HR>New entry (optional):");
  printf("%04d.   URL=<INPUT SIZE=60 NAME=H VALUE=\"\">\n",i);
  printf("      Title=<INPUT SIZE=60 NAME=T VALUE=\"\">\n");

  puts("</PRE><BR>\n");
  if(i==MAXITEMS)
   printf("<BIG>Warning: Hotlist is too long - max. number of items=%d.</BIG>\n",MAXITEMS);
  fclose(in);
  puts("<INPUT TYPE=SUBMIT VALUE=\"Write new hotlist\">");

 }
 else
 if(argc==3 && argv[1][1]=='q')
 {
  FILE *query,*http,*file,*mailto,*other,*tpl,*out=NULL;
  char str[1001];
  int i=0,m=0,f=0,o=0;
  char manager=0;
  char outfname[80]="STRANGE.HTM";

  query=fopen(argv[2],"rt");

  http=fopen("http.tmp","w+");
  mailto=fopen("mailto.tmp","w+");
  file=fopen("file.tmp","w+");
  other=fopen("other.tmp","w+");
  if(!query||!http||!mailto||!file||!other)
  {
   perror("Hotlist manager can't r/w");
   exit(0);
  }

  do
  {
   str[i]=fgetc(query);
   if(str[i]=='%')
   {
    char hex[5]="0x00";
    hex[2]=fgetc(query);
    hex[3]=fgetc(query);
    sscanf(hex,"%x",&str[i++]);
   }
   else
   if(str[i]=='&' || feof(query))
   {
    str[i]='\0';
    if(!strncmpi(str,"H=",2))
    {
     switch(toupper(str[2]))
     {
      case 'H':
      out=http;
      break;
      case 'M':
      out=mailto;
      m++;
      break;
      case 'F':
      out=file;
      f++;
      break;
      default:
      if(str[2])
       o++;
      out=other;
     }
     if(str[2])
     {
      fputs("<LI><A HREF=\"",out);
      fputs(&str[2],out);
      fputs("\">",out);
     }
     else
      out=NULL;
    }
    else
    if(!strncmpi(str,"T=",2) && out)
    {
     fputs(&str[2],out);
     fputs("</A>\n",out);
    }
    else
    if(!strncmpi(str,"filename=",9))
    {
     strncpy(outfname,&str[9],79);outfname[79]='\0';
    }
    else
    if(!strncmpi(str,"manager",7))
     manager=1;
    i=0;
   }
   else
    if(i<1000)i++;
  }
  while (!feof(query)); //!not terminated by \n

  fclose(query);

  out=fopen(outfname,"w+");
  if(!out)
  {
   puts("Undefined filename!");
   exit(0);
  }


  if(manager)
  {
   tpl=fopen("hot_mgr.htp","rt");
   i=fread(str,1,1000,tpl);
   str[i]='\0';
   fprintf(out,str,outfname);
  }
  else
  {
   tpl=fopen("hot_raw.htp","rt");
   append(tpl,out);
  }

  fputs("\n\n<!-- start of Hotlist Manager output -->\n\n",out);

  /*
  if(m)
   fputs("<H3><A HREF=\"#mailto\">eMail addresses</A></H3>\n",out);
  if(f)
   fputs("<H3><A HREF=\"#file\">Local and remote files, DGI scripts</A></H3>\n",out);
  if(o)
   fputs("<H3><A HREF=\"#other\">Other URLs</A></H3>\n",out);
  */

  fseek(other,0l,0);
  fseek(file,0l,0);
  fseek(mailto,0l,0);
  fseek(http,0l,0);

  fputs("<OL><A NAME=\"http\">Web pages | <A HREF=\"#mailto\">Addresses</A> | <A HREF=\"#file\">Files</A> | <A HREF=\"#other\">Other URLs</A><HR>\n",out);
  append(http,out);

  fputs("</OL><HR><OL><A NAME=\"mailto\"><A HREF=\"#http\">Web pages</A> | Addresses | <A HREF=\"#file\">Files</A> | <A HREF=\"#other\">Other URLs</A><HR>\n",out);
  if(m)
   append(mailto,out);

  fputs("</OL><HR><OL><A NAME=\"file\"><A HREF=\"#http\">Web pages</A> | <A HREF=\"#mailto\">Addresses</A> | Files | <A HREF=\"#other\">Other URLs</A><HR>\n",out);
  if(f)
   append(file,out);

  fputs("</OL><HR><OL><A NAME=\"other\"><A HREF=\"#http\">Web pages</A> | <A HREF=\"#mailto\">Addresses</A> | <A HREF=\"#file\">Files</A> | Other URLs<HR>\n",out);
  if(o)
   append(other,out);

  fputs("\n</OL><I>Generated by Hotlist Manager, (G)2000 xChaos software</I>\
	<br>(modified by glennmcc Nov 14, 2005)<HR>\n",out);

  fclose(other);
  fclose(file);
  fclose(mailto);
  fclose(http);

  fseek(out,0l,0);
//  printf("<ARACHNE RAW=\"file:%s\">\n",outfname);
  cat(out);
  fclose(out);
//  puts("<TITLE>Succes report.</TITLE><BODY>\n");
  printf("Hotlist Manager: <A HREF=\"%s\">%s</A> was succesfuly written.<HR>\n",outfname,outfname);
  unlink("http.tmp");
  unlink("mailto.tmp");
  unlink("file.tmp");
  unlink("other.tmp");
 }
 else
  puts("Weird error.");
}