#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <dir.h>
#include <alloc.h>
#include <time.h>
#include "cache.h"     //Derived from Arachne sources, for HTTPrecord [JdS]
#include "drvtypes.h"
#include "drvtypes.cpp"
#include "truename.cpp"
#include "messages.c"

//Last Modified - Vladimir Merlichenko 2006/08/23
//Restructured messages, for multi-lingual support

//Modified - Joe da Silva 2006/6/17
//Major tidy-up, a few corrections and bug fixes (particularly for
//code safety), restored "nocache" option for directory listings,
//dramatic speed increase for directory sorting. Fixed the directory
//splitting code, so greater than 'maxdiritems' items can be listed.

//Modified - xChaos, 1999-12-19
//added MP3/WAV/etc. ASF playlist creation - works nice with XTC player APM...
//added xcols variable controled by argv[3] - -x=640, etc.

/*
Arachne WWW browser utility - MIME.CFG fragment:
file/*                >HTM|[100]WWWMAN.EXE -d $1>$2
fastfile/*            >HTM|[100]WWWMAN.EXE -l $1>$2
file/cacheindex.dgi   >HTM|[110]WWWMAN.EXE -c $c>$2
file/galery.dgi       >HTM|[100]WWWMAN.EXE -g $S>$2
file/playlist.dgi     >ASF|[100]WWWMAN.EXE -p $S>$2
*/

unsigned _stklen = 40000u;

// The version number is now within the following two lines only :
// #define HEADSTRING "WWWman v1.91, Arachne cache and directory maintenance tool\n"
// #define FOOTSTRING "<br><b><small>This file generated by wwwman.exe v1.91<br>(Now being maintained by the Arachne Development team)</b>"

#define maxiconames 128
#ifdef UE
#define URLSIZE 400
#else
#define URLSIZE 512
#endif
//!!Udo: Dec 27, 2007 -- increase stringsize to 96
#ifdef UE
#define STRINGSIZE 48
#else
//!!Igor: Dec 29, 2007 -- increase to 255 (RFC max)
#define STRINGSIZE 255 //was 48
#endif
#define icontype_file 0
#define icontype_dir  1
#define icontype_drv  2
#define drive_fixed  0
#define drive_floppy 1
#define IS_FILE 0
#define IS_DIR  1
#define IS_ROOT 2
#define IS_DRIVES 3
//!!glennmcc: Jan 12, 2005 -- increase limit by 50%
#define maxdiritems 2000 //JdS : was 1536
//#define maxdiritems 1024
#define IMAGE_GALERY   1
#define AUDIO_PLAYLIST 2

typedef struct
//JdS : Commented-out most unused fields to save memory
{
 char name[9];
 char ext[5];
// unsigned char attr;
// int time;
// int date;
 long size;
 long descrowoffs;
} Tdiritem;

typedef Tdiritem Tdirarr[maxdiritems+2];

const char typechar[2]={'/','*'};

// JdS: 2006/5/06 {
// Fixed previously mutilated record structure :

struct HTTPrecord cacheitem;

/*  Replaced by header file from Arachne sources
struct HTTPrecord
{
 char URL[URLSIZE];    // Uniform Resource Locator
 int x;                // coordinates where the document was last displayed
 long y;               //
 long size;            // size in bytes
 char knowsize;        // logical - size is valid
 char mime[STRINGSIZE];// mime type
 char locname[80];     // full filename (after conversion to TXT,HTM,GIF,BMP)
 char rawname[80];     // full filename (before conversion)
 int handle;           // file handle
//!!glennmcc: begin Apr 10, 2002
//'postflag' is now 'dynamic' and moved to before 'lastseen'
 char dynamic;         // document is dynamic
// char postflag;        // it is result of operation post
 long lastseen;        // last seen time
//!!glennmcc: end
} cacheitem;
*/

// JdS: 2006/5/06 }

typedef struct Ticondef
{
 char id[16];
 char iconame[64];
};

Ticondef icondef[maxiconames];

int iconcnt = 0;
int defaulticon;
int defaultdiricon;
int defaultdriveicon;
int items;
int filecnt = 0;
int readasicons = 1;

//int tablecolumns = 5;
//#define tablecolumns 5
//Temporarly, read/calculated via mime.cfg call later
//saves some memmory for now
//Bernie 1999-06-17
#define MAXCFGFILENAME 64

char cfgfilename[MAXCFGFILENAME];
int drive;
int xcols=5; //how much <TD>s should be grouped in one <TR>
//int apick_histptr;
//Not in use anymore
//Bernie 1999-06-18
char ssdir[64];

//for image galery:
char galery = 0;
long jpegsize = 0l;

void getpathfromfilename(char *s, char *si)
{
 char *s1;
 Truename(s, si);
 s1 = strrchr(s, '\\');
 if (s1)
  s1[1] = 0;
}

void *mem_calloc(size_t size)
{
  void *ptr;
  ptr = calloc(1,size);
  if (ptr)
   return ptr;
  //!!JdS 2006/6/15 : Fix display format problem ...
   printf(cOUTOFMEM,
///  printf("Out of memory ! (alloc = %lu, coreleft = %lu)\n",
         (unsigned long) size, (unsigned long) coreleft());
  exit(128);
  return ptr;
}

void help()
{
 //snipped "history, " since that's not longer handled by wwwman
 //Also added my name, and changed to use printf() instead of puts()
 //Bernie 1999-06-17

 printf(cDOSINFO, cVER);
///
/*
 printf(HEADSTRING);
 printf("(G)1997 New Wave Microtechnology Ltd. Portions (G)1998,1999 Arachne Labs\n");
 printf("Portions (G)1999 Bernhard \"Bernie\" Eriksson\n");
 printf("[Now being maintained by the Arachne Development team]\n\n");
 printf("WWWman -c <cache_index>       converts cache index to HTML\n");
 printf("WWWman -d file:fullpathname   DOS directory, table, icons from WWWman.cfg\n");
 printf("WWWman -l file:fullpathname   DOS directory, text only\n\n");
 printf("Program writes to STDOUT; syntax is WWWMAN [options] > file\n\n");
 */
 exit(0);
}

void width20()
//Saves a few bytes
//Bernie 1999-06-18
{
 unsigned char i;
 printf("<TABLE WIDTH=100%>\n");
 for (i = 0; i < xcols; i++)
  printf("<TD WIDTH=%d%%>",100/xcols);
 printf("<TR>\n");
}

void delmessage()
//Saves a few bytes
//Bernie 1999-06-18
{
 printf(cFASTDEL);
/// printf("<ARACHNE MSG=\"Fast delete: right-click local file name and press <Delete> key...\">");
}

char *strtrim(char *s)
{
 int t;
 char *s1;
 for (t = strlen(s) - 1; t > 0; t--)
 {
  if (s[t] <= ' ')
   s[t] = 0;
  else
   break;
 }
 s1 = s;
 while (s1[0] <= ' ')
  s1++;
 if (s1 != s)
  memmove(s, s1, strlen(s1) + 1);
 return s;
}

void storesetup(char *s)
{ char *s1,*s2;
  if (!s)
   return;
  if (s[0]==0)
   return;
  strupr(s);
  strcat(s,"&");
  strcpy(ssdir,"");
  s1=s;
  while (s1[0])
  {
   s2=strchr(s1,'&');
   if (s2)
    {s2[0]=0; s2++;}
   else
    {s2=s1; s1[0]=0;}
   if (strncmp(s1,"READAS=",7)==0)
   {
    if (strncmp(s1+7,"LIST",4)==0)
     readasicons=0;
    else
     if (strncmp(s1+7,"ICON",4)==0)
      readasicons=1;
   }
   else
    if (strncmp(s1,"DIR=",4)==0)
     {strcpy(ssdir,s1+4);}
   s1=s2;
  }
}

void readcfgfile()
{
 FILE *f;
 char s[256];
 char *s1;

 iconcnt = 0;
 defaulticon = -1;
 defaultdiricon = -1;
 defaultdriveicon = -1;
 f = fopen(cfgfilename, "r");
 if (!f)
  return;
//Perhaps this should be handled somewhere
//Bernie 1999-06-17
 do
 {
  fgets(s, 256, f);
  if (feof(f))
   break;
  strtrim(s);
  if (s[0] == ';')
   continue;
  if (!s[0])
   continue;
     //if (s[0]=='$'){handlecfgvar(s);continue;}
  s1 = strchr(s, ' ');
  if (!s1)
   continue;
  s1[0] = 0;
  s1++;
//  strtrim(s);
  strupr(strtrim(s));
//  strtrim(s1);
  strlwr(strtrim(s1));

//Put things together (and in the fastest order)
//Bernie 1999-06-17

  strncpy(icondef[iconcnt].id, s, 16);
  strncpy(icondef[iconcnt].iconame, s1, 64);
  if (strcmpi(s, ".*") == 0)
   defaulticon = iconcnt;
  else if (strcmpi(s, "/DIR") == 0)
    defaultdiricon = iconcnt;
  iconcnt++;
  if (iconcnt >= maxiconames)
   break;
 }
 while (!feof(f));
 if (defaultdiricon == - 1)
  defaultdiricon = defaulticon;
 if (defaultdriveicon == - 1)
  defaultdriveicon = defaultdiricon;
 fclose(f);
}

int geticoname(char *iconame,char *fn,int type,int defi)
{
  int t,sl1,sl2,ofs;
  char fname[16];
  char *s;
  if (!type)
    strncpy(fname,fn,14);
  else
  {
    strncpy(fname+1,fn,13);
    if (type>1)
      fname[0]='*';
    else
      fname[0]='/';
  }
  strcpy(iconame,"");
  sl1=strlen(fname);
  ofs=0;
  if (type)
    ofs++;
  for (t=0;t<iconcnt;t++)
  {
    sl2=strlen(icondef[t].id+ofs);
    if (sl2>sl1)
      continue;
    s=fname;
    s+=strlen(fname);
    s-=sl2;
    if ((type==0)||(icondef[t].id[0]==typechar[type-1]))
      if (strcmpi(icondef[t].id+ofs,s)==0)
      {
        strcpy(iconame,icondef[t].iconame);
        return 1;
      }
  }
  if (defi)
  {
    if (type==2)
    {
      if (defaultdriveicon>=0)
      {
	strcpy(iconame,icondef[defaultdriveicon].iconame);
        return 1;
      }
    }
    if (type)
    {
      if (defaultdiricon>=0)
      {
        strcpy(iconame,icondef[defaultdiricon].iconame);
        return 1;
      }
    }
    if (defaulticon>=0)
    {
      strcpy(iconame,icondef[defaulticon].iconame);
      return 1;
    }
  }
  return 0;
}

// BGCOLOR=BLACK TEXT=WHITE LINK=#00FF00

void HTMLheader(char *title, char *bs)
{
 //Made this a bit nicer to look at
 //Also changed from <BODY%s into <BODY %s (and all calling functions was
 //changed)
 //Bernie 1999-06-17

// char s[256];
/// printf("<HTML><HEAD><TITLE>%s\n", title);
 printf(cTITLE1, title);
// strcpy(s, title);
// puts(s);
 printf("</TITLE></HEAD><BODY %s>\n", bs);
//!!glennmcc: begin Apr 10, 2002
//!!glennmcc: June 30, 2002.... removed, bad idea :(
// printf("<ARACHNE NOCACHE>\n");  //!!JdS : Re-instated ... good idea! <g>
//!!glennmcc: end
}

void HTMLfooter()
{
 printf("</BODY></HTML>");
}

void cache(char *fn)
{
//!!glennmcc: Begin Dec 15, 2002  added '*d' to prevent listing of deleted cache items
 FILE *f,*d;
 int listed=0,len;
 char iconame[64];
 char *ptr;

 HTMLheader("Cache index", "ARACHNE");

 delmessage();
//  printf("<ARACHNE MSG=\"Fast delete: right-click local file name and press <Delete> key...\">");
 puts(cCACHEINX);
/// puts("<FONT SIZE=6 3D>Index of Arachne WWW cache</FONT>");
 // switchicons("cacheindex.dgi",0)
  printf(cINDXNAME, fn);
/// printf("<HR SIZE=4>Cache index filename: %s<HR>\n", fn);

 printf("<ARACHNE NOCACHE>\n"); //!!glennmcc: Dec 15, 2002 --- don't cache the cache.idx listing

 f=fopen(fn,"rb");
 if (!f)
 {
  printf(cOPENERR, fn);
///  printf("<FONT COLOR=#FF0000>Error opening file '%s'</FONT>\n",fn);
 }
 else
 {
  while (!feof(f))
  {
   if (fread(&len,2,1,f)==1)
   {
    if (sizeof(struct HTTPrecord)==len)   //!!JdS (true length is best;-)
    {
     if (fread(&cacheitem,len,1,f)==1 &&
         cacheitem.URL[0] &&
         strcmpi(cacheitem.locname,"NUL"))
     {
      ptr=strrchr(cacheitem.locname,'\\');
      if (ptr)
       geticoname(iconame,ptr+1,0,1);
      else
       strcpy(iconame,"UNKNOWN.IKN");

      //!!glennmcc: Begin Dec 15, 2002
      d=fopen(cacheitem.locname,"rt");
      if (d) // if item has been fast-deleted,
      {//don't list it in cache index display
       fclose(d);//!!glennmcc: Dec 15, 2002

       printf("\n\
<A HREF=\"%s\">\
<IMG ALIGN=LEFT SRC=\"%s\" BORDER=0>\n\
</U>&nbsp;<U>%s</A><P>\
&nbsp;<FONT SIZE=-2>%s | %ld %s | %s | \
<A HREF=\"file:%s\" REMOVABLE>%s</A></FONT>\
<BR CLEAR=ALL><BR>\n",
	      cacheitem.URL,iconame,cacheitem.URL,
              ctime((time_t *)(&cacheitem.lastseen)),
              cacheitem.size,cBYTES,cacheitem.mime,
              cacheitem.locname,cacheitem.locname);
       listed++;
      }//!!glennmcc: end Dec 15, 2002
     }
    }
    else
    {
     printf(cINCPVER);
///     printf("<H1>Incompatible version!</H1>");
     exit(0);
    }
   }//end if
  }//loop
  printf(cLSTCACHE, listed);
///  printf("<HR><I>(%d cached documents listed)</I>\n",listed);
  printf(cFOOTLINE1, cVER);
  printf(cFOOTLINE2);
  fclose(f);
 }
 HTMLfooter();
}


void switchicons(char *ds, char pics, char allowgallery)
{
 strlwr(ds);
 //Moved the content of the puts() statments
 //Bernie 1999-06-18
 printf("<TABLE CELLSPACING=0 CELLPADDING=0><TD NOWRAP><Form action=\"arachne:internal-config?reload:file:%s\">\n", ds);

 //LocalIcons variable renamed to FILEargs, values changed to -d|-l
 printf("<input type=hidden name=\"FILEargs\" value=\"");
 if (pics)
  printf(cDIS);
///  printf("-l\"><input type=submit value=\"Dis");
 else
  printf(cEN);
///  printf("-d\"><input type=submit value=\"En");

 puts(cABLEIKN);
/// puts("able icons \">");

 if (allowgallery &&
     (strstr(ds, ".*"  ) || strstr(ds, ".gif") || strstr(ds, ".jpg") ||
      strstr(ds, ".png") || strstr(ds, ".ikn") || strstr(ds, ".bmp") ||
      strstr(ds, ".jpe")))
//Added support for .jpe
//Bernie 1999-06-18
 {
#ifdef RON
  char *rs='\0';
#endif
  if (allowgallery == 2)
   printf("<TR>");
  printf("<TD NOWRAP><form action=\"galery.dgi\">\n<input type=hidden name=\"DIR\" value=\"%s\">\n", ds);
  printf(cBIMGSGALL);
//!!glennmcc: Mar 07, 2007
#ifdef RON
  printf(rs,ds);
  strrev(rs);
  do strcpy(rs,rs+1); while(rs[0]!='\\');
  strrev(rs);
  printf("\n<TD NOWRAP><form action=\"rongalery.dgi\">\n<input type=hidden value=\"%s\">\n", rs);
  printf(cBIMGSGALL);
#endif
//!!glennmcc: end
//  printf("<input type=submit value=\"Image gallery \">");
 }

//added playlist creation, xChaos, 1999-06-20
 if (allowgallery &&
     (strstr(ds, ".*"  ) || strstr(ds, ".mp2") || strstr(ds, ".mp3") ||
      strstr(ds, ".wav") || strstr(ds, ".mod") || strstr(ds, ".xm") ||
      strstr(ds, ".s3m")))
 {
  if (allowgallery == 2)
   printf("<TR>");
  printf("<TD NOWRAP><form action=\"playlist.dgi\">\n<input type=hidden name=\"DIR\" value=\"%s\">\n", ds);
  printf(cBPLAYLST);
///  printf("<input type=submit value=\"Audio playlist\">");
 }

//  if(allowgallery==2)
//   puts("<TR>");
//  if(strstr(ds,"*.*"))
//  {
//   printf("\
//<TD NOWRAP><form action=\"file:\">\n\
//<input type=submit value=\"View only HTML\">\n",ds);
//  }
//  else

 puts("</TABLE>");
}

void handledrives(char *mask,int pics)
{
 int t, t1;
// int dt;
//Not longer in use, uses t1 instead
//Bernie 1999-06-17
 char getlabel;
 char s[128], s1[32];
 char cmos;
 char cm;
 char ico[12];
 char iconame[64];
 int fixed;
 char *ptr;
 ffblk ff;
 puts(cDRIVES);
/// puts("<TABLE CELLSPACING=0 CELLPADDING=0><TD WIDTH=76%><FONT 3D SIZE=6>Accessible drives</FONT><TD WIDTH=24%>");
 switchicons(mask,pics,0);
 printf("</TABLE><HR");
//Moved "<HR" up from belove
//Bernie 1999-06-17
 if (pics)
 {
  printf(" SIZE=4><BASEFONT SIZE=-2>");
  width20();
//   printf(" SIZE=4><BASEFONT SIZE=-2><TABLE WIDTH=100%>");
//   <TD WIDTH=20%><TD WIDTH=20%><TD WIDTH=20%><TD WIDTH=20%><TD WIDTH=20%>
//   printf("<TR>\n");
 }
 else
  puts("><UL>");

 outportb(0x70, 0x10);
 cmos = inportb(0x71);
 for (t = 1; t < 0x1b; t++)
 {
  t1=getdrivetype(t);
  if (!t1)
   continue;
  switch (t1)
  {
   case dt_hdd: strcpy(s1, cHDD);/// "Hard disk");
      strcpy(ico,"FIXED"  );
      fixed=drive_fixed;
      getlabel=1;
      break;
   case dt_flp: strcpy(s1,cFLOPPY);/// "Floppy ");
      strcpy(ico, "FLOPPY" );
      fixed = drive_floppy;
      getlabel = 0;
      cm = 0;
      if (t == 1)
       cm = cmos >> 4;
      else if (t == 2)
       cm = cmos & 0x0f;
      if (t <= 2)
      {
       switch (cm)
       {
        case 0x01: strcpy(s1, cFL_5_360); break; /// 21 Aug. 2006: VBM: sorry, here I can't keep originals.
        case 0x02: strcpy(s1, cFL_5_1_2); break;
        case 0x03: strcpy(s1, cFL_3_720 ); break;
        case 0x04: strcpy(s1, cFL_3_1_4); break;
        case 0x05: strcpy(s1, cFL_3_2_8); break;
        default: strcpy(s1, ""); continue;
       }
      }
/*      else
      strcpy(s1, "");*/
      break;
   case dt_net: strcpy(s1, cNETDRV);
      strcpy(ico,"NET"    );
      fixed=drive_fixed;
      getlabel=1;
      break;
   case dt_cdr: strcpy(s1, cCD_ROM);
      strcpy(ico,"CDROM"  );
      fixed=drive_fixed;
      getlabel=0;
      break;
   case dt_dbl:
   case dt_st4: strcpy(s1, cSTACKER);
      strcpy(ico,"STACKER");
      fixed=drive_fixed;
      getlabel=1;
      break;
   case dt_sub: strcpy(s1, cSUBST);
      strcpy(ico,"SUBST"  );
      fixed=drive_fixed;
      getlabel=1;
      break;
   case dt_ram: strcpy(s1, cRAMDRV);
      strcpy(ico,"RAM"    );
      fixed=drive_fixed;
      getlabel=1;
      break;
  } //switch
/*   if (dt==dt_flp)
  {
   cm=0;
   if (t==1)
    cm=(cmos>>4);
   else if (t==2)
    cm=cmos;
   cm&=0x0f;
   if (t<=2)
   {
    switch (cm)
    {
     case 0x01: strcpy(s1,"5.25\" 360 KB");break;
     case 0x02: strcpy(s1,"5.25\" 1.2 MB");break;
     case 0x03: strcpy(s1,"3.5\" 720 KB");break;
     case 0x04: strcpy(s1,"3.5\" 1.44 MB");break;
     case 0x05: strcpy(s1,"3.5\" 2.88 MB");break;
     default: strcpy(s1,"");continue;
    }
   }
  }
*/
  strcpy(s,"@:\*.*");
  s[0] += t;
  if (!getlabel || findfirst(s,&ff,FA_LABEL))
   ff.ff_name[0]=0;
  ptr = strchr(ff.ff_name,'.');
  if (ptr)
   memmove(ptr, ptr + 1, strlen(ptr));

  if (getlabel)
   sprintf(s," %s",ff.ff_name);
  else
   sprintf(s," (%s)",drvtypename[t1]);

  t1 = 0;

  if (pics)
  {
   if (items%xcols==0)
    printf("<TR>\n");
   printf("<TD ALIGN=CENTER>");
   t1 = geticoname(iconame, ico, icontype_drv, 0);
   if (!t1)
   {
    if (fixed == drive_fixed)
     t1 = geticoname(iconame, ico, icontype_drv, 0);
    else
     t1 = geticoname(iconame, "FLOPPY", icontype_drv, 0);
    if (!t1)
     t1 = geticoname(iconame, ico, icontype_drv, 1);
   }
   printf("<A HREF=\"%c:\\*.*\">", '@' + t);
   if (t1)
    printf("<IMG SRC=\"%s\" BORDER=0><BR>", iconame);
   else
    printf("<I>&lt;%s&gt;</I><BR>", ico);
   printf("<B>%c:</B></A>%s<BR><I>%s</I>\n", '@' + t, s, s1);
   items++;
  }
  else
  {
   printf("<LI><A HREF=\"%c:\\*.*\">%c: %s</A> <I>%s</I>\n", '@' + t, '@' + t, s, s1);
  }
  //if (getlabel)rowputplainstr(_getdcwd(t,s,127),GREEN,0);
 }
 if (pics)
  printf("</TABLE>\n");
 else
  printf("</BIG></UL>\n");
 puts(cBOTTOM);
/// puts("<HR><BASEFONT SIZE=3><SMALL>GNUpyright (G)1999 Arachne Labs. Goto <A HREF=\"file://home.htm\">Arachne desktop</A>. See also <A HREF=\"file://help.htm\">Arachne documentation</A>.");
 printf(cFOOTLINE1, cVER);
 printf(cFOOTLINE2);
}

void galeryhead(void)
{
#ifdef EXP
 printf("<BR><A REMOVABLE HREF=\"");
#else
 printf("<HR><A REMOVABLE HREF=\"");
#endif
}

void putdiritem(char *n, char *e, int dir, char *path, int pics, long size, char *mask)
{
 int t1;
 char iconame[64];
 char name[16];
 if (n[0] == 1)
  n[0] = '.';
 strlwr(path);
 strcpy(name, n);
 strcat(name, e);
 //if (dir)strupr(name); else
 //No more CAPS on directories from 1.50
 strlwr(name);

 if (galery)
 {
  if (dir == IS_FILE)
  {
   if (galery==IMAGE_GALERY)
   {
    if (!strcmpi(e,".jpg") || !strcmpi(e,".png") || !strcmpi(e,".jpe"))
    {
//Fixed bug if the max JPGborder (500000l) is reached with an early image.
//The rest will still be displayed.
//Also .jpe are also usable now (they come from Linux/Win .jpeg)
//Bernie 1999-06-17
     items++;
     //jpegsize+=size;
     galeryhead();
     printf(cCONVERT, name, name, size, cBYTES);
///     printf("%s\">%s</A> (converted; original size %ld bytes)<BR>", name, name, size);
//!!glennmcc: Mar 02, 2007 -- increased to 50megs for very large image galeries
     if (jpegsize + size < 50000000L)
//     if (jpegsize + size < 500000L)
      printf("<IMG SRC=\"%s\">\n", name);
     else
      puts(c2MANYCNV);
///      puts("[Too many converted images]");
     jpegsize += size;
    //Moved line
    }
    else if (!strcmpi(e,".gif") || !strcmpi(e,".bmp"))
    {
     items++;
     galeryhead();
     printf(cREALSIZE, name, name, size, cBYTES);
///     printf("%s\">%s</A> (real size %ld bytes)",name,name,size);
     printf("<BR><IMG SRC=\"%s\">\n",name);
    }
    else if (!strcmpi(e,".ikn")) //for IBASE icons only:
    {
     items++;
     galeryhead();
     printf(cIKNS, name, name, size, cBYTES);
///     printf("%s\">%s</A> (Arachne icon; real size %ld bytes)",name,name,size);
     if (size>4500)
      printf("<BR><IMG SRC=\"%s\" HEIGHT=100>\n",name);
     else
      printf("<BR><IMG SRC=\"%s\">\n",name);
    }
   }
   else //audio playlist
    if (!strcmpi(e,".mp2") || !strcmpi(e,".mp3") || !strcmpi(e,".wav") ||
	!strcmpi(e,".mod") || !strcmpi(e,".xm") || !strcmpi(e,".s3m"))
    {
     printf("file://%s%s\n",path,name);
    }
  }//end if IS_FILE
 }
 else
  if (!pics)
  {
//JdS {
// printf("<LI><A REMOVABLE HREF=\"");
   if ((dir==IS_DRIVES) || (dir==IS_ROOT))
    printf("<LI><A REMOVABLE HREF=\"");
   else
    printf("<LI><A NAME=\"%s\" REMOVABLE HREF=\"",name);
//JdS }
   if (dir==IS_DRIVES)
    printf("@:*.*\">\\\\</A>\n");
   else if (dir==IS_ROOT  )
    printf("%c:\\%s\">%c:\\</A>\n",'@'+drive,mask,'@'+drive);
   else if (dir==IS_DIR   )
    printf("%s\\%s\"><B>%s\\</B></A>\n",name,mask,name);
   else
    printf("%s\">%s</A> (%ld %s)", name, name, size, cBYTES);
///    printf("%s\">%s</A> (%ld bytes)",name,name,size);
  }
  else
  {
   if (items%xcols==0)
    printf("<TR>\n");
//JdS {
// printf("<TD ALIGN=CENTER><A REMOVABLE HREF=\"");
   if ((dir==IS_DRIVES) || (dir==IS_ROOT))
    printf("<TD ALIGN=CENTER><A REMOVABLE HREF=\"");
   else
    printf("<TD ALIGN=CENTER><A NAME=\"%s\" REMOVABLE HREF=\"",name);
//JdS }
   if (dir==IS_DRIVES)
    printf("@:*.*\">");
   else if (dir==IS_ROOT  )
    printf("%c:\\%s\">",'@'+drive,mask);
   else if (dir==IS_DIR   )
    printf("%s\\%s\">",name,mask);
   else
    printf("%s\">",name);
   printf("<IMG BORDER=0 SRC=\"");
   if (dir==IS_DRIVES)
   {
    t1=geticoname(iconame,"//",1,1);
    printf("%s\"><BR>\\\\",iconame);
   }
   else if (dir==IS_ROOT)
   {
    t1=geticoname(iconame,"\\",1,1);
    printf("%s\"><BR>%c:\\",iconame,'@'+drive);
   }
   else if (dir==IS_DIR)
   {
    t1=geticoname(iconame,name,1,1);
    printf("%s\"><BR>%s\\",iconame,name);
   }
   else
   {
    t1=geticoname(iconame,name,0,1);
    printf("%s\"><BR>%s",iconame,name);
   }
   printf("</A>\n");
   items++;
  }
}

//!!JdS 2006/6/17 {
//  Replaced infamous "bubble sort" algorithm with much, much faster
//  "Shell sort" algorithm, based on example code by Peter Grogono :

//void sortdirectory(Tdirarr *dir,int cnt)
//{
//  int t,swp;
////  int va1,va2
////These are unused
////Bernie 1999-06-18
//  int va3,va4;
//  Tdiritem d;
//  do
//  {
//    swp=0;
//    for (t=0;t<cnt-1;t++)
//    {
//      //va1=(*dir)[t  ].attr&FA_DIREC;
//      //va2=(*dir)[t+1].attr&FA_DIREC;
//      va3=strcmpi((*dir)[t].name,(*dir)[t+1].name);
//      va4=strcmpi((*dir)[t].ext,(*dir)[t+1].ext);
//      if /*(va2>va1)||((va2==va1)&&(va4>0))||((va2==va1)&&*/
//          ((va4>0)||((va4==0)&&(va3>0)))
//      {
//        memcpy(&d,&(*dir)[t],sizeof(d));
//        memcpy(&(*dir)[t],&(*dir)[t+1],sizeof(d));
//        memcpy(&(*dir)[t+1],&d,sizeof(d));swp++;
//      }
//    }
//  } while (swp>0);
//}

void swapdir (Tdirarr *dir, int d1, int d2)
{
  Tdiritem temp;

  memcpy(&temp, &(*dir)[d1], sizeof(temp));
  memcpy(&(*dir)[d1], &(*dir)[d2], sizeof(temp));
  memcpy(&(*dir)[d2], &temp, sizeof(temp));
} //swapdir

int greater (Tdirarr *dir, int d1, int d2)
{
  int va3,va4;

  va3 = strcmpi((*dir)[d1].name, (*dir)[d2].name);
  va4 = strcmpi((*dir)[d1].ext, (*dir)[d2].ext);
  return ((va4>0) || ((va4==0)&&(va3>0)));
} //greater

void sortdirectory (Tdirarr *dir, int cnt)
{
  int jump, m, n;
  char done;

  jump = cnt;
  while (jump > 1)
  {
    jump = jump / 2;
    do
    {
      done = 1;
      for (m = 0; m < (cnt-jump); m++)
      {
        n = m + jump;
        if (greater(dir,m,n))
        {
          swapdir(dir,m,n);
          done = 0;
        } //if
      } //for
    } while (!done);
  } //while
} //sortdirectory

//!!JdS 2006/6/17 }

/*
void assigndesctodir(Tdirarr *dir,int cnt,FILE *fdesc)
{
  char s[256];
  char *s1;
  int t;
  int end;
  long offs;
  end=0;
  fseek(fdesc,0,SEEK_SET);
  do
  {
    offs=ftell(fdesc);
    fgets(s,255,fdesc);
    if (feof(fdesc))
      end=1;
    if (s[0]>' ')
    {
      s1=strchr(s,' ');
      if (s1)
        s1[0]=0;
      s1=strchr(s,'.');
      if (s1)
        {s1[0]=0;s1++;}
      else
        s1=strchr(s,0);
      for (t=0;t<cnt;t++)
      {
        if (s[0]==(*dir)[t].name[0])
          if ((strcmpi(s,(*dir)[t].name)==0) &&
              (strcmpi(s1,(*dir)[t].ext+1)==0))
          {
	    (*dir)[t].descrowoffs=offs;
            break;
          }
      }
    }
  } while (end==0);
}*/

void adddir(Tdirarr *dir,ffblk *ff,int cnt)
{
  char *s1;
//  printf("\nDIAG:%s\n",(*ff).ff_name);
  if (ff->ff_name[0]!='.')
  {
    s1=strchr(ff->ff_name,'.');
    if (s1)
      strcpy((*dir)[cnt].ext,s1);
    else
      strcpy((*dir)[cnt].ext,"");
    if (s1)
      s1[0]=0;
  }
  else
  {
    ff->ff_name[0]=1;
    strcpy((*dir)[cnt].name,ff->ff_name);
    strcpy((*dir)[cnt].ext,"");
  }
  strcpy((*dir)[cnt].name,ff->ff_name);
  (*dir)[cnt].size=ff->ff_fsize;
//  (*dir)[cnt].attr=ff->ff_attrib;  //JdS
//  (*dir)[cnt].time=ff->ff_ftime;   //JdS
//  (*dir)[cnt].date=ff->ff_fdate;   //JdS
  (*dir)[cnt].descrowoffs=-1;
}

void startfilelist(char *filename)
{
     puts("<TD COLSPAN=2>");
     switchicons(filename,1,2);
     printf("<TR><TD COLSPAN=%d><HR><TR>\n",xcols);
     items=0;
}

void readdirectory(char *filename, int pics)
{
 int d, t, t1;
 int done;
 int part; //JdS
// long totsize;
// long totcnt;
// int fcnt;
//All these are unused
//Bernie 1999-06-17
// char s[128];
 char sa[256];
 char path[128];
// char *bufin;
 char *s1;
// int isroot = 0;
//Changed Bernie 1999-06-18
 char isroot = 0;

 char *mask;
 ffblk ff;
// Tdiritem dr;
 Tdirarr *dir;
// FILE *fdesc;
//int usedesc;

 mask = strrchr(filename, '\\');
 if (!mask)
  mask = strrchr(filename, ':');
 if (!mask)
  mask = filename;
 else
  mask++;

 putdiritem("", "", IS_DRIVES, "", pics, 0l, mask);

// totsize=0;
// totcnt=0;
//!!JdS 2006/6/15 {
//This memory allocation was dangerous, since it allocated less than
//the theoretical amount required, further it assumed no padding :
// dir = (Tdirarr*)mem_calloc(maxdiritems * sizeof(Tdiritem));
 dir = (Tdirarr*) mem_calloc(sizeof(Tdirarr));
//!!JdS 2006/6/15 }
// usedesc=1;
// isroot = 0;
  //bufin=NULL; fdesc=NULL;
  //usedesc=1; if (pics) usedesc=0;
/*
 if (usedesc)
 {
  strcpy(sa,htmldocinfo.filename);
  s1=strrchr(sa,'\\');
  if (s1)
   s1++;
  else
  {
   s1=strchr(sa,':');
   if (s1)
    s1++;
   else
    s1=sa;
  }
  strcpy(s1,filedescname1);
  fdesc=fopen(sa,"rb");
  if (!fdesc)
  {
   strcpy(s1,filedescname2);
   fdesc=fopen(sa,"rb");
   if (!fdesc)
    {strcpy(s1,filedescname3);fdesc=fopen(sa,"rb");}
  }
 }
 if (!fdesc)usedesc=0;
 else
 {
  bufin=(char*)mem_calloc( 4096);
  if (bufin)
   setvbuf(fdesc,bufin,_IOFBF, 4096);
 }
*/
//  strcpy(s,filename);
//  s1=strrchr(s,'\\'); if (s1) s1[1]=0; t=0;
 for (d = 0; d < 2; d++)
 //d = 0 -> Searches for directories
 //d = 1 -> Searches for files
 {
//   fcnt=0;
  strcpy(sa, filename);
  if (d == 0)
  {
   s1 = strrchr(sa, '\\');
   if (!s1)
    s1 = strrchr(sa, ':');
   if (s1)
    s1++;
   if (!s1)
    s1 = sa;
   s1[0] = 0;
   strcpy(path, sa);
   strcpy(s1, "*.*");
  }
  part = 0; //JdS
  done = findfirst(sa, &ff, 0xff - FA_LABEL - (d * FA_DIREC));
  while (!done)
  {
//   printf("DEBUG: file found");
   t = 0;   //!!JdS 2006/6/18 : moved down, into this 'while' loop
   part++; //JdS
   while ((!done) && (t < maxdiritems))
   {
    if (strcmp(ff.ff_name, "."))
    {
     if (((d == 0) && (ff.ff_attrib&FA_DIREC)) || (d == 1))
     {
      adddir(dir, &ff, t);
      t++;
     }
    }
    else
     isroot = 1;
//!!JdS 2006/6/18 {
//Restructured/rewrote end of 'while' loop code ...
//  if (t >= maxdiritems)
//   break;
//  if (d==0)
//   ff.ff_attrib = FA_DIREC;
//  done = findnext(&ff);
    if (!done)
     done = findnext(&ff);
   } //while
//!!JdS 2006/6/18 }

   sortdirectory(dir, t);  //!!JdS 2006/6/16: moved up, so we always sort!

//!!JdS 2006/6/18 {
//Moved 'if' block down, out from the above 'while' loop & modified.
//Added "split heading" for extra-long ( > maxdiritems ) listings.
//!!glennmcc: Jan 12, 2005 -- turn icons off if more than 500 (was 512) items
   if ((t>500) && (pics))  //JdS
   {
    printf(cAUTOFFIKN);
///    printf("</table><b>More than 500 items... Icons auto-disabled for this directory.</b><br>");
    pics=0;
   }
//glennmcc: end
   if (part > 1)
    printf(cSPLITDIR,part);
///    printf("<TD><B>============ split directory listing (part %u) ============</B><BR>",part);
//!!JdS 2006/6/18 }

// if (usedesc) assigndesctodir(dir,t,fdesc);

   if (!done && (filecnt < maxdiritems))  //JdS - only write this message once
   {
//!!JdS 2006/6/18 {
//Restored original code here (with corrected spelling)...
/*
//!!glennmcc: Jan 12, 2005 -- break if too many items
    printf("<TD><B>Ugh! Unbelievably large directory."
           " Only listing the first %d items.</B>",maxdiritems);
    break;
*/
    printf(c2BIGDIR);
///    printf("<TD><B>Ugh! Unbelievably large directory, list will be split!</B>");
//  items++;
//!!glennmcc: end
//!!JdS 2006/6/18 }
   }

//   if ((d==0)&&(fcnt<=maxdiritems)&&(*dir)[0].name[0]=='.')
   if (isroot)
   {
    strncpy(sa, path, 2);
    if (sa[1] != ':')
     sa[0] = 0;
    else
     sa[2] = 0;
    putdiritem("\\", "", IS_ROOT, sa, pics, 0l, mask);
   }
   else
    if (pics && d == 0)
     startfilelist(filename);
   for (t1 = 0; t1 < t; t1++)
   {
    putdiritem((*dir)[t1].name, (*dir)[t1].ext, 1 - d, path, pics, (*dir)[t1].size, mask);
    if (t1 == 0 && isroot && pics)
    {
     startfilelist(filename);
     isroot = 0;
    }
    else
     filecnt++;
   } //for
  } //while   //!!JdS 2006/6/18 : moved down, to include the above 'for' loop
 } //for
 free(dir);
//  if (bufin) free(bufin);
//  if (usedesc) fclose(fdesc);
} //readdirectory

long localdiskspace(int drive)
{
  struct dfree d;
  getdfree( drive, &d );
  return((long)d.df_avail*(long)d.df_bsec*(long)d.df_sclus);
}

char *diskspacestr(char *s,int drive)
{
  long l;
  l=localdiskspace(drive);
  l>>=10;
/*
  sprintf(s,"%3li,%03li,%03li",(l%1000000000L)/1000000L,(l%1000000L)/1000L,l%1000L);
  if ((s[3]==',')&&(s[2]=='0'))
    s[3]='0';
  if ((s[7]==',')&&(s[6]=='0'))
    s[7]='0';
  strtrim(s);
*/
  sprintf(s,"%ld",l);
  while (s[0]=='0')
    s++;
  return s;
}

void handledirs(char *ds,int pics)
{
 ffblk ff;
 char *s;
 char path[128];
 char s1[32];//, s2[32];

 if (ds[1]==':')
  drive=(toupper(ds[0])-'@');
 else
  drive=getdisk()+1;


 strcpy(s1,"@:\*.*");s1[0]+=drive;
 if (findfirst(s1,&ff,FA_LABEL))
  ff.ff_name[0]=0;
 s=strchr(ff.ff_name,'.');
 if (s)
  memmove(s,s+1,strlen(s));

 strcpy(path,"?:\\");
 path[0]='@'+drive;
 getcurdir(drive,path+3);

 if (ds[1]==':')
  strlwr(&ds[2]);
 else
  strlwr(ds);
 strlwr(&path[1]);

 if (galery)
 {
//   printf("<BASE HREF=\"file:%s\">",ds);
  if (galery==IMAGE_GALERY)
   printf(cIMGSGALL);
///   printf("<FONT SIZE=6 3D>Image gallery</FONT>\n");
 }
 else
 {
  char realpath[128];

  if (ds[1]==':')
   strcpy(realpath,ds);
  else if (ds[1]=='\\')
   sprintf(realpath,"%c:%s",'@'+drive,ds);
  else
   sprintf(realpath,"%s\\%s",path,ds);

  HTMLheader(realpath, "ARACHNE NORESIZE");
//   puts("<ARACHNE MSG=\"Fast delete: right-click file name and press <Delete> key...\">");
  delmessage();

//
//Check for .htm .txt .jpg .jpe and .gif was remomved by me
//xChaos 1999-06-20
//sorry Bernie, I don't like it ;-))) I will explain you my reasons in
//the e-mail

/*
//Check for .htm .txt .jpg .jpe and .gif added by me

//Bernie 1999-06-18

  if (strstr(realpath, "*.htm"))
   strcpy(realpath,"HTML files");
  else if (strstr(realpath,"*.txt"))
   strcpy(realpath,"Text files");
  else if (strstr(realpath,"*.jpg") || strstr(realpath, "*.jpe"))
   strcpy(realpath,"JPEG files");
  else if (strstr(realpath,"*.gif"))
   strcpy(realpath,"GIF files");
  else
*/

  if (strstr(realpath,"*.acf"))
   strcpy(realpath,cAR_ACFS);
  else if (strstr(realpath,"*.asf"))
   strcpy(realpath,cAR_ASFS);
  else if (strstr(realpath,"*.apm"))
   strcpy(realpath,cAR_APMS);
  else if (strstr(realpath,"*.log"))
   strcpy(realpath,cAR_LOGS);

/*
  if (strstr(realpath,"*.acf"))
   strcpy(realpath,"Arachne Profiles");
  else if (strstr(realpath,"*.asf"))
   strcpy(realpath,"Arachne Scripts");
  else if (strstr(realpath,"*.apm"))
   strcpy(realpath,"Arachne Packages");
  else if (strstr(realpath,"*.log"))
   strcpy(realpath,"Log files");
*/
  printf("<FONT SIZE=6 3D>%s</FONT>\n",realpath);
  if (!pics)
  {
   puts("<HR SIZE=4>");
   switchicons(ds,0,1);
  }
 }

 if (galery!=AUDIO_PLAYLIST)
 {
  puts("<BASEFONT SIZE=-2>");
  if (pics)
  {
   puts("<P><TABLE WIDTH=100% BORDER FRAME=void CELLSPACING=4>");
   printf(cHEADER,
///   printf("<TD WIDTH=18%%>Current path<TD WIDTH=44%%>%s\n<TD WIDTH=18%%>Volume<TD WIDTH=20%%>%s\n\<TR><TD>File mask<TD><B>%s</B>\n<TD>Free space<TD>%s KB</TABLE>\n",
          path,ff.ff_name,ds,diskspacestr(s1,drive));

   width20();
//    puts("<TABLE WIDTH=100%>");
//    <TD WIDTH=20%><TD WIDTH=20%><TD WIDTH=20%><TD WIDTH=20%><TD WIDTH=20%>
//    printf("<TR>");
  }
  else
  {
   printf(cHEADER2,
///   printf("<HR>Path: %s<BR>\nVolume: %s<BR>\nMask: <B>%s</B><BR>\nFree space: %s KB\n",
          path,ff.ff_name,ds,diskspacestr(s1,drive));
   if (!galery)
    puts("<HR><UL>");
  }
 }

 readdirectory(ds,pics);

 if (galery!=AUDIO_PLAYLIST)
 {
  if (pics)
   printf("</TABLE>\n");else printf("</UL>\n");
  if (!galery)
   items=filecnt;
  printf(cLISTED,items);
///  printf("<HR><I>(%d items listed)</I>\n",items);
  printf(cFOOTLINE1, cVER);
  printf(cFOOTLINE2);
 }
} //handledirs

//!!glennmcc: Oct 17, 2006 -- added nocache as 3rd argument
//to use ExpireDynamic to determine
//whether or not to cache the dir listings
//0==always cache ... >0==nocache
void dirlist(char *fspec, int pics, int nocache)
{
 char s[256];
 char drives = 0;
//!!glennmcc: Oct 17, 2006 -- nocache when ExpireDynamic is non-zero
 if(nocache) printf("<arachne nocache>\n");
//!!glennmcc: end
 if (strstr(fspec, "@:"))
  drives = 1;
 items = 0;
//  puts(fspec);
 if (galery)
 {
  if (galery==IMAGE_GALERY)
  {
   sprintf(s, cNUMOFIMGS, fspec);
   HTMLheader(s, "BGCOLOR=BLACK TEXT=WHITE LINK=LIME");
  }
 }
 else
  if (drives)
  {
   sprintf(s, cACCESDRVS);
   HTMLheader(s, "ARACHNE NORESIZE");
  }

 if (drives)
  handledrives(fspec, pics);
 else
  handledirs(fspec, pics);

 if (galery==AUDIO_PLAYLIST)
  printf("file://%s\n",fspec); //terminate ASF file - go back to the listing!
 else
  HTMLfooter();
}

/*
void dirlist(char *fspec,int pics)
{
 char s[256];
 char drives=0;
 if (strstr(fspec,"@:"))
  drives=1;

//  puts(fspec);
 if (galery)
 {
  sprintf(s,"Picture galery of %s",fspec);
  HTMLheader(s," ARACHNE");
 }
 else
  if (drives)
  {
   sprintf(s,"Accessible drives");
   HTMLheader(s," ARACHNE NORESIZE");
  }
 items=0;
 if (drives)
  handledrives(fspec,pics);
 else
  handledirs(fspec,pics);
 HTMLfooter();
}
*/

/*
Not in use anymore
Bernie 1999-06-17
void gethistory(char *s)
{
 struct ArachnePick
 {
  char graphics[16];//last video mode
  char GUIstyle;    //0-menu vpravo, 1-menu nahore
  char language[9]; //*.MSG File name
  long cachesize;   //velikost HTTP cache
  int  history;     //ukazatel do souboru TADYJSEM.BYL
 } apick;

 FILE *f;
 char sn[256];
 apick_histptr=0;
 strcpy(sn,s);strcat(sn,"arachne.pck");
 f=fopen(sn,"rb");
 if (!f)
  return;
 fread(&apick,sizeof(apick),1,f);
 apick_histptr=apick.history;
 fclose(f);
}
*/

void ftpdir(char *filename)
{
 FILE *f;
 char str[256],*ptr;
 char head=1;
 int count=0;

 f=fopen(filename,"rt");
 if (!f)
 {
  puts(cCNTRDIR);
///  puts("Cannot read directory listing.");
//!!JdS 2006/5/6 : Disabled (can't close a null stream pointer) ...
//  fclose(f);//!!glennmcc: May 29, 2002. added to be sure the file gets closed
  return;
 }
 puts(cHDRFTPDIR);
/// puts("<H1>FTP directory</H1><BASEFONT SIZE=1><TT>");

 while (1)
 {
  fgets(str,250,f);
  if (feof(f))
   break;
//!!glennmcc: Feb 03, 2006 -- added || str[3]==' 'for this situation...
/*
230-some text
250 more text
*/
  if (((*str=='2' || *str=='5') && (str[3]=='-' || str[3]==' '))
//added =='5' for 'permission denied' message
      || *str=='\n') //for messages with 'empty lines' such-as...
/*
(found at ... ftp://ftp.cdrom.com:21/.2/simtelnet/ )
230-some text

230-more text

230-some text

250 more text
*/
//  if (*str=='2' && str[3]=='-') //normal Unix //original simgle line
//!!glennmcc: end
  {
//!!glennmcc: Feb 03, 2005 -- if there are 'empty lines', remove them
   if (*str!='\n')
//!!glennmcc: end
   {
    puts(&str[4]);
    puts("<BR>");
   }
  }
  else
   if (*str==' ' && str[1]=='2') //for Windows NT...
   {
    puts(&str[5]);
    puts("<BR>");
   }
   else
   {
    if (head)
    {
     printf("</TT><HR><PRE>");
     head=0;
    }

    ptr=strrchr(str,'\n');
    if (ptr)
     *ptr='\0';

    if (!strncmpi(str,"total",5))
     ptr=NULL;
    else
     ptr=strrchr(str,' ');
    if (ptr)
    {
//!!glennmcc: Oct 17, 2007 -- add trailing slash for Microsoft FTP server
// format which contains '<DIR>' within the line instead of the permissions
// at the start of the line.
if (*str=='d' || *str=='D' || *str=='l' || *str=='L' || strstr(str,"<DIR>"))
//     if (*str=='d' || *str=='D' || *str=='l' || *str=='L')
      strcat(str,"/");
     *ptr='\0';
     ptr++;
    }
    printf(str);
//!!glennmcc: begin May 29, 2002
//only create a link if permissions are shown at the start of the line
//   if (ptr)
    if (ptr && (*str=='d' || *str=='D' || *str=='l' || *str=='L' || *str=='-'
//!!glennmcc: Oct 15, 2007 -- for Microsoft FTP server
// which does not include permisions but rather has the date
// at the start.... 08-15-2007
// so... look for_____^<-- a dash in the 3rd position
    || str[2]=='-'))
//!!glennmcc: end
    {
     printf(" <A HREF=\"%s\">%s</A>\n",ptr,ptr);
     count++;
    }
    else
     printf("\n");
   }

 } //while
 fclose(f);
 printf("</PRE>");
 printf(cLISTED, count);
/// printf("</PRE><HR><I>(%d items listed)</I>\n",count);
 printf(cFOOTLINE1, cVER);
 printf(cFOOTLINE2);

}


void main(int argc, char *argv[])
{
 char *s;
 char progpath[MAXCFGFILENAME + 10];
 //for progpath + "wwwman.cfg"
 //Bernie 1999-06-17

//!!glennmcc: Oct 17, 2006
 int nocache;
//!!glennmcc: end

//  printf("%s...%s...%s\n\r",argv[0],argv[1],argv[2],argv[3]);
//  if (argc<3) help();
//I put the check more together (one line now)
//Bernie 1999-06-17
 if ((argc < 3) || ((argv[1][0] != '-') && (argv[1][0] != '/')))
  help();
 getpathfromfilename(progpath, argv[0]);
 strcpy(cfgfilename, progpath);
 strcat(cfgfilename, "wwwman.cfg");
 s = argv[2];
 if (strncmpi(s, "FILE:", 5) == 0)
  s += 5;

 if (strncmpi(argv[3], "-x=", 3) == 0)
  xcols=atoi(&(argv[3][3]))/120;

//!!glennmcc: Oct 25, 2006 -- use new keyword 'CacheDirList
//to determine whether or not to cache the dir listings
//defaults to cached if CacheDirList line is missing from arachne.cfg
//see companion code in misc.c of SRC for core.exe
if(toupper(argv[1][2])=='N') nocache=1; else nocache=0;
//!!glennmcc: end

 switch (toupper(argv[1][1]))
 {
  case 'C': readcfgfile();cache(s);break;
  case 'D': readcfgfile();dirlist(s,readasicons,nocache);break;
  case 'I': readcfgfile();dirlist(s,1,nocache);break;
  case 'G': storesetup(s);galery=IMAGE_GALERY;dirlist(ssdir,0,nocache);break;
//the Audio Playlist was done this way to allow things like file sorting, etc.
  case 'P': storesetup(s);galery=AUDIO_PLAYLIST;dirlist(ssdir,0,nocache);break;
  case 'L': dirlist(s,0,nocache);break;
  case 'F': ftpdir(s);break;
  default:  help();break;
 }
//getch();
 exit(0);
}