#include <dos.h>
#include <stdio.h>
#include "drvtypes.h"

#ifdef RUSSIAN
#ifdef KOI8R
const char drvtypename[9][13]={"  ",
                               "",
                               "",
                               "",
                               "",
                               " DS",
                               "",
                               "",
                               "RAM"};
#endif
#ifdef CP1251
const char drvtypename[9][13]={"  ",
                               "Ƹ",
                               "",
                               "",
                               "",
                               " DS",
                               "",
                               "",
                               "RAM"};
#endif
#endif

#ifdef ENG
const char drvtypename[9][13]={"Non-existent",
                               "Fixed",
                               "Floppy",
                               "Network",
                               "CD-ROM",
                               "DoubleSpaced",
                               "SUBSTed",
                               "Stacker",
                               "RAM"};
#endif

int chkABforSTK=0;

typedef struct{long startsect;
               int  cnt;
               int  bufoffs;
               int  bufseg;}CtrlBlk25;

int drverr;

int chkStk4(char drive)
{ CtrlBlk25 cb;
  char boot[512];
  register int r;
  cb.startsect=0;cb.cnt=1;cb.bufoffs=FP_OFF(boot);cb.bufseg=FP_SEG(boot);
  drive--;
  r=0;
  asm{push ds;mov al,drive;or chkABforSTK,0;jnz j1;
      cmp al,1;ja j1;sub al,al;jmp q;}
  j1:;
  asm{push ss;pop ds;
      lea bx,cb;
      sub ax,ax;mov al,drive;
      sub cx,cx;dec cx;
/*
//!!glennmcc: begin Dec 31, 2002
//new routine by Michal H. Tyc (eMail message at the end of this file)
  push bp;                // I didn't test whether MS-DOS 7.10 trashes bp...
  int 0x25;               // read logical sector
  pop si;                 // throw away the flags saved by INT
  pop bp;                 // bp points to the local variables on the stack
  lea si, [boot + 0x1f0]; // this doesn't modify any flags
  sub al, al;             // al = 0
  jc q;                   // an error occured during int 0x25

/*
      mov si,sp;
      int 0x25;
      cli;mov sp,si;sti;
      pushf;
      lea si,boot;add si,0x1f0;sub al,al;
      popf;jc q;
*/
//!!glennmcc: end


//!!glennmcc: begin Nov 17, 2003 --- update provided By Michal again :)
//By the way, I found an error in my old WWWMAN patch (DRVTYPES.CPP):
//new routine by Michal H. Tyc (eMail message at the end of this file)
  push bp;                // I didn't test whether MS-DOS 7.10 trashes bp...
  int 0x25;               // read logical sector
  pop si;                 // throw away the flags saved by INT
  pop bp;                 // bp points to the local variables on the stack
  lea si, [boot + 0x1f0]; // this doesn't modify any flags
//**BEGIN mht 2003-11-17
//sub al, al;
  mov al, 0;
//**END   mht 2003-11-17
  jc q;                   // an error occured during int 0x25
//I missed the fact that 'sub al, al' (left from original code)
//will modify flags anyway, so an error will never be detected.
//Shame on me!
//Please add this to your cleaned WWWMAN code.
//!!glennmcc: end

      cmp word ptr ds:[si]   ,0x13cd;jnz q;
      cmp word ptr ds:[si][2],0x14cd;jnz q;
      cmp word ptr ds:[si][4],0x01cd;jnz q;
      cmp word ptr ds:[si][6],0x03cd;jnz q;
      mov al,1;
     }
  q:;
  asm{pop ds;xor ah,ah;mov r,ax;}
  return r;
}

int iscdrom(char drive)
{ int r;
  asm{mov ax,0x1500;//chk4 CDROM
      sub bx,bx;
      int 0x2f;
      or bx,bx;
      jz j2;
      mov ax,0x150b;
      sub ch,ch;
      mov cl,drive;
      dec cl;
      int 0x2f;
      cmp bx,0xadad;jne j2;
      or ax,ax;     jz j2;
      mov ax,dt_cdr;
      jmp q;}
  j2:;asm{xor ax,ax;}
  q:;asm{mov r,ax;}
  return r;
}

int issubst(char drive)
{ int r;
  asm{mov ax,0x4409;//chk4SUBST
      mov bl,drive;
      int 0x21;    jc j2;
      test dh,0x80;jz j2;
      mov ax,dt_sub;
      jmp q;}
  j2:;asm{xor ax,ax;}
  q:;asm{mov r,ax;}
  return r;
}

int isdblsp(char drive)
{ int r;
  asm{mov ax,0x4a11;mov bx,1;
      mov dl,drive;dec dl;
      int 0x2f;
      sub cl,cl;
      or ax,ax;    jnz j2;
      cmp dl,bl;   je  j2;
      test bl,0x80;jz  j2;
      inc dl;
      cmp drive,dl;jne j2;
      mov ax,dt_dbl;
      jmp q;}
  j2:;asm{xor ax,ax;}
  q:;asm{mov r,ax;}
  return r;
}

int isnet(char drive)
{ int r;
  asm{mov ax,0x4409;mov bl,drive;
      int 0x21;     jc jerr;
      and dx,0x1000;jz j2;
      mov ax,dt_net;
      jmp q;}
  jerr:;//asm{mov ax,1;mov drverr,ax;}
  drverr=1;
  j2:;asm{xor ax,ax;}
  q:;asm{mov r,ax;}
  return r;
}

int isfloppy(char drive)
{ int r;
  asm{mov ax,0x4408;mov bl,drive;
      int 0x21;     jc jerr;
      or al,al;     jnz j2;
      mov ax,dt_flp;jmp q;}
  jerr:;asm{mov ax,1;mov drverr,ax;}
  j2:;asm{xor ax,ax;}
  q:;asm{mov r,ax;}
  return r;
}

int isram(char drive)
{ int r;
  asm{push ds;
      mov ax,ss;mov ds,ax;
      mov si,sp;sub sp,0x28;mov dx,sp;
      mov ax,0x440d;
      mov cx,0x860;
      mov bl,drive;
      int 0x21;
      mov sp,si;
      pop ds;
      mov ax,dt_ram;jc q;
      mov ax,dt_hdd;jmp q;
      xor ax,ax;}
  q:;asm{mov r,ax;}
  return r;
}

int getdrivetype(char drive)
{ drverr=0;
  if(iscdrom(drive))return dt_cdr;
  if(issubst(drive))return dt_sub;
  if(isdblsp(drive))return dt_dbl;
  if(isnet  (drive))return dt_net;
  if(drverr)        return dt_err;
  if(chkStk4(drive))return dt_st4;
  if(isfloppy(drive))return dt_flp;
  return isram(drive);
}

/*void main()
{ int t,t1;
  printf("\n");
  for(t=1;t<0x1b;t++){t1=getdrivetype(t);
                      if(t1)printf(" %c: %s drive\n",t+'@',drvtypename[t1]);}
  printf("\n");
}*/

/*
From: "Michal H. Tyc" <mhtyc@if.pwr.wroc.pl>
Organization: Institute of Physics, Wroclaw Univ. Tech., Poland
Date: Mon, 30 Dec 2002 15:41:09 +0100
X-Mailer: Arachne V1.70;rev.3
To: arachne@arachne.cz
Subject: WWWMAN bug
MIME-Version: 1.0
Content-type: text/plain; charset=ISO-8859-2
Content-transfer-encoding: 8bit
Sender: owner-arachne@arachne.cz
Precedence: bulk
Reply-To: arachne@arachne.cz

Hi Glenn, Hi all,

On Mon, 23 Dec 2002 19:42:29 -0500, Glenn McCorkle wrote:

>  mov si,sp;
>  int 0x25;
>  cli;mov sp,si;sti;
>  pushf;
>  lea si,boot;add si,0x1f0;sub al,al;
>  popf;jc q;

> Now..... how do we re-write ths section of drvtypes.cpp so that
> we CAN look for stacker drives WITHOUT locking-up the machine ????

I suuggest just a small change:

  push bp;                // I didn't test whether MS-DOS 7.10 trashes bp...
  int 0x25;               // read logical sector
  pop si;                 // throw away the flags saved by INT
  pop bp;                 // bp points to the local variables on the stack
  lea si, [boot + 0x1f0]; // this doesn't modify any flags
  sub al, al;             // al = 0
  jc q;                   // an error occured during int 0x25

I haven't tested the above code yet, but it should work.

Greetings,

Michal

*/