
#include <stdio.h>
#include <string.h>
#include <process.h>

#define HEADER "Invented by Dev Teelucksingh - written by Arachne Labs, GNUpyright(G)1998-2000"

void TAGradio(char *name,char *value,char *test,FILE *f)
{
 fprintf(f,"<INPUT TYPE=RADIO NAME=\"%s\" VALUE=\"%s\"",name,value);
 if(test && !strcmpi(value,test))
  fprintf(f," CHECKED");
 fprintf(f,">\n");
}

void HTMLwrite(char *filename,char *port, char *base, char *irq)
{
 FILE *f=fopen(filename,"w");
 if(f)
 {
  fputs("<HTML><HEAD><TITLE>Arachne PPP Wizard - modem settings</TITLE></HEAD>\n",f);
  fputs("<BODY BACKGROUND=\"SETUP.GIF\" TEXT=BLACK BGCOLOR=BLACK>\n\n",f);
  fputs("<BR><TABLE CELLSPACING=8 BORDER FRAME=\"void\" WIDTH=450 ALIGN=CENTER>\n",f);
  fputs("<TD BGCOLOR=SILVER ALIGN=RIGHT NOWRAP><FONT 3D=2><B>",f);
  fputs("Arachne PPP Wizard - modem settings\n",f);
  fputs("&nbsp;<A HREF=\"file://setup.htm\"><IMG SRC=\"file://pidizrus.ikn\" HEIGHT=16 WIDTH=16 BORDER=0>",f);
  fputs("<TR><TD BGCOLOR=WHITE>\n",f);

  if(port)
   fputs("Modem was detected on following serial port - if you don't understand it, it will be probably ok :-)\n",f);
  else
   fputs("Modem not found - please enter settings of serial port where your modem is connected. Winmodems are not supported, sorry...\n",f);

  fputs("<TR><TD BGCOLOR=SILVER><FORM ACTION=\"arachne:internal-config?file://system/gui/wizard2.ah\">\n",f);
  fputs("<TABLE><TD>\n",f);
TAGradio("Port","1",port,f);
fputs("<TD COLSPAN=3>COM1 (IRQ 4, Base 0x3f8 = \"/dev/ttyS0\")\n<TR><TD>",f);
TAGradio("Port","2",port,f);
fputs("<TD COLSPAN=3>COM2 (IRQ 3, Base 0x2f8 = \"/dev/ttyS1\")\n<TR><TD>",f);
TAGradio("Port","3",port,f);
fputs("<TD COLSPAN=3>COM3 (IRQ 4, Base 0x3e8 = \"/dev/ttyS2\")\n<TR><TD>",f);
TAGradio("Port","4",port,f);
fputs("<TD COLSPAN=3>COM4 (IRQ 3, Base 0x2e8 = \"/dev/ttyS3\")\n<TR><TD>",f);
TAGradio("Port","0",port,f);
fputs("<TD COLSPAN=3>Non-standard serial port:\n",f);
fprintf(f,"<TR><TD><TD>Irq:\n\
<TD><INPUT SIZE=6 TYPE=TEXT NAME=\"Irq\" VALUE=\"%s\">\n\
<TD><FONT COLOR=BLACK> (2,3,4,5,7,9,10,11,12)\n\
<TR><TD><TD><FONT COLOR=BLACK>\n\
Base\n\
<TD><INPUT SIZE=6 TYPE=TEXT NAME=\"Base\" VALUE=\"%s\">\n\
<TD><FONT COLOR=BLACK> (0x3f8,0x2f8,0x3e8, 0x2e8, ...)\n\
</TABLE>\n",irq,base);

 fputs("<TABLE ALIGN=RIGHT CELLSPACING=0 CELLPADDING=0 WIDTH=80><TD><INPUT TYPE=SUBMIT VALUE=\"Continue >>\"></TABLE>\n",f);
 fputs("<TABLE CELLPADDING=0 CELLSPACING=0><TD>&nbsp;<FORM ACTION=\"file://system/gui/wizard1.ah\"><TD><INPUT TYPE=SUBMIT VALUE=\"<< Previous\">",f);

  fputs("\n</TABLE></TABLE></BODY></HTML>\n",f);
 }
 else
  perror(filename);
}

int main(int argc,char **argv)
{
 int errlvl;
 char *port,*base,*irq;

 if(argc==3 && argv[1][1]=='m')
 {
  HTMLwrite(argv[2],NULL,"\0","\0");
  exit(0);
 }

 if(argc==2 && argv[1][1]=='l')
 {
  if(strlen(argv[0])<32)
   exit(1);
  else
   exit(0);
 }


 puts("Arachne modem detection wizard\n");
 puts(HEADER);
 puts("Uses COMTOOL.COM utility by K.H.Weiss <khweis1@mvmhp.ciw.uni-karlsruhe.de>\n");
 puts("Arachne is now trying to detect your modem; this may crash your system.");
 puts("If you are already wathing this screen for more than 5 minutes, it means");
 puts("that autodection failed and you have to press Reset button and restart Arachne.");
 puts("In this case, please send your modem settings to <xchaos@arachne.cz>");

 port="2";
 base="0x2f8";
 irq="3";
 printf("\nDetecting modem on standard COM2(0x2f8/IRQ 3)...");
 errlvl=spawnl(P_WAIT,"COMTOOL.COM","COMTOOL.COM","2f8","3","ATH0","^CR","^w40","OK","^",NULL);
 if(errlvl==1) goto found;

 port="1";
 base="0x3f8";
 irq="4";
 printf("\nDetecting modem on standard COM1(0x3f8/IRQ 4)...");
 errlvl=spawnl(P_WAIT,"COMTOOL.COM","COMTOOL.COM","3f8","4","ATH0","^CR","^w40","OK","^",NULL);
 if(errlvl==1) goto found;

 port="3";
 base="0x3e8";
 irq="4";
 printf("\nDetecting modem on standard COM3(0x3e8/IRQ 4)...");
 errlvl=spawnl(P_WAIT,"COMTOOL.COM","COMTOOL.COM","3e8","4","ATH0","^CR","^w40","OK","^",NULL);
 if(errlvl==1) goto found;

 port="0";
 base="0x3e8";
 irq="5";
 printf("\nDetecting modem on alternative COM3(0x3e8/IRQ 5)...");
 errlvl=spawnl(P_WAIT,"COMTOOL.COM","COMTOOL.COM","3e8","5","ATH0","^CR","^w40","OK","^",NULL);
 if(errlvl==1) goto found;

 port="4";
 base="0x2e8";
 irq="3";
 printf("\nDetecting modem on standard COM4(0x2e8/IRQ 3)...");
 errlvl=spawnl(P_WAIT,"COMTOOL.COM","COMTOOL.COM","2e8","3","ATH0","^CR","^w40","OK","^",NULL);
 if(errlvl==1) goto found;

 port="0";
 base="0x2e8";
 irq="2";
 printf("\nDetecting modem on alternative COM4(0x2e8/IRQ 2)...");
 errlvl=spawnl(P_WAIT,"COMTOOL.COM","COMTOOL.COM","2e8","2","ATH0","^CR","^w40","OK","^",NULL);
 if(errlvl==1) goto found;

 port="0";
 base="0x2e8";
 irq="5";
 printf("\nDetecting modem on alternative COM4(0x2e8/IRQ 5)...");
 errlvl=spawnl(P_WAIT,"COMTOOL.COM","COMTOOL.COM","2e8","5","ATH0","^CR","^w40","OK","^",NULL);
 if(errlvl==1) goto found;

 port="2";
 base="0x2f8";
 irq="3";
 printf("\nDetecting unitialized modem on standard COM2(0x2f8/IRQ 3)...");
 errlvl=spawnl(P_WAIT,"COMTOOL.COM","COMTOOL.COM","2f8","3","ATZ","^CR","^w40","OK","^",NULL);
 if(errlvl==1) goto found;

 port="1";
 base="0x3f8";
 irq="4";
 printf("\nDetecting unitialized modem on standard COM1(0x3f8/IRQ 4)...");
 errlvl=spawnl(P_WAIT,"COMTOOL.COM","COMTOOL.COM","3f8","4","ATZ","^CR","^w40","OK","^",NULL);
 if(errlvl==1) goto found;

 port="3";
 base="0x3e8";
 irq="4";
 printf("\nDetecting unitialized modem on standard COM3(0x3e8/IRQ 4)...");
 errlvl=spawnl(P_WAIT,"COMTOOL.COM","COMTOOL.COM","3e8","4","ATZ","^CR","^w40","OK","^",NULL);
 if(errlvl==1) goto found;

 port="0";
 base="0x2e8";
 irq="10";
 printf("\nDetecting modem on alternative COM4 (0x2e8/IRQ 10)...");
 errlvl=spawnl(P_WAIT,"COMTOOL.COM","COMTOOL.COM","2e8","10","ATH0","^CR","^w40","OK","^",NULL);
 if(errlvl==1) goto found;

 port="0";
 base="0x2e8";
 irq="7";
 printf("\nDetecting modem on alternative COM4 (0x2e8/IRQ 7)...");
 errlvl=spawnl(P_WAIT,"COMTOOL.COM","COMTOOL.COM","2e8","7","ATH0","^CR","^w40","OK","^",NULL);
 if(errlvl==1) goto found;

 port="0";
 base="0x3f8";
 irq="2";
 printf("\nDetecting modem on alternative (historical ?) COM1 (0x3f8/IRQ 2)...");
 errlvl=spawnl(P_WAIT,"COMTOOL.COM","COMTOOL.COM","3f8","2","ATH0","^CR","^w40","OK","^",NULL);
 if(errlvl==1) goto found;

 port="0";
 base="0x3e8";
 irq="7";
 printf("\nDetecting modem on alternative COM3 (0x3e8/IRQ 7)...");
 errlvl=spawnl(P_WAIT,"COMTOOL.COM","COMTOOL.COM","3e8","7","ATH0","^CR","^w40","OK","^",NULL);
 if(errlvl==1) goto found;

 port="0";
 base="0x3e8";
 irq="10";
 printf("\nDetecting modem on alternative COM3 (0x3e8/IRQ 10)...");
 errlvl=spawnl(P_WAIT,"COMTOOL.COM","COMTOOL.COM","3e8","10","ATH0","^CR","^w40","OK","^",NULL);
 if(errlvl==1) goto found;

 port="0";
 base="0x2e8";
 irq="11";
 printf("\nDetecting modem on alternative COM4 (0x2e8/IRQ 11)...");
 errlvl=spawnl(P_WAIT,"COMTOOL.COM","COMTOOL.COM","2e8","11","ATH0","^CR","^w40","OK","^",NULL);
 if(errlvl==1) goto found;

 port="0";
 base="0x3e8";
 irq="11";
 printf("\nDetecting modem on alternative COM3 (0x3e8/IRQ 11)... [Note: this is nonstandard IRQ!]");
 errlvl=spawnl(P_WAIT,"COMTOOL.COM","COMTOOL.COM","3e8","11","ATH0","^CR","^w40","OK","^",NULL);
 if(errlvl==1) goto found;

 puts("\n*** Modem not found ***\n");
 if(argc>1)
  HTMLwrite(argv[1],NULL,"\0","\0");
 exit(2);

 found:
 printf("\n*** Modem was found at COM%s, address %s, IRQ %s ***\n",port,base,irq);
 if(argc>1)
  HTMLwrite(argv[1],port,base,irq);

 return 0;
}




/*

@echo off
rem   This is an attempt to use COMTOOL to determine your modem location
rem   This batch file written by Dev Teelucksingh (devtee@trinidad.net)
rem      Please send any comments on this batch file
rem
cls
echo.
echo.
if (%1)==() goto badparam
if (%1)==(/?) goto badparam
if (%2)==() goto COMPORT

:ADDRESS
echo         Attempting to issue AT commands to address %1 IRQ %2
echo.
COMTOOL %1 %2 ATH ^CR ^w20 OK ^
if errorlevel 8 goto ADDnotfound
if errorlevel 1 goto ADDfound
goto ADDnotfound

:ADDnotfound
echo.
echo           Modem not detected at address %1 IRQ %2
echo.
echo             Please recheck your address and IRQ!
goto end

:ADDfound
echo.
echo           Modem found at address %1 IRQ %2!
goto end


:COMPORT
echo.
echo         Attempting to issue AT commands to COM %1
echo.
COMTOOL %1 ATH ^CR ^w20 OK ^
if errorlevel 8 goto notfound
if errorlevel 1 goto found
goto notfound

:found
echo.
echo              Modem found on COM %1!
goto end

:notfound
echo.
echo             Modem not detected on COM %1!
echo              Please try another COM port
goto end

:badparam
echo.
echo Syntax of DMODEM.BAT
echo      DMODEM COMPORT
echo  where COMPORT is the number of COM port to test
echo.
echo.     DMODEM ADDRESS IRQ
echo  where ADDRESS is the base address in hexadecimal and
echo        IRQ     is the number of the IRQ
echo.
echo Examples of use:
echo.
echo   DMODEM 2
echo       Tests for modem at COM2
echo.
echo   DMODEM 2F8 3
echo       Tests for modem at base address 2F8 and at IRQ 3
goto end

:end
echo.

 
*/