
// ==================================================================
// str.h is Arachne Labs enhancent and replacement of string.h
// it offers some quite
// GNUpyright (Gnu) 2000 Michael Polak, Arachne Labs
// ==================================================================

#include "str.h"

// ==================================================================
// pathstr() creates pathname which is terminated by DIRSLASHCHAR
// *dest must be allocated at least one byte bigger than *src!!!
// ==================================================================
char *pathstr(char *dest, char *src)
{
 int l=strlen(src);
 strcpy(dest,src);

 if(l>0 && dest[l-1]!=DIRSLASHCHAR)
 {
  dest[l]=DIRSLASHCHAR;
  dest[l+1]='\0';
 }

 return dest;
}

// ==================================================================
// makestr() is common-sense compatible replacement for both strcpy()
// and strncpy()
// ==================================================================

char *makestr(char *dest, char *src, int lim)
{
 if(lim>0)
  strncpy(dest,src,lim);
 dest[lim]='\0';

 return dest;
}



