
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

struct Finf
{
 char y[6][8];
 char prop_x[6][4][224];
 char fixed_x[6][4];
 char entity[128][6];
};


void finf_save(struct Finf *finf)
{
 FILE *f;

 unlink("fontinfo.bin");

 f=fopen("fontinfo.bin","wb");
 if(f)
 {
  if(fwrite((char *)finf,6216,1,f)==1)
   printf("Ok, fontinfo.bin written...\n");

  puts(&(finf->entity[32][0]));
  fclose(f);
 }
 else
 {
  perror("fontinfo.bin");
  exit(-1);
 }
}

void finf_load(char *name,struct Finf *finf)
{
 FILE *f;

 f=fopen(name,"rb");
 if(f)
 {
  if(fread((char *)finf,6216,1,f)!=1)
   goto fontinferr;
  fclose(f);
 }
 else
 {
  fontinferr:
  perror(name);
  exit(-1);
 }
}

void main(void)
{
 int i=127,l;
 char str[80];
 struct Finf *finf, *oldfinf;

 finf=malloc(sizeof(struct Finf)+2);
 oldfinf=malloc(sizeof(struct Finf)+2);

 if(!finf || !oldfinf)
  exit(-1);

 finf_load("fontinfo.bin",finf);

 printf("Enter filename of fontinfo.bin to import [Enter=skip]:");
 gets(str);
 if(str[0])
 {
  finf_load(str,oldfinf);
  memmove(finf->entity,oldfinf->entity,768);
  finf_save(finf);
  return;
 }


 do
 {
  printf("Enter entity number [128-255, 0=cancel,-1=reset,1=save]:");
  gets(str);
  if(str[0])
   i=atoi(str);
  else
   i++;

  if(i==0)
   exit(0);
  else if(i==-1)
  {
   memset(finf->entity,0,128*6);
   i=127;
  }
  else if(i==1)
   break;
  else
  {
   strncpy(str,finf->entity[i-128],6);
   str[6]='\0';
   printf("%03d [%c] [%-6s] new entity>",i,i,str);
   gets(str);

   l=strlen(str);
   if(l)
   {
    if(l>6)l=6;
    str[l]='\0';
    strncpy(finf->entity[i-128],str,6);
   }
  }

 }
 while(i<256 && i>1);


 finf_save(finf);
}
