#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "comdef.h"
#include <dir.h>
#include "messages.h"

int unarj_main(int argc, char *argv[]);

/*
Primitive package installator and URL verifier for Arachne WWW browser...

idea of SECURITY.CFG file is Copyright (C)1998 Michael Polak, xChaos software
code is GNUpyright(G)1998 Michael Polak, xChaos software

Changed by Bernhard "Bernie" Eriksson 1999
I added a check so the APM (eg. ARJ) files are correct.
Also made a Messages.H file for it, so it's easy to translate :)

Added so the APM file is copied to the download directory (which is sent
through mime.cfg to APM.EXE)
*/

char URL_is_trusted(char *URL)
{
 FILE *f = fopen("security.cfg", "rt");
 char str[256];

 if(f)
 {
  int l;
  while(1)
  {
   fgets(str, 256, f);
   if(feof(f))
    break;

   l = strlen(str) - 1;
   if(l > 0 && str[0] != ';' && !strnicmp(str, URL, l))
    return 1;
  }
  fclose(f);
 }
 return 0;
}


void updatecfg(char *filename, char *var)
{
 FILE *in;
 char *ptr = strchr(var, ' ');
 int n;

 if(ptr)
  n = (int)(ptr - var);
 else
  return;

 unlink("_$.cfg");

 in = fopen(filename, "rt");
 if(in)
 {
  FILE *out;
  out = fopen("_$.cfg", "wt");
  if(out)
  {
   char changed = 0;
   char str[1024];
   while(1)
   {
    fgets(str, 1020, in);
    if(feof(in))
     break;

    if(!strnicmp(str, var, n))
    {
     fputs(var, out);
     changed = 1;
    }
    else
     fputs(str, out);
   }
   if(!changed)
    fputs(var, out);

   fclose(out);
   fclose(in);

   unlink(filename);
   rename("_$.cfg", filename);
   printf("<HR>%s "MSG_APM_UPD_SUC":<H3>%s</H3>", filename, var);
   return;
  }
 }
 printf("<HR><H3>"MSG_APM_UPD_NOSUC"</H3>", filename);

}

int main(int argc, char **argv)
{
 char str[128];
 char APMname[128];
 char APMicon[MAXPATH + 7] = "file:zip.ikn";
 char cmd[256];
 FILE *f,*a;
 char *unarjargs[3];
 int unarjret;

 if(argc < 2)
 {
  printf(MSG_APM_REQ" "HOMEPAGE"\n");
  return 1;
 }
 if(argv[1][1]=='h' && argc==3)
 {
  char *name=strrchr(argv[2],'/');
  if(name)
   name++;

  printf("<H2>"MSG_APM_NOINST"</H2>\n\n");
  printf(MSG_APM_NOINST2" <A HREF=\"%s.apm\">\n",argv[2]);
  printf(MSG_APM_NOINST3"<A HREF=\"apm.htm\">"MSG_APM_NOINST4"</A>,\n");
  printf("<B>%s.apm</B>. "MSG_APM_NOINST5" <A HREF=\"*.apm\">",name);
  printf(MSG_APM_NOINST6".\n");
  printf("<ARACHNE MSG=\""MSG_APM_NOINST7"\">");
  return 0;
 }
 else if(argv[1][1] == 't' && argc == 3)
 {
  char *name = strrchr(argv[2], '/');
  if(name)
   name++;

  printf(MSG_APM_NOINST"\n");
  printf("-------------------------------------------------------\n\n");
  printf(MSG_APM_NOINST8" \"%s.apm\".\n", name);
  printf(MSG_APM_NOINST9" \"%s.apm\".\n", argv[2]);
  printf(MSG_APM_NOINST10".\n\n");
  system("pause");
  return 0;
 }
 else if(argv[1][1] == '1' && argc == 3)
 {
  unlink("_$.exe");
  unlink("apm.id");
  rename(argv[2], "_$.exe");
  system("echo A|_$.exe>NUL");
  rename("_$.exe", argv[2]);
  strcpy(APMname, argv[2]);
 }
 else //APM.EXE -u URL package_name.APM
 if(argc == 4 && argv[1][1] == 'u')
 {
  //Copy command added by Bernie
  //Impossible due to too long command line....
  /*
  sprintf(str, "copy %s %s>nul", argv[3], argv[4]);
  system(str);
  */

  if(URL_is_trusted(argv[2]))
  {
   //Following check added by Bernie
   unlink("apm.id");
   //sprintf(str, "unarj.exe t %s>NUL", argv[3]);
   //system(str);
   unarjargs[0]=argv[0];
   unarjargs[1]="t";
   unarjargs[2]=argv[3];
   printf("<TITLE>Arachne Package Manager</TITLE><H1>Arachne Package Manager</H1><HR><PRE>");
   unarjret=unarj_main(3,unarjargs);
   puts("</PRE><HR>");
   if(unarjret == 0)
   {
//    sprintf(str, "unarj.exe y %s>APM.LOG", argv[3]);
//    system(str);
    unarjargs[0]=argv[0];
    unarjargs[1]="y";
    unarjargs[2]=argv[3];
    printf("Package is OK - installing now. To make backup copy, press F2 key...<HR><PRE>");
    unarjret=unarj_main(3,unarjargs);
    puts("</PRE><HR>");
    strcpy(APMname, argv[2]);
   }
   else
   {
    puts("<IMG SRC=\"file://system\\gui\\error.gif\" ALIGN=RIGHT>\n");
    puts("<IMG SRC=\"file://system\\gui\\error.gif\" ALIGN=LEFT>\n");
    puts("<CENTER><H2>"MSG_APM_CORRUPT1"</H2></CENTER><BR><HR>");
    printf(MSG_APM_CORRUPT2, argv[3]);
    return(1);
   }
  }
  else
  {
   puts("<IMG SRC=\"file://system\\gui\\error.gif\" ALIGN=RIGHT>\n");
   puts("<IMG SRC=\"file://system\\gui\\error.gif\" ALIGN=LEFT>\n");
   printf("<H2>"MSG_APM_NOTRUST"</H2><BR CLEAR=ALL><HR>\n\n");
   printf(MSG_APM_NOTRUST2" ("MSG_APM_NOINST4") "MSG_APM_NOTRUST4 " <B>%s</B>.\n",argv[2]);
   printf(MSG_APM_NOTRUST3, argv[2]);
   printf(" <A HREF=\"file://security.cfg\">security.cfg</A>.\n<P>");
   printf(MSG_APM_NOTRUST5);
   return 1;
  }
 }
 else //APM.EXE -v URL package_name.APM - NetDOS Security Check mode
 if(argc == 4 && argv[1][1] == 'v')
 {
  if(URL_is_trusted(argv[2]))
   return system(argv[3]);
  else
  {
   printf(MSG_APM_NOTRUST_T"\n");
   printf("----------------------------------------\n\n");
   printf(MSG_APM_NOTRUST2_T"\n");
   printf("\n", argv[2]);
   printf(MSG_APM_NOTRUST3_T "security.cfg.\n");
   printf(MSG_APM_NOTRUST5_T);
   system("pause");
   return 1;
  }
 }
 else
 {
  puts(MSG_APM_ERROR);
  return 1;
 }

 // APM.ID analysis... and package instalation - both version 1 and 2...

 f = fopen("apm.id", "rt");
 if(!f)
 {
  puts("<H1>"MSG_APM_ERROR1"</H1><ARACHNE>");
  if(argc == 4)
  {
   puts(MSG_APM_ERROR2);
   puts("<BR>"MSG_APM_ERROR3);
   printf(MSG_APM_ERROR4"<P><TT>apm -1 %s</TT>.\n", argv[1]);
  }
  return 1;
 }

 {
  char *ptr;

  ptr = strrchr(APMname, '.');
  if(ptr)
   *ptr = '\0';

  ptr = strrchr(APMname, '\\');
  if(!ptr)
  {
   ptr = strrchr(APMname, '/');
   if(!ptr)
    ptr = APMname;
   else
    ptr++;
  }
  else
   ptr++;

  sprintf(str, "SYSTEM\\APM.DB\\%s.htm", ptr);

  a = fopen(str, "wt");
//  puts(str);
 }
 while(1)
 {
  fgets(str, 120, f);
  if(feof(f))
   break;

  if(!strnicmp(str, "APMicon", 7))
  {
   char *ptr;
   strcpy(APMicon, &str[8]);
   ptr = strrchr(APMicon, '\n');
   if(ptr)
    *ptr = '\0';
  }
  if(!strnicmp(str, "name", 4))
  {
   strcpy(APMname, &str[5]);
   printf("<IMG SRC=\"%s\" ALIGN=LEFT>\n", APMicon);
   if(a)
    fprintf(a,"<IMG SRC=\"%s\" ALIGN=LEFT>\n", APMicon);
   printf("<H1>&nbsp;%s </B>"MSG_APM_INSTALL"</H1><BR CLEAR=ALL><BR><HR SIZE=4>\n", APMname);
   if(a)
    fprintf(a, "<H2>&nbsp;%s</H2>\n", APMname);
  }
  else if(!strnicmp(str, "license", 7))
  {
   printf("<I>License: %s</I><HR>\n", &str[8]);
   if(a)
    fprintf(a, "&nbsp;<I>"MSG_APM_LICENSE" %s</I><BR CLEAR=ALL>\n", &str[8]);
  }
  else if(!strnicmp(str, "description", 11))
  {
   puts(&str[12]);
   if(a)
    fprintf(a, "<FONT SIZE=-1>%s</FONT>\n", &str[12]);
  }
  else if(!strnicmp(str, "mime", 4))
   updatecfg("MIME.CFG", &str[5]);
  else if(!strnicmp(str, "icon", 4))
   updatecfg("WWWMAN.CFG", &str[5]);
  else if(!strnicmp(str, "config", 6))
   updatecfg("ARACHNE.CFG", &str[7]);
  else if(!strnicmp(str, "overwrite", 9))
  {
   char *ptr = strrchr(&str[10], '\n');
   if(ptr)
    *ptr = '\0';
   sprintf(cmd, "if exist system\\apm.db\\%s.htm del system\\apm.db\\%s.htm", &str[10], &str[10]);
   system(cmd);
  }
 }

 puts("<HR><I>"MSG_APM_APM", (c)2000 Arachne Labs\
<BR>Portions (c)1999 Bernhard \"Bernie\" Eriksson\n\
<BR>UNARJ is copyright (c) 1991-93 by Robert K Jung.  All rights reserved. </I>");
 fputs("<HR>", a);
if(a)
  fclose(a);

 fclose(f);
 return 0;
}
