/************************************************************************/
/*																		*/
/*		Name:		IO_ALLEG.C                                          */
/*		Function:	Allegro Hardware Interface							*/
/*		Author:		Paul Robson      									*/
/*		Created:	3rd December 2001                                   */
/*		Modified:	4th December 2001                                   */
/*		Project:	The Valley in C										*/
/*																		*/
/************************************************************************/


#define DRIVER
#include "valley.h"

#include <conio.h>						/* Specific to this file */
#include <allegro.h>
                        				/* This optimises the file size */
BEGIN_GFX_DRIVER_LIST
GFX_DRIVER_VESA1
GFX_DRIVER_VGA
END_GFX_DRIVER_LIST
BEGIN_COLOR_DEPTH_LIST
COLOR_DEPTH_8
END_COLOR_DEPTH_LIST
BEGIN_DIGI_DRIVER_LIST
END_DIGI_DRIVER_LIST
BEGIN_MIDI_DRIVER_LIST
END_MIDI_DRIVER_LIST
BEGIN_JOYSTICK_DRIVER_LIST
END_JOYSTICK_DRIVER_LIST

int CColour;							/* Current Colour */
volatile long Clock;
BITMAP *FontBmp;

/************************************************************************/
/*		  User Defined Graphics lifted from the BBC Micro Version		*/
/************************************************************************/

char BBCGfx[18*8] = {
        126,189,219,231,231,219,189,126,
        231,231,231,0,0,231,231,231,
        1,2,4,8,16,32,64,128,
        128,64,32,16,8,4,2,1,
        255,193,128,128,128,148,247,247,
        255,231,219,189,189,219,231,255,
        24,24,65,90,88,64,36,36,
        0,1,3,7,15,31,63,127,
        170,85,170,85,170,85,170,85,
        255,213,128,255,255,171,1,255,
        0,62,127,127,127,107,8,8,
        255,255,255,255,255,255,255,255,
        2,5,32,80,4,10,64,160,
        129,189,189,181,189,189,189,129,
        255,204,51,255,255,204,51,255,
        153,90,36,219,219,36,90,153,
        255,129,129,129,129,129,129,255,
        231,231,190,165,167,191,219,219,
};

static int ColTrans[8] =				/* Colours -> IBM Standard */
    				{ 0,12,10,14,9,13,11,15 };

static char PixelGraphics[4608];		/* Multicolour graphics */

void HWTimerProc(void)
{
	Clock += 10;
}

/************************************************************************/
/*						Initialise the Hardware I/O						*/
/************************************************************************/

void HWInitialise(void)
{
	int i;
	RGB r,r1[256];
	FILE *f;
	allegro_init();
	install_timer();
	install_int(HWTimerProc,10);
	set_color_depth(8);
	set_gfx_mode(GFX_AUTODETECT,640,480,640,480);
	FontBmp = load_pcx("FONT.PCX",r1);
	if (FontBmp == NULL) HWError(__LINE__,__FILE__);
	f = fopen("GRAPHICS.BIN","rb");		/* Read in graphics data */
	if (f == NULL) HWError(__LINE__,__FILE__);
	fread(PixelGraphics,sizeof(PixelGraphics),1,f);
	fclose(f);
	for (i = 0;i < 8;i++)
	{
		r.r = (i & 1) ? 63 : 0;
		r.g = (i & 2) ? 63 : 0;
		r.b = (i & 4) ? 63 : 0;
		set_color(i,&r);
	}
}

/************************************************************************/
/*						   Terminate Hardware I/O						*/
/************************************************************************/

void HWTerminate(void)
{
	allegro_exit();
}

/************************************************************************/
/*			Read key, return ASCII code or 0 if no key pressed			*/
/************************************************************************/

int HWInkey(void)
{
	int c;
	if (!kbhit()) return 0;				/* Key pressed ? */
    c = getch();						/* Get key */
    if (c == 0) c = -getch();			/* Handle IBM specials */
    return (c < 0) ? 0 : toupper(c);	/* Zero if IBM special */
}

/************************************************************************/
/*					Return elapsed time in milliseconds					*/
/************************************************************************/

long HWGetTimer(void)
{
	return Clock;
}

/************************************************************************/
/*							Draw a BBC Micro UDG						*/
/************************************************************************/

static void _HWDrawUDG(char *Data,int x1,int y1,int x2,int y2,int n,int c)
{
	int x,y;
	if (x2-x1 == 15 && y2-y1 == 15)		/* Check for pixel map */
		if (HWDrawGraphic(x1,y1,n,c)) return;

    for (y = 0;y < 8;y++)				/* Work through the bitmaps */
    	for (x = 0;x < 8;x++)
			if (Data[y] & (0x80 >> x))	/* If pixel set,draw a solid block */
			{
				rectfill(screen,
						 (x2-x1)*x/8+x1,(y2-y1)*y/8+y1,
						 (x2-x1)*(x+1)/8+x1-1,(y2-y1)*(y+1)/8+y1-1,
						 CColour);
			}
}

/************************************************************************/
/*							Print a character							*/
/************************************************************************/

void HWPrint(int x,int y,int Colour,int Char)
{
	int c,x1,y1,x2,y2,xb,yb,n,ySize;
    if (x < 0 || y < 0) return;			/* Check range */
    if (x >= SCX || y >= SCY) return;
	x1 = x * SCREEN_W / SCX;			/* Calculate box surrounding char */
	x2 = (x+1) * SCREEN_W / SCX-1;
	ySize = SCREEN_H / SCY;
	if (ySize > 16) ySize = 16;
	y1 = y * ySize;
	y2 = (y+1) * ySize-1;
	rectfill(screen,x1,y1,x2,y2,0);
	CColour = Colour;
    if (Char == 32) return;				/* Space */
    if (Char >= 224 && Char < 242)		/* If it's a UDG */
    {
		_HWDrawUDG(BBCGfx+(Char-224)*8,x1,y1,x2,y2,Char,Colour);
        return;
    }
    if (Char > 32 && Char < 126)		/* If it's a character */
    {
		xb = 1 + 32 * ((Char-0x20) % 16);
		yb = 1 + 32 * ((Char-0x20) / 16);
		n = 0;
		while (getpixel(FontBmp,xb+n,yb) != 255) n++;
		n = (x2-x1-n)/2;
		for (x = x1;x <= x2;x++)
			for (y = y1;y <= y2;y++)
			{
				c = getpixel(FontBmp,x-x1+xb,y-y1+yb+3);
				if (c != 0 && c != 255)
							putpixel(screen,x+n,y,Colour);
			}
        return;
    }
}

/************************************************************************/
/*								Report an Error							*/
/************************************************************************/

void HWError(int Line,char *File)
{
	allegro_exit();
    fprintf(stderr,"Error at %d of %s.\n\n",Line,File);
    exit(1);
}

/************************************************************************/
/*					Draw Graphic as multicolour pixel					*/
/************************************************************************/

int HWDrawGraphic(int x,int y,int Char,int Colour)
{
	int x1,y1;
	char c;
	for (x1 = 0;x1 < 16;x1++)
		for (y1 = 0;y1 < 16;y1++)
		{
			c = PixelGraphics[(Char-224)*256+y1*16+x1];
			if (c & 0x80) c = Colour;
			c = ColTrans[c & 7];
			putpixel(screen,x+x1,y+y1,c);
		}
	return 1;
}
