/************************************************************************/
/*																		*/
/*		Name:		BUILDING.C                                          */
/*		Function:	Building Handlers (Lair,Zaexon,Temple)				*/
/*		Author:		Paul Robson      									*/
/*		Created:	2nd December 2001                                   */
/*		Modified:	3rd December 2001                                   */
/*		Project:	The Valley in C										*/
/*																		*/
/************************************************************************/

#include "valley.h"

void BDDrawBuilding(PLAYER *p,int HasDoor);

/************************************************************************/
/*					Message handler for lair/temple						*/
/************************************************************************/

void BDLairTempleHandler(int Command,PLAYER *p,void *Data)
{
	LOCATION *l = &(p->Loc[p->CLoc]);
	VASSERT(p != NULL);
    switch(Command)
    {
		case CCM_GETMLIST:
			VASSERT(Data != NULL);
			strcpy(Data,"CBE");
			break;
    	case CCM_REDRAW:				/* Redraw the scene */
			p->Floor = 4;
            srand(l->Seed);				/* Seed random number gen. */
            BDDrawBuilding(p,1);		/* Draw the building */
            if (l->ClassID == RC_LAIR)
            {
            	IOPrintString(SCX*3/4-4,6,COL_YELLOW,"Vounim's");
            	IOPrintString(SCX*3/4-2,7,COL_YELLOW,"Lair");
            }
            else
            {
            	IOPrintString(SCX*3/4-6,6,COL_YELLOW,"The Temple Of");
            	IOPrintString(SCX*3/4-4,7,COL_YELLOW,"Y'Naigoth");
            }
        	break;

        case CCM_SETINITPOS:
        	l->x = 7;l->y = HEIGHT-1;
            break;

		case CCM_POSTMOVE:				/* Check for treasure */
			if (l->OldChar == CHR_TREASURE)
				BDGetTreasure(p);
			else
				CLDefaultHandler(Command,p,Data);
			break;

        default:
            CLDefaultHandler(Command,p,Data);
            break;
    }
}

/************************************************************************/
/*					Building data from BBC Version						*/
/************************************************************************/

#define	WALLINFOSIZE	(31)

static int WallInfo[WALLINFOSIZE] =
	{
		4,7,3,6,4,4,6,5,3,6,0,3,
        8,4,3,5,5,3,8,3,4,5,0,6,
        3,6,4,6,4,7,4 };

/************************************************************************/
/*							Draw a building								*/
/************************************************************************/

void BDDrawBuilding(PLAYER *p,int HasDoor)
{
	int i,n,x,y,d1,d2,d3,Layout,WallHeight;
	VASSERT(p != NULL);
    Layout = rand() % WALLINFOSIZE;		/* Generate sizing info */
    WallHeight = rand()%5+4;
    for (x = 0;x < 21;x++)				/* Draw the frame */
    {
    	IOPrint(x+2,0,COL_RED,CHR_IWALL);
    	IOPrint(x+2,HEIGHT,COL_RED,CHR_IWALL);
    }
    for (y = 1;y < HEIGHT;y++)
    {
    	IOPrint(2,y,COL_RED,CHR_IWALL);
    	IOPrint(22,y,COL_RED,CHR_IWALL);
    }
	y = 1;								/* Work down walls */
    while (y < HEIGHT)
    {
    	if (y+WallHeight == HEIGHT-1)	/* Stops micro-rooms */
        						WallHeight++;
        d1 = WallInfo[Layout];			/* Read layout info */
        d2 = WallInfo[(Layout+1) % WALLINFOSIZE];
        d3 = WallInfo[(Layout+2) % WALLINFOSIZE];
		for (i = 0;i < WallHeight;i++)	/* Draw vertical walls */
        {
        	if (y < HEIGHT)				/* If there's space... */
            {
	            IOPrint(2+d1,y,COL_RED,(i == 0 && d1 != 0) ? ' ':CHR_IWALL);
                IOPrint(2+d1+d2,y,COL_RED,(i == 2) ? ' ':CHR_IWALL);
                IOPrint(2+d1+d2+d3,y,COL_RED,(i == 1) ? ' ':CHR_IWALL);
            }
        	y++;
        }
        if (y < HEIGHT)					/* Need a horizontal wall */
        {
            for (x = 3;x < 22;x++)
            		IOPrint(x,y-1,COL_RED,CHR_IWALL);
            IOPrint(4,y-1,0,' ');
            IOPrint(19,y-1,0,' ');
            IOPrint(3*WallHeight+2,y-1,0,' ');
        }
    	Layout = (Layout + 3) % WALLINFOSIZE;
    }
    if (HasDoor)						/* And a door ... */
		IOPrint(7,HEIGHT,COL_CYAN,CHR_DOOR);
	randomize();
	if (rand() % 3 == 0) return;/* Chance of 2 in 3 only */
	if (p->Floor < 4) return;	/* Floors 4 up (e.g. 3 up) only */

	i = rand()%4+2; 			/* Draw treasure */
	while (i-- > 0)
	{
		do						/* Find a spot */
		{
			x = rand()%21+2;y = rand()%HEIGHT;
			IORead(x,y,NULL,&n);
		}
		while (n != 32);
		IOPrint(x,y,COL_WHITE,	/* Then draw it */
						CHR_TREASURE);
	}
}

/************************************************************************/
/*					Message handler for Tower of Zaexon					*/
/************************************************************************/

void BDZaexonHandler(int Command,PLAYER *p,void *Data)
{
	LOCATION *l = &(p->Loc[p->CLoc]);
    int n;
    char Temp[16];
	VASSERT(p != NULL);
    switch(Command)
    {
		case CCM_GETMLIST:
			VASSERT(Data != NULL);
			strcpy(Data,"CAGE");
			break;
    	case CCM_REDRAW:				/* Redraw the scene */
        	p->Floor = 2;
			n = p->CLoc-1;				/* Find out which floor by tracking back */
            while (p->Loc[n].ClassID == RC_ZAEXON)
            		n--,p->Floor++;
            srand(l->Seed);				/* Seed random number gen. */
            BDDrawBuilding(p,			/* Draw the building */
            			p->Floor == 2);
            if (p->Floor % 2 == 0)		/* Draw the stairs */
            	IOPrint(21,1,COL_BLUE,CHR_STAIRS);
            else
           		IOPrint(3,HEIGHT-1,COL_BLUE,CHR_STAIRS);

           	IOPrintString(SCX*3/4-2,5,COL_YELLOW,"Tower");
           	IOPrintString(SCX*3/4-4,6,COL_YELLOW,"Of Zaexon");
            sprintf(Temp,"Floor %d",p->Floor-1);
           	IOPrintString(SCX*3/4-3,8,COL_YELLOW,Temp);
        	break;

		case CCM_SETINITPOS:
			if (p->Loc[p->CLoc-1].ClassID == RC_ZAEXON)
			{                           /* On the second or greater floor */
				l->x = p->Loc[p->CLoc-1].x;
				l->y = p->Loc[p->CLoc-1].y;
			}
			else						/* First floor */
			{
				l->x = 7;l->y = HEIGHT-1;
			}
            break;

		case CCM_POSTMOVE:				/* Check for stairs,treasure */
			switch(l->OldChar)
			{
				case CHR_STAIRS:
					BDUseStairs(p);
					break;
				case CHR_TREASURE:
					BDGetTreasure(p);
				default:
					CLDefaultHandler(Command,p,Data);
					break;
			}
			break;

        default:
            CLDefaultHandler(Command,p,Data);
            break;
    }
}

/************************************************************************/
/*				On the stairs of the Tower of Zaexon					*/
/************************************************************************/

void BDUseStairs(PLAYER *p)
{
	LOCATION *l = &(p->Loc[p->CLoc]);
	int c,Err = 0;
	VASSERT(p != NULL);
	PLBanner("A stairway.... up or down ?",0);
	do									/* Get up or down */
		c = IOGet();
	while (c != 'U' && c != 'D');
	if (c == 'U')						/* Up stairs */
	{
		Err = (p->Floor == 7);			/* Six floors only */
		if (Err == 0)					/* Recursively stack the next floor */
				CLEnterArea(p,RC_ZAEXON);
	}
	else								/* Down stairs */
	{
		Err = (p->Floor == 2);			/* Actual floor is p->Floor-1 */
		if (Err == 0)
		{
			p->Loc[p->CLoc-1].x = l->x;	/* Copy the current position to */
			p->Loc[p->CLoc-1].y = l->y;	/* the floor below, stairs aren't */
										/* logical in Valley */
			p->CLoc--;					/* Previous level */
			PLClear(p);					/* Redraw screen and player */
			CLDispatch(CCM_DRAWPLAYER,p,0);
		}
	}
	if (Err) PLBanner("These stairs are blocked",250);
}

/************************************************************************/
/*							Found some treasure							*/
/************************************************************************/

void BDGetTreasure(PLAYER *p)
{
	LOCATION *l = &(p->Loc[p->CLoc]);
	long OldCash = p->Cash;
	double r;
	VASSERT(p != NULL);
	l->OldChar = ' ';					/* Will erase the treasure */
	p->Cash += 100 *					/* Usually get some money */
			(p->Floor+p->Treasure[0]+p->Treasure[1]+p->Treasure[2]);
	r = ((double)(rand()%1000))/1000.0;	/* Random number 0-1 */

	if (l->ClassID == RC_TEMPLE &&		/* Helm of Evanna */
		r > 0.95 &&
		p->Treasure[1] == 6 &&
		p->Treasure[2] == 0)
	{
		p->Treasure[2] = 1;
		PLBanner("You find the HELM OF EVANNA !!!!",280);
		return;
	}

	if (l->ClassID == RC_LAIR &&		/* Amulet of Alarian */
		r > 0.85 &&
		p->Treasure[0] == 0)
	{
		p->Treasure[0] = 1;
		PLBanner("You find the AMULET OF ALARIAN... empty",280);
		return;
	}
	if (l->ClassID == RC_ZAEXON &&  	/* Amulet stone */
		r > 0.7 &&
		p->Treasure[0] == 1 &&
		p->Treasure[1] < 6 &&
		p->Floor > p->Treasure[1])
	{
		PLBanner("An Amulet Stone...",280);
		if (rand()%100 > 85)
		{
			PLBanner(".... but the wrong one !",280);
			p->Cash = OldCash;
		}
		else
		{
			PLBanner("... the stone fits !",280);
			p->Treasure[1]++;
		}
		return;
	}
	if (r > 0.43)						/* If a bauble, then no cash either */
	{
		PLBanner("A worthless bauble",280);
		p->Cash = OldCash;
		return;
	}
	PLPanel(p);
	PLBanner("A precious stone....",280);
}