/************************************************************************/
/*																		*/
/*		Name:		VALLEY.H                                            */
/*		Function:	Generic include file								*/
/*		Author:		Paul Robson      									*/
/*		Created:	2nd December 2001                                   */
/*		Modified:	3rd December 2001                                   */
/*		Project:	The Valley in C										*/
/*																		*/
/************************************************************************/

#define  VERSION	"1.0 (04-Dec-01)"

#include <stdio.h>						/* Headers */
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <math.h>

#define	 MKG(h,l)		(((h) << 8) | (l))
#define	 VERROR()		IOError(__LINE__,__FILE__)
#define	 VASSERT(x)		if (!(x)) VERROR()

#define	 SCX			(40)			/* Screen Size */
#define	 SCY			(28)

#define  HEIGHT			(SCY-12)		/* Height of game area */

#define  RC_VALLEY		(0)				/* Valley class identifier */
#define  RC_ZAEXON		(1)
#define  RC_SWAMP		(2)
#define  RC_FOREST		(3)
#define	 RC_LAIR		(4)
#define	 RC_TEMPLE		(5)

#define  COL_BLACK		(0)				/* Colours */
#define	 COL_RED		(1)
#define	 COL_GREEN		(2)
#define	 COL_YELLOW		(3)
#define	 COL_BLUE		(4)
#define	 COL_MAGENTA	(5)
#define	 COL_CYAN		(6)
#define	 COL_WHITE		(7)

#define	 CHR_FRAME		MKG(0,224)		/* Character constants */
#define	 CHR_CASTLE		MKG(1,225)		/* MSB is unique ID */
#define	 CHR_PATHBLTR   MKG(2,226)		/* LSB is graphic number */
#define  CHR_PATHBRTL	MKG(3,227)
#define	 CHR_FOREST		MKG(4,228)
#define	 CHR_ZAEXON		MKG(5,229)
#define	 CHR_PLAYER		MKG(6,230)
#define  CHR_STAIRS		MKG(7,231)
#define	 CHR_BUILDING	MKG(8,232)
#define  CHR_SWAMPMAP	MKG(9,233)
#define	 CHR_TREE		MKG(10,234)
#define	 CHR_IWALL		MKG(11,235)
#define	 CHR_SWAMP		MKG(12,236)
#define  CHR_DOOR		MKG(13,237)
#define	 CHR_WATER		MKG(14,238)
#define  CHR_TREASURE	MKG(15,239)
#define	 CHR_EXIT		MKG(16,240)
#define  CHR_PLAYERWTR	MKG(17,241)

#define CCM_REDRAW		(0)				/* Redraw the display area */
#define CCM_SETINITPOS	(1)				/* Set the initial position */
#define CCM_DRAWPLAYER	(2)				/* Draw the player */
#define CCM_ERASEPLAYER	(3)				/* Erase the player */
#define CCM_CANMOVE		(4)				/* Moving to position allowed */
#define CCM_POSTMOVE	(5)				/* Post-Move tests */
#define CCM_GETMLIST	(6)				/* Get list of monster types */

#define SPR_PSISHIELD	(1)				/* Spell results */
#define SPR_BEYOND		(2)
#define SPR_SAPSTRENGTH	(3)
#define SPR_FAILS		(4)
#define SPR_OK			(5)

typedef char STRING[17];				/* String constant */

typedef struct _Location				/* Location structure */
{
	int x,y;							/* Coordinates therein */
    int ClassID;						/* Class ID of location */
    int Seed;							/* Seed for location */
    int OldChar,OldColour;				/* Old background details */
} LOCATION;

typedef struct _Monster					/* Monster structure */
{
	STRING Name;						/* Name */
	int    Combat;						/* Combat points */
	int    PSI;							/* PSI points */
	char   Location;					/* Where found */
	int	   Defeated;					/* Set when defeated */
} MONSTER;

typedef struct _Player					/* Player structure */
{
	LOCATION Loc[32];					/* Location Stack */
    int	Quit;							/* Quit when game over */
    int Floor;							/* Effective floor */
    int CLoc;							/* Current Location ID */
    long Cash;							/* Amount of cash */
    int Treasure[3];					/* Treasures */
    long Turns;							/* Turns completed */
    long QuitTurns;						/* Turns to quit area */
    STRING Name;						/* Name String */
    STRING Class;						/* Class  */
    double MagicSkill;					/* Magic Skill */
    double FightFactor;					/* Fight factor */
    double CombatInc;					/* Combat Increment */
    int  CombatStr;						/* Combat Strength */
    int	 PSIStr;						/* PSI Strength */
    int	 Stamina;						/* Stamina */
    double Experience;					/* Experience */
    double NewExp;						/* Experience to be won */
	int	 MonsterFlag;					/* Non-zero if monster here */
	MONSTER Mon;						/* Monster information */
} PLAYER;

void MovePlayer(PLAYER *p,char Key);	/* Function prototyping */
void Instructions(void);
void DeathCode(PLAYER *p);

void IOInitialise(void);
void IOTerminate(void);
int  IOInkey(void);
long IOGetTimer(void);
void IOPrint(int x,int y,int Colour,int Char);
void IOPrintString(int x,int y,int Colour,char *String);
int IOTimedInkey(int msTime);
void IOClearWindow(int x1,int y1,int x2,int y2);
int IOGet(void);
void IOClear(void);
void IOError(int Line,char *File);
void IORead(int x,int y,int *Colour,int *Char);

void PLReset(int Class,PLAYER *Player);
void PLPanel(PLAYER *Player);
void PLClear(PLAYER *Player);
void PLBanner(char *Msg,int Delay);
void PLDelay(int Delay);
void PLStatusDisplay(PLAYER *Player);
void PLSaveCharacter(PLAYER *Player);
void PLDrawFrame(int Char);
void PLRangeCheck(PLAYER *p);
char *PLFileName(void);
int  PLLoadFile(PLAYER *p);

void CLDispatch(int Command,PLAYER *Player,void *Data);
void CLDefaultHandler(int Command,PLAYER *Player,void *Data);
void CLValleyHandler(int Command,PLAYER *Player,void *Data);
void CLFindSpace(int *x,int *y);
int CLMonsterCheck(PLAYER *p);
void CLLocationCheck(PLAYER *p);
void CLEnterArea(PLAYER *p,int Class);

void SASwampForestHandler(int Command,PLAYER *p,void *Data);
void BDLairTempleHandler(int Command,PLAYER *p,void *Data);
void BDZaexonHandler(int Command,PLAYER *p,void *Data);
void BDUseStairs(PLAYER *p);
void BDGetTreasure(PLAYER *p);

void MOAttack(PLAYER *p);
int MOGetMonster(int n,MONSTER *p);

#ifdef DRIVER
void HWInitialise(void);				/* Function prototyping [drivers] */
void HWTerminate(void);
int HWInkey(void);
long HWGetTimer(void);
void HWPrint(int x,int y,int Colour,int Char);
void HWError(int Line,char *File);
int  HWDrawGraphic(int x,int y,int n,int Colour);
#endif

#ifdef DJGPP							/* DJGPP doesn't support randomize */
#define randomize()	srand(clock())
#endif