/************************************************************************/
/*																		*/
/*		Name:		VALLEY.C		                                    */
/*		Function:	The Valley, Main Program							*/
/*		Author:		Paul Robson      									*/
/*		Created:	2nd December 2001                                   */
/*		Modified:	4th December 2001                                   */
/*		Project:	The Valley in C										*/
/*					This is a rewrite of the code in C, from the BBC	*/
/*					Micro version, which was reverse engineered.		*/
/*																		*/
/************************************************************************/
#include "valley.h"

static void _ICentre(int y,int Colour,char *Text);
static int  SelectChar(char *Name);

/************************************************************************/
/*						   Main Program									*/
/************************************************************************/

int main()
{
	PLAYER p;
	char Key,Name[32];
	int c;
	IOInitialise();             		/* Set up */
	#ifndef IDE							/* Instructions in build */
	Instructions();
	#endif
    if (PLLoadFile(&p) == 0)			/* Load file ? */
    {
		PLReset(SelectChar(Name),&p);	/* Initialise player */
	    strcpy(p.Name,Name);			/* Copy in the name */
    }
	PLClear(&p);						/* Display valley */
    CLDispatch(CCM_DRAWPLAYER,&p,NULL);
	while (p.Quit == 0)					/* While not completed */
	{
		PLPanel(&p);
		IOClearWindow(0,HEIGHT+7,SCX-1,SCY-1);
		c = p.Loc[p.CLoc].OldChar;		/* Display prompt */
		PLBanner((c == CHR_PATHBLTR || c == CHR_PATHBRTL) ?
							"Safe on the path... which way ? ":
							"Which direction.... ?",0);
		Key = IOGet();					/* Get command, clear panel */
		if (Key == 'Q')					/* Exit ? */
        {
        	PLBanner("Are you sure you want to quit ?",0);
            if (IOGet() == 'Y') p.Quit = 1;
            PLBanner("",0);
        }
		if (Key == 'E')					/* Status */
				PLStatusDisplay(&p);
		if (isdigit(Key))				/* Movement */
				MovePlayer(&p,Key);
        if (p.Stamina <= 0)				/* Dead ? */
	        		DeathCode(&p);
    }
	IOTerminate();
	printf("The Valley %s\n",VERSION);
	printf("Originally published in Computing Today from Argus Specialist Publications.\n");
	printf("'C' version written by Paul Robson (autismuk@aol.com)\n");
	return 0;
}

/************************************************************************/
/*							Player movement handling					*/
/************************************************************************/

void MovePlayer(PLAYER *p,char Key)
{
	LOCATION *l = &(p->Loc[p->CLoc]);	/* Location Pointer */
    int Ok,n,x,y;
    CLDispatch(CCM_ERASEPLAYER,p,NULL);
    n = Key-'0';x = l->x;y = l->y;		/* Work out new location */
    if (n >= 7) (l->y)--;
    if (n <= 3) (l->y)++;
    if (n % 3 == 1) (l->x)--;
    if (n % 3 == 0) (l->x)++;
    CLDispatch(CCM_CANMOVE,p,&Ok);		/* Check if move possible */
    if (Ok == 0)						/* Nope... */
    {
    	l->x = x;l->y = y;				/* Fix the coordinates back */
        p->Stamina = p->Stamina-10;		/* Can't move through there */
		PLBanner("The way is barred",200);
    }
    CLDispatch(CCM_DRAWPLAYER,p,NULL);	/* Draw the player back */
    p->Turns++;							/* One more turn */
   	if (Ok == 1)                        /* Conduct post-move tests */
	    CLDispatch(CCM_POSTMOVE,p,NULL);
    PLPanel(p);							/* Redraw the panel */
}

#define INSTR(x)	_ICentre(y++,COL_GREEN,x)

void Instructions(void)
{
	int y = 2;
	IOClear();
	_ICentre(0,COL_YELLOW,"The Valley");
	_ICentre(SCY-1,COL_CYAN,"Press SPACE to start");
    INSTR("The Valley is an adventure game in which");
    INSTR("you will explore the valley itself,");
    INSTR("Woods, Swamps The temple of Y'Naigoth");
    INSTR("Vounims Lair and The Tower of Zaexon.");
    INSTR("First you will be asked to chose your");
    INSTR("character. Next you will see a map of");
    INSTR("the valley with your character at the");
    INSTR("left hand safe castle You will be asked");
    INSTR("in which direction you wish to move. To");
    INSTR("move your character you press one of the");
    INSTR("keys 1-9 on the numeric pad. You will");
    INSTR("find treasure,explore the woods, swamps");
    INSTR("and mysterious buildings and fight");
    INSTR("monsters. If you have to fight a monster");
    INSTR("you must press a button on the words");
    INSTR("'STRIKE QUICKLY'. 'H' for HEAD 'B' for");
    INSTR("BODY 'L' for LEGS 'S' for SPELL 1 to 3.");
    INSTR("To see your rating press E. To exit,");
    INSTR("press Q.");

	while (IOGet() != ' ') {};
}

static void _ICentre(int y,int Colour,char *Text)
{
	IOPrintString(SCX/2-strlen(Text)/2,y,Colour,Text);
}

/************************************************************************/
/*					Select a Name and character class					*/
/************************************************************************/

static int  SelectChar(char *Name)
{
	int n;
    static char *Class[5] = { "Wizard","Thinker","Barbarian","Warrior","Cleric" };

    #ifdef IDE							/* Development only */
    strcpy(Name,"Erik");				/* Stops me getting tired :) */
    return 2;
    #endif

	IOClear();							/* Name bit */
	_ICentre(3,COL_YELLOW,"Please enter a name for your character");
    strcpy(Name,"");
	do									/* Entry loop */
    	{
        	IOPrintString(SCX/2-4,6,COL_BLUE,"--------");
        	IOPrintString(SCX/2-4,6,COL_WHITE,Name);
        	n = IOGet();
            if (n == 8 && *Name!='\0')	/* Delete/Backspace */
            	Name[strlen(Name)-1] = '\0';
            if (isalpha(n) &&			/* Legitimate name */
            			strlen(Name) < 8)
            {
            	if (*Name != '\0') n = tolower(n);
            	sprintf(Name+strlen(Name),"%c",n);
            }
        }
    while (*Name == '\0' || n != 13);	/* Until a non-empty name */

    _ICentre(10,COL_YELLOW,				/* Display character class */
    			"Please select a character class");
    for (n = 0;n < 5;n++)
    {
    	IOPrint(10,12+n*2,COL_CYAN,n+'1');
        IOPrintString(20,12+n*2,COL_GREEN,Class[n]);
    }
    return IOGet() - '0';				/* Get and return */

}

/************************************************************************/
/*							Kicked the bucket							*/
/************************************************************************/

void DeathCode(PLAYER *p)
{
    if (p->Treasure[0] == 1)			/* Amulet resurrection */
    {
    	p->Treasure[0] = p->Treasure[1] = p->Treasure[2] = 0;
        p->Cash = 0;p->CombatStr = 30;
        p->PSIStr = 30;p->Stamina = 150;
		IOPrintString(0,HEIGHT+8,COL_YELLOW,"Alarian's Amulet protects thy soul");
    	IOPrintString(0,HEIGHT+9,COL_YELLOW,"Live Again");
        IOTimedInkey(999);
        p->CLoc = 0;
        PLClear(p);
	    CLDispatch(CCM_DRAWPLAYER,p,NULL);
    }
	else
    {
		IOPrintString(0,HEIGHT+8,COL_RED,"Oh, what a frail shell");
    	IOPrintString(0,HEIGHT+9,COL_RED,"is that which we call man");
		IOTimedInkey(3000);
		p->Quit = 1;
    }
}
