/************************************************************************/
/*																		*/
/*		Name:		SUBAREA.C                                           */
/*		Function:	Swamp and Forest Handlers							*/
/*		Author:		Paul Robson      									*/
/*		Created:	2nd December 2001                                   */
/*		Modified:	3rd December 2001                                   */
/*		Project:	The Valley in C										*/
/*																		*/
/************************************************************************/

#include "valley.h"

static void _SADrawRoom(int x,int y);

/************************************************************************/
/*					Message handler for swamp/forest					*/
/************************************************************************/

void SASwampForestHandler(int Command,PLAYER *p,void *Data)
{
	LOCATION *l = &(p->Loc[p->CLoc]);
    int n,cl,ch;
	VASSERT(p != NULL);
    switch(Command)
	{
		case CCM_GETMLIST:
			VASSERT(Data != NULL);
			strcpy(Data,l->ClassID == RC_SWAMP ? "AFL":"FAEHL");
			break;

    	case CCM_REDRAW:				/* Redraw the scene */
        	PLDrawFrame(CHR_EXIT);
        	p->Floor = 2;				/* Set the effective floor */
            srand(l->Seed);				/* Seed random number gen. */
            n = 200 * HEIGHT / 12;		/* Scale swamps etc. */
            cl = COL_GREEN;ch = CHR_TREE;
            if (p->Loc[p->CLoc].ClassID == RC_SWAMP)
            	cl = COL_MAGENTA,ch = CHR_SWAMP;
            while (n-- > 0)
            	IOPrint(rand()%(SCX-2)+1,rand()%HEIGHT+1,cl,ch);
            _SADrawRoom(rand()%(SCX-10)+1,rand()%(HEIGHT-9)+2);
        	break;

        case CCM_POSTMOVE:
            if (l->OldChar == CHR_BUILDING)
                CLEnterArea(p,(l->ClassID == RC_SWAMP) ? RC_LAIR:RC_TEMPLE);
            else
	            CLDefaultHandler(Command,p,Data);
            break;


        case CCM_SETINITPOS:
        	l->x = SCX/2;l->y = HEIGHT;
            break;

        default:
            CLDefaultHandler(Command,p,Data);
            break;
    }
}

/************************************************************************/
/*			 Draw the little island area in the swamp/forest			*/
/************************************************************************/

static void _SADrawRoom(int x,int y)
{
	static int Bitmaps[7] = { 0x30,0x7C,0xCC,0xCE,0x7B,0xC0,0x40 };
    int i,j;
    for (i = 0;i < 7;i++)
    	for (j = 0;j < 8;j++)
        	if (Bitmaps[i] & (0x80 >> j))
            	IOPrint(x+j,y+i,COL_BLUE,CHR_WATER);
    IOPrint(x+2,y+2,COL_BLACK,' ');
    IOPrint(x+3,y+2,COL_BLACK,' ');
    IOPrint(x+2,y+3,COL_RED,CHR_BUILDING);
    IOPrint(x+3,y+3,COL_BLACK,' ');
}