/************************************************************************/
/*																		*/
/*		Name:		PLAYER.C                                            */
/*		Function:	Player Management Functions							*/
/*		Author:		Paul Robson      									*/
/*		Created:	2nd December 2001                                   */
/*		Modified:	3rd December 2001                                   */
/*		Project:	The Valley in C										*/
/*																		*/
/************************************************************************/

#include "valley.h"

/************************************************************************/
/*						Reset Player, given the class					*/
/************************************************************************/

void PLReset(int Class,PLAYER *Player)
{
	VASSERT(Player != NULL);
	memset(Player,0,sizeof(PLAYER));	/* Erase the whole structure */
	randomize();
	Player->CLoc = 0;					/* Current location entry zero */
    Player->Loc[0].ClassID = RC_VALLEY;	/* Create initial location structure */
    Player->Loc[0].Seed = rand();		/* Random generator value */
    CLDispatch(CCM_SETINITPOS,			/* Initialise the position */
	    					Player,NULL);

    Player->Cash = 0;					/* Other defaults */
    Player->Turns = 0;
    Player->Quit = 0;
    Player->Treasure[0] =
    		Player->Treasure[1] = Player->Treasure[2] = 0;
    Player->Experience = 5.0;
    Player->Stamina = 150;
    Player->MonsterFlag = 0;			/* No monster */
    strcpy(Player->Name,"John Doe");	/* Default name */
    switch(Class)
    {
    	case 1: strcpy(Player->Class,"Wizard");
        		Player->MagicSkill = 2;
                Player->CombatInc = 0.2;
                Player->CombatStr = 22;
                Player->PSIStr = 28;
                break;
    	case 2: strcpy(Player->Class,"Thinker");
        		Player->MagicSkill = 1.5;
                Player->CombatInc = 0.75;
                Player->CombatStr = 24;
                Player->PSIStr = 26;
                break;
    	case 3: strcpy(Player->Class,"Barbarian");
        		Player->MagicSkill = 0.5;
                Player->CombatInc = 2;
                Player->CombatStr = 28;
                Player->PSIStr = 22;
                break;
    	case 4: strcpy(Player->Class,"Warrior");
        		Player->MagicSkill = 1;
                Player->CombatInc = 1.5;
                Player->CombatStr = 26;
                Player->PSIStr = 24;
                break;
    	case 5: strcpy(Player->Class,"Cleric");
        		Player->MagicSkill = 1.25;
                Player->CombatInc = 1;
                Player->CombatStr = 25;
                Player->PSIStr = 25;
                break;
    	default:strcpy(Player->Class,"Dolt");
        		Player->MagicSkill = 1;
                Player->CombatInc = 1;
                Player->CombatStr = 20;
                Player->PSIStr = 20;
                break;
    }
}

/************************************************************************/
/*						Refresh the display panel						*/
/************************************************************************/

void PLPanel(PLAYER *p)
{
	int y = HEIGHT+3;
    char Temp[42];
	VASSERT(p != NULL);
	PLRangeCheck(p);
    sprintf(Temp,"%s the %s",p->Name,p->Class);
    IOPrintString(0,y,COL_WHITE,Temp);
    IOPrintString(0,y+1,COL_GREEN,"Treasure");
    IOPrintString(0,y+2,COL_GREEN,"Experience");
    IOPrintString(0,y+3,COL_GREEN,"Turns");
    IOPrintString(SCX/2,y+1,COL_GREEN,"Combat Str");
    IOPrintString(SCX/2,y+2,COL_GREEN,"PSI Str");
    IOPrintString(SCX/2,y+3,COL_GREEN,"Stamina");
    sprintf(Temp,"%-6ld",p->Cash);IOPrintString(11,y+1,COL_YELLOW,Temp);
    sprintf(Temp,"%-6.0f",p->Experience);IOPrintString(11,y+2,COL_YELLOW,Temp);
    sprintf(Temp,"%-4ld",p->Turns);IOPrintString(11,y+3,COL_YELLOW,Temp);
    sprintf(Temp,"%-6d",p->CombatStr);IOPrintString(SCX/2+11,y+1,COL_YELLOW,Temp);
    sprintf(Temp,"%-6d",p->PSIStr);IOPrintString(SCX/2+11,y+2,COL_YELLOW,Temp);
    sprintf(Temp,"%-6d",p->Stamina);IOPrintString(SCX/2+11,y+3,COL_YELLOW,Temp);
   	sprintf(Temp,"%40s","");IOPrintString(0,y+4,COL_WHITE,Temp);
    if (p->MonsterFlag)
    {
		IOPrintString(0,y+4,COL_CYAN,p->Mon.Name);
        IOPrintString(SCX/2,y+4,COL_GREEN,"M Str = ");
		sprintf(Temp,"%-3d %-3d",p->Mon.Combat,p->Mon.PSI);
        IOPrintString(SCX/2+11,y+4,COL_YELLOW,Temp);
    }
}

/************************************************************************/
/*							Redraw the entire screen					*/
/************************************************************************/

void PLClear(PLAYER *p)
{
	IOClear();							/* Clear screen */
    PLPanel(p);							/* Draw information panel */
    CLDispatch(CCM_REDRAW,p,NULL);		/* Redraw the display */
}

/************************************************************************/
/*							Display a banner message					*/
/************************************************************************/

void PLBanner(char *Msg,int Delay)
{
    int y = HEIGHT+8;
    char Temp[41];
    sprintf(Temp,"%-40s",Msg);
    IOPrintString(0,y,COL_YELLOW,Temp);
	PLDelay(Delay);
    if (Delay > 0)
    {
    	sprintf(Temp,"%-40s","");
        IOPrintString(0,y,COL_YELLOW,Temp);
    }
}

/************************************************************************/
/*								Short delay								*/
/************************************************************************/

void PLDelay(int Delay)
{
	long EndTime = IOGetTimer()+Delay*5;
    while (EndTime > IOGetTimer()) {};
}

/************************************************************************/
/*							Save your game								*/
/************************************************************************/

void PLSaveCharacter(PLAYER *p)
{
	FILE *f = fopen(PLFileName(),"wb");
    fwrite(p,sizeof(PLAYER),1,f);
    fclose(f);
}

/************************************************************************/
/*						Display player status							*/
/************************************************************************/

void PLStatusDisplay(PLAYER *p)
{
	double n;
    int y = HEIGHT+9;
    char Temp[32];
    n = 0.067*((double)p->Experience+(double)p->Cash /3.0);
    n = pow(n,0.5);
    n = n + log ((double)p->Experience /(pow(p->Turns+1,1.5)));
    if (n < 0.0) n = 0.0;
    if (n > 28.0) n = 28.0;
    IOClearWindow(0,HEIGHT+8,SCX-1,SCY-1);
	IOPrintString(0,HEIGHT+8,COL_GREEN,"Your rating is now");
    sprintf(Temp,"%.0f",n);IOPrintString(SCX/2,HEIGHT+8,COL_YELLOW,Temp);
    if (p->Treasure[2] != 0)
    	IOPrintString(0,y++,COL_GREEN,"You have the Helm of Evanna");
	if (p->Treasure[0] != 0)
    {
        IOPrintString(0,y,COL_GREEN,"Amulet Stones");
	    sprintf(Temp,"%d",p->Treasure[1]);IOPrintString(SCX/2,y++,COL_YELLOW,Temp);
    }
    IOGet();
    IOClearWindow(0,HEIGHT+8,SCX-1,SCY-1);
}

/************************************************************************/
/*							Draw the full frame							*/
/************************************************************************/

void PLDrawFrame(int Char)
{
	int x,y;
	for (y = 0;y < HEIGHT;y++)			/* Draw frame */
    {
    	IOPrint(0,y+1,COL_YELLOW,Char);
    	IOPrint(SCX-1,y+1,COL_YELLOW,Char);
    }
    for (x = 0;x < SCX;x++)
    {
    	IOPrint(x,0,COL_YELLOW,Char);
    	IOPrint(x,HEIGHT+1,COL_YELLOW,Char);
    }
}

/************************************************************************/
/*						Force values within range						*/
/************************************************************************/

void PLRangeCheck(PLAYER *p)
{
	int n;
	n = 77 - 2*(int)pow(p->MagicSkill,2.5);
	if (p->CombatStr > n) p->CombatStr = n;

	n = (int)(42.0 * pow(p->MagicSkill+1,log(pow(p->MagicSkill,3.7)))+75);
	if (p->PSIStr > n) p->PSIStr = n;

	n = 125 - (int)(p->MagicSkill * 12.5);
	if (p->Stamina > n) p->Stamina = n;

	if (p->PSIStr < 7) p->PSIStr = 7;
    if (p->Stamina < 0) p->Stamina = 0;
	if (p->Mon.Combat < 0) p->Mon.Combat = 0;
	if (p->Mon.PSI < 0) p->Mon.PSI = 0;
}

/************************************************************************/
/*							Get a file name								*/
/************************************************************************/

char *PLFileName(void)
{
	int n;
    static char FName[24];
	PLBanner("Enter a game slot 0-9",0);
	do n = IOGet(); while (n < '0' || n > '9');
    sprintf(FName,"VALLEY%c.DAT",n);
    return FName;
}

/************************************************************************/
/*							Load a file 								*/
/************************************************************************/

int PLLoadFile(PLAYER *p)
{
	char *pr = "Do you want to Load a game ?";
    FILE *f;
	int n;
	#ifdef IDE
	return 0;
	#endif
	IOClear();
	IOPrintString(SCX/2-strlen(pr)/2,SCY/2,COL_CYAN,pr);
	do n = IOGet(); while (n != 'Y' && n != 'N');
    if (n == 'N') return 0;
    f = fopen(PLFileName(),"rb");
    if (f == NULL) return PLLoadFile(p);
	fread(p,sizeof(PLAYER),1,f);
    fclose(f);
    return 1;
}