/************************************************************************/
/*																		*/
/*		Name:		MONSTER.C                                           */
/*		Function:	Monster Battles      								*/
/*		Author:		Paul Robson      									*/
/*		Created:	3rd December 2001                                   */
/*		Modified:	3rd December 2001                                   */
/*		Project:	The Valley in C										*/
/*																		*/
/************************************************************************/

#include "valley.h"

static void MOMonsterAttack(PLAYER *p);
static void MOPlayerAttack(PLAYER *p);
static void MOMonsterSwipe(PLAYER *p);
static void MOMonsterSpell(PLAYER *p);
static void MOSwordAttack(PLAYER *p,int Target);
static void MOSpellAttack(PLAYER *p);
static int MOSpellSleep(PLAYER *p);
static int MOSpellLance(PLAYER *p);
static int MOSpellBlast(PLAYER *p);

/************************************************************************/
/*							Monster fight time !						*/
/************************************************************************/

void MOAttack(PLAYER *p)
{
	int i,n,Found,Turn;
	double d;
	char Temp[32],Types[32];
	LOCATION *l = &(p->Loc[p->CLoc]);
	#ifdef IDE
	return;
	#endif
	p->MonsterFlag = 1;
	n = MOGetMonster(999,&(p->Mon));	/* Read monster count */
	CLDispatch(CCM_GETMLIST,p,Types);	/* Get types list */
	Found = 0;							/* Find a legitimate monster */
	while (Found == 0)
	{
		i = rand()%n;					/* Select one at random */
		if (l->OldChar == CHR_WATER)	/* Special water monsters */
							i = rand()%2 + 17;
		MOGetMonster(i,&(p->Mon));		/* Read its information */
		if (strchr(Types,p->Mon.Location)	/* Does it belong here ? */
							!= NULL) Found = 1;
		if (stricmp(p->Mon.Name,		/* Not too many Balrogs */
			"balrog") == 0 && rand() % 10 < 7) Found = 0;
		if (stricmp(p->Mon.Name,		/* Ring wraiths in upper levels only */
				"ring-wraith") == 0 && p->Floor < 5) Found = 0;
	}

										/* Calculate actual combat */
	d = (0.3 * p->CombatStr)+p->Mon.Combat;
	d = d * pow(p->Floor,0.2);
	d = d / (1.0+((rand()%100)/100.0));
	if (p->Mon.Combat != 0) p->Mon.Combat = (int)(d+0.5);
										/* Calculate actual magic */
	d = p->Mon.PSI * pow (p->Floor,0.2);
	d = d / (1.0+((rand()%100)/100.0));
	if (p->Mon.PSI != 0) p->Mon.PSI = (int)(d+0.5);

	p->NewExp = (i+1) *					/* Experience to be gained */
					(pow(p->Floor,1.5));

    p->FightFactor = 39.0 *				/* Calculate the fighting factor */
    					log(p->Experience) / 3.14;

										/* Display information */
	PLBanner("Beware. Thou hast encountered ...",200);
	sprintf(Temp,"... an evil %s",p->Mon.Name);
	PLBanner(Temp,200);
    Turn = 0;							/* Monster first */
	if (rand() % 10 >= 6)				/* Option to attack or run ? */
	{
		PLBanner("You have surprise... attack or retreat?",0);
		n = IOTimedInkey(1500);
		PLBanner("",0);
		if (n == 'R')					/* Retreat */
		{
			PLBanner("Knavish Coward !",200);
			p->MonsterFlag = 0;
			return;
		}
		if (n == 'A')					/* Attack, player gets first blow */
		{
			PLPanel(p);
            Turn = 1;
		}
	}

    p->Mon.Defeated = 0;				/* Defeated ? */

	while (p->Stamina > 0 &&			/* Keep going till one person is dead */
				(p->Mon.Combat+p->Mon.PSI) > 0)
	{
		if (Turn == 0 &&				/* Monster only attacks if not defeated */
        		p->Mon.Defeated == 0)
        {
        	PLPanel(p);
			MOMonsterAttack(p);
        }
        if (Turn == 1)					/* Players turn */
        {
			PLPanel(p);
			MOPlayerAttack(p);
        }
        Turn = 1-Turn;					/* Swap next time */
	}
	p->MonsterFlag = 0;					/* Monster over */
	if (p->Stamina > 0)					/* We won.... */
    	p->Experience += p->NewExp;		/* Add experience */
}
/************************************************************************/
/*							Get Monster Information						*/
/************************************************************************/

int MOGetMonster(int n,MONSTER *p)
{
	int Result = 0;
	VASSERT(p != NULL);
	switch (n)
	{
		case  0: strcpy(p->Name,"awolfen");p->Combat=9; p->PSI=0;break;
		case  1: strcpy(p->Name,"ahob-goblin");p->Combat=9; p->PSI=0;break;
		case  2: strcpy(p->Name,"aorc");p->Combat=9; p->PSI=0;break;
		case  3: strcpy(p->Name,"efire-imp");p->Combat=7; p->PSI=3;break;
		case  4: strcpy(p->Name,"grock-troll");p->Combat=19; p->PSI=0;break;
		case  5: strcpy(p->Name,"eharpy");p->Combat=10; p->PSI=12;break;
		case  6: strcpy(p->Name,"aogre");p->Combat=23; p->PSI=0;break;
		case  7: strcpy(p->Name,"bbarrow-wight");p->Combat=0; p->PSI=25;break;
		case  8: strcpy(p->Name,"hcentaur");p->Combat=18; p->PSI=14;break;
		case  9: strcpy(p->Name,"efire-giant");p->Combat=26; p->PSI=20;break;
        case 10: strcpy(p->Name,"vthunder-lizard");p->Combat=50; p->PSI=0;break;
        case 11: strcpy(p->Name,"cminotaur");p->Combat=35; p->PSI=25;break;
        case 12: strcpy(p->Name,"cwraith");p->Combat=0; p->PSI=30;break;
        case 13: strcpy(p->Name,"fwyvern");p->Combat=36; p->PSI=12;break;
        case 14: strcpy(p->Name,"bdragon");p->Combat=50; p->PSI=20;break;
        case 15: strcpy(p->Name,"cring-wraith");p->Combat=0; p->PSI=45;break;
        case 16: strcpy(p->Name,"abalrog");p->Combat=50; p->PSI=50;break;
        case 17: strcpy(p->Name,"lwater-imp");p->Combat=15; p->PSI=15;break;
        case 18: strcpy(p->Name,"lkraken");p->Combat=50; p->PSI=0;break;
		default: Result = 19;break;
	}
	if (Result == 0)
	{
		p->Location = toupper(p->Name[0]);
		strcpy(p->Name,p->Name+1);
        p->Name[0] = toupper(p->Name[0]);
	}
	return Result;
}

/************************************************************************/
/*						Monsters turn to attack							*/
/************************************************************************/

static void MOMonsterAttack(PLAYER *p)
{
	int MagicType;
    MONSTER *m = &(p->Mon);
	PLBanner("The Creature attacks...",150);
	MagicType = (m->Combat < m->PSI &&	/* Work out what to do */
    			 m->PSI > 6 &&
                 rand() % 2 == 0);
    if (m->Combat == 0) MagicType = 1;
    if (MagicType == 0)					/* Attack physically */
    	MOMonsterSwipe(p);
    else								/* Magic attack */
    	MOMonsterSpell(p);
}

/************************************************************************/
/*						Monster attacks physically						*/
/************************************************************************/

static void MOMonsterSwipe(PLAYER *p)
{
	double g,Damage;
    char Temp[32];
    MONSTER *m = &(p->Mon);
   	m->Combat--;       					/* Uses one combat point */
    if (m->Combat <= 0)					/* Died attacking */
    {
       	PLBanner("Using its last energy in the attempt",400);
        p->NewExp = p->NewExp / 2.0;	/* Half experience */
        m->Combat = m->PSI = 0;			/* Kill it */
        return;
    }
    Damage = 0.0;
    switch (rand()%10)					/* 10 options */
    {
    	case 0:
           	PLBanner("It swings at you... and misses",160);
            break;
        case 1:
           	PLBanner("Your blade defects the blow",160);
            break;
        case 2:
           	PLBanner("... but hesitates, unsure ...",160);
            break;
        case 3:
           	Damage = 3.0;PLBanner("It strikes your head !",160);
            break;
        case 4:
        case 5:
           	Damage = 1.5;PLBanner("Your chest is struck!",160);
            break;
        case 6:
        case 7:
          	Damage = 1.0;PLBanner("A strike to your sword arm !",160);
            break;
        case 8:
           	Damage = 1.3;PLBanner("A blow to your body !",160);
            break;
        case 9:
          	Damage = 0.5;PLBanner("It catches your legs !",160);
            break;
    }
    if (Damage != 0.0)					/* It didn't miss ... */
    {
		g = m->Combat * 75.0 * ((double)(rand() % 1000)) / 1000.0;
        g = g - (10 * p->CombatStr) - p->FightFactor;
        g = g / 100 * Damage;
        if (g < 1.0)
        {
          	g = 0;
            PLBanner("... saved by your Armour",100);
        }
        else
        {
            p->Stamina -= (int)g;		/* Take a hit */
            if (g > 9)					/* A real whack ! */
            		p->CombatStr -= (int)(g/6);
            sprintf(Temp,"You take %.0f damage...",g);
            PLBanner(Temp,180);
        }
    }
}

/************************************************************************/
/*							Monster uses magic							*/
/************************************************************************/

static void MOMonsterSpell(PLAYER *p)
{
    MONSTER *m = &(p->Mon);
    double g;
	char Temp[32];
   	PLBanner("Hurling a lightning bolt at you !",150);
    	        						/* Calculate Damage */
    g = 180.0 * (m->PSI) * ((double)(rand()%1000)) / 1000.0;
    g = (g - p->PSIStr - p->FightFactor) / 100.0;
    m->PSI = m->PSI - 5;				/* Monster loses magic points */
    if (g > 9)							/* Can damage magic rating */
           	p->PSIStr -= (int)(g/5);
    if (m->PSI < 0)						/* Effort kills it */
    {
       	PLBanner("Using its last energy in the attempt",400);
        p->NewExp = p->NewExp / 2.0;	/* Half experience */
   	    m->Combat = m->PSI = 0;			/* Kill it */
       	return;
    }
	if (rand() % 4 == 0)				/* 1 in 4 chance of missing */
    {
       	PLBanner("... Missed you !",180);
        return;
    }
    if (g < 1.0)						/* Saved by shield */
    {
      	g = 0;
        PLBanner("Your PSI Shield protects you",150);
        return;
    }
    p->Stamina -= (int)g;			/* Been hit */
    PLBanner("It strikes home !",150);
    sprintf(Temp,"You take %.0f damage...",g);
    PLBanner(Temp,180);
}

/************************************************************************/
/*							  Player attacks							*/
/************************************************************************/

static void MOPlayerAttack(PLAYER *p)
{
    int n;
    PLBanner("**** Strike Quickly ****",0);
    n = IOTimedInkey(1500);				/* Get keystroke */
    if (n == 0)							/* Not got ! */
    {
    	PLBanner("Too slow ... Too slow",150);
        return;
    }
    if (n == 'S') MOSpellAttack(p);		/* Decide what to do */
    if (strchr("HBL",n) != NULL) MOSwordAttack(p,n);
}

/************************************************************************/
/*							Bash with sword								*/
/************************************************************************/

static void MOSwordAttack(PLAYER *p,int Target)
{
	int n;
    double Damage,g;
    char Temp[32];
    MONSTER *m = &(p->Mon);
    if (m->Combat <= 0)					/* Can't whack magic monsters */
    {
    	PLBanner("Your sword avails you nought here",180);
        return;
    }
    if (--p->Stamina == 0)				/* Last breath ? */
    {
        PLBanner("You fatally exhaust yourself",400);
        return;
    }
    n = rand() % 10;Damage = 0.0;
    switch(Target)						/* Work out basic damage level */
    {
    	case 'H':
			if (n < 5 || p->CombatStr > m->Combat*4) Damage = 2.0;
            break;
    	case 'B':
			if (n < 7 || p->CombatStr > m->Combat*4) Damage = 1.0;
            break;
    	case 'L':
			if (n < 9 || p->CombatStr > m->Combat*4) Damage = 0.3;
            break;
	}
    if (Damage == 0.0)					/* Missed it */
    {
        PLBanner("You missed it !",280);
        return;
    }
                   						/* Work out actual damage */
    g = p->CombatStr * 50.0 * ((double)(rand()%1000)) / 1000.0;
    g = g - (10.0 * m->Combat) + p->FightFactor;
    g = g / 100.0 * Damage;
    if (g < 1.0) g = 0;
    if (m->Defeated)					/* Is defeated, this one */
        Damage = m->Combat + rand() % 9 + 1;

    if (p->CombatStr > (m->Combat-g)*4)	/* Check if defeated ... */
						    	m->Defeated = 1;
    m->Combat -= (int)g;				/* Damage it */
    PLBanner("A Hit ...",150);
    if (g == 0)							/* But nothing .... */
    {
    	m->Defeated = 0;
        PLBanner(".... but no damage",280);
        return;
    }
    sprintf(Temp,"%.0f damage....",g);	/* Display damage */
    PLBanner(Temp,150);
	if (m->Defeated && m->Combat >= 0)	/* Display if defeated */
    	PLBanner("The monster staggers defeated ...",140);
    if (m->Combat <= 0)					/* Check dead */
    {
    	PLBanner("... killing the Monster !",180);
        m->Combat = m->PSI = 0;
    }
}

/************************************************************************/
/*							  Cast a spell								*/
/************************************************************************/

static void MOSpellAttack(PLAYER *p)
{
    MONSTER *m = &(p->Mon);
    int n,Result;
    PLBanner("Which spell seek ye ?",0);/* Get spell number */
	n = IOTimedInkey(1500);
    if (n == 0)							/* Not got ! */
    {
    	PLBanner("Too slow ... Too slow",150);
        return;
    }
    if (n < '1' || n > '3')				/* Invalid key */
    {
    	PLBanner("No such spell ...",150);
        return;
    }
    if (4 * p->PSIStr *					/* Too weak */
    		(rand()%100)/100 <= m->PSI) n = 0;
    switch(n)
    {
    	case '1': Result = MOSpellSleep(p);break;
    	case '2': Result = MOSpellLance(p);break;
    	case '3': Result = MOSpellBlast(p);break;
        default:  Result = SPR_PSISHIELD;break;
    }
    switch(Result)
    {
    	case SPR_PSISHIELD:
        	PLBanner("No use, the beasts PSI shields it.",180);break;
        case SPR_BEYOND:
        	PLBanner("It is beyond you",180);break;
        case SPR_SAPSTRENGTH:
        	PLBanner("The spell saps all your strength",180);
            p->Stamina = 0;break;
        case SPR_FAILS:
        	PLBanner(".... but the spell fails!",180);break;
        case SPR_OK:
        	break;
    }
}

/************************************************************************/
/*									Sleep								*/
/************************************************************************/

static int MOSpellSleep(PLAYER *p)
{
    MONSTER *m = &(p->Mon);
	p->Stamina -= 5;					/* Some cost in stamina */
    if (p->Stamina <= 0) return SPR_SAPSTRENGTH;
    PLBanner("Sleep you foul fiend that I may escape",200);
    PLBanner("The creature staggers...",200);
    if (rand() % 2 == 0)
    {
    	PLBanner("... and collapses, stunned.",200);
        p->NewExp = p->NewExp / 2;
        m->Combat = m->PSI = 0;
    }
    else
    	PLBanner("... but recovers with a snarl.",200);
	return SPR_OK;
}

/************************************************************************/
/*								PSI Lance								*/
/************************************************************************/

static int MOSpellLance(PLAYER *p)
{
    MONSTER *m = &(p->Mon);
    double rf,Damage;
    char Temp[40];
    if (m->Combat > p->Stamina) return SPR_BEYOND;
    if (p->PSIStr < 49 || p->Experience < 1000) return SPR_BEYOND;
	p->Stamina -= 10;					/* Some cost in stamina */
    if (p->Stamina <= 0) return SPR_SAPSTRENGTH;
    if (m->PSI == 0)					/* Must have some PSI ! */
    {
    	PLBanner("This beast has no PSI to Attack",200);
        return SPR_OK;
    }
	PLBanner("With my mind I battle thee for my life",180);
    rf = ((double)(rand()%100))/100.0;	/* Chance of failure */
    if (rf < 0.4 && m->PSI > 10) return SPR_FAILS;

    Damage = rf * 50 * p->CombatStr;	/* Calculate damage */
    Damage = (Damage - 5 * (m->Combat+m->PSI) + p->FightFactor) / 50 / 4;
    if (Damage < 1.0) return SPR_PSISHIELD;
    sprintf(Temp,"The PSI Lance causes %.0f damage",Damage*2);
    PLBanner(Temp,180);
    m->PSI -= Damage * 2;				/* Adjust the values */
    m->Combat -= Damage;
	return SPR_OK;
}

/************************************************************************/
/*						Flaming sword death thingy						*/
/************************************************************************/

static int MOSpellBlast(PLAYER *p)
{
    MONSTER *m = &(p->Mon);
    double rf,Damage;
    char Temp[40];
    if (p->PSIStr < 77 ||				/* Requirements */
    		p->Experience < 5000) return SPR_BEYOND;
	p->Stamina -= 20;					/* Some cost in stamina */
    if (p->Stamina <= 0) return SPR_SAPSTRENGTH;
    PLBanner("With the might of my sword I smite thee",180);
    PLBanner("With the power of my spell I curse thee",180);
    PLBanner("Burn ye spawn of hell and suffer",280);
    PLBanner("A bolt of energy lashes at the beast",280);

    rf = ((double)(rand()%100))/100.0;	/* Chance of failure */
    if (rf > (p->PSIStr/780.0)*(5-p->MagicSkill))
    {
    	PLBanner("Missed it !",180);
        return SPR_OK;
    }

    rf = ((double)(rand()%100))/100.0;	/* Calculate Damage */
    Damage = (rf * p->CombatStr * p->PSIStr);
    rf = ((double)(rand()%100))/100.0;
	Damage = Damage - (10 * m->PSI * rf);
    if (Damage < 1.0) return SPR_PSISHIELD;

    if (m->Combat == 0)					/* Do damage to PSI or Combat */
    	m->PSI = m->PSI - Damage;
    else
    {
    	m->Combat = m->Combat - Damage;
        if (Damage > 10) m->PSI = m->PSI - Damage/3;
    }

    sprintf(Temp,"It strikes home causing %.0f damage",Damage);
    PLBanner(Temp,180);

    if (m->PSI < 0) m->PSI = 0;
    if (m->Combat < 0) m->Combat = 0;
    if (m->PSI + m->Combat == 0)
    	PLBanner("The beast dies screaming !",180);
    return SPR_OK;
}
