/************************************************************************/
/*																		*/
/*		Name:		IO_DOS.C                                            */
/*		Function:	MSDOS/Turbo C Hardware Interface					*/
/*		Author:		Paul Robson      									*/
/*		Created:	2nd December 2001                                   */
/*		Modified:	4th December 2001                                   */
/*		Project:	The Valley in C										*/
/*																		*/
/************************************************************************/

#define DRIVER
#include "valley.h"

#include <conio.h>						/* Specific to this file */
#include <graphics.h>

/************************************************************************/
/*		  User Defined Graphics lifted from the BBC Micro Version		*/
/************************************************************************/

char BBCGfx[18*8] = {
        126,189,219,231,231,219,189,126,
        231,231,231,0,0,231,231,231,
        1,2,4,8,16,32,64,128,
        128,64,32,16,8,4,2,1,
        255,193,128,128,128,148,247,247,
        255,231,219,189,189,219,231,255,
        24,24,65,90,88,64,36,36,
        0,1,3,7,15,31,63,127,
        170,85,170,85,170,85,170,85,
        255,213,128,255,255,171,1,255,
        0,62,127,127,127,107,8,8,
        255,255,255,255,255,255,255,255,
        2,5,32,80,4,10,64,160,
        129,189,189,181,189,189,189,129,
        255,204,51,255,255,204,51,255,
        153,90,36,219,219,36,90,153,
        255,129,129,129,129,129,129,255,
        231,231,190,165,167,191,219,219,
};

static int ColTrans[8] =				/* Colours -> IBM Standard */
    				{ 0,12,10,14,9,13,11,15 };

static char PixelGraphics[4608];		/* Multicolour graphics */

/************************************************************************/
/*						Initialise the Hardware I/O						*/
/************************************************************************/

void HWInitialise(void)
{
	int Drv = VGA;  					/* Borland driver */
	int	Mode = VGAHI;					/* Mode */
	FILE *f;
	f = fopen("GRAPHICS.BIN","rb");		/* Read in graphics data */
	if (f == NULL) HWError(__LINE__,__FILE__);
	fread(PixelGraphics,sizeof(PixelGraphics),1,f);
	fclose(f);
	#ifdef EGARES
	Drv = EGA;Mode = EGAHI;
    #endif
	initgraph(&Drv,&Mode,".");			/* Switch graphics on */
    if (graphresult() != grOk)
    				HWError(__LINE__,__FILE__);
}

/************************************************************************/
/*						   Terminate Hardware I/O						*/
/************************************************************************/

void HWTerminate(void)
{
	closegraph();						/* Back to text mode */
}

/************************************************************************/
/*			Read key, return ASCII code or 0 if no key pressed			*/
/************************************************************************/

int HWInkey(void)
{
	int c;
	if (!kbhit()) return 0;				/* Key pressed ? */
    c = getch();						/* Get key */
    if (c == 0) c = -getch();			/* Handle IBM specials */
    return (c < 0) ? 0 : toupper(c);	/* Zero if IBM special */
}

/************************************************************************/
/*					Return elapsed time in milliseconds					*/
/************************************************************************/

long HWGetTimer(void)
{
	return clock() * 10000L / 182L;		/* Get PC Tick and scale it */
}

/************************************************************************/
/*							Draw a BBC Micro UDG						*/
/************************************************************************/

static void _HWDrawUDG(char *Data,int x1,int y1,int x2,int y2,int n,int c)
{
	int x,y;
	if (x2-x1 == 15 && y2-y1 == 15)
		if (HWDrawGraphic(x1,y1,n,c)) return;

    for (y = 0;y < 8;y++)				/* Work through the bitmaps */
    	for (x = 0;x < 8;x++)
        	if (Data[y] & (0x80 >> x))	/* If pixel set,draw a solid block */
            	bar((x2-x1)*x/8+x1,(y2-y1)*y/8+y1,
                	(x2-x1)*(x+1)/8+x1-1,(y2-y1)*(y+1)/8+y1-1);
}

/************************************************************************/
/*							Print a character							*/
/************************************************************************/

void HWPrint(int x,int y,int Colour,int Char)
{
	int x1,y1,x2,y2,ySize;
    char Temp[2];
    if (x < 0 || y < 0) return;			/* Check range */
	if (x >= SCX || y >= SCY) return;

	ySize = (getmaxy()+1) / SCY;
	if (ySize > 16) ySize = 16;

	x1 = x * (getmaxx()+1) / SCX;		/* Calculate box surrounding char */
	x2 = (x+1) * (getmaxx()+1) / SCX-1;
	y1 = y * ySize;
	y2 = (y+1) * ySize-1;
    setfillstyle(SOLID_FILL,BLACK); 	/* Fill in the background */
	bar(x1,y1,x2,y2);
    if (Char == 32) return;				/* Space */
    setcolor(ColTrans[Colour & 7]);		/* Set drawing colour */
   	setfillstyle(SOLID_FILL,ColTrans[Colour & 7]);
    if (Char >= 224 && Char < 242)		/* If it's a UDG */
    {
		_HWDrawUDG(BBCGfx+(Char-224)*8,x1,y1,x2,y2,Char,Colour);
        return;
    }
    if (Char > 32 && Char < 126)		/* If it's a character */
    {
		Temp[0] = Char;Temp[1] = '\0';
		if (getmaxy() >= 479)			/* 640 x 480 */
			settextstyle(SMALL_FONT,HORIZ_DIR,6);
		else							/* 640 x 350 */
			settextstyle(SMALL_FONT,HORIZ_DIR,6);
	    outtextxy((x1+x2-textwidth(Temp))/2+2,
    			  (y1+y2-textheight(Temp))/2-2,Temp);
        return;
    }
    rectangle(x1,y1,x2,y2);				/* Otherwise draw a box */
    line(x1,y1,x2,y2);line(x1,y2,x2,y1);/* And cross */
}

/************************************************************************/
/*								Report an Error							*/
/************************************************************************/

void HWError(int Line,char *File)
{
	closegraph();
    fprintf(stderr,"Error at %d of %s.\n\n",Line,File);
    exit(1);
}

/************************************************************************/
/*					Draw Graphic as multicolour pixel					*/
/************************************************************************/

int HWDrawGraphic(int x,int y,int Char,int Colour)
{
	int x1,y1;
	char c;
	for (x1 = 0;x1 < 16;x1++)
		for (y1 = 0;y1 < 16;y1++)
		{
			c = PixelGraphics[(Char-224)*256+y1*16+x1];
			if (c & 0x80) c = Colour;
			c = ColTrans[c & 7];
			putpixel(x+x1,y+y1,c);
		}
	return 1;
}
