/************************************************************************/
/*																		*/
/*		Name:		IO.C 	                                            */
/*		Function:	Layer between I/O Functions and Drivers				*/
/*		Author:		Paul Robson      									*/
/*		Created:	2nd December 2001                                   */
/*		Modified:	3rd December 2001                                   */
/*		Project:	The Valley in C										*/
/*																		*/
/************************************************************************/

#define  DRIVER
#include "valley.h"

static int ScreenMap[SCX][SCY];			/* Current screen display */
static int ColourMap[SCX][SCY];

/************************************************************************/
/*			These simply map straight onto the Driver Funcs				*/
/************************************************************************/

void IOInitialise(void) 			{ HWInitialise(); }
void IOTerminate(void) 	 			{ HWTerminate(); }
int  IOInkey(void)					{ return HWInkey(); }
long IOGetTimer(void)				{ return HWGetTimer(); }
void IOError(int Line,char *File) 	{ HWError(Line,File); }

/************************************************************************/
/*						Print a single character						*/
/************************************************************************/

void IOPrint(int x,int y,int Colour,int Char)
{
	VASSERT(x >= 0 && x < SCX);			/* Validation */
	VASSERT(y >= 0 && y < SCY);
	VASSERT(Colour >= 0 && Colour < 8);
	HWPrint(x,y,Colour & 7,Char & 255);	/* Display it */
    ScreenMap[x][y] = Char;				/* Copy into the map */
    ColourMap[x][y] = Colour;
}

/************************************************************************/
/*				    Clear the screen or a Window in it					*/
/************************************************************************/

void IOClearWindow(int x1,int y1,int x2,int y2)
{
	int x,y;
	VASSERT(x1 >= 0 && x1 < SCX);			/* Validation */
	VASSERT(y1 >= 0 && y1 < SCY);
	VASSERT(x2 >= 0 && x2 < SCX);
	VASSERT(y2 >= 0 && y2 < SCY);
	VASSERT(x1 <= x2 && y1 <= y2);
	for (x = x1;x <= x2;x++)
    	for (y = y1;y <= y2;y++)
	        	IOPrint(x,y,7,' ');
}

void IOClear(void) { IOClearWindow(0,0,SCX-1,SCY-1); }

/************************************************************************/
/*							Read a keystroke							*/
/************************************************************************/

int IOGet(void)
{
	int c;
	while (IOInkey() != 0) {};
    do
    	c = IOInkey();
    while (c == 0);
    return c;
}

/************************************************************************/
/*		     Read a key if one available in the given time				*/
/************************************************************************/

int IOTimedInkey(int msTime)
{
	long EndTime;
    int  c;
	VASSERT(msTime >= 0 && msTime < 10000);
	while (IOInkey() != 0) {};
    EndTime = (long)msTime + IOGetTimer();
    while (IOGetTimer() < EndTime)
    {
    	c = IOInkey();
        if (c != 0) return c;
    }
    return 0;
}

/************************************************************************/
/*							Print a string								*/
/************************************************************************/

void IOPrintString(int x,int y,int Colour,char *String)
{
	VASSERT(x >= 0 && x < SCX);			/* Validation */
	VASSERT(y >= 0 && y < SCY);
	VASSERT(Colour >= 0 && Colour < 8);
	VASSERT(String != NULL);
	VASSERT(x+strlen(String) <= SCX);

	while (*String != '\0')				/* Display all characters */
	    	IOPrint(x++,y,Colour,*String++);
}

/************************************************************************/
/*						Read screen information							*/
/************************************************************************/

void IORead(int x,int y,int *Colour,int *Char)
{
	VASSERT(x >= 0 && x < SCX);			/* Validation */
	VASSERT(y >= 0 && y < SCY);
    if (Colour != NULL) *Colour = ColourMap[x][y];
    if (Char != NULL)   *Char = ScreenMap[x][y];
}

