#include <stdio.h>
#include "allegro.h"

char Data[4608];

void ConvertBinToBmp(void);
void ConvertBmpToBin(void);
void GetPos(int n,int *x,int *y);

int main()
{
	int i;
	RGB r;
	allegro_init();
	set_color_depth(8);
	set_gfx_mode(GFX_AUTODETECT,640,480,640,480);
	for (i = 0;i < 8;i++)
	{
		r.r = (i & 1) ? 63 : 0;
		r.g = (i & 2) ? 63 : 0;
		r.b = (i & 4) ? 63 : 0;
		set_color(i,&r);
	}
	r.r = 31;r.g = 31;r.b = 31;
	set_color(i,&r);
	r.r = r.g = r.b = 0;
	for (i = 9;i < 256;i++) set_color(i,&r);
	ConvertBmpToBin();
	return 0;
}

void ConvertBmpToBin()
{
	PALETTE Pal;
	int n,x,y,c,xo,yo;
	FILE *f;
	BITMAP *Bmp = load_bmp("GRAPHICS.BMP",Pal);
	blit(Bmp,screen,0,0,0,0,212,96);
	for (n = 0;n < 18;n++)
	{
		GetPos(n,&xo,&yo);
		for (x = 0;x < 16;x++)
			for (y = 0;y < 16;y++)
			{
				c = getpixel(screen,x+xo,y+yo);
				Data[n*256+x+y*16] = c;
			}
	}
	f = fopen("GRAPHICS.BIN","wb");
	fwrite(Data,sizeof(Data),1,f);
	fclose(f);
}

void ConvertBinToBmp()
{
	FILE *f;
	int n,x,y,c,xo,yo;
	PALETTE Pal;
	BITMAP *Bmp;
	f = fopen("GRAPHICS.BIN","rb");
	fread(Data,sizeof(Data),1,f);
	fclose(f);
	rectfill(screen,0,0,639,479,8);
	for (n = 0;n < 18;n++)
	{
		GetPos(n,&xo,&yo);
		for (x = 0;x < 16;x++)
			for (y = 0;y < 16;y++)
			{
				c = Data[n*256+x+y*16];
				if (c & 0x80) c = 6;
				putpixel(screen,x+xo,y+yo,c);
			}
	}
	get_palette(Pal);
	Bmp = create_sub_bitmap(screen,0,0,212,96);
	save_bmp("Graphics.Bmp",Bmp,Pal);
	destroy_bitmap(Bmp);

}

void GetPos(int n,int *x,int *y)
{
	*x = (n % 8) * 24 + 16;
	*y = (n / 8) * 24 + 16;
}
