/************************************************************************/
/*																		*/
/*		Name:		CLASS.C                                             */
/*		Function:	Class Dispatched and Valley Handler					*/
/*		Author:		Paul Robson      									*/
/*		Created:	2nd December 2001                                   */
/*		Modified:	3rd December 2001                                   */
/*		Project:	The Valley in C										*/
/*																		*/
/************************************************************************/

#include "valley.h"

/************************************************************************/
/*				Dispatch messages to appropriate handler				*/
/************************************************************************/

void CLDispatch(int Command,PLAYER *p,void *Data)
{
	VASSERT(p != NULL);
	switch(p->Loc[p->CLoc].ClassID)		/* Rip the class number */
    {
    	case RC_VALLEY:					/* The Valley itself */
        	CLValleyHandler(Command,p,Data);
            break;
        case RC_SWAMP:					/* Swamp & Forest share a handler */
        case RC_FOREST:
        	SASwampForestHandler(Command,p,Data);
	        break;
    	case RC_LAIR:					/* So do Lair and Temple */
        case RC_TEMPLE:
        	BDLairTempleHandler(Command,p,Data);
            break;
        case RC_ZAEXON:					/* Tower of Zaexon Handler */
        	BDZaexonHandler(Command,p,Data);
            break;

        default:
			VERROR();
    }
}

/************************************************************************/
/*							  Default handlers							*/
/************************************************************************/

void CLDefaultHandler(int Command,PLAYER *p,void *Data)
{
	LOCATION *l = &(p->Loc[p->CLoc]);
    int n;
	VASSERT(p != NULL);
	switch(Command)
    {
		case CCM_GETMLIST:				/* Get list of monsters */
			VERROR();break;

		case CCM_DRAWPLAYER:
        	IORead(l->x,l->y,&(l->OldColour),&(l->OldChar));
			IOPrint(l->x,l->y,COL_YELLOW,
					(l->OldChar == CHR_WATER) ? CHR_PLAYERWTR:CHR_PLAYER);
        	break;

        case CCM_ERASEPLAYER:
        	IOPrint(l->x,l->y,l->OldColour,l->OldChar);
            break;

        case CCM_CANMOVE:
			VASSERT(Data != NULL);
        	IORead(l->x,l->y,NULL,&n);
            *(int *)Data = (n == CHR_TREE || n == CHR_FRAME || n == CHR_EXIT ||
	            					n == CHR_DOOR || n == CHR_IWALL) ? 0 : 1;
            if ((n == CHR_FRAME || n == CHR_EXIT || n == CHR_DOOR)
            			&& p->Turns > p->QuitTurns && p->CLoc > 0)
            {
                p->CLoc--;
   	            PLClear(p);
       	        *(int *)Data = 2;
            }
            break;

        case CCM_POSTMOVE:
        	if (l->OldChar == CHR_WATER)
			            	p->Stamina = p->Stamina - 20;
			if (l->OldChar == ' ' ||
				l->OldChar == CHR_WATER ||
				l->OldChar == CHR_SWAMP)
			{
				if (CLMonsterCheck(p) == 0 &&
                	l->OldChar == ' ')
							CLLocationCheck(p);
			}
            break;
    }
}

/************************************************************************/
/*					Message handler for main valley						*/
/************************************************************************/

void CLValleyHandler(int Command,PLAYER *p,void *Data)
{
	LOCATION *l = &(p->Loc[p->CLoc]);
    int i,x,y,y1;
	VASSERT(p != NULL);
    switch(Command)
	{
		case CCM_GETMLIST:				/* Get list of monsters */
			VASSERT(Data != NULL);
			strcpy(Data,"VAEGH");
			break;
    	case CCM_REDRAW:				/* Redraw the scene */
        	PLDrawFrame(CHR_FRAME);
        	p->Floor = 1;				/* Set the effective floor */
        	x = 1;y = HEIGHT/2;			/* Start from the left castle */
        	IOPrint(x++,y,COL_CYAN,CHR_CASTLE);
            srand(l->Seed);				/* Seed random number gen. */
            while (x < SCX-2)			/* Work left to right */
            {
            	do						/* Next pos */
	                y1 = (rand() & 1) ? y+1 : y-1;
                while (y1 == 1 || y1 > HEIGHT);
                IOPrint(x,(y1<y) ? y:y1,/* Draw path */
                			COL_BLUE,(y1 < y) ? CHR_PATHBLTR:CHR_PATHBRTL);
            	x++;y = y1;
            }
        	IOPrint(x,y,COL_CYAN,		/* Right hand castle */
            				CHR_CASTLE);
            CLFindSpace(&x,&y);			/* Locate Tower */
            IOPrint(x,y,COL_RED,CHR_ZAEXON);
            for (i = 0;i < 2;i++)		/* Locate Swamp, Forest */
            {
	            CLFindSpace(&x,&y);
                IOPrint(x,y,COL_MAGENTA,CHR_SWAMPMAP);
                IOPrint(x+1,y,COL_MAGENTA,CHR_SWAMPMAP);
    	        CLFindSpace(&x,&y);
                IOPrint(x,y,COL_GREEN,CHR_FOREST);
                IOPrint(x+1,y,COL_GREEN,CHR_FOREST);
            }
        	break;

        case CCM_SETINITPOS:
        	l->x = 1;l->y = HEIGHT/2;
            break;

        case CCM_POSTMOVE:
        	switch (l->OldChar)
            {
				case CHR_ZAEXON:			/* Tower of Zaexon */
                	CLEnterArea(p,RC_ZAEXON);
                	break;
                case CHR_FOREST:			/* Enter a forest */
                	CLEnterArea(p,RC_FOREST);
                	break;
                case CHR_SWAMPMAP:			/* Enter a swamp */
                	CLEnterArea(p,RC_SWAMP);
                	break;
                case CHR_CASTLE:			/* Back at a castle */
                    PLBanner("Thou art safe in a castle",280);
                    if (p->CombatStr < 20) p->CombatStr = 20;
                    p->Stamina = 150;
                    PLPanel(p);
                    PLBanner("Wilt thou leave the valley ? (Y/N)",0);
                    do  i = IOGet(); while (i != 'Y' && i != 'N');
                    if (i == 'Y')
                    {
                    	PLSaveCharacter(p);
                        p->Quit = 1;
                    }
                    else
                    {
	                    PLBanner("Thy wounds healed, thy sword sharp",280);
    	                PLBanner("Go as the Gods Demand, trust none other",280);
                    }
                	break;
            	case ' ':      				/* Open space, default handler */
		            CLDefaultHandler(Command,p,Data);
   	                break;
            }
            break;


        default:
            CLDefaultHandler(Command,p,Data);
            break;
    }
}

/************************************************************************/
/*					   Find 2 adjacent empty spaces						*/
/************************************************************************/

void CLFindSpace(int *x,int *y)
{
	int c1,c2;
	VASSERT(x != NULL && y != NULL);
	do
    {
    	*x = rand() % (SCX-3)+1;
        *y = rand() % HEIGHT+1;
        IORead(*x,*y,NULL,&c1);
        IORead((*x)+1,*y,NULL,&c2);
    } while (c1 != 32 || c2 != 32);
}

/************************************************************************/
/*			Check for monsters. Return zero if no monster attack		*/
/************************************************************************/

int CLMonsterCheck(PLAYER *p)
{
	int Attack = (rand() % 3 == 0);		/* 1 in 3 chance of attack */
	if (Attack) MOAttack(p);
	return Attack;
}

/************************************************************************/
/*						 Location check if no attack					*/
/************************************************************************/

void CLLocationCheck(PLAYER *p)
{
	int n;
	if (rand() % 3 != 0)        		/* 1 in 3 chance of an event */
	{
		p->Stamina = p->Stamina+10;		/* Recover if nothing happens */
		return;
	}
	n = rand() % 6;						/* 6 options */
    switch(n)
    {
    	case 0:							/* Circle of Evil */
				PLBanner("A Circle of Evil... Depart in Haste",280);
                p->CombatStr = p->CombatStr + (p->Floor+1)/2;
                p->PSIStr = p->PSIStr - (p->Floor+1)/2;
                p->Stamina = p->Stamina-20;
         		break;
        case 1:							/* Hoard of Gold */
        case 2:
				PLBanner("A Hoard of Gold",280);
                p->Cash = p->Cash+100+(rand()%100)*(p->Floor);
        		break;
        default:						/* Magic/Ancient power: the same ! */
        		PLBanner(n == 3 ?
                			"You feel the Aura of the Deep Magic":
							"A place of Ancient power",280);
                p->PSIStr = p->PSIStr + 2 +
                				(int)(p->MagicSkill*p->Floor);
                p->CombatStr = p->CombatStr + 1 +
                				(int)(p->CombatInc*p->Floor);
        		break;
    }
}

/************************************************************************/
/*							Enter a new area							*/
/************************************************************************/

void CLEnterArea(PLAYER *p,int ClassID)
{
	LOCATION *l = &(p->Loc[p->CLoc]);

    CLDispatch(CCM_ERASEPLAYER,p,NULL);
	srand(p->Loc[p->CLoc].Seed +		/* Reseed the random number gen */
    					ClassID * 317 + l->x * 7 + l->y * 53);
	p->CLoc++;							/* Go into a new area */
    p->Loc[p->CLoc].Seed = rand();		/* Get a new seed */
    p->Loc[p->CLoc].ClassID = ClassID;
    CLDispatch(CCM_SETINITPOS,p,NULL);	/* Set the start position */
    PLClear(p);							/* Clear the Display */
	CLDispatch(CCM_REDRAW,p,NULL);		/* Redraw the screen */
    CLDispatch(CCM_DRAWPLAYER,p,NULL);
    p->QuitTurns = p->Turns+6;			/* Can't leave immediately */
}
