; The CMD file.
; Written by Pioupiou 2001
;
; Two parts: 1. Command definition and  2. State entry
; (state entry is after the commands def section)
;
; 1. Command definition
; ---------------------
; Note: The commands are CASE-SENSITIVE, and so are the command names.
; The eight directions are:
;   B, DB, D, DF, F, UF, U, UB     (all CAPS)
;   corresponding to back, down-back, down, downforward, etc.
; The six buttons are:
;   a, b, c, x, y, z               (all lower case)
;   In default key config, abc are are the bottom, and xyz are on the
;   top row. For 2 button characters, we recommend you use a and b.
;   For 6 button characters, use abc for kicks and xyz for punches.
;
; Each [Command] section defines a command that you can use for
; state entry, as well as in the CNS file.
; The command section should look like:
;
;   [Command]
;   name = some_name
;   command = the_command
;   time = time (optional -- defaults to 15 if omitted)
;
; - some_name
;   A name to give that command. You'll use this name to refer to
;   that command in the state entry, as well as the CNS. It is case-
;   sensitive (QCB_a is NOT the same as Qcb_a or QCB_A).
;
; - command
;   list of buttons or directions, separated by commas.
;   Directions and buttons can be preceded by special characters:
;   slash (/) - means the key must be held down
;          egs. command = /D       ;hold the down direction
;               command = /F, a    ;hold fwd while you press a
;   tilde (~) - to detect key releases
;          egs. command = ~a       ;release the a button
;               command = ~D, F, a ;release down, press fwd, then a
;          If you want to detect "charge moves", you can specify
;          the time the key must be held down for (in game-ticks)
;          egs. command = ~30a     ;hold a for at least 30 ticks, then release
;               command = ~30
;   dollar ($) - Direction-only: detect as 4-way
;          egs. command = $D       ;will detect if D, DB or DF is held
;               command = $B       ;will detect if B, DB or UB is held
;   plus (+) - Buttons only: simultaneous press
;          egs. command = a+b      ;press a and b at the same time
;               command = x+y+z    ;press x, y and z at the same time
;   You can combine them:
;     eg. command = ~30$D, a+b     ;hold D, DB or DF for 30 ticks, release,
;                                  ;then press a and b together
;   It's recommended that for most "motion" commads, eg. quarter-circle-fwd,
;   you start off with a "release direction". This matches the way most
;   popular fighting games implement their engine.
;
; - time (optional)
;   Time allowed to do the command, given in game-ticks. Defaults to 15
;   if omitted
;
; If you have two or more commands with the same name, all of them will
; work. You can use it to allow multiple motions for the same move.
;
; Some common commands are given below. Delete, add, or modify as you wish.

;-| Super Motions |--------------------------------------------------------
; double QCF
[Command]
name = "2QCF_a"
command = ~D, DF, F, D, DF, F, a
time = 25

[Command]
name = "2QCF_b"
command = ~D, DF, F, D, DF, F, b
time = 25

[Command]
name = "2QCF_x"
command = ~D, DF, F, D, DF, F, x
time = 25

[Command]
name = "2QCF_y"
command = ~D, DF, F, D, DF, F, y
time = 25

;-----------------
; QCF
[Command]
name = "QCF_a"
command = ~D, DF, F, a

[Command]
name = "QCF_b"
command = ~D, DF, F, b

[Command]
name = "QCF_c"
command = ~D, DF, F, c

[Command]
name = "QCF_x"
command = ~D, DF, F, x

[Command]
name = "QCF_y"
command = ~D, DF, F, y

[Command]
name = "QCF_z"
command = ~D, DF, F, z

;-----------------
; QCB
[Command]
name = "QCB_a"
command = ~D, DB, B, a

[Command]
name = "QCB_b"
command = ~D, DB, B, b

[Command]
name = "QCB_c"
command = ~D, DB, B, c

[Command]
name = "QCB_x"
command = ~D, DB, B, x

[Command]
name = "QCB_y"
command = ~D, DB, B, y



;-| Double Tap |-----------------------------------------------------------
[Command]
name = "FF"
command = F, F
time = 10

[Command]
name ="BB"
command = B, B
time = 10

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery"
command = a+b
time = 1

[Command]
name = "recovery"
command = x+y
time = 1

[Command]
name = "ab"
command = a+b
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "fwd_a"
command = /F,a
time = 1

[Command]
name = "fwd_b"
command = /F,b
time = 1

[Command]
name = "fwd_c"
command = /F,c
time = 1

[Command]
name = "fwd_x"
command = /F,x
time = 1

[Command]
name = "fwd_y"
command = /F,y
time = 1

[Command]
name = "fwd_z"
command = /F,z
time = 1

[Command]
name = "back_a"
command = /B,a
time = 1

[Command]
name = "back_b"
command = /B,b
time = 1

[Command]
name = "back_c"
command = /B,c
time = 1

[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

[Command]
name = "down_c"
command = /$D,c
time = 1

[Command]
name = "fwd_ab"
command = /F, a+b
time = 1

[Command]
name = "back_ab"
command = /B, a+b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1
;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd"  ;Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback" ;Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup"   ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown" ;Required (do not remove)
command = /$D
time = 1

;---------------------------------------------------------------------------
; CPU only commands. Thanks to Herman SDio. (SDio VS Karai ? Could be an interessing fight)

[command]
name = "CPU1"
command = D, D, D, D, 
time = 1

[command]
name = "CPU11"
command = D, D, D, D, 
time = 1

[command]
name = "CPU12"
command = D, D, D, D,
time = 1

[command]
name = "CPU2"
command = z, z, z, z, 
time = 1

[command]
name = "CPU13"
command = z, z, z, z, 
time = 1

[command]
name = "CPU14"
command = z, z, z, z,
time = 1

[command]
name = "CPU3"
command = B, B, B, B, 
time = 1

[command]
name = "CPU15"
command = B, B, B, B, 
time = 1

[command]
name = "CPU16"
command = B, B, B, B, 
time = 1

[command]
name = "CPU4"
command = x, x, x, x, 
time = 1

[command]
name = "CPU17"
command = x, x, x, x, 
time = 1

[command]
name = "CPU18"
command = x, x, x, x, 
time = 1

[command]
name = "CPU5"
command = U, U, U, U,
time = 1

[command]
name = "CPU19"
command = U, U, U, U, 
time = 1

[command]
name = "CPU20"
command = U, U, U, U, 
time = 1

[command]
name = "CPU6"
command = a, a, a, a, 
time = 1

[command]
name = "CPU21"
command = a, a, a, a,
time = 1

[command]
name = "CPU22"
command = a, a, a, a, 
time = 1

[command]
name = "CPU7"
command = F, F, F, F, 
time = 1

[command]
name = "CPU23"
command = F, F, F, F, 
time = 1

[command]
name = "CPU24"
command = F, F, F, F, 
time = 1

[command]
name = "CPU8"
command = b, b, b, b, 
time = 1

[command]
name = "CPU25"
command = b, b, b, b, 
time = 1

[command]
name = "CPU26"
command = b, b, b, b,
time = 1

[command]
name = "CPU9"
command = y, y, y, y, 
time = 1

[command]
name = "CPU27"
command = y, y, y, y,
time = 1

[command]
name = "CPU28"
command = y, y, y, y, 
time = 1

[command]
name = "CPU10"
command = s, s, s, s, 
time = 1

[command]
name = "CPU29"
command = s, s, s, s, 
time = 1

[command]
name = "CPU30"
command = s, s, s, s,
time = 1

;Thanks to Sunboy

[Command]
name = "cpu1"
command = U, U, U, U
time = 1
[Command]
name = "cpu2"
command = U, U, U, D
time = 1
[Command]
name = "cpu3"
command = U, U, D, D
time = 1
[Command]
name = "cpu4"
command = U, D, D, D
time = 1
[Command]
name = "cpu5"
command = D, D, D, D
time = 1
[Command]
name = "cpu6"
command = D, D, D, U
time = 1
[Command]
name = "cpu7"
command = D, D, U, U
time = 1
[Command]
name = "cpu8"
command = D, U, U, U
time = 1
[Command]
name = "cpu9"
command = U, D, U, U
time = 1
[Command]
name = "cpu10"
command = U, U, D, U
time = 1
[Command]
name = "cpu11"
command = D, U, U, D
time = 1
[Command]
name = "cpu12"
command = U, D, D, U
time = 1
[Command]
name = "cpu13"
command = D, U, D, U
time = 1
[Command]
name = "cpu14"
command = U, D, U, D
time = 1
[Command]
name = "cpu15"
command = F, F, F, F
time = 1
[Command]
name = "cpu16"
command = B, B, B, B
time = 1
[Command]
name = "cpu17"
command = F, B, F, F
time = 1
[Command]
name = "cpu18"
command = F, F, B, F
time = 1
[Command]
name = "cpu19"
command = B, F, F, F
time = 1
[Command]
name = "cpu20"
command = F, F, F, B
time = 1
[Command]
name = "cpu21"
command = F, B, B, F
time = 1
[Command]
name = "cpu22"
command = B, F, F, B
time = 1
[Command]
name = "cpu23"
command = F, B, F, B
time = 1
[Command]
name = "cpu24"
command = B, F, B, F
time = 1
[Command]
name = "cpu25"
command = D, F, D, F
time = 1
[Command]
name = "cpu26"
command = D, B, D, B
time = 1
[Command]
name = "cpu27"
command = D, B, D, F
time = 1
[Command]
name = "cpu28"
command = D, F, D, B
time = 1
[Command]
name = "cpu29"
command = U, F, D, B
time = 1
[Command]
name = "cpu30"
command = U, B, D, F
time = 1
[Command]
name = "cpu31"
command = B, D, F, U
time = 1
[Command]
name = "cpu32"
command = F, D, B, U
time = 1
[Command]
name = "cpu33"
command = U, U, U, U
time = 1
[Command]
name = "cpu34"
command = U, U, U, D
time = 1
[Command]
name = "cpu35"
command = U, U, D, D
time = 1
[Command]
name = "cpu36"
command = U, D, D, D
time = 1
[Command]
name = "cpu37"
command = D, D, D, D
time = 1
[Command]
name = "cpu38"
command = D, D, D, U
time = 1
[Command]
name = "cpu39"
command = D, D, U, U
time = 1
[Command]
name = "cpu40"
command = D, U, U, U
time = 1
[Command]
name = "cpu41"
command = U, D, U, U
time = 1
[Command]
name = "cpu42"
command = U, U, D, U
time = 1
[Command]
name = "cpu43"
command = D, U, U, D
time = 1
[Command]
name = "cpu44"
command = U, D, D, U
time = 1
[Command]
name = "cpu45"
command = D, U, D, U
time = 1
[Command]
name = "cpu46"
command = U, D, U, D
time = 1
[Command]
name = "cpu47"
command = F, F, F, F
time = 1
[Command]
name = "cpu48"
command = B, B, B, B
time = 1
[Command]
name = "cpu49"
command = F, B, F, F
time = 1
[Command]
name = "cpu50"
command = F, F, B, F
time = 1


;---------------------------------------------------------------------------
; 2. State entry
; --------------
; This is where you define what commands bring you to what states.
;
; Each state entry block looks like:
;   [State -1]                  ;Don't change this
;   type = ChangeState          ;Don't change this
;   value = new_state_number
;   trigger1 = command = command_name
;   . . .  (any additional triggers)
;
; - new_state_number is the number of the state to change to
; - command_name is the name of the command (from the section above)
; - Useful triggers to know:
;   - statetype
;       S, C or A : current state-type of player (stand, crouch, air)
;   - ctrl
;       0 or 1 : 1 if player has control. Unless "interrupting" another
;                move, you'll want ctrl = 1
;   - stateno
;       number of state player is in - useful for "move interrupts"
;   - movecontact
;       0 or 1 : 1 if player's last attack touched the opponent
;                useful for "move interrupts"
;
; Note: The order of state entry is important.
;   State entry with a certain command must come before another state
;   entry with a command that is the subset of the first.  
;   For example, command "fwd_a" must be listed before "a", and
;   "fwd_ab" should come before both of the others.
;
; For reference on triggers, see CNS documentation.
;
; Just for your information (skip if you're not interested):
; This part is an extension of the CNS. "State -1" is a special state
; that is executed once every game-tick, regardless of what other state
; you are in. 


; Don't remove the following line. It's required by the CMD standard.
[Statedef -1]

;===========================================================================
;Cpu Commands for AI
[State -1]
type = VarSet
var(7) = 1
trigger1 = command = "CPU1"
trigger2 = command = "CPU2"
trigger3 = command = "CPU3"
trigger4 = command = "CPU4"
trigger5 = command = "CPU5"
trigger6 = command = "CPU6"
trigger7 = command = "CPU7"
trigger8 = command = "CPU8"
trigger9 = command = "CPU9"
trigger10 = command = "CPU10"
trigger11 = command = "CPU11"
trigger12 = command = "CPU12"
trigger13 = command = "CPU13"
trigger14 = command = "CPU14"
trigger15 = command = "CPU15"
trigger16 = command = "CPU16"
trigger17 = command = "CPU17"
trigger18 = command = "CPU18"
trigger19 = command = "CPU19"
trigger20 = command = "CPU20"
trigger21 = command = "CPU21"
trigger22 = command = "CPU22"
trigger23 = command = "CPU23"
trigger24 = command = "CPU24"
trigger25 = command = "CPU25"
trigger26 = command = "CPU26"
trigger27 = command = "CPU27"
trigger28 = command = "CPU28"
trigger29 = command = "CPU29"
trigger30 = command = "CPU30"

[State -1]
type = VarSet
v = 7
value = 1
triggerall = RoundState = 1 || RoundState = 2 || RoundState = 3 || RoundState = 4 
triggerall = ctrl = 0 || ctrl = 1
trigger1 = command = "cpu1"
trigger2 = command = "cpu2"
trigger3 = command = "cpu3"
trigger4 = command = "cpu4"
trigger5 = command = "cpu5"
trigger6 = command = "cpu6"
trigger7 = command = "cpu7"
trigger8 = command = "cpu8"
trigger9 = command = "cpu9"
trigger10 = command = "cpu10"
trigger11 = command = "cpu11"
trigger12 = command = "cpu12"
trigger13 = command = "cpu13"
trigger14 = command = "cpu14"
trigger15 = command = "cpu15"
trigger16 = command = "cpu16"
trigger17 = command = "cpu17"
trigger18 = command = "cpu18"
trigger19 = command = "cpu19"
trigger20 = command = "cpu20"
trigger21 = command = "cpu21"
trigger22 = command = "cpu22"
trigger23 = command = "cpu23"
trigger24 = command = "cpu24"
trigger25 = command = "cpu25"
trigger26 = command = "cpu26"
trigger27 = command = "cpu27"
trigger28 = command = "cpu28"
trigger29 = command = "cpu29"
trigger30 = command = "cpu30"
trigger31 = command = "cpu31"
trigger32 = command = "cpu32"
trigger33 = command = "cpu33"
trigger34 = command = "cpu34"
trigger35 = command = "cpu35"
trigger36 = command = "cpu36"
trigger37 = command = "cpu37"
trigger38 = command = "cpu38"
trigger39 = command = "cpu39"
trigger40 = command = "cpu40"
trigger41 = command = "cpu41"
trigger42 = command = "cpu42"
trigger43 = command = "cpu43"
trigger44 = command = "cpu44"
trigger45 = command = "cpu45"
trigger46 = command = "cpu46"
trigger47 = command = "cpu47"
trigger48 = command = "cpu48"
trigger49 = command = "cpu49"
trigger50 = command = "cpu50"


;---------------------------------------------------------------------------
;RunFwd
[State -1]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;RunBack
[State -1]
type = ChangeState
value = 105
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl = 1

;---------------------------------------------------------------------------
;Stand_Throw (close dir+button)
[State -1]
type = ChangeState
value = 2000
triggerall = statetype = S
triggerall = ctrl = 1
triggerall = p2bodydist X < 5 ;Near P2
trigger1 = command = "fwd_x"   ;p2 stand
trigger1 = stateno != 100    ;Not running
trigger1 = p2statetype = S
trigger1 = p2movetype != H
trigger2 = command = "fwd_y"   ;p2 crouch
trigger2 = stateno != 100    ;Not running
trigger2 = p2statetype = S
trigger2 = p2movetype != H

;AI
[State -1]
type = ChangeState
value = 2000
triggerall = statetype = S
triggerall = ctrl = 1
triggerall = p2bodydist X < 35 ;Near P2
trigger1 = var(7) = 1
trigger1 = p2movetype != H
trigger1 = p2statetype = S

;---------------------------------------------------------------------------
;Air_Throw1 (close dir+b)
; This is disabled right now. Remove the "null;" below when you
; want to use it.
[State -1]
type = null; ChangeState
value = 950
triggerall = statetype = A
triggerall = ctrl = 1
triggerall = p2bodydist X < 9
triggerall = p2bodydist Y > -22
triggerall = p2bodydist Y < 22
triggerall = p2statetype = A
triggerall = p2movetype != H
trigger1 = command = "fwd_b"
trigger2 = command = "back_b"

;Hyper attack
[State -1]
type = null;ChangeState
value = 3000
triggerall = command != "holddown"
triggerall = statetype = S
triggerall = ctrl = 1
triggerall = power >= 1000
trigger1 = command = "2QCF_a"
trigger2 = command = "2QCF_b"
trigger3 = command = "2QCF_x"
trigger4 = command = "2QCF_y"

;===========================================================================
;Fireball
[State -1]
type = ChangeState
value = 1000
triggerall = ctrl = 1
triggerall = statetype = S
trigger1 = command = "QCF_x"
trigger2 = command = "QCF_y"
trigger3 = var(7) = 1
trigger3 = P2dist X >= 170
trigger3 = random = [400,500]
trigger3 = numprojid(1000) = 0

;Fireball - Long
[State -1]
type = ChangeState
value = 1001
triggerall = ctrl = 1
triggerall = statetype = S
trigger1 = command = "QCF_a"
trigger2 = command = "QCF_b"
trigger3 = var(7) = 1
trigger3 = P2dist X >= 170
trigger3 = random = [500,600]
trigger3 = numprojid(1000) = 0

;---------------------------------------------------------------------------
;Dash
[State -1]
type = ChangeState
value = 1100
triggerall = statetype = S
triggerall = ctrl = 1
trigger1 = command = "QCB_b"
trigger2 = command = "QCB_y"
trigger3 = command = "QCB_x"
trigger4 = command = "QCB_a"

;Dash
[State -1]
type = ChangeState
value = 1100
triggerall = statetype = S
triggerall = ctrl = 1
triggerall = var(7) = 1
triggerall = random = [700,800]
triggerall = P2life != 0 
triggerall = Prevstateno != 1100 
trigger1 = P2stateno = 1000
trigger2 = P2stateno = 1100
trigger3 = P2statetype = A
trigger3 = P2movetype = A
trigger4 = P2dist X = [60,150] 

;---------------------------------------------------------------------------
;Stand_A
[State -1]
type = ChangeState
value = 210
triggerall = command != "holddown"  
triggerall = statetype = S
triggerall = command = "a"
trigger1 = ctrl = 1
trigger2 = stateno = 200
trigger2 = movecontact = 1
trigger3 = stateno = 400
trigger3 = movecontact = 1
trigger4 = stateno = 410
trigger4 = movecontact = 1

;Stand_A
[State -1]
type = ChangeState
value = 210
triggerall = command != "holddown"  
triggerall = statetype = S
triggerall = var(7) = 1
trigger1 = ctrl = 1
trigger1 = random = [251,350]
trigger1 = P2Dist X >= 70
trigger2 = stateno = 200
trigger2 = movecontact = 1
trigger3 = stateno = 400
trigger3 = movecontact = 1
trigger4 = stateno = 410
trigger4 = movecontact = 1

;---------------------------------------------------------------------------
;Stand_B
[State -1]
type = ChangeState
value = 230
triggerall = command != "holddown"
triggerall = statetype = S
triggerall = command = "b"
trigger1 = ctrl = 1
trigger2 = stateno = 200
trigger2 = movecontact = 1
trigger3 = stateno = 210
trigger3 = movecontact = 1
trigger4 = stateno = 220
trigger4 = movecontact = 1
trigger5 = stateno = 400
trigger5 = movecontact = 1
trigger6 = stateno = 410
trigger6 = movecontact = 1
trigger7 = stateno = 420
trigger7 = movecontact = 1
trigger8 = stateno = 430
trigger8 = movecontact = 1

;Stand_B
[State -1]
type = ChangeState
value = 230
triggerall = command != "holddown"
triggerall = statetype = S
triggerall = var(7) = 1
trigger1 = ctrl = 1
trigger1 = random = [151,250]
trigger1 = P2Dist X >= 70
trigger2 = stateno = 200
trigger2 = movecontact = 1
trigger3 = stateno = 210
trigger3 = movecontact = 1
trigger4 = stateno = 220
trigger4 = movecontact = 1
trigger5 = stateno = 400
trigger5 = movecontact = 1
trigger6 = stateno = 410
trigger6 = movecontact = 1
trigger7 = stateno = 420
trigger7 = movecontact = 1
trigger8 = stateno = 430
trigger8 = movecontact = 1

;---------------------------------------------------------------------------
;Stand_X
[State -1]
type = ChangeState
value = 200
triggerall = command != "holddown"
triggerall = statetype = S
triggerall = command = "x"
trigger1 = ctrl = 1
trigger2 = stateno = 210
trigger2 = movecontact = 1
trigger3 = stateno = 410
trigger3 = movecontact = 1
trigger4 = stateno = 400
trigger4 = movecontact = 1

;Stand_X
[State -1]
type = ChangeState
value = 200
triggerall = command != "holddown"
triggerall = statetype = S
triggerall = var(7) = 1
trigger1 = ctrl = 1
trigger1 = random = [0,150]
trigger1 = P2Dist X >= 70
trigger2 = stateno = 210
trigger2 = movecontact = 1
trigger3 = stateno = 410
trigger3 = movecontact = 1
trigger4 = stateno = 400
trigger4 = movecontact = 1
;---------------------------------------------------------------------------
;Stand_Y
[State -1]
type = ChangeState
value = 220
triggerall = command != "holddown"
triggerall = statetype = S
triggerall = command = "y"
trigger1 = ctrl = 1
trigger2 = stateno = 200
trigger2 = movecontact = 1
trigger3 = stateno = 210
trigger3 = movecontact = 1
trigger4 = stateno = 230
trigger4 = movecontact = 1
trigger5 = stateno = 400
trigger5 = movecontact = 1
trigger6 = stateno = 410
trigger6 = movecontact = 1
trigger7 = stateno = 430
trigger7 = movecontact = 1
trigger8 = stateno = 420
trigger8 = movecontact = 1

;Stand_Y
[State -1]
type = ChangeState
value = 220
triggerall = command != "holddown"
triggerall = statetype = S
triggerall = var(7) = 1
trigger1 = ctrl = 1
trigger1 = random = [351,450]
trigger1 = P2Dist X >= 70
trigger2 = stateno = 200
trigger2 = movecontact = 1
trigger3 = stateno = 210
trigger3 = movecontact = 1
trigger4 = stateno = 230
trigger4 = movecontact = 1
trigger5 = stateno = 400
trigger5 = movecontact = 1
trigger6 = stateno = 410
trigger6 = movecontact = 1
trigger7 = stateno = 430
trigger7 = movecontact = 1
trigger8 = stateno = 420
trigger8 = movecontact = 1

;---------------------------------------------------------------------------
;Crouch_A
[State -1]
type = ChangeState
value = 430
triggerall = command = "holddown"
triggerall = statetype = C
triggerall = command = "a"
trigger1 = ctrl = 1
trigger2 = stateno = 400
trigger2 = movecontact = 1
trigger3 = stateno = 210
trigger3 = movecontact = 1
trigger4 = stateno = 200
trigger4 = movecontact = 1

;Crouch_A
[State -1]
type = ChangeState
value = 430
triggerall = command = "holddown"
triggerall = statetype = C
triggerall = var(7) = 1
trigger1 = ctrl = 1
trigger1 = random = [151,250]
trigger1 = P2Dist X >= 70
trigger2 = stateno = 400
trigger2 = movecontact = 1
trigger3 = stateno = 210
trigger3 = movecontact = 1
trigger4 = stateno = 200
trigger4 = movecontact = 1



;---------------------------------------------------------------------------
;Crouch_B
[State -1]
type = ChangeState
value = 410
triggerall = command = "holddown"
triggerall = statetype = C
triggerall = command = "b"
trigger1 = ctrl = 1
trigger2 = stateno = 400
trigger2 = movecontact = 1
trigger3 = stateno = 430
trigger3 = movecontact = 1
trigger4 = stateno = 420
trigger4 = movecontact = 1
trigger5 = stateno = 200
trigger5 = movecontact = 1
trigger6 = stateno = 210
trigger6 = movecontact = 1
trigger7 = stateno = 220
trigger7 = movecontact = 1
trigger8 = stateno = 230
trigger8 = movecontact = 1

;Crouch_B
[State -1]
type = ChangeState
value = 410
triggerall = command = "holddown"
triggerall = statetype = C
triggerall = var(7) = 1
trigger1 = ctrl = 1
trigger1 = random = [0,150]
trigger1 = P2Dist X >= 70
trigger2 = stateno = 400
trigger2 = movecontact = 1
trigger3 = stateno = 430
trigger3 = movecontact = 1
trigger4 = stateno = 420
trigger4 = movecontact = 1
trigger5 = stateno = 200
trigger5 = movecontact = 1
trigger6 = stateno = 210
trigger6 = movecontact = 1
trigger7 = stateno = 220
trigger7 = movecontact = 1
trigger8 = stateno = 230
trigger8 = movecontact = 1

;---------------------------------------------------------------------------
;Crouch_X
[State -1]
type = ChangeState
value = 400
triggerall = command = "holddown"
triggerall = statetype = C
triggerall = command = "x"
trigger1 = ctrl = 1
trigger2 = stateno = 430
trigger2 = movecontact = 1
trigger3 = stateno = 210
trigger3 = movecontact = 1
trigger4 = stateno = 200
trigger4 = movecontact = 1

;Crouch_X
[State -1]
type = ChangeState
value = 400
triggerall = command = "holddown"
triggerall = statetype = C
triggerall = var(7) = 1
trigger1 = ctrl = 1
trigger1 = random = [351,450]
trigger1 = P2Dist X >= 70
trigger2 = stateno = 430
trigger2 = movecontact = 1
trigger3 = stateno = 210
trigger3 = movecontact = 1
trigger4 = stateno = 200
trigger4 = movecontact = 1

;---------------------------------------------------------------------------
;Crouch_Y
[State -1]
type = ChangeState
value = 420
triggerall = command = "holddown"
triggerall = statetype = C
triggerall = command = "y"
trigger1 = ctrl = 1
trigger2 = stateno = 400
trigger2 = movecontact = 1
trigger3 = stateno = 410
trigger3 = movecontact = 1
trigger4 = stateno = 430
trigger4 = movecontact = 1
trigger5 = stateno = 200
trigger5 = movecontact = 1
trigger6 = stateno = 210
trigger6 = movecontact = 1
trigger7 = stateno = 220
trigger7 = movecontact = 1
trigger8 = stateno = 230
trigger8 = movecontact = 1

;Crouch_Y
[State -1]
type = ChangeState
value = 420
triggerall = command = "holddown"
triggerall = statetype = C
triggerall = var(7) = 1
trigger1 = ctrl = 1
trigger1 = random = [251,350]
trigger1 = P2Dist X >= 70
trigger2 = stateno = 400
trigger2 = movecontact = 1
trigger3 = stateno = 410
trigger3 = movecontact = 1
trigger4 = stateno = 430
trigger4 = movecontact = 1
trigger5 = stateno = 200
trigger5 = movecontact = 1
trigger6 = stateno = 210
trigger6 = movecontact = 1
trigger7 = stateno = 220
trigger7 = movecontact = 1
trigger8 = stateno = 230
trigger8 = movecontact = 1

;---------------------------------------------------------------------------
;Jump_A
[State -1]
type = ChangeState
value = 610
triggerall = statetype = A
triggerall = command = "a"
trigger1 = ctrl = 1
trigger2 = stateno = 600
trigger2 = movecontact = 1

;Jump_A
[State -1]
type = ChangeState
value = 610
triggerall = statetype = A
triggerall = var(7) = 1
trigger1 = ctrl = 1
trigger1 = random = [401,500]
trigger2 = stateno = 600
trigger2 = movecontact = 1


;---------------------------------------------------------------------------
;Jump_B
[State -1]
type = ChangeState
value = 630
triggerall = statetype = A
triggerall = command = "b"
trigger1 = ctrl = 1
trigger2 = stateno = 600
trigger2 = movecontact = 1
trigger3 = stateno = 610
trigger3 = movecontact = 1
trigger4 = stateno = 620
trigger4 = movecontact = 1

;Jump_B
[State -1]
type = ChangeState
value = 630
triggerall = statetype = A
triggerall = var(7) = 1
trigger1 = ctrl = 1
trigger1 = random = [301,400]
trigger2 = stateno = 600
trigger2 = movecontact = 1
trigger3 = stateno = 610
trigger3 = movecontact = 1
trigger4 = stateno = 620
trigger4 = movecontact = 1


;---------------------------------------------------------------------------
;Jump_X
[State -1]
type = ChangeState
value = 600
triggerall = statetype = A
triggerall = ctrl = 1
triggerall = command = "x"
trigger1 = ctrl = 1
trigger2 = stateno = 610
trigger2 = movecontact = 1

;Jump_X
[State -1]
type = ChangeState
value = 600
triggerall = statetype = A
triggerall = var(7) = 1
trigger1 = ctrl = 1
trigger1 = random = [151,300]
trigger2 = stateno = 610
trigger2 = movecontact = 1

;---------------------------------------------------------------------------
;Jump_Y
[State -1]
type = ChangeState
value = 620
triggerall = statetype = A
triggerall = command = "y"
trigger1 = ctrl = 1
trigger2 = stateno = 600
trigger2 = movecontact = 1
trigger3 = stateno = 610
trigger3 = movecontact = 1
trigger4 = stateno = 630
trigger4 = movecontact = 1

;Jump_Y
[State -1]
type = ChangeState
value = 620
triggerall = statetype = A
triggerall = var(7) = 1
trigger1 = ctrl = 1
trigger1 = random = [0,150]
trigger2 = stateno = 600
trigger2 = movecontact = 1
trigger3 = stateno = 610
trigger3 = movecontact = 1
trigger4 = stateno = 630
trigger4 = movecontact = 1

;---------------------------------------------------------------------------
;Taunt
[State -1]
type = ChangeState
value = 195
triggerall = statetype = S
triggerall = ctrl = 1
trigger1 = command = "start"
trigger2 = var(7) = 1
trigger2 = P2Dist X >= 200
trigger2 = random = [400,500]

;---------------------------------------------------------------------------
;AI Guard

;Stand Guard
[State -1]
type = ChangeState
value = 130
triggerall = var(7) = 1
triggerall = ctrl = 1
triggerall = random = [0,900]
trigger1 = statetype != A
trigger1 = p2statetype != C
trigger1 = p2movetype = A

;Crouch Guard
[State -1]
type = ChangeState
value = 131
triggerall = var(7) = 1
triggerall = ctrl = 1
triggerall = random = [0,900]
trigger1 = statetype != A
trigger1 = p2statetype = C
trigger1 = p2movetype = A

;Air Guard
[State -1]
type = ChangeState
value = 132
triggerall = var(7) = 1
triggerall = ctrl = 1
triggerall = random = [0,900]
trigger1 = statetype = A
trigger1 = p2movetype = A
