/************************************************************************/
/************************************************************************/
/*																		*/
/*	Name :		PORTIO.C												*/
/*	Project :	Tomb of Drewan in 'C'									*/
/*	Author :	Paul Robson												*/
/*	Created :	23rd April 2001											*/
/*	Function :	Hardware I/O. All porting involves changing this		*/
/*	Changes :															*/
/*																		*/
/************************************************************************/
/************************************************************************/

#include "drewan.h"
#include <time.h>
#include <conio.h>
#include <graphics.h>
#include <dos.h>
#include "gamegfx.h"						/* Graphics */

static	clock_t StartTime;					/* Start time of running */

#define	XSIZE	(3)							/* Pixel size for scaling */
#define	YSIZE	(1)
#define	XORG	(56)						/* Screen Display Start */
#define	YORG	(7)

static int ClassicMode;						/* Use classic "Vic-20" mode */

/************************************************************************/
/*																		*/
/*							Initialise everything						*/
/*																		*/
/************************************************************************/

void IOInitialise(int Classic)
{
	int i,x;
	int GraphDriver = VGA; 					/* Initialise the BGI Driver */
	int GraphMode = VGALO;					/* VGA, 640x200 mode */
	initgraph(&GraphDriver,&GraphMode,"");	/* Start it up */
	ClassicMode = Classic;					/* Set classic mode global */
	StartTime = clock();					/* Initialise the clock */
	IOFrame(COL_RED << 4);					/* Default frame */
	setfillstyle(SOLID_FILL,2);				/* 2 is the frame colour */
	bar(0,0,640,480);
	setfillstyle(SOLID_FILL,1);				/* 1 is the background colour */
	bar(XORG,YORG,XORG+22*8*XSIZE-1,YORG+23*8*YSIZE-1);
	for (x = 0;x < 8;x++) Graphics[94*8+x] = (x == 3) ? 255:0;
	for (x = 0;x < 8;x++) Graphics[95*8+x] = (x & 1) ? 170:85;
}

/************************************************************************/
/*																		*/
/*							Terminate everything						*/
/*																		*/
/************************************************************************/

void IOTerminate(void)
{
	closegraph();							/* Return to DOS Text Mode */
}

/************************************************************************/
/*																		*/
/*  					Read the Millisecond Timer						*/
/*																		*/
/*			It does not need to be this accurate, 10-20Hz will do !		*/
/*																		*/
/************************************************************************/

long IOTimer(void)
{
	return (long)(clock()-StartTime)*55;	/* Accurate to 1/18 second */
}

/************************************************************************/
/*																		*/
/*	 Print character at position (176x184) in given colour, may have	*/
/*	 a transparent background.											*/
/*																		*/
/************************************************************************/

int ColMap[] = { 0,15,12,11,13,10,9,14,		/* 8 foreground colours */
				 6,6,5,3,5,2,1,6 };			/* 8 extra background colours */

void IODraw(int x,int y,int Char,int Colour)
{
	int b,x1,cp;
	cp = (Char & 0x7F) << 3;				/* Offset in graphic table */
	x = x * XSIZE+XORG;y = y*YSIZE + YORG;	/* Scale x and centre it */
	setfillstyle(SOLID_FILL,1);				/* Set fill colour as BGR */
	setcolor(ColMap[Colour & 7]);			/* Set drawing colour */
	bar(x,y,x+8*XSIZE-1,y+8*YSIZE-1);		/* Erase the old character */
	setfillstyle(SOLID_FILL,ColMap[Colour & 7]);
	do										/* Do each line */
		{
		b = Graphics[cp++];x1 = x;		/* Read the character */
		while (b != 0)						/* While bits left */
			{
			if (b & 0x80)
			{
				if (YSIZE == 1) line(x1,y,x1+XSIZE-1,y);
				else bar(x1,y,x1+XSIZE-1,y+YSIZE-1);
			}
			x1 = x1 + XSIZE;b = (b << 1) & 0xFF;
			}
		y = y + YSIZE;						/* Next line down */
		}
	while (cp % 8 != 0);					/* Do all 8 pixels */
}

/************************************************************************/
/*																		*/
/*					Set the frame and background colour					*/
/*																		*/
/************************************************************************/

void IOFrame(int Frame)
{
	setpalette(1,ColMap[Frame & 7]);			/* Set the border */
	setpalette(2,ColMap[(Frame >> 4) & 15]);	/* Set the background */
}

/************************************************************************/
/*																		*/
/*				Read a key, make it capital if appropriate				*/
/*																		*/
/************************************************************************/

int IOGet(void)
{
	int Key;
	if (!kbhit()) return 0;						/* No key pressed */
	Key = getch();if (Key == 0) Key = -getch();	/* Get key, handle keypad */
	if (Key > 0) Key = toupper(Key);			/* Capitalise it */
	if (Key == 27) Key = 'Q';					/* ESCape key */
	if (Key < ' ')								/* Handle control keys */
	{
		switch(Key)                				/* Map them onto VIC keys */
		{
		case -72:	Key = KEY_UP;break;
		case -75:	Key = KEY_LEFT;break;
		case -77:	Key = KEY_RIGHT;break;
		case -80:	Key = KEY_DOWN;break;
		case -83:	Key = KEY_LOOKLEFT;break;
		case -79:	Key = KEY_LOOKRIGHT;break;
		default:	Key = 0;break;				/* No others */
		}
	while (kbhit()) getch();					/* One at a time ! */
	}
	return Key;
}

/************************************************************************/
/*																		*/
/*							Display the site URL						*/
/*																		*/
/************************************************************************/

void IOShowURL(int y,char *s)
{
	setcolor(CYAN);
	outtextxy(320-textwidth(s)/2,y*8,s);
}

/************************************************************************/
/*																		*/
/*						Return device capabilities						*/
/*																		*/
/************************************************************************/

int IOGetCaps(void)
{
	return DC_COLOUR | DC_BACKGROUND | DC_PIXEL;
}

/************************************************************************/
/************************************************************************/
/*																		*/
/*	All these functions below are hook functions, if they return		*/
/*	0 the game will work perfectly. The hooks allow you to make the		*/
/*	game prettier.														*/
/*																		*/
/************************************************************************/
/************************************************************************/

/************************************************************************/
/*																		*/
/*						Return "classic mode" flag						*/
/*																		*/
/************************************************************************/

int IOIsClassic(void)
{
	return (ClassicMode != 0);
}

#include "portdosx.c"