/************************************************************************/
/************************************************************************/
/*																		*/
/*	Name :		TITLE.C													*/
/*	Project :	Tomb of Drewan in 'C'									*/
/*	Author :	Paul Robson												*/
/*	Created :	24th April 2001											*/
/*	Function :	Display titles											*/
/*	Changes :															*/
/*																		*/
/************************************************************************/
/************************************************************************/

#include "drewan.h"

/************************************************************************/
/*																		*/
/*							Title Page 1								*/
/*																		*/
/************************************************************************/

void TITLEPage1(void)
{
	int x;
	DRAWClear();
	IOFrame((COL_BLACK << 4) + COL_WHITE);
	for (x = 2;x < 20;x++)
	{
		DRAWChar(x,8,94,COL_RED);
		DRAWChar(x,10,94,COL_RED);
	}
	for (x = 0;x < 22;x++)
	{
		DRAWChar(x,0,95,COL_RED);
		DRAWChar(x,22,95,COL_RED);
		DRAWChar(0,x,95,COL_RED);
		DRAWChar(21,x,95,COL_RED);
	}
	DRAWPrint(1,3,COL_BLUE,"YOU ARE EMBARKING ON");
	DRAWPrint(2,5,COL_BLUE,"A MAGICAL QUEST TO");
	DRAWPrint(2,9,COL_BLACK,"THE TOMB OF DREWAN");
	DRAWPrint(3,14,COL_GREEN,"PREPARE THYSELF !");
	DRAWPrint(7,18,COL_BLACK+COL_REVTEXT,"SPACE");
	while (IOGet() != ' ') {}
}

/************************************************************************/
/*																		*/
/*							Title Page 2								*/
/*																		*/
/************************************************************************/

int TITLEPage2(void)
{
	int i,c = 20;
	char Temp[32];
	#ifdef IDE
	return 0;
	#endif
	TITLEInfo(2);
	IOFrame(COL_BLUE*16+COL_YELLOW);
	DRAWPrint(0,c+0,COL_BLACK+COL_REVTEXT,"DO YOU WANT TO PLAY A ");
	DRAWPrint(0,c+1,COL_BLACK+COL_REVTEXT,"   SAVED GAME");
	DRAWPrint(13,c+1,COL_RED,"Y/N");
	DRAWPrint(16,c+1,COL_BLACK+COL_REVTEXT,"      ");
	c = 6;
	TITLECPrint(c++,COL_BLACK,"ORIGINAL VIC VERSION");
	TITLECPrint(c++,COL_BLACK,"BY TREVOR PITTS");
	c++;
	sprintf(Temp,"C VERSION %d-%02d",VERSION/100,VERSION%100);
	TITLECPrint(c++,COL_BLUE,Temp);
	TITLECPrint(c++,COL_BLUE,"BY PAUL ROBSON");
	c++;
	TITLECPrint(c++,COL_GREEN,"RESEARCH AND THANKS");
	TITLECPrint(c++,COL_GREEN,"TO RENE KINT");
	IOShowURL(c+1,"http://www.xs4all.nl/~itsux/TOMB.HTM");
	c=c+2;
	TITLECPrint(c++,COL_RED,"NEW GRAPHICS BY");
	TITLECPrint(c++,COL_RED,"(YOUR NAME HERE?)");
	do
		c = IOGet();
	while (c != 'Y' && c != 'N');
	return (c == 'Y');
}

void TITLECPrint(int y,int Col,char *Text)
{
	DRAWPrint(11-strlen(Text)/2,y,Col,Text);
}

void TITLEInfo(int c)
{
	int i;
	DRAWClear();
	DRAWPrint(2,c+1,COL_RED,"THE TOMB OF DREWAN");
	DRAWChar(1,c+1,124,COL_BLACK);
	DRAWChar(20,c+1,124,COL_BLACK);
	for (i = 1;i <= 20;i++)
	{
		DRAWChar(i,c+0,124,COL_BLACK);
		DRAWChar(i,c+2,124,COL_BLACK);
	}
}
