/************************************************************************/
/************************************************************************/
/*																		*/
/*	Name :		PORTDOSX.C												*/
/*	Project :	Tomb of Drewan in 'C'									*/
/*	Author :	Paul Robson												*/
/*	Created :	23rd April 2001											*/
/*	Function :	Hook functions for the DOS Version						*/
/*				To work as standard, all should return 0				*/
/*	Changes :															*/
/*																		*/
/************************************************************************/
/************************************************************************/

static void IODOS_Write(int x,int y,int Char,int Colour);

/************************************************************************/
/*																		*/
/*				Extended drawing (alphanumeric characters)				*/
/*																		*/
/*	This one receives an ASCII value in bits 0..6 and reverse in bit 7	*/
/*	which is *NOT* the same as the standard VIC20 set					*/
/*																		*/
/************************************************************************/

int  IOXAlphaDraw(int x,int y,int Char,int Colour)
{
	IODOS_Write(x,y,Char,Colour);
	return 1;
}

/************************************************************************/
/*																		*/
/*					Extended drawing (all characters)					*/
/*																		*/
/************************************************************************/

int  IOXDraw(int x,int y,int Char,int Colour)
{
	int w,h,i,x1,y1,n = 1;
	x = x * XSIZE+XORG;w = XSIZE*8-1;		/* Scale x,y and centre it */
	y = y * YSIZE+YORG;h = YSIZE*8-1;
	switch(Char)
	{

	case GRX_HASOBJECT:
		setfillstyle(SOLID_FILL,1);bar(x,y,x+w,y+h);
		setcolor(YELLOW);line(x,y+h*3/4,x+w/4,y+h);
		line(x+w/4,y+h,x+w,y);break;

	case GRX_TREE:
		setfillstyle(SOLID_FILL,1);bar(x,y,x+w,y+h);
		setfillstyle(SOLID_FILL,COL_RED);setcolor(BLACK);
		fillellipse(x+w/2,y+h/2,w/2,h/2);
		break;

	case GRX_STONE:
	case GRX_OUTSIDEWALL:
		setfillstyle(SOLID_FILL,7);bar(x,y,x+w,y+h);
		setcolor(0);rectangle(x,y,x+w,y+h);
		setcolor(15);line(x,y,x+w,y);line(x,y,x,y+h);
		break;

	case GR_TREASURE:
		setfillstyle(SOLID_FILL,1);bar(x,y,x+w,y+h);
		setfillstyle(SOLID_FILL,14);setcolor(BLACK);
		fillellipse(x+w/2,y+h/2,w/2,h/2);
		bar(x,y+h/2,x+w,y+h);rectangle(x,y+h/2,x+w,y+h);
		break;

	case GR_BRICK:
		setfillstyle(SOLID_FILL,RED);bar(x,y,x+w,y+h);
		for (i = 0;i < 4;i++)
		{
			y1 = y+h-i*YSIZE*2;setcolor(WHITE);
			x1 = x+(i & 1)*XSIZE*2;
			line(x,y1,x+w,y1);line(x1,y1,x1,y1-YSIZE-YSIZE/2);
			x1 = x1+XSIZE*4;line(x1,y1,x1,y1-YSIZE-YSIZE/2);
		}
		break;

	default:
		n = 0;break;
	}
	return n;
}

/************************************************************************/
/*																		*/
/*		   Draw a tile which is part of the map (main game area)		*/
/*																		*/
/************************************************************************/

int IOXMapTileDraw(int x,int y,int Char,int Colour)
{
	return 0;
}

/************************************************************************/
/*																		*/
/*							Draw the extended panel						*/
/*																		*/
/************************************************************************/

int  IOXPanel(void)
{
	return 0;
}

/************************************************************************/
/*																		*/
/*						Display the message box							*/
/*																		*/
/************************************************************************/

int  IOXMessage(int Cmd,char *Message)
{
	return 0;
}

/************************************************************************/
/*																		*/
/*						Display the message box							*/
/*																		*/
/************************************************************************/

int  IOXRemMessage(PLAYER *p,ROOM *r)
{
	return 0;
}

/************************************************************************/
/*																		*/
/*						Refresh the extended panel						*/
/*																		*/
/************************************************************************/

int  IOXPanelRefresh(PLAYER *p)
{
	return 0;
}

/************************************************************************/
/*																		*/
/*					Alternate font for DOS, TURBOC						*/
/*																		*/
/************************************************************************/

static void IODOS_Write(int x,int y,int Char,int Colour)
{
	int b,oc,w,h,Seg = 0,Rev;
	x = x * XSIZE+XORG;						/* Scale x,y and centre it */
	y = y * YSIZE+YORG;
	Rev = Char & 0x80;
	Colour = ColMap[Colour & 7];			/* Map to PC Colours */
	Char = Char & 0x7F;						/* Prepare the character */
	Char = toupper(Char);
	w = XSIZE*8-1;h = YSIZE*8-1;			/* Get width and height */
	setfillstyle(SOLID_FILL,Rev ? Colour:1);
	setcolor(Rev ? 1 : Colour);
	bar(x,y,x+w,y+h);						/* Erase it */
	setfillstyle(SOLID_FILL,Rev ? 1 : Colour);
	x++;y++;w-=2;h-=2;b = XSIZE;
	switch(Char)							/* How is the character made up */
	{
		case '0':
		case 'O': Seg = 0x3F;break;
		case '1':Seg = 0x80;break;
		case '2':
		case 'Z': Seg = 0x76;break;
		case '3': Seg = 0x5E;break;
		case '4': Seg = 0x4D;break;
		case '5':
		case 'S': Seg = 0x5B;break;
		case '6': Seg = 0x7B;break;
		case '7': Seg = 0x0E;break;
		case '8':
		case 'B': Seg = 0x7F;break;
		case '9': Seg = 0x5F;break;
		case 'A': Seg = 0x6F;break;
		case 'C': Seg = 0x33;break;
		case 'D': Seg = 0x9E;break;
		case 'E': Seg = 0x73;break;
		case 'F': Seg = 0x63;break;
		case 'G': Seg = 0x3B;break;
		case 'H': Seg = 0x6D;break;
		case 'I': Seg = 0x92;break;
		case 'J': Seg = 0x3C;break;
		case 'K': Seg = 0x921;break;
		case 'L': Seg = 0x31;break;
		case 'M': Seg = 0xAF;break;
		case 'N': Seg = 0x2F;break;
		case 'P': Seg = 0x67;break;
		case 'Q': Seg = 0x4F;break;
		case 'R': Seg = 0x867;break;
		case 'T': Seg = 0x82;break;
		case 'U': Seg = 0x3D;break;
		case 'V': Seg = 0x205;break;
		case 'W': Seg = 0xBD;break;
		case 'X': Seg = 0x400;break;
		case 'Y': Seg = 0x4D;break;
	}
	if (Seg & 0x01) bar(x,y,x+b,y+h/2);		/* Seg 0-6 are A-G on 7 seg */
	if (Seg & 0x02) line(x,y,x+w,y);
	if (Seg & 0x04) bar(x+w-b,y,x+w,y+h/2);
	if (Seg & 0x08) bar(x+w-b,y+h/2,x+w,y+h);
	if (Seg & 0x10) line(x,y+h,x+w,y+h);
	if (Seg & 0x20) bar(x,y+h/2,x+b,y+h);
	if (Seg & 0x40) line(x,y+h/2,x+w,y+h/2);
	if (Seg & 0x80)	bar(x+w/2-b/2,y,x+w/2-b/2+b,y+h);	/* Seg 7 is vertical line */
	if (Seg & 0x100) line(x,y+h/2,x+w,y);		/* Seg 8 is K top left */

	if (Seg & 0x200)							/* Seg 9 is V bit */
		{ line(x,y+h/2,x+w/2,y+h);line(x+w/2,y+h,x+w,y+h/2); }
	if (Seg & 0x400)							/* Seg 10 is X */
		{ line(x,y,x+w,y+h);line(x+w,y,x,y+h); }
	if (Seg & 0x800) line(x,y+h/2,x+w,y+h);	/* Seg 11 is R leg */

}
