/************************************************************************/
/************************************************************************/
/*																		*/
/*	Name :		PLAYER.C												*/
/*	Project :	Tomb of Drewan in 'C'									*/
/*	Author :	Paul Robson												*/
/*	Created :	23rd April 2001											*/
/*	Function :	Player init/move functions								*/
/*	Changes :															*/
/*																		*/
/************************************************************************/
/************************************************************************/

#include "drewan.h"

static void _PLAYERInitRoom(RDATA *r);

/************************************************************************/
/*																		*/
/*							Initialise a player							*/
/*																		*/
/************************************************************************/

void PLAYERInit(PLAYER *p,int Seed)
{
	int c,i,j,Clash;
	srand(Seed);							/* Seed the RNG */
	p->RoomID = 0;							/* Start in room 0 */
	p->Pos.x = 11;p->Pos.y = 3;				/* Start at offset 77 */
	p->Strength = 100;p->Wounds = 0;
	p->Gold = 0;p->Arrows = 0;p->Kills = 0;
	p->LookDir = 0;p->Quit = 0;c = 0;
	p->Char = GR_PLAYER;p->Colour = COL_BLACK;
	#ifdef IDE								/* Debugging, make it easy :) */
	c = 1;p->Arrows = 8;
	#endif
	for (i = 0;i < HF_FLAGS;i++)			/* Don't have any objects */
							p->Has[i] = c;
	p->Has[HF_AMULET] = 0;					/* not even in debug mode */
	p->StartTimer = IOTimer();				/* Start time for the game */
	p->MajorTreasure[0] =					/* First treasure */
				rand()%(MAPSIZE*MAPSIZE)+1;
	for (i = 1;i < 5;i++)					/* Place the other treasures */
	{
		do
		{
			p->MajorTreasure[i] =			/* Place it */
						rand()%(MAPSIZE*MAPSIZE-1)+1;
			Clash = 0;						/* Check not already used */
			for (j = 0;j < i;j++)
				if (p->MajorTreasure[i] == p->MajorTreasure[j])
					Clash = 1;
		} while (Clash != 0);				/* Keep doing till all different */
	}
	for (i = 0;i < MAPSIZE*MAPSIZE;i++)		/* Initialise all rooms */
			_PLAYERInitRoom(&(p->Room[i]));
	for (i = 0;i < 4;i++)					/* Make it easy at the start */
			p->Room[0].MonsterDead[i] = 1;
}

/************************************************************************/
/*																		*/
/*					Initialise a single room descriptor.				*/
/*																		*/
/************************************************************************/

static void _PLAYERInitRoom(RDATA *r)
{
	int i;
	r->LayoutType = rand()%8+1;				/* Set up the game */
	r->TreasureLayoutType = rand()%5+1;
	r->MonsterLayoutType = rand()%7+1;
	r->TreasureType = rand()%15+1;
	r->MonsterType = rand()%15+1;
	for (i = 0;i < MCOUNT;i++)				/* Everything is available */
		r->MonsterDead[i] = 0;
	for (i = 0;i < TCOUNT;i++)
		r->TreasureTaken[i] = 0;
}

/************************************************************************/
/*																		*/
/*							Tomb Lord & Resurrection					*/
/*																		*/
/************************************************************************/

int  PLAYERResurrect(PLAYER *p,ROOM *r)
{
	int k,i,x,y,Cost = rand()%80;
	char Temp[64];
	DRAWMessage(MB_DELAY,"You are dead");
	sprintf(Temp,"The tomb lord appears!and demands %d!pounds of gold",Cost);
	DRAWMessage(MB_DRAWONLY,Temp);
	do										/* Find a spot for time lord */
	{
		x = p->Pos.x+rand()%3-1;
		y = p->Pos.y+rand()%3-1;
	} while (DRAWGet(x,y) != GR_SPACE);
	for (k = 1;k <= 4;k++)					/* Colour cycling effect */
		for (i = 1;i <= 7;i++)
			{
			DRAWChar(x,y,GR_TOMBLORD,i);
			DRAWDelay(150);
			}
	if (p->Gold > Cost)
	{
		p->Gold = p->Gold - Cost;
		DRAWMessage(MB_DELAY,"You live again");
		DRAWChar(x,y,GR_SPACE,0);
		p->Wounds = 0;p->Strength = 100;
		DRAWRemMessage(p,r);
		return 1;
	}
	DRAWMessage(MB_DELAY,"Not enough gold!to save you");
	return 0;
}

/************************************************************************/
/*																		*/
/*						Report on how well you did						*/
/*																		*/
/************************************************************************/

void  PLAYERReport(PLAYER *p,ROOM *r)
{
	int c = 5;
	char Temp[32];
	long t;
	TITLEInfo(c-4);
	if (PLAYERHasWon(p))
	{
		TITLECPrint(c++,COL_BLACK,"is destroyed");
		c++;TITLECPrint(c++,COL_YELLOW,"you have won");
	}
	else
	{
		TITLECPrint(c++,COL_BLACK,"remains intact");c++;
		if ((IOTimer()-p->StartTimer)/1000 > 3000)
			TITLECPrint(c++,COL_YELLOW,"but you did well");
		else
			TITLECPrint(c++,COL_YELLOW,"a poor try");
	}
	c++;TITLECPrint(c++,COL_CYAN,"you killed");
	sprintf(Temp,"%d of my guards",p->Kills);
	TITLECPrint(c++,COL_CYAN,Temp);c++;
	TITLECPrint(c++,COL_GREEN,"and lasted for");
	t = (IOTimer()-p->StartTimer)/1000;		/* Calculate elapsed time */
	sprintf(Temp,"%ld:%02ld:%02ld",t/3600,(t/60)%60,t%60);
	TITLECPrint(c++,COL_GREEN,Temp);c+=2;
	TITLECPrint(c++,COL_BLACK+COL_REVTEXT,"Do you want to try");
	TITLECPrint(c++,COL_BLACK+COL_REVTEXT,"again Y or N");
	do
		c = IOGet();
	while (c != 'Y' && c != 'N');
	if (c == 'N')
	{
		p->Quit = 1;
	}
	else
	{
		DRAWClear();
		PLAYERInit(p,rand());
		p->Pos.x = 11;p->Pos.y = 14;
		DRAWClear();
		PANELDraw(p);
		ROOMDraw(p,r,1);
	}
}

/************************************************************************/
/*																		*/
/*							Has Player won ?							*/
/*																		*/
/************************************************************************/

int PLAYERHasWon(PLAYER *p)
{
	int i;
	for (i = HF_WATERSTONE;i <= HF_AMULET;i++)
		if (p->Has[i] == 0) return 0;
	return 1;
}
