/************************************************************************/
/************************************************************************/
/*																		*/
/*	Name :		MAIN.C													*/
/*	Project :	Tomb of Drewan in 'C'									*/
/*	Author :	Paul Robson												*/
/*	Created :	24th April 2001											*/
/*	Function :	Main Program											*/
/*	Changes :															*/
/*																		*/
/************************************************************************/
/************************************************************************/

#include "drewan.h"

PLAYER p;
ROOM r;

static void _MAINCommand(PLAYER *p,ROOM *r);
static void _MAINEffects(PLAYER *p);
static int  _MAINJump(PLAYER *p,int Try);
static int  _MAINInspect(PLAYER *p,ROOM *r);
static void _MAINMove(PLAYER *p,ROOM *r,int xi,int yi);
static void _MAINHelp(PLAYER *p);
static char *_MAINGetSlot(char *Type);

/************************************************************************/
/*																		*/
/*							  Main Program								*/
/*																		*/
/************************************************************************/

void main(int argc,char *argv[])
{
	FILE *f;
	PARAMInit();
	IOInitialise(PARAM(PR_USECLASSICMODE,0) || argc != 1);
	IOFrame(COL_GREEN*16+COL_BLUE);
	#ifndef IDE
	TITLEPage1();
	#endif
	if (TITLEPage2() == 0)					/* Check load here */
	{
		DRAWClear();  						/* No, start the game */
		PLAYERInit(&p,(int)IOTimer());
	}
	else									/* Yes, try and load */
	{
		PLAYERInit(&p,424);					/* In case... */
		f = fopen(_MAINGetSlot("Load"),"rb");
		if (f != NULL)						/* Could open */
		{
			fread(&p,sizeof(p),1,f);		/* Read in the data */
			fclose(f);
		}
		else								/* File not found */
			DRAWMessage(MB_DELAY,"Slot is empty");
	}
	PANELDraw(&p);
	ROOMDraw(&p,&r,p.RoomID);
	while (p.Quit == 0)
	{
		_MAINCommand(&p,&r);				/* Do a command */
		if (p.Wounds >= 100 ||          	/* Have we died ? */
						p.Strength <= 0)
		{
			if (PLAYERResurrect(&p,&r) == 0)/* Did resurrection work ? */
					  PLAYERReport(&p,&r);	/* No, result,mebbe restart */
		}

		/* TODO: Start Vampire Sequence */

		if (PLAYERHasWon(&p))				/* Give a report,mebbe restart */
						PLAYERReport(&p,&r);/* if the player has won */

		_MAINEffects(&p);					/* Treasures have side effects */
		PANELRefresh(&p);					/* Refresh the panel */
	}
	IOTerminate();
	PARAMWrite();
}

/************************************************************************/
/*																		*/
/*						Command instruction								*/
/*																		*/
/************************************************************************/

static void _MAINCommand(PLAYER *p,ROOM *r)
{
	long t = IOTimer()+1000;
	int i,n,Key = 0;
	POINT pEnd;
	FILE *f;
	while (Key == 0 && t > IOTimer())
								Key = IOGet();

	switch(Key)								/* Command dispatcher */
	{
		case KEY_UP:                  		/* Move up */
			_MAINMove(p,r,0,-1);break;
		case KEY_DOWN:                 		/* Move down */
			_MAINMove(p,r,0,1);break;
		case KEY_LEFT:                 		/* Move left */
			_MAINMove(p,r,-1,0);break;
		case KEY_RIGHT:                		/* Move right */
			_MAINMove(p,r,1,0);break;
		case KEY_LOOKLEFT:					/* Look left */
			p->LookDir = -1;
			p->Char = GR_LOOKLEFT;
			break;
		case KEY_LOOKRIGHT:					/* Look right */
			p->LookDir = 1;
			p->Char = GR_LOOKRIGHT;
			break;
		case 'I':							/* Inspect treasure */
			if (p->LookDir == 0) break;
			if (MAP(p->Pos.x+p->LookDir,p->Pos.y) != GR_TREASURE) break;
			_MAINInspect(p,r);
			break;
		case 'S':							/* Swing sword */
			if (p->LookDir == 0) break;
			i = MAP(p->Pos.x+p->LookDir,p->Pos.y);
			if (i != GR_MONSTER && i != GR_MAGICMONSTER) break;
			n = (p->LookDir < 0) ? GR_SWORDLEFT:GR_SWORDRIGHT;
			for (i = 1;i <= 8;i++)
			{
				DRAWChar(p->Pos.x+p->LookDir,p->Pos.y,n,COL_RED);
				DRAWDelay(60);
				DRAWChar(p->Pos.x+p->LookDir,p->Pos.y,GR_ALTSWORD,COL_RED);
				DRAWDelay(60);
			}
			MONSTDamage(p,r,p->Pos.x+p->LookDir,p->Pos.y,3);
			break;
		case 'A':							/* Fire arrow */
			if (p->Arrows == 0) break;		/* Take away one arrow */
			p->Arrows--;
			if (p->LookDir == 0) break;		/* Must be facing */
			n = MAINMissile(p,r,&(p->Pos),p->LookDir,&pEnd,PARAM(PR_RANGE,6));
			DRAWAnimate(&(p->Pos),&pEnd,
						(p->LookDir < 0) ? GR_LARROW:GR_RARROW,
						COL_YELLOW,PARAM(PR_ARROWTIME,300));
			if (n == GR_MONSTER || n == GR_MAGICMONSTER)
				if (MONSTDamage(p,r,pEnd.x,pEnd.y,4))
						DRAWChar(pEnd.x,pEnd.y,GR_SPLAT,COL_WHITE);
			break;
		case 'F':							/* Fire spell */
			if (p->Has[HF_FIRE] == 0) break;
			p->Has[HF_FIRE] = 0;
			if (p->LookDir == 0) break;		/* Must be facing */
			n = MAINMissile(p,r,&(p->Pos),p->LookDir,&pEnd,PARAM(PR_RANGE,6));
			DRAWAnimate(&(p->Pos),&pEnd,
						(p->LookDir < 0) ? GR_LFIRE:GR_RFIRE,COL_RED,
						PARAM(PR_SPELLTIME,300));
			if (n == GR_MONSTER || n == GR_MAGICMONSTER)
				if (MONSTDamage(p,r,pEnd.x,pEnd.y,7))
				{
					for (n = 0;n < 5;n++)
					{
						DRAWChar(pEnd.x,pEnd.y,GR_ONFIRE,COL_RED);
						DRAWDelay(80);
						DRAWChar(pEnd.x,pEnd.y,GR_ONFIRE,COL_WHITE);
						DRAWDelay(80);
					}
					DRAWChar(pEnd.x,pEnd.y,' ',0);
				}
			break;
		case 'C':							/* Chaos Spell */
			if (p->Has[HF_CHAOS] == 0) break;
			p->Has[HF_CHAOS] = 0;
			if (p->LookDir == 0) break;		/* Must be facing */
			n = MAINMissile(p,r,&(p->Pos),p->LookDir,&pEnd,PARAM(PR_RANGE,6));
			DRAWAnimate(&(p->Pos),&pEnd,
						(p->LookDir < 0) ? GR_LCHAOS : GR_RCHAOS,
						COL_BLACK,PARAM(PR_SPELLTIME,300));
			if (n == GR_MONSTER || n == GR_MAGICMONSTER)
				if (MONSTDamage(p,r,pEnd.x,pEnd.y,10))
			{
				for (n = 0;n <= 7;n++)
				{
					DRAWChar(pEnd.x,pEnd.y,GR_CHAOSMIST,n);
					DRAWDelay(100);
				}
				for (n = 7;n >= 0;n--)
				{
					DRAWChar(pEnd.x,pEnd.y,GR_CHAOSMIST,n);
					DRAWChar(pEnd.x+1,pEnd.y,GR_CHAOSMIST,n);
					DRAWChar(pEnd.x,pEnd.y+1,GR_CHAOSMIST,n);
					DRAWChar(pEnd.x+1,pEnd.y+1,GR_CHAOSMIST,n);
					DRAWDelay(100);
				}
			}
			break;
		case 'W':							/* Water Spell */
			if (p->Has[HF_WATER] == 0) break;
			p->Has[HF_WATER] = 0;
			if (p->LookDir == 0) break;		/* Must be facing */
			n = MAINMissile(p,r,&(p->Pos),p->LookDir,&pEnd,PARAM(PR_RANGE,6));
			DRAWAnimate(&(p->Pos),&pEnd,GR_WATER,COL_BLUE,PARAM(PR_SPELLTIME,300));
			if (n == GR_MONSTER || n == GR_MAGICMONSTER)
				if (MONSTDamage(p,r,pEnd.x,pEnd.y,6))
				{
					for (n = 120;n <= 126;n++)
					{
						DRAWChar(pEnd.x,pEnd.y,n,COL_BLUE);
						DRAWDelay(160);
					}
					DRAWChar(pEnd.x,pEnd.y,' ',COL_BLUE);
				}
			break;
		case 'P':							/* Petrify Spell */
			if (p->Has[HF_PETRIFY] == 0) break;
			p->Has[HF_PETRIFY] = 0;
			if (p->LookDir == 0) break;		/* Must be facing */
			n = MAINMissile(p,r,&(p->Pos),p->LookDir,&pEnd,PARAM(PR_RANGE,6));
			DRAWAnimate(&(p->Pos),&pEnd,
						GR_PETRIFY,COL_BLUE,PARAM(PR_SPELLTIME,300));
			if (n == GR_MONSTER || n == GR_MAGICMONSTER)
			MONSTDamage(p,r,pEnd.x,pEnd.y,999);
			break;
		case 'E':							/* Drink Elixir */
			if (p->Has[HF_ELIXIR] == 0) break;
			p->Has[HF_ELIXIR] = 0;
			p->Strength = 100;p->Wounds = 0;
			break;
		case 'R':							/* Remove Brick */
			if (p->Has[HF_REMOVE] == 0) break;
			p->Has[HF_REMOVE] = 0;
			if (p->LookDir != 0)
					DRAWChar(p->Pos.x+p->LookDir,p->Pos.y,' ',0);
			break;
		case 'T':							/* Take Treasure */
			if (p->LookDir == 0) break;
			if (MAP(p->Pos.x+p->LookDir,p->Pos.y) != GR_TREASURE) return;
			n = _MAINInspect(p,r);
			r->Desc->TreasureTaken[n] = 1;	/* set flag so no more */
			DRAWChar(p->Pos.x+p->LookDir,	/* Erase the tile */
								p->Pos.y,' ',0);
			i = r->Treasure[n].TreasureID;	/* Get object */
			switch(i)
			{
				case HF_FOUNDARROW:			/* Arrow and gold are special */
						p->Has[i]++;break;
				case HF_FOUNDGOLD:
						p->Gold += r->Treasure[n].Gold;break;
				default:
						p->Has[i] = 1;break;
			}
			break;
		case 'D':							/* Dump Gold */
			p->Gold = p->Gold - PARAM(PR_GOLDDROPAMOUNT,10);
			if (p->Gold < 0) p->Gold = 0;
			break;
		case 'O':							/* Jump Over */
			if (p->LookDir == 0) break;
			n = MAP(p->Pos.x+p->LookDir,p->Pos.y);
			if (n==GR_MONSTER || n==GR_MAGICMONSTER || n==GR_CHAOSMIST)
			{
				n = _MAINJump(p,3);
				if (n == 0) n = _MAINJump(p,-21);
				if (n == 0) n = _MAINJump(p,-21);
				if (n == 0) n = _MAINJump(p, 23);
				if (n == 0) n = _MAINJump(p, 24);
				if (n == 0) n = _MAINJump(p,-20);
			}
			break;
		case 'J':							/* Random Reposition */
			if (p->Has[HF_JUMP] == 0) break;
			p->Has[HF_JUMP] = 0;
			p->Pos.x = 11;p->Pos.y = 3;
			p->RoomID = rand()%(MAPSIZE*MAPSIZE);
			ROOMDraw(p,r,1);
			break;
		case 'H':							/* Help Pages */
			_MAINHelp(p);
			PANELDraw(p);ROOMDraw(p,r,0);break;
			break;
		case 'Q':							/* Q = Quit and Save */
			DRAWMessage(0,"Are you sure you want!want to quit ? Y/N");
			do	i = IOGet(); while (i != 'Y' && i != 'N');
			if (i == 'Y')
			{
				DRAWMessage(0,"Do you want to save !this game ? Y/N");
				do	i = IOGet(); while (i != 'Y' && i != 'N');
				if (i == 'Y')
				{
					f = fopen(_MAINGetSlot("Save"),"wb");
					fwrite(p,sizeof(PLAYER),1,f);
					fclose(f);
				}
				p->Quit = 1;
			}
			else
				DRAWRemMessage(p,r);
			break;

		case 0:								/* 0 = No key pressed */
			p->Strength = p->Strength+PARAM(PR_STRENGTHREGAIN,5);
			if (p->Strength > 100) p->Strength = 100;
			break;
	}

	if (Key != 0)							/* Vampire test */
	{
		#ifdef IDE
		if (Key == 'V')
		#else
		if (rand()%PARAM(PR_VAMPIRERATE,100) == 0)
		#endif
			MONSTVampire(p,r);
	}
	if (Key != 0)							/* If some command,lose strength */
			p->Strength = p->Strength -
							(1 + p->Gold/PARAM(PR_STRENGTHLOSSSCALER,20));

	DRAWChar(p->Pos.x,p->Pos.y,				/* Repaint the player */
						p->Char,p->Colour);

	MONSTAction(p,r);						/* Do the monster stuff */
}

/************************************************************************/
/*																		*/
/*							Move a player								*/
/*																		*/
/************************************************************************/

static void _MAINMove(PLAYER *p,ROOM *r,int xi,int yi)
{
	int x,y,Exit;
	POINT p2;
	p->Char = GR_PLAYER;p->LookDir = 0;		/* Not looking any more */
	x = p->Pos.x+xi;y = p->Pos.y+yi;		/* Calculate new position */
	if (MAP(x,y) == GR_SPACE)				/* Move okay ? */
	{
		DRAWChar(p->Pos.x,p->Pos.y,' ',0);	/* Erase it */
		p2.x = x;p2.y = y;					/* Update position */
		DRAWAnimate(&(p->Pos),&p2,			/* Animate the movement */
					p->Char,p->Colour,PARAM(PR_MOVESPEED,300));
		p->Pos = p2;
		Exit = (x == 11 && (y == 0 || y == 17));
		Exit |= (y == 13 && (x == 0 || x == 21));

		if (Exit)
		{
			p->RoomID=p->RoomID+xi+yi*MAPSIZE;/* Go to next room */
			if (x == 11) p->Pos.y = 17-y;else p->Pos.x = 21-x;
			ROOMDraw(p,r,1);
		}
	}
}

/************************************************************************/
/*																		*/
/*								Display Help							*/
/*																		*/
/************************************************************************/

static char *OInfo[7] = {
	"A4MAGIC ARROW","C0CHAOS SPELL","F7FIRE SPELL","MMMIRROR SPELL",
	"PAPETRIFY SPELL","S3SWORD","W6WATER SPELL " };

static void _MAINHelp(PLAYER *p)
{
	int i,y,n,Page;
	MONSTER m;
	char Temp[32],*s;
	long Clock = IOTimer();					/* Time at the start */
	for (Page = 1;Page <= 2;Page++)			/* 2 Pages of Information */
	{
		DRAWClear();
		if (Page == 1)						/* Page 1 lists the monsters */
		{
			DRAWPrint(5,0,COL_WHITE+COL_REVTEXT,"CLOCK STOPPED");
			DRAWPrint(6,1,COL_RED+COL_REVTEXT,"TOMB BEINGS");
			for (i = 1;i <= 6;i++)			/* 6 of them */
			{
				m.Type = i;y = i * 3;		/* Set up */
				MONSTGetInfo(&m);			/* Get info */
				sprintf(Temp,"A %s",m.Name);/* Print it */
				DRAWPrint(7,y,COL_BLACK,Temp);
				sprintf(Temp,"STRENGTH %d",m.Strength);
				DRAWPrint(7,y+1,COL_BLACK,Temp);
				DRAWChar(3,y,				/* Draw the graphic */
							m.Graphic,m.Colour);
			}
		}
		if (Page == 2)						/* Page 2 uses array above */
		{
			DRAWPrint(5,0,COL_RED+COL_REVTEXT,"YOUR WEAPONS");
			for (i = 0;i < 7;i++)			/* 7 of them */
			{
				s = OInfo[i];y = i*3+2;  	/* Set up */
				DRAWChar(2,y,*s,COL_RED);	/* Key, then body */
				DRAWPrint(7,y,COL_BLACK,s+2);
				n = s[1]-'0';				/* Convert char 2 to line 2 */
				if (n == 0) n = 10;
				sprintf(Temp,"STRENGTH %d",n);
				if (s[1] == 'M') strcpy(Temp,"MAGICAL BEINGS");
				if (s[1] == 'A') strcpy(Temp,"ALL BEINGS");
				DRAWPrint(7,y+1,COL_BLACK,Temp);
			}
		}									/* Any key, then wait */
		DRAWPrint(4,20+Page,COL_WHITE,"* HIT ANY KEY *");
		while (IOGet() == 0) {}
	}
	p->StartTimer += (IOTimer()-Clock);		/* Allow for time spent here */
}

/************************************************************************/
/*																		*/
/*				Describe a treasure, return its ID						*/
/*																		*/
/************************************************************************/

static int _MAINInspect(PLAYER *p,ROOM *r)
{
	char Desc[32];
	int i,n = -1;
	for (i = 0;i < TCOUNT;i++)				/* Find out which one it is */
		if (p->Pos.x+p->LookDir == r->Treasure[i].Pos.x &&
					p->Pos.y == r->Treasure[i].Pos.y) n = i;
	if (n < 0) return 0;					/* Oops ! */
	strcpy(Desc,r->Treasure[n].Name);		/* Get name gold is special */
	if (r->Treasure[n].TreasureID == HF_FOUNDGOLD)
		sprintf(Desc,"%d %s",r->Treasure[n].Gold,r->Treasure[n].Name);
	DRAWMessage(MB_DELAY,Desc);				/* Draw, delay, repair */
	DRAWRemMessage(p,r);
	return n;
}

/************************************************************************/
/*																		*/
/*					Handle side effects of treasures					*/
/*																		*/
/************************************************************************/

static void _MAINEffects(PLAYER *p)
{
	if (p->Has[HF_AIRSTONE])        		/* Air, strength always 100 */
					p->Strength=100;
	if (p->Has[HF_FIRESTONE])				/* Others keep spell always on */
					p->Has[HF_FIRE] = 1;
	if (p->Has[HF_WATERSTONE])
					p->Has[HF_WATER] = 1;
	if (p->Has[HF_EARTHSTONE])
					p->Has[HF_REMOVE] = 1;
}

/************************************************************************/
/*																		*/
/*			See if jump possible, if so do it, return 1 if done			*/
/*																		*/
/************************************************************************/

static int _MAINJump(PLAYER *p,int Try)
{
	POINT pNew;
	pNew.x = p->Pos.x +						/* Work out new position */
				p->LookDir*(Try+40)%20;
	pNew.y = p->Pos.y + Try/20;
	if (MAP(pNew.x,pNew.y) != GR_SPACE)		/* Couldn't go there */
									return 0;
	DRAWChar(p->Pos.x,p->Pos.y,' ',0);		/* Erase old */
	DRAWAnimate(&(p->Pos),&pNew,p->Char,p->Colour,PARAM(PR_JUMPSPEED,200));
	p->Pos = pNew;DRAWChar(pNew.x,pNew.y,p->Char,p->Colour);
	return 1;
}

/************************************************************************/
/*																		*/
/*							Fire a missile								*/
/*																		*/
/************************************************************************/

int MAINMissile(PLAYER *p,ROOM *r,POINT *pStart,int Dir,POINT *pEnd,int Range)
{
	int c;
	*pEnd = *pStart;
	while (Range-- > 0)
	{
		pEnd->x = pEnd->x + Dir;
		c = MAP(pEnd->x,pEnd->y);if (c != GR_SPACE) return c;
	}
	return 0;
}

/************************************************************************/
/*																		*/
/*				   Get the file name of a load/save slot				*/
/*																		*/
/************************************************************************/

static char *_MAINGetSlot(char *Type)
{
	static char Msg[32];
	char c;
	sprintf(Msg,"Select slot for %s",Type);
	DRAWMessage(MB_DRAWONLY,Msg);
	do
		c = IOGet();
	while (!isdigit(c));
	sprintf(Msg,"DREWAN%c.SAV",c);
	return Msg;
}