#ifndef VTIMER_H
#define VTIMER_H

#include "types.h"

#define VT_VRSYNC	1
#define VT_CALLOLD	2

#ifdef __cplusplus
extern "C" {
#endif

void VT_Exit(void);
void VT_Init(void);
short VT_Alloc(void);
void VT_Free(short handle);
void VT_SetHandler(short handle,void (*handler)(void));
void VT_SetSpeed(short handle,long speed);
void VT_SetBPM(short handle,uchar bpm);
void VT_Start(short handle);
void VT_Stop(short handle);
void VT_Mode(uchar flags);
void VT_V0Handler(void (*handler)(void));
void VT_V1Handler(void (*handler)(void));

#ifdef __cplusplus
}
#endif

#endif
