
#ifndef AH_SETUP
#define AH_SETUP

#include "types.h"

#pragma pack (4)

#ifndef AH_MAINMODULE
#define _ext extern
#else
#define _ext
#endif


// Einige NATURKONSTANTEN.
// Don't expect the game to run properly if you change any of
// the NATURKONSTANTEN.
#define CONFIGFILE      "RAVAGE.INI"
#define MAXPLAYERS      2

// Keep track of several machine settings.
// This structure will be saved to disk.
struct Settings {
// Control settings.
   int      device[MAXPLAYERS];  // Input device for all the players.
// Mouse settings.
   int      msens;               // Mouse sensitivity.
// Keyboard settings.
   int      key[5];              // Defined keys. (lt, rt, up, dn, fire).
// Sound settings.
   int      sound_device;        // Sound device to use.
   int      voices;              // Number of SFX voices to mix.
   int      mix_freq;            // Mixing frequency.
   int      mod_vol;             // Volume of MOD Music.
   int      wav_vol;             // Volume of WAVES.
// Graphic settings.
   int      shadows;             // Shadow level. (None, Some or All).
   int      frate;               // Frame rate. (Auto, 15fps or 30fps).
   int      cpu_usage;           // "Display CPU Usage" FLAG.
};


// Define some global variables.
_ext FilePool  filepool[4];      // A pool of all the needed data files.

_ext Settings  settings;         // Environment settings.

extern volatile int timer_ticks;

// --- Prototypes of "stuff.cpp"
#define FADE_PALETTE       1        // Do palette fading.
#define FADE_MUSIC         2        // Do music fading.
#define FADE_ALL           (FADE_PALETTE | FADE_MUSIC)
void fadeout(int);
void fadein(void *p);

// --- Prototypes of "face.cpp"
#define MAINMENU        0
#define SHOPMENU        4

#define M_PLAY          1
#define M_LOAD          2
#define M_SOUND         3
#define M_QUIT          -1

int menu(void);

#endif

