
/*-------------------------------------------------------*/
/*                                                       */
/* [c]copyright 1996 by AlphaHelix                       */
/*                                                       */
/*                                                       */
/*-------------------------------------------------------*/


#include <malloc.h>
#include <setjmp.h>
#include <sys\types.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <iostream.h>
#include <i86.h>
#include <dos.h>

#define AH_MAINMODULE
#include "error.hpp"
#include "memory.hpp"
#include "types.h"
#include "timer.hpp"    // easy timer module.
#include "xlib.hpp"
#include "input.hpp"
#include "diskio.hpp"
#include "sound.hpp"
#include "setup.hpp"


// Some variables.
const    char copyright[] = "RAVAGE setup 1.1 [c]copyright 1996 by AlphaHelix.";


/*---------------------------------------------------------
 Function: timer

 Description:
 This is the all important timer function.
 This function will be called 60 times a second and
 updates the "timer_ticks" variable.
 "timer_ticks" is then used in the rest of the program
 to synchronize game speed and screen output to 30
 frames per second.
---------------------------------------------------------*/
volatile int  timer_ticks;
void timer(void)
{
   timer_ticks++;
}



/*---------------------------------------------------------
 Function:

 Description:
 Critical error handler for DOS int 24h ?
---------------------------------------------------------*/
#pragma off (unreferenced)
int __far critical_err(unsigned dev, unsigned err, unsigned __far *hdr)
{
   return _HARDERR_FAIL;
}
#pragma on (unreferenced)


/*---------------------------------------------------------
 Function: loadsettings & savesettings

 Description:
 These functions are used to save\load the configuration
 the user has choosen.
---------------------------------------------------------*/
static void loadsettings(char *file)
{
   myFile   myfile;

// Fill in settings structure with FACTORY DEFAULTS.
// Sound settings.
   settings.voices = 2;
   settings.sound_device = 1;
   settings.mix_freq = 44100;
   settings.mod_vol = 10;
   settings.wav_vol = 30;
// Control settings.
   settings.msens = M_MEDIUM;
   settings.key[0] = 0x4b;
   settings.key[1] = 0x4d;
   settings.key[2] = 0x48;
   settings.key[3] = 0x50;
   settings.key[4] = 0x39;
   settings.device[0] = 1;       // Player 1 input: Keyboard.
   settings.device[1] = 3;       // Player 2 input: Mouse.
// Graphix
   settings.frate = 1;
   settings.shadows = 2;
   settings.cpu_usage = 0;

// Try to load configuration file.
   if (myfile.open(file)) {
      myfile.read(&settings, sizeof(Settings));
      myfile.close();
   }
}

static void savesettings(char *file)
{
   myFile   myfile;

   if (!myfile.creat(file)) return;
   myfile.write(&settings, sizeof(Settings));
   myfile.close();

}

/*---------------------------------------------------------
 Function: powerdown

 Description:
 Function called upon exit of the program.
 Does all the needed housekeeping AFTER the
 registered exit functions (reg_exit) have been
 called.
---------------------------------------------------------*/
static void powerdown(void)
{
#ifdef DEBUG
   memory_usage();
#endif
}

/*---------------------------------------------------------
 Function: powerup

 Description:
 Initialize the system.
 - memory manager
 - timer
 - sound card
 - graphics
 - inputs (keyboard, mouse, joystick)
---------------------------------------------------------*/
static void powerup(void)
{
// Install DOS error handler.
   _harderr(critical_err);
   atexit(powerdown);

// Load configurations.
   loadsettings(CONFIGFILE);

// Init filesystem.
   initfilesystem(); reg_exit(shutfilesystem);
// Initialize Inputs.
   initinputs(INPUT_KEYBOARD | INPUT_MOUSE);
   reg_exit(shutinputs);
// Define keys according to loaded settings.
   setkeys(settings.key[0], settings.key[1],
           settings.key[2], settings.key[3],
           settings.key[4]);

// Enter graphics.
   initgraphics(); reg_exit(shutgraphics);

// Start TIMERS.
// Easy timer. (ET = Easy Timer)
   ET_init(60); reg_exit(ET_shut);
   ET_setmode(ET_CALLOLD);
   ET_reg(timer);    // Register screen timer.

// Register sound timer.
   ET_reg(s_update);
}


void main(void)
{
   int   request;          // Returned request from MAIN MENU.

// Set up error handling LONG JUMP.
   if (setjmp(_err_jmp)) {
// If an error occurs we will jump here.
      reg_down();          // Properly shut down the system.
      post_error();        // Post error processing.
      exit(1);
   }

// Display some message.
   cout << endl << copyright << endl << endl;

// Start the system.
   powerup();

// Open FilePool.
   filepool[0].open("RAV0.DAT");
   filepool[1].open("RAV1.DAT");
   filepool[2].open("RAV2.DAT");
   filepool[3].open("RAV3.DAT");

// Play loop.

   do {
      request = menu();          // Show menu and play DEMO.
   } while (request != M_QUIT);

// Close FilePool.
   filepool[3].close();
   filepool[2].close();
   filepool[1].close();
   filepool[0].close();

// Done for the game. Back to OS.
   reg_down();                // Execute registered shutdown functions.
   savesettings(CONFIGFILE);  // Save current game settings.
   exit(0);                   // Exit nicely.
}



