
#ifndef AH_DISKIO
#define AH_DISKIO

#include <stdio.h>

#define HDRSIZE      80

class myFile {
   int   active;
   int   realfile;
   FILE  *stream;
   int   base;
   int   size;
public:
   ~myFile() { close(); }
   int   open(char *f);
   int   creat(char *f);
   void  close(void);
   void  read(void *ptr, int size);
   void  write(void *ptr, int size);
   FILE  *getFILE(void) { return stream; }
   int   getbase(void) { return base; }
   int   getsize(void) { return size; }
};

struct File {
   char     name[80];            // Name of the file (including directory).
   long     flags;               // Some flags.
   long     size;                // File size in bytes;
   long     fptr;                // File ptr to get access to data.
};

class FilePool {
   FILE  *stream;                // File handle to database file.
   char  hdr[HDRSIZE];           // Header string. (like "DATABASE VER 1.0")
   long  flags;
   long  n;                      // Number of files in database.
   File  *file;                  // File headers.

   File  *findfile(char *f);
   friend class myFile;

public:
   FilePool();
   ~FilePool(void) { close(); }
   void open(char *f);
   void close(void);
};

void *loadfile(char *);
void unloadfile(void *);

void initfilesystem(void);
void shutfilesystem(void);

#endif

