// ****************************************************************************
// * SoundManager.java                                                        *
// *                                                                          *
// * (c) 1997-2002 by Eric Tucker.                                            *
// *                                                                          *
// * This program is free software; you can redistribute it and/or modify it  *
// * under the terms of version 2 of the GNU General Public License (GPL) as  *
// * published by the Free Software Foundation.  This program is distributed  *
// * in the hope that it will be useful but WITHOUT ANY WARRANTY; without     *
// * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR *
// * PURPOSE.  See the GPL for more details.  You should have received a copy *
// * of the GPL along this program.  If not, write to the Free Software       *
// * Foundation, Inc. at 59 Temple Place, Suite 330, Boston, MA  02111  USA   *
// *                                                                          *
// * Please contact Eric Tucker at erictucker2000@yahoo.com with any          *
// * questions, comments, suggestions, or bug reports.                        *
// ****************************************************************************

import java.awt.*;
import java.net.URL;
import java.applet.*;
import java.net.MalformedURLException;

class SoundManager
{
  Menus menus;
  String urlBase;
  AudioClip clickSound;
  AudioClip laserSound;
  AudioClip captureSound;
  AudioClip beepSound;
  AudioClip explosionSound;
  AudioClip teleportSound;
  AudioClip winSound;
  AudioClip loseSound;

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  SoundManager(Menus menus)
  {
    URL urlClickSound;
    URL urlLaserSound;
    URL urlCaptureSound;
    URL urlBeepSound;
    URL urlExplosionSound;
    URL urlTeleportSound;
    URL urlWinSound;
    URL urlLoseSound;

    this.menus = menus;
    urlClickSound = null;
    urlLaserSound = null;
    urlCaptureSound = null;
    urlBeepSound = null;
    urlExplosionSound = null;
    urlTeleportSound = null;
    urlWinSound = null;
    urlLoseSound = null;

    urlBase = "file:///" + System.getProperty("user.dir") + "/../sounds/";

    try {
      urlClickSound = new URL(urlBase + "click.au");
      urlLaserSound = new URL(urlBase + "laser.au");
      urlCaptureSound = new URL(urlBase + "capture.au");
      urlBeepSound = new URL(urlBase + "chord.au");
      urlExplosionSound = new URL(urlBase + "disintegrate.au");
      urlTeleportSound = new URL(urlBase + "teleport.au");
    }
    catch (MalformedURLException e) {
      System.err.println(e.getMessage());
    }

    clickSound = Applet.newAudioClip(urlClickSound);
    laserSound = Applet.newAudioClip(urlLaserSound);
    captureSound = Applet.newAudioClip(urlCaptureSound);
    beepSound = Applet.newAudioClip(urlBeepSound);
    explosionSound = Applet.newAudioClip(urlExplosionSound);
    teleportSound = Applet.newAudioClip(urlTeleportSound);
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  void Click()
  {
    if (menus.IsSoundEnabled())
      clickSound.play();
  }

  void StartFiringLaser()
  {
    if (menus.IsSoundEnabled())
      laserSound.loop();
  }

  void StopFiringLaser()
  {
    if (menus.IsSoundEnabled())
      laserSound.stop();
  }

  void Capture()
  {
    if (menus.IsSoundEnabled())
      captureSound.play();
  }

  void Explode()
  {
    if (menus.IsSoundEnabled())
      explosionSound.play();
  }

  void Teleport()
  {
    if (menus.IsSoundEnabled())
      teleportSound.play();
  }

  // --------------------------------------------------------------------------
  // If player A makes a mistake, and player B is on a remote computer,
  // we shouldn't also beep on player B's computer.
  // --------------------------------------------------------------------------
  void Beep(boolean local)
  {
    if (local && menus.IsSoundEnabled())
      beepSound.play();
  }
}
