// ****************************************************************************
// * ResultProcessor.java                                                     *
// *                                                                          *
// * (c) 1997-2002 by Eric Tucker.                                            *
// *                                                                          *
// * This program is free software; you can redistribute it and/or modify it  *
// * under the terms of version 2 of the GNU General Public License (GPL) as  *
// * published by the Free Software Foundation.  This program is distributed  *
// * in the hope that it will be useful but WITHOUT ANY WARRANTY; without     *
// * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR *
// * PURPOSE.  See the GPL for more details.  You should have received a copy *
// * of the GPL along this program.  If not, write to the Free Software       *
// * Foundation, Inc. at 59 Temple Place, Suite 330, Boston, MA  02111  USA   *
// *                                                                          *
// * Please contact Eric Tucker at erictucker2000@yahoo.com with any          *
// * questions, comments, suggestions, or bug reports.                        *
// ****************************************************************************

import java.awt.*;

// ----------------------------------------------------------------------------
// A generic interface for anything that needs to be notified of a dialog
// box being dismissed.  The "source" parameter is a Window, rather than
// a Dialog, because of a quirk of AWT: if you want to bring up a dialog box
// with no other windows already up, you can't... so you have to make it a
// Window instead, and put up with the inappropriate maximize and mimimize
// buttons in its title bar.
// ----------------------------------------------------------------------------
interface ResultProcessor
{
  public void ProcessResult(Window source, Object result);
}
