// ****************************************************************************
// * Readout.java                                                             *
// *                                                                          *
// * (c) 1997-2002 by Eric Tucker.                                            *
// *                                                                          *
// * This program is free software; you can redistribute it and/or modify it  *
// * under the terms of version 2 of the GNU General Public License (GPL) as  *
// * published by the Free Software Foundation.  This program is distributed  *
// * in the hope that it will be useful but WITHOUT ANY WARRANTY; without     *
// * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR *
// * PURPOSE.  See the GPL for more details.  You should have received a copy *
// * of the GPL along this program.  If not, write to the Free Software       *
// * Foundation, Inc. at 59 Temple Place, Suite 330, Boston, MA  02111  USA   *
// *                                                                          *
// * Please contact Eric Tucker at erictucker2000@yahoo.com with any          *
// * questions, comments, suggestions, or bug reports.                        *
// ****************************************************************************

import java.awt.*;
import java.awt.event.*;

class Readout extends Panel
{
  static final int kFontSize=16;
  Label label1, label2, label3, label4;
  Board board;
  int winner;
  boolean gameOver;
  int workaround=0; // @@ works around bug in JDK 1.1.3 and beyond on WinNT

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  Readout(Board board)
  { 
    this.board = board;
    setLayout(new GridLayout(2, 2));
    add(label1 = new Label("1", Label.LEFT));
    add(label3 = new Label("3", Label.RIGHT));
    add(label2 = new Label("2", Label.LEFT));
    add(label4 = new Label("4", Label.RIGHT));
    winner = LaserChess.kNoTeam;
    gameOver = false;
    label1.setFont(new Font("dialog", Font.BOLD, kFontSize));
    label2.setFont(new Font("dialog", Font.BOLD, kFontSize));
    label3.setFont(new Font("dialog", Font.BOLD, kFontSize));
    label4.setFont(new Font("dialog", Font.BOLD, kFontSize));
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  void DeclareWinner(int winner)
  {
    gameOver = true;
    this.winner = winner;
    Update();
  }
  
  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  void Update()
  {
    SetMovesLabel();
    SetTurnLabel();
    SetTimeLimitLabel();
  }

  // ##########################################################################
  // ##########################################################################
 
  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  private void SetMovesLabel()
  {
    String dummy;
    if (gameOver) {
      if (winner == LaserChess.kNoTeam) {
	label1.setForeground(ColorManager.kHotCursor);
	label1.setText("  Stalemate!");
      }
      else if (winner == LaserChess.kLostContact) {
	label1.setForeground(ColorManager.kHotCursor);
	label1.setText("  Lost contact with opponent");
      }
      else {
	label1.setForeground(ColorManager.PlayerColor(winner).h);
	label1.setText("  " + ColorManager.TeamColorCodeToString(winner) +
		       " team wins!");
      }
      label2.setText("");
    }
    else {
      label1.setForeground(ColorManager.PlayerColor(board.turn).h);
      label2.setForeground(ColorManager.PlayerColor(board.turn).h);
      if (board.pickedUpPiece == null)
	dummy = " N/A";
      else
	dummy = " " + board.pickedUpPiece.MovesUsed(board.cursor.sq);

      ++workaround;
      if (workaround % 2 == 1)
	dummy = dummy + " ";

      label1.setText("  Moves left: " + board.movesLeft);
      label2.setText("  Moves pending: " + dummy);
    }
  }


  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  private void SetTurnLabel()
  {
    if (board.netplay && !gameOver) {
      label3.setForeground(ColorManager.PlayerColor(board.turn).h);
      if (board.turn == board.localTeam)
	label3.setText("        Your turn  ");
      else
	label3.setText("  Opponent's turn  ");
    }
    else if (!gameOver) {
      label3.setForeground(ColorManager.PlayerColor(board.turn).h);
      label3.setText(ColorManager.TeamColorCodeToString(board.turn) +
		     "'s turn  ");
    }
    else if (board.timeRanOut) {
      label3.setForeground(ColorManager.kHotCursor);
      label3.setText("Time ran out!  ");
    }
    else
      label3.setText("");
  }


  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  private void SetTimeLimitLabel()
  {
    String dummy;
    int secLeft;

    if (!gameOver) {
      secLeft = board.timeLeft[board.turn];
      label4.setForeground(ColorManager.PlayerColor(board.turn).h);
      switch (board.game.configInfo.timerType) {
      case GameConfigInfo.kNoTimeLimit:
	label4.setText("No time limit  ");
	break;
      case GameConfigInfo.kTimeLimitPerTurn:
	label4.setText(secLeft + " sec. left this turn  ");
	break;
      case GameConfigInfo.kTimeLimitPerGame:
	if (secLeft%60 < 10)
	  dummy = ":0" + secLeft%60;
	else
	  dummy = ":" + secLeft%60;
	label4.setText(secLeft/60 + dummy + " left this game  ");
	break;
      }
    }
    else
      label4.setText("");
  }
}
