// ****************************************************************************
// * RandomNumberServer.java                                                  *
// *                                                                          *
// * (c) 1997-2002 by Eric Tucker.                                            *
// *                                                                          *
// * This program is free software; you can redistribute it and/or modify it  *
// * under the terms of version 2 of the GNU General Public License (GPL) as  *
// * published by the Free Software Foundation.  This program is distributed  *
// * in the hope that it will be useful but WITHOUT ANY WARRANTY; without     *
// * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR *
// * PURPOSE.  See the GPL for more details.  You should have received a copy *
// * of the GPL along this program.  If not, write to the Free Software       *
// * Foundation, Inc. at 59 Temple Place, Suite 330, Boston, MA  02111  USA   *
// *                                                                          *
// * Please contact Eric Tucker at erictucker2000@yahoo.com with any          *
// * questions, comments, suggestions, or bug reports.                        *
// ****************************************************************************

import java.io.*;
import java.net.*;
import java.util.*;

// ----------------------------------------------------------------------------
// This class listens on a port and doles out the same series of random numbers
// over that port as it does to local clients who call its Random() method.
// ----------------------------------------------------------------------------
class RandomNumberServer extends Thread
{
  static final int kMagicPort=7602;
  Vector nums;
  int numLocal=0, numRemote=0;
  ServerSocket server;

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  RandomNumberServer()
  {
    nums = new Vector(3, 2);
    try {
      server = new ServerSocket(kMagicPort);
    } catch (IOException e) { NetError(e); }
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  public void run()
  {
    while (true) {
      try {
	Socket sock = server.accept();
	DataOutputStream out = new DataOutputStream(sock.getOutputStream());
	out.writeDouble(random(false));
	sock.close();
      } catch (IOException e) { NetError(e); }
    }
  }

  // --------------------------------------------------------------------------
  // This function serves random numbers out two streams: local and remote.
  // Each stream will match each other stream byte for byte; so every time we
  // send out byte n for the first time, we have to rememeber it until the 
  // other stream asks for that byte.
  // --------------------------------------------------------------------------
  double random(boolean local)
  {
    double num;
    
    // forging ahead: generate a new number, and remember it for later
    if ((local && numLocal>=numRemote) || (!local && numRemote>=numLocal)) {
      num = Math.random();
      nums.addElement(new Double(num));
    }

    // catching up with other side: just use its old random numbers
    else {
      num = ((Double)(nums.firstElement())).doubleValue();
      nums.removeElementAt(0);
    }

    if (local)
      ++numLocal;
    else
      ++numRemote;

    return num;
  }

  // ##########################################################################
  // ##########################################################################
 
  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  protected static void NetError(IOException e)
  {
    System.out.println("\nNetwork error: " + e);
    System.exit(0);
  }
}
