// ****************************************************************************
// * RadioButton.java                                                         *
// *                                                                          *
// * (c) 1997-2002 by Eric Tucker.                                            *
// *                                                                          *
// * This program is free software; you can redistribute it and/or modify it  *
// * under the terms of version 2 of the GNU General Public License (GPL) as  *
// * published by the Free Software Foundation.  This program is distributed  *
// * in the hope that it will be useful but WITHOUT ANY WARRANTY; without     *
// * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR *
// * PURPOSE.  See the GPL for more details.  You should have received a copy *
// * of the GPL along this program.  If not, write to the Free Software       *
// * Foundation, Inc. at 59 Temple Place, Suite 330, Boston, MA  02111  USA   *
// *                                                                          *
// * Please contact Eric Tucker at erictucker2000@yahoo.com with any          *
// * questions, comments, suggestions, or bug reports.                        *
// ****************************************************************************

import java.awt.*;

// ----------------------------------------------------------------------------
// This class is just like an AWT Checkbox, except for two things:
//    - it can only be used for mutually exclusive choices (radio buttons)
//    - when disabled, it sets its value to false, remembering its original
//      value for when it is reenabled.
//
// What a massive hack it was to get this to work though... curses to a
// buggy AWT!!  The stupid Checkbox class won't let you clear out the last
// radio button in a group.  So, my only alternative was to tell the
// checkboxgroup that no radio button was to be active by passing it null.
// The docs say this won't work, but it does.
//
// Disturbingly, javac doesn't have any complaints about my redeclaring
// instance variables of classes I'm inheriting from, so I don't know how to
// reliably ensure that I don't step on java.awt.checkbox's toes.  I'll just
// prepend an "x", sloppy as this may seem...
// ----------------------------------------------------------------------------
public class RadioButton extends Checkbox
{
  boolean xSavedState;

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  public RadioButton(String xLabel, CheckboxGroup xCbg, boolean xState)
  {
    super(xLabel, xCbg, xState);
    xSavedState = xState;
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  public void setEnabled(boolean xEnabled)
  {
    if (xEnabled && !isEnabled())
      setState(xSavedState);
    else if (!xEnabled && isEnabled()) {
      xSavedState = getState();
      if (getCheckboxGroup().getSelectedCheckbox() == this)
	getCheckboxGroup().setSelectedCheckbox(null);
      setState(false);
    }
    super.setEnabled(xEnabled);
  }
}
