// ****************************************************************************
// * MyUtils.java                                                             *
// *                                                                          *
// * (c) 1997-2002 by Eric Tucker.                                            *
// *                                                                          *
// * This program is free software; you can redistribute it and/or modify it  *
// * under the terms of version 2 of the GNU General Public License (GPL) as  *
// * published by the Free Software Foundation.  This program is distributed  *
// * in the hope that it will be useful but WITHOUT ANY WARRANTY; without     *
// * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR *
// * PURPOSE.  See the GPL for more details.  You should have received a copy *
// * of the GPL along this program.  If not, write to the Free Software       *
// * Foundation, Inc. at 59 Temple Place, Suite 330, Boston, MA  02111  USA   *
// *                                                                          *
// * Please contact Eric Tucker at erictucker2000@yahoo.com with any          *
// * questions, comments, suggestions, or bug reports.                        *
// ****************************************************************************

import java.awt.*;

class MyUtils
{
  // The height of the Windows start menu is not subtracted from the screen
  // height, so we have to correct for that.  Unfortunately, this may be different
  // on other Windows systems, is know to overcorrect for X Windows, and may be
  // wrong on other operating systems too.  You can always change it...
  static final int kUnusableVerticalSpace = 33;

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  static void EnlargeWindow(Window w, int dx, int dy)
  {
    Dimension d = w.getSize();
    w.setSize(d.width + dx, d.height + dy);
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  static Dimension ScreenSize()
  {
    Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
    s.height -= kUnusableVerticalSpace;
    return s;
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  static void CenterWindowOnScreen(Window w)
  {
    Dimension d = w.getSize();
    Dimension s = ScreenSize();
    w.setLocation((s.width - d.width)/2, (s.height - d.height)/2);
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  static void CenterDialogWithinParent(Dialog dlg, Frame parent)
  {
    Point ploc = parent.getLocation();
    Dimension psiz = parent.getSize();
    Dimension msiz = dlg.getSize();
    int x, y;
    
    x = ploc.x + (int)((psiz.width-msiz.width)/2);
    y = ploc.y + (int)((psiz.height-msiz.height)/2);
    dlg.setLocation(x, y);
  }

  // --------------------------------------------------------------------------
  // dx and dy are offsets that allow you to specify non-square dimensions for
  // the window.  Of course, a ratio may be preferable in some situations, but
  // we don't support that yet.
  // --------------------------------------------------------------------------
  static void SizeWindowToFitScreen(Window w, int dx, int dy)
  {
    Dimension s = ScreenSize();
    int mindim = Math.min(s.height, s.width);
    if (dx > dy) {
      dy -= dx;
      dx = 0;
    }
    else {
      dx -= dy;
      dy = 0;
    }
    w.setSize(mindim+dx, mindim+dy);
  }

  // --------------------------------------------------------------------------
  // The "which" parameter should be either 0 or 1, and signifies
  // whether even or odd pixels should be plotted.
  // --------------------------------------------------------------------------
  static void DrawDottedRect(Graphics g, int left, int top,
			     int width, int height, int which, int offset)
  {
    DrawDottedLine(g, left, top, left+width, top, which, offset);
    DrawDottedLine(g, left, top+height, left, top, which, offset);
    DrawDottedLine(g, left+width, top, left+width, top+height, which, offset);
    DrawDottedLine(g, left, top+height, left+width, top+height, which, offset);
  }

  // --------------------------------------------------------------------------
  // Can only draw lines that are perpendicular to an axis!  (so I am declaring
  // this private for now, to prevent confusion)
  // The "which" parameter should be either 0 or 1, and signifies
  // whether even or odd pixels should be plotted.
  // --------------------------------------------------------------------------
  private static void DrawDottedLine(Graphics g, int x1, int y1,
				     int x2, int y2, int which, int offset)
  {
    if (x1 == x2) { // vertical line
      for (int y=Math.min(y1,y2); y<=Math.max(y1,y2); ++y)
	if ((y+offset)%2 == which)
	  PlotPoint(g, x1, y);
    }
    else { // horizontal line
      for (int x=Math.min(x1,x2); x<=Math.max(x1,x2); ++x)
	if ((x+offset)%2 == which)
	  PlotPoint(g, x, y1);
    }
  }

  // --------------------------------------------------------------------------
  // Somehow Javasoft forgot to give the Graphics class a method for plotting
  // a single point!
  // --------------------------------------------------------------------------
  static void PlotPoint(Graphics g, int x, int y)
  {
    g.fillRect(x, y, 1, 1);
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  static void FillTriangle(Graphics g,
			   int x1, int y1, int x2, int y2, int x3, int y3)
  {
    int[] xPoints = new int[3];
    int[] yPoints = new int[3];

    xPoints[0] = x1;
    xPoints[1] = x2;
    xPoints[2] = x3;
    
    yPoints[0] = y1;
    yPoints[1] = y2;
    yPoints[2] = y3;
    
    g.fillPolygon(xPoints, yPoints, 3);
  }

  // --------------------------------------------------------------------------
  // A rather conspicuous omission from the standard math library...
  // --------------------------------------------------------------------------
  static double Clamp(double n, double lo, double hi)
  {
    if (n < lo)
      return lo;
    else if (n > hi)
      return hi;
    else
      return n;
  }
}
