// ****************************************************************************
// * Morgue.java                                                              *
// *                                                                          *
// * (c) 1997-2002 by Eric Tucker.                                            *
// *                                                                          *
// * This program is free software; you can redistribute it and/or modify it  *
// * under the terms of version 2 of the GNU General Public License (GPL) as  *
// * published by the Free Software Foundation.  This program is distributed  *
// * in the hope that it will be useful but WITHOUT ANY WARRANTY; without     *
// * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR *
// * PURPOSE.  See the GPL for more details.  You should have received a copy *
// * of the GPL along this program.  If not, write to the Free Software       *
// * Foundation, Inc. at 59 Temple Place, Suite 330, Boston, MA  02111  USA   *
// *                                                                          *
// * Please contact Eric Tucker at erictucker2000@yahoo.com with any          *
// * questions, comments, suggestions, or bug reports.                        *
// ****************************************************************************

import java.util.*;

class Morgue
{
  Vector doomed;

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  Morgue()
  {
    doomed = new Vector(3, 2);
  }

  // --------------------------------------------------------------------------
  // Marks the piece as "doomed" (so it knows to draw itself in a different
  // color) and adds it to our blacklist (if it's not already there) so we
  // know whom to kill off later.
  // --------------------------------------------------------------------------
  void Doom(Piece piece)
  {
    if (!doomed.contains(piece))
      doomed.addElement(piece);
    piece.doomed = true;
    piece.Draw();
  }

  // --------------------------------------------------------------------------
  // Iterates through list of doomed pieces, telling each one to die.
  // Also notices if any kings die, and if so, declares the game over.
  // This has to be done at this level, rather than by the kings themselves,
  // because if both kings die from the same beam, the game is a stalemate.
  // --------------------------------------------------------------------------
  void DestroyAll(Board board)
  {
    int i, winner=LaserChess.kNoTeam;
    boolean gameOver=false;
    Piece next;

    for (i=0; i<doomed.size(); ++i) {
      next = (Piece)(doomed.elementAt(i));
      if (next.type == Piece.kKing) {
	if (gameOver)
	  // if the game was already over, this must be the 2nd king being
	  // killed too, which means a stalemate!
	  winner = LaserChess.kNoTeam;
	else {
	  winner = 1 - next.team;
	  gameOver = true;
	}
      }
      next.Die(true);
    }
    if (gameOver)
      board.EndGame(winner, false);
    doomed.removeAllElements();
  }
  
}
