// ****************************************************************************
// * Menus.java                                                               *
// *                                                                          *
// * (c) 1997-2002 by Eric Tucker.                                            *
// *                                                                          *
// * This program is free software; you can redistribute it and/or modify it  *
// * under the terms of version 2 of the GNU General Public License (GPL) as  *
// * published by the Free Software Foundation.  This program is distributed  *
// * in the hope that it will be useful but WITHOUT ANY WARRANTY; without     *
// * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR *
// * PURPOSE.  See the GPL for more details.  You should have received a copy *
// * of the GPL along this program.  If not, write to the Free Software       *
// * Foundation, Inc. at 59 Temple Place, Suite 330, Boston, MA  02111  USA   *
// *                                                                          *
// * Please contact Eric Tucker at erictucker2000@yahoo.com with any          *
// * questions, comments, suggestions, or bug reports.                        *
// ****************************************************************************

import java.awt.*;
import java.awt.event.*;

class Menus extends MenuBar implements ActionListener, ItemListener
{
  LaserChess game;
  Board board;
  Menu file, action, options;
  MenuItem newgame, quit, toggle, rotate, fire, cancel, setkeys;
  CheckboxMenuItem pause, sound;

  // Pad string to work around AWT bug which causes buttons to not
  // resize themselves properly when their text is changed.
  static final String kPickUp = " Pick up ", kPutDown = "Put down";

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  Menus(LaserChess game, Board board)
  {
    this.game = game;
    this.board = board;

    file = new Menu("File", true);
    file.add(newgame = new MenuItem("New Game"));
    file.add(pause = new CheckboxMenuItem("Pause"));
    pause.setState(false);
    file.addSeparator();
    file.add(quit = new MenuItem("Quit"));
    newgame.addActionListener(this);
    pause.addItemListener(this);
    quit.addActionListener(this);

    // @@ not implemented yet...
    newgame.setEnabled(false);
    
    action = new Menu("Action", true);
    action.add(toggle = new MenuItem(kPickUp));
    action.add(rotate = new MenuItem("Rotate"));
    action.add(fire = new MenuItem("Fire"));
    action.add(cancel = new MenuItem("Cancel"));
    toggle.addActionListener(this);
    rotate.addActionListener(this);
    fire.addActionListener(this);
    cancel.addActionListener(this);

    options = new Menu("Options", true);
    options.add(sound = new CheckboxMenuItem("Sound"));
    sound.setState(true);
    options.addSeparator();
    options.add(setkeys = new MenuItem("Set Keyboard Controls..."));
    setkeys.addActionListener(this);

    add(file);
    add(action);
    add(options);
  }
  

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  public void actionPerformed(ActionEvent e)
  {
    // first, translate it into a key event
    Object src = e.getSource();
    int key=0;

    if (src == toggle)
      key = KeyEvent.VK_ENTER;
    else if (src == rotate)
      key = KeyEvent.VK_SPACE;
    else if (src == cancel)
      key = KeyEvent.VK_ESCAPE;
    else if (src == quit)
      game.Quit();
    else if (src == setkeys)
      game.SetKeys();
    else if (src == fire) {
      key = KeyEvent.VK_TAB;
      if (board.netplay) {
	game.net.SendKeyPress(key);
	game.net.SendKeyRelease(key);
      }
      board.ProcessKeyPress(key, true);
      board.ProcessKeyRelease(key, true);
      return;
    }

    // then, process it as if it were a key event (except for quitting
    // and firing a laser, which we have already taken care of)
    if (board.netplay)
      game.net.SendKeyPress(key);
    board.ProcessKeyPress(key, true);
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  public void itemStateChanged(ItemEvent e)
  {
    Object src = e.getSource();
    int key=0;

    if (src == pause)
      key = KeyEvent.VK_P;
    else
      return;

    if (board.netplay)
      game.net.SendKeyPress(key);
    board.ProcessKeyPress(key, true);
  }


  // --------------------------------------------------------------------------
  // Enables the appropriate menu items pertaining to actions, according
  // to parameters passed in.
  // --------------------------------------------------------------------------
  void EnableActionItems(boolean toggle, boolean rotate, boolean fire,
			 boolean cancel, boolean pause)
  {
    this.toggle.setEnabled(toggle);
    this.rotate.setEnabled(rotate);
    this.fire.setEnabled(fire);
    this.cancel.setEnabled(cancel);
    this.pause.setEnabled(pause);
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  void DisableActionItems()
  {
    this.rotate.setEnabled(false);
    this.fire.setEnabled(false);
    this.cancel.setEnabled(false);
  }
  
  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  void ChangeToggleMessage(boolean putDown)
  {
    if (putDown)
      toggle.setLabel(Menus.kPutDown);
    else
      toggle.setLabel(Menus.kPickUp);
  }
  
  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  boolean IsSoundEnabled()
  {
    return sound.getState();
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  void TogglePause(boolean local, boolean paused)
  {
    pause.setState(paused);
    pause.setEnabled(local);
  }
}
