// ****************************************************************************
// * GameConfigInfo.java                                                      *
// *                                                                          *
// * (c) 1997-2002 by Eric Tucker.                                            *
// *                                                                          *
// * This program is free software; you can redistribute it and/or modify it  *
// * under the terms of version 2 of the GNU General Public License (GPL) as  *
// * published by the Free Software Foundation.  This program is distributed  *
// * in the hope that it will be useful but WITHOUT ANY WARRANTY; without     *
// * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR *
// * PURPOSE.  See the GPL for more details.  You should have received a copy *
// * of the GPL along this program.  If not, write to the Free Software       *
// * Foundation, Inc. at 59 Temple Place, Suite 330, Boston, MA  02111  USA   *
// *                                                                          *
// * Please contact Eric Tucker at erictucker2000@yahoo.com with any          *
// * questions, comments, suggestions, or bug reports.                        *
// ****************************************************************************

// ----------------------------------------------------------------------------
// This class is basically just a structure that holds information about how
// the game is configured.
// ----------------------------------------------------------------------------
class GameConfigInfo
{
  boolean netplay, host;
  String hostname;
  int localTeam;

  // used while parsing command line options to flag inconsistencies
  boolean inconsistent;

  // timer length always stored in seconds, even though
  // the user may enter it in minutes
  int timerType, redTimerLength, greenTimerLength;

  static final int kNoTimeLimit=0, kTimeLimitPerTurn=1, kTimeLimitPerGame=2;

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  GameConfigInfo()
  {
    netplay = false;
    host = false;
    inconsistent = false;
    hostname = "";
    localTeam = LaserChess.kNoTeam;
    timerType = kNoTimeLimit;
    redTimerLength = 0;
    greenTimerLength = 0;
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  GameConfigInfo(boolean netplay, boolean host, String hostname, int localTeam,
		 int timerType, int redTimerLength, int greenTimerLength)
  {
    this.netplay = netplay;
    this.host = host;
    this.inconsistent = false;
    this.hostname = hostname;
    this.localTeam = localTeam;
    this.timerType = timerType;
    this.redTimerLength = redTimerLength;
    this.greenTimerLength = greenTimerLength;
  }
}
