// ****************************************************************************
// * Direction.java                                                           *
// *                                                                          *
// * (c) 1997-2002 by Eric Tucker.                                            *
// *                                                                          *
// * This program is free software; you can redistribute it and/or modify it  *
// * under the terms of version 2 of the GNU General Public License (GPL) as  *
// * published by the Free Software Foundation.  This program is distributed  *
// * in the hope that it will be useful but WITHOUT ANY WARRANTY; without     *
// * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR *
// * PURPOSE.  See the GPL for more details.  You should have received a copy *
// * of the GPL along this program.  If not, write to the Free Software       *
// * Foundation, Inc. at 59 Temple Place, Suite 330, Boston, MA  02111  USA   *
// *                                                                          *
// * Please contact Eric Tucker at erictucker2000@yahoo.com with any          *
// * questions, comments, suggestions, or bug reports.                        *
// ****************************************************************************

// ----------------------------------------------------------------------------
// In Laser Chess, it is sometimes useful to think of a direction as an integer
// ranging between 0 and one less than the total number of directions possible.
// At other times, we need to have it expressed as a {dx, dy} vector.
// This class takes care of converting between those two formats.
// ----------------------------------------------------------------------------
class Direction
{
  int dx, dy, dir;

  Direction(int dx, int dy)
  { Set(dx, dy); }

  Direction(int dir)
  { Set(dir); }

  Direction(Direction copy)
  { Set(copy.dir); }

  Direction()
  { dx = dy = 0; dir = -1; }

  void Set(int dx, int dy)
  { this.dx = dx; this.dy = dy; VectorToDir(); }

  void Set(int dir)
  { this.dir = dir; DirToVector(); }

  void Reverse()
  { Set(-dx, -dy); }

  // --------------------------------------------------------------------------
  // converts integer direction to {dx,dy} vector
  // --------------------------------------------------------------------------
  void DirToVector()
  {
    switch (dir) {
    case 0: dx = 0; dy = -1; break;
    case 1: dx = 1; dy = 0;  break;
    case 2: dx = 0; dy = 1;  break;
    case 3: dx = -1; dy = 0; break;
    default: dx = 0; dy = 0; break;
    }
  }

  // --------------------------------------------------------------------------
  // converts {dx, dy} vector to integer direction.
  // Assumes the vector has a zero in exactly one direction.
  // --------------------------------------------------------------------------
  void VectorToDir()
  {
    if (dy == -1)
      dir = 0;
    else if (dx == 1)
      dir = 1;
    else if (dy == 1)
      dir = 2;
    else
      dir = 3;
  }
}
