// ****************************************************************************
// * Cursor.java                                                              *
// *                                                                          *
// * (c) 1997-2002 by Eric Tucker.                                            *
// *                                                                          *
// * This program is free software; you can redistribute it and/or modify it  *
// * under the terms of version 2 of the GNU General Public License (GPL) as  *
// * published by the Free Software Foundation.  This program is distributed  *
// * in the hope that it will be useful but WITHOUT ANY WARRANTY; without     *
// * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR *
// * PURPOSE.  See the GPL for more details.  You should have received a copy *
// * of the GPL along this program.  If not, write to the Free Software       *
// * Foundation, Inc. at 59 Temple Place, Suite 330, Boston, MA  02111  USA   *
// *                                                                          *
// * Please contact Eric Tucker at erictucker2000@yahoo.com with any          *
// * questions, comments, suggestions, or bug reports.                        *
// ****************************************************************************

import java.awt.*;

class Cursor
{
  Point sq;
  Board board;
  boolean holdingPiece;
  int turn;
  Graphics g;
  
  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  Cursor(Board board, int col, int row)
  {
    this.board = board;
    sq = new Point(col, row);
    holdingPiece = false;
    turn = LaserChess.kNoTeam;
    g = null;
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  void Move(int dx, int dy)
  {
    MoveTo(Math.max (0, Math.min(Board.kNumCols-1, sq.x+dx)),
	   Math.max (0, Math.min(Board.kNumRows-1, sq.y+dy)));
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  void MoveTo(int newx, int newy)
  {
    Erase();
    board.DrawGrid();
    sq.x = newx;
    sq.y = newy;
    Draw();
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  void Draw()
  {
    if (g == null)
      if ((g=board.getGraphics()) == null)
	return;

    if (turn == LaserChess.kNoTeam)
      return;

    if (holdingPiece)
      g.setColor(ColorManager.kHotCursor);
    else
      g.setColor(ColorManager.PlayerColor(turn).h);
    DrawHelper();
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  void Erase()
  {
    if (g == null)
      if ((g=board.getGraphics()) == null)
	return;

    g.setColor(ColorManager.kBoardBackground);
    DrawHelper();
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  void SetTurn(int turn, boolean redraw)
  {
    this.turn = turn;
    if (redraw)
      Draw();
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  void SetPieceHeld(boolean holdingPiece)
  {
    this.holdingPiece = holdingPiece;
    Draw();
  }

  // ##########################################################################
  // ##########################################################################

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  private void DrawHelper()
  {
    int x0 = board.GetX(sq.x);
    int w = board.GetX(sq.x+1)-x0;
    int y0 = board.GetY(sq.y);
    int h = board.GetY(sq.y+1)-y0;
    
    g.drawRect(x0, y0, w, h);
    g.drawRect(x0+1, y0+1, w-2, h-2);
    g.drawRect(x0+2, y0+2, w-4, h-4);
    g.drawRect(x0-1, y0-1, w+2, h+2);
  }
 
}
