// ****************************************************************************
// * ColorManager.java                                                        *
// *                                                                          *
// * (c) 1997-2002 by Eric Tucker.                                            *
// *                                                                          *
// * This program is free software; you can redistribute it and/or modify it  *
// * under the terms of version 2 of the GNU General Public License (GPL) as  *
// * published by the Free Software Foundation.  This program is distributed  *
// * in the hope that it will be useful but WITHOUT ANY WARRANTY; without     *
// * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR *
// * PURPOSE.  See the GPL for more details.  You should have received a copy *
// * of the GPL along this program.  If not, write to the Free Software       *
// * Foundation, Inc. at 59 Temple Place, Suite 330, Boston, MA  02111  USA   *
// *                                                                          *
// * Please contact Eric Tucker at erictucker2000@yahoo.com with any          *
// * questions, comments, suggestions, or bug reports.                        *
// ****************************************************************************

import java.awt.*;

// ----------------------------------------------------------------------------
// Knows about all color-related things in Laser Chess.
// ----------------------------------------------------------------------------
class ColorManager
{
  static final Color kBoardGrid = Color.white;
  static final Color kBoardBackground = Color.black;
  static final Color kHotCursor = new Color(1.0f, 1.0f, 1.0f);
  static final Color kLaserColor = new Color(1.0f, 1.0f, 0.0f);
  static final int kRedIndex = 0;
  static final int kGreenIndex = 1;

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  static PieceColor DoomedPiece()
  {
    return new PieceColor(new Color(0.5f, 0.5f, 0.0f),
			  new Color(1.0f, 1.0f, 0.0f));
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  static PieceColor HeldPiece()
  {
    return new PieceColor(new Color(0.5f, 0.5f, 0.5f),
			  new Color(1.0f, 1.0f, 1.0f));
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  static PieceColor PlayerColor(int team)
  {
    switch(team) {
    case 0:
      return new PieceColor(new Color(0.5f, 0.0f, 0.0f),
			    new Color(1.0f, 0.0f, 0.0f));
    case 1:
      return new PieceColor(new Color(0.0f, 0.5f, 0.0f),
			    new Color(0.0f, 1.0f, 0.0f));
    case 2:
      return new PieceColor(Color.white, Color.lightGray);
    default:
      return new PieceColor(Color.white, Color.white);
    }
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  static String TeamColorCodeToString(int team)
  {
    if (team == 0)
      return "Red";
    else if (team == 1)
      return "Green";
    else
      return "NONE";
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  static int TeamColorStringToCode(String team)
  {
    if (team.equalsIgnoreCase("red"))
      return 0;
    else if (team.equalsIgnoreCase("green"))
      return 1;
    else
      return LaserChess.kNoTeam;
  }

}
