// ****************************************************************************
// * ButtonPanel.java                                                         *
// *                                                                          *
// * (c) 1997-2002 by Eric Tucker.                                            *
// *                                                                          *
// * This program is free software; you can redistribute it and/or modify it  *
// * under the terms of version 2 of the GNU General Public License (GPL) as  *
// * published by the Free Software Foundation.  This program is distributed  *
// * in the hope that it will be useful but WITHOUT ANY WARRANTY; without     *
// * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR *
// * PURPOSE.  See the GPL for more details.  You should have received a copy *
// * of the GPL along this program.  If not, write to the Free Software       *
// * Foundation, Inc. at 59 Temple Place, Suite 330, Boston, MA  02111  USA   *
// *                                                                          *
// * Please contact Eric Tucker at erictucker2000@yahoo.com with any          *
// * questions, comments, suggestions, or bug reports.                        *
// ****************************************************************************

import java.awt.*;
import java.awt.event.*;

class ButtonPanel extends Panel implements ActionListener, KeyListener
{
  LaserChess game;
  Board board;
  Button pause, newGame, quit;
  Button rotate, fire, cancel, toggle;

  // Pad string to work around AWT bug which causes buttons to not
  // resize themselves properly when their text is changed.
  static final String kPause = " Pause ", kResume = "Resume";
  
  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  ButtonPanel(LaserChess game, Board board)
  {
    this.game = game;
    this.board = board;

    setLayout(new BorderLayout());

    Panel p1 = new Panel();
    p1.add(toggle = new Button(Menus.kPickUp));
    p1.add(rotate = new Button("Rotate"));
    p1.add(fire = new Button("Fire"));
    p1.add(cancel = new Button("Cancel"));
    add("West", p1);

    Panel p2 = new Panel();
    p2.add(pause = new Button(kPause));
    p2.add(newGame = new Button("New Game"));
    p2.add(quit = new Button("Quit"));
    add("East", p2);

    toggle.addActionListener(this);
    rotate.addActionListener(this);
    fire.addMouseListener(new FireButtonEventHandler());
    cancel.addActionListener(this);
    quit.addActionListener(this);
    newGame.addActionListener(this);
    pause.addActionListener(this);

    // Need these key listeners in case we ever get input focus -- so we 
    // can throw it back to the board.
    toggle.addKeyListener(this);
    rotate.addKeyListener(this);
    fire.addKeyListener(this);
    cancel.addKeyListener(this);
    quit.addKeyListener(this);
    pause.addKeyListener(this);

    // @@ to let people restart games, this needs to be reenabled
    newGame.setEnabled(false);

    // Workaround for JDK bug #8 (see BUGS.txt)
    pause.setBackground(Color.lightGray);
    newGame.setBackground(Color.lightGray);
    quit.setBackground(Color.lightGray);
    rotate.setBackground(Color.lightGray);
    fire.setBackground(Color.lightGray);
    cancel.setBackground(Color.lightGray);
    toggle.setBackground(Color.lightGray);
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  void EnableActionButtons(boolean toggle, boolean rotate, boolean fire,
			   boolean cancel, boolean pause)
  {
    this.toggle.setEnabled(toggle);
    this.rotate.setEnabled(rotate);
    this.fire.setEnabled(fire);
    this.cancel.setEnabled(cancel);
    this.pause.setEnabled(pause);
  }
    
  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  void DisableActionButtons()
  {
    this.rotate.setEnabled(false);
    this.fire.setEnabled(false);
    this.cancel.setEnabled(false);
  }

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  void ChangeToggleMessage(boolean putDown)
  {
    if (putDown)
      toggle.setLabel(Menus.kPutDown);
    else
      toggle.setLabel(Menus.kPickUp);
  }
  
  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  void ChangePauseMessage(boolean isPaused)
  {
    if (isPaused)
      pause.setLabel(kResume);
    else
      pause.setLabel(kPause);
  }
  
  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  public void keyTyped(KeyEvent e) { ; }
  public void keyReleased(KeyEvent e) { ; }
  public void keyPressed(KeyEvent e)
  {
    board.dispatchEvent(e);
    board.requestFocus();
  }

  // --------------------------------------------------------------------------
  // We handle the fire button separately, because unlike all the others,
  // we also care about when the fire button is released.
  // --------------------------------------------------------------------------
  public void actionPerformed(ActionEvent e)
  {
    // first, translate it into a key event
    Object src = e.getSource();
    int key=0;
    if (src == toggle)
      key = KeyEvent.VK_ENTER;
    else if (src == rotate)
      key = KeyEvent.VK_SPACE;
    else if (src == cancel)
      key = KeyEvent.VK_ESCAPE;
    else if (src == pause)
      key = KeyEvent.VK_P;
    else if (src == quit) {
      game.Quit();
    }
    else if (src == newGame)
	; // don't handle these yet

    // then, process it like a normal key event
    if (board.netplay)
      game.net.SendKeyPress(key);
    board.ProcessKeyPress(key, true);
  }

  // ##########################################################################
  // ##########################################################################
 
  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  public class FireButtonEventHandler extends MouseAdapter
  {
    public void mousePressed(MouseEvent e)
    {
      if ((board.netplay && board.turn != board.localTeam) ||
	  !(e.getComponent().isEnabled()))
	return;
      if (board.netplay)
	game.net.SendKeyPress(Board.kKeyLaserFire);
      board.ProcessKeyPress(Board.kKeyLaserFire, true);
    }

    public void mouseReleased(MouseEvent e)  
    {
      if ((board.netplay && board.turn != board.localTeam) ||
	  !(e.getComponent().isEnabled()))
	return;
      if (board.netplay)
	game.net.SendKeyRelease(Board.kKeyLaserFire);
      board.ProcessKeyRelease(Board.kKeyLaserFire, true);
    }
  }
  
}
