// ****************************************************************************
// * BoardConfiguration.java                                                  *
// *                                                                          *
// * (c) 1997-2002 by Eric Tucker.                                            *
// *                                                                          *
// * This program is free software; you can redistribute it and/or modify it  *
// * under the terms of version 2 of the GNU General Public License (GPL) as  *
// * published by the Free Software Foundation.  This program is distributed  *
// * in the hope that it will be useful but WITHOUT ANY WARRANTY; without     *
// * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR *
// * PURPOSE.  See the GPL for more details.  You should have received a copy *
// * of the GPL along this program.  If not, write to the Free Software       *
// * Foundation, Inc. at 59 Temple Place, Suite 330, Boston, MA  02111  USA   *
// *                                                                          *
// * Please contact Eric Tucker at erictucker2000@yahoo.com with any          *
// * questions, comments, suggestions, or bug reports.                        *
// ****************************************************************************

// ----------------------------------------------------------------------------
// This class knows how to set up the Laser Chess game board: where to place
// the pieces and how they should be oriented.  Right now, it just knows about
// the "standard" setup, but it might be fun to offer some alternatives later
// on down the road.
// ----------------------------------------------------------------------------
class BoardConfiguration
{
  static final int kStandard=0;

  // --------------------------------------------------------------------------
  // --------------------------------------------------------------------------
  static void PopulateBoard(Board board, int configType)
  {
    switch (configType) {
    case kStandard:
      StandardBoard(board);
      break;
    }
  }

  // --------------------------------------------------------------------------
  // This is the board setup from the original version of Laser Chess.
  // --------------------------------------------------------------------------
  static void StandardBoard(Board board)
  {
    board.AddPiece(new Piece(Piece.kTriangle,       0, 2, 0, 0, board));
    board.AddPiece(new Piece(Piece.kTriangle,       0, 2, 1, 0, board));
    board.AddPiece(new Piece(Piece.kDiagMirror,     0, 0, 2, 0, board));
    board.AddPiece(new Piece(Piece.kLaser,          0, 2, 3, 0, board));
    board.AddPiece(new Piece(Piece.kKing,           0, 0, 4, 0, board));
    board.AddPiece(new Piece(Piece.kHypercube,      0, 0, 5, 0, board));
    board.AddPiece(new Piece(Piece.kDiagMirror,     0, 1, 6, 0, board));
    board.AddPiece(new Piece(Piece.kTriangle,       0, 3, 7, 0, board));
    board.AddPiece(new Piece(Piece.kTriangle,       0, 3, 8, 0, board));

    board.AddPiece(new Piece(Piece.kTriangle,       0, 3, 0, 1, board));
    board.AddPiece(new Piece(Piece.kSquare,         0, 2, 1, 1, board));
    board.AddPiece(new Piece(Piece.kSquare,         0, 2, 2, 1, board));
    board.AddPiece(new Piece(Piece.kBeamSplitter,   0, 0, 3, 1, board));
    board.AddPiece(new Piece(Piece.kStraightMirror, 0, 1, 4, 1, board));
    board.AddPiece(new Piece(Piece.kStraightMirror, 0, 0, 5, 1, board));
    board.AddPiece(new Piece(Piece.kSquare,         0, 2, 6, 1, board));
    board.AddPiece(new Piece(Piece.kSquare,         0, 2, 7, 1, board));
    board.AddPiece(new Piece(Piece.kTriangle,       0, 2, 8, 1, board));

    board.AddPiece(new Piece(Piece.kTriangle,       1, 1, 8, 7, board));
    board.AddPiece(new Piece(Piece.kSquare,         1, 0, 7, 7, board));
    board.AddPiece(new Piece(Piece.kSquare,         1, 0, 6, 7, board));
    board.AddPiece(new Piece(Piece.kBeamSplitter,   1, 2, 5, 7, board));
    board.AddPiece(new Piece(Piece.kStraightMirror, 1, 1, 4, 7, board));
    board.AddPiece(new Piece(Piece.kStraightMirror, 1, 0, 3, 7, board));
    board.AddPiece(new Piece(Piece.kSquare,         1, 0, 2, 7, board));
    board.AddPiece(new Piece(Piece.kSquare,         1, 0, 1, 7, board));
    board.AddPiece(new Piece(Piece.kTriangle,       1, 0, 0, 7, board));

    board.AddPiece(new Piece(Piece.kTriangle,       1, 0, 8, 8, board));
    board.AddPiece(new Piece(Piece.kTriangle,       1, 0, 7, 8, board));
    board.AddPiece(new Piece(Piece.kDiagMirror,     1, 0, 6, 8, board));
    board.AddPiece(new Piece(Piece.kLaser,          1, 0, 5, 8, board));
    board.AddPiece(new Piece(Piece.kKing,           1, 0, 4, 8, board));
    board.AddPiece(new Piece(Piece.kHypercube,      1, 0, 3, 8, board));
    board.AddPiece(new Piece(Piece.kDiagMirror,     1, 1, 2, 8, board));
    board.AddPiece(new Piece(Piece.kTriangle,       1, 1, 1, 8, board));
    board.AddPiece(new Piece(Piece.kTriangle,       1, 1, 0, 8, board));

    board.AddPiece(new Piece(Piece.kHypercube,      2, 0, 4, 4, board));
  }
}
