/*
 * Decompiled with CFR 0.152.
 */
package cgedit;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Hashtable;

public class SpriteManager
extends Hashtable {
    private static SpriteManager def = new SpriteManager(new Canvas());
    private MediaTracker MT;
    private int idcount;
    private byte[] buffer = new byte[50000];

    public SpriteManager(Component component) {
        this.MT = new MediaTracker(component);
    }

    public Image addImageFile(String string) throws IOException {
        Image image = Toolkit.getDefaultToolkit().getImage(string);
        this.MT.addImage(image, ++this.idcount);
        return image;
    }

    public Image addImage(String string) throws IOException {
        return this.addImageFile(string);
    }

    public Image addImageResource(Class clazz, String string) {
        InputStream inputStream = clazz.getResourceAsStream(string);
        System.err.println("InputStream [" + string + "]: " + inputStream);
        try {
            int n = inputStream.read(this.buffer);
            inputStream.close();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
            byteArrayOutputStream.write(this.buffer, 0, n);
            ((OutputStream)byteArrayOutputStream).close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            Image image = Toolkit.getDefaultToolkit().createImage(byArray);
            this.MT.addImage(image, ++this.idcount);
            return image;
        }
        catch (IOException iOException) {
            System.err.println("Image load error: " + iOException);
            return null;
        }
    }

    public Image addImageURL(URL uRL) throws IOException {
        Image image = Toolkit.getDefaultToolkit().createImage((ImageProducer)uRL.getContent());
        this.MT.addImage(image, ++this.idcount);
        return image;
    }

    public boolean loadAllImages() throws InterruptedException {
        this.MT.waitForAll();
        return true;
    }

    public static SpriteManager getDefaultSpriteManager() {
        return def;
    }
}

