/*
 * Decompiled with CFR 0.152.
 */
package cgedit;

import cgedit.GUIUtils;
import cgedit.MainFrame;
import cgedit.Mission;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;

public class ScenarioDialog
extends Dialog {
    public List[] scenarioLists = new List[4];
    private Panel scenarioListPanel = new Panel();
    private ButtonPanel BP;
    public MainFrame MF;
    private TextField count;
    private TextField scName;
    public Choice selector;

    public ScenarioDialog(MainFrame mainFrame) {
        super(mainFrame, "Scenarios", false);
        this.MF = mainFrame;
        this.setLayout(new GridBagLayout());
        this.buildScenarioListPanel(mainFrame.MP.m);
        this.BP = new ButtonPanel(this);
        GUIUtils.constrain(this, this.scenarioListPanel, 0, 0, 1, 1, 0.0, 1.0);
        GUIUtils.constrain(this, this.BP, 1, 0, 1, 1, 1.0, 0.0);
        this.pack();
        Dimension dimension = mainFrame.getSize();
        Dimension dimension2 = this.getSize();
        Point point = mainFrame.getLocation();
        ((Component)this).setLocation((dimension.width - dimension2.width) / 2 + point.x, (dimension.height - dimension2.height) / 2 + point.y);
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            default: {
                return super.handleEvent(event);
            }
            case 701: {
                int n = (Integer)event.arg;
                ((TextComponent)this.count).setText(Integer.toString(this.MF.MP.m.getScenario(this.selector.getSelectedIndex(), n)));
                this.MF.MP.repaint();
                return true;
            }
            case 702: 
        }
        this.MF.MP.repaint();
        return true;
    }

    private void buildScenarioListPanel(Mission mission) {
        this.scenarioListPanel.setLayout(new CardLayout());
        int n = 0;
        while (n < 4) {
            this.scenarioLists[n] = new List();
            int n2 = 0;
            while (n2 < mission.getScenarioCount(n)) {
                this.scenarioLists[n].add(this.genScenarioListString(mission, n, n2));
                ++n2;
            }
            this.scenarioListPanel.add(Integer.toString(n), this.scenarioLists[n]);
            ++n;
        }
    }

    private String genScenarioListString(Mission mission, int n, int n2) {
        return new String("#" + Integer.toString(n2) + ": " + Integer.toString(mission.getScenario(n, n2)) + "(" + Integer.toString(mission.getScenarioMemberCount(n, n2)) + ")");
    }

    public void refreshData() {
        int n = this.selector.getSelectedIndex();
        int n2 = this.scenarioLists[n].getSelectedIndex();
        if (n2 < 0) {
            return;
        }
        this.scenarioLists[n].replaceItem(this.genScenarioListString(this.MF.MP.m, n, n2), n2);
        this.scenarioLists[n].select(n2);
    }

    class ButtonPanel
    extends Panel {
        private ScenarioDialog parent;

        public ButtonPanel(ScenarioDialog scenarioDialog2) {
            ScenarioDialog.this = ScenarioDialog.this;
            this.parent = scenarioDialog2;
            this.setLayout(new GridBagLayout());
            ScenarioDialog.this.selector = new Choice();
            ScenarioDialog.this.selector.addItem("Death Success");
            ScenarioDialog.this.selector.addItem("Death Failure");
            ScenarioDialog.this.selector.addItem("Rescue Success");
            ScenarioDialog.this.selector.addItem("Rescue Failure");
            ScenarioDialog.this.selector.select(0);
            GUIUtils.constrain(this, ScenarioDialog.this.selector, 0, 0, 1, 1, 0.0, 0.0);
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout());
            panel.add(new Label("Name:"));
            ScenarioDialog.this.scName = new TextField("", 20);
            panel.add(ScenarioDialog.this.scName);
            GUIUtils.constrain(this, panel, 0, 1, 1, 1, 1.0, 0.0);
            Panel panel2 = new Panel();
            panel2.setLayout(new FlowLayout());
            panel2.add(new Label("Count:"));
            ScenarioDialog.this.count = new TextField("1", 3);
            panel2.add(ScenarioDialog.this.count);
            GUIUtils.constrain(this, panel2, 0, 2, 1, 1, 1.0, 0.0);
            GUIUtils.constrain(this, new Button("Update"), 0, 3, 1, 1, 0.0, 0.0);
            GUIUtils.constrain(this, new Button("Add"), 0, 4, 1, 1, 0.0, 0.0);
            GUIUtils.constrain(this, new Button("Delete"), 0, 5, 1, 1, 0.0, 0.0);
            GUIUtils.constrain(this, new Button("Done!"), 0, 6, 1, 1, 0.0, 0.0);
        }

        public boolean handleEvent(Event event) {
            switch (event.id) {
                default: {
                    return super.handleEvent(event);
                }
                case 1001: 
            }
            String string = (String)event.arg;
            if (string == null) {
                return true;
            }
            if (event.target == ScenarioDialog.this.selector) {
                LayoutManager layoutManager = ScenarioDialog.this.scenarioListPanel.getLayout();
                if (layoutManager instanceof CardLayout) {
                    CardLayout cardLayout = (CardLayout)layoutManager;
                    cardLayout.show(ScenarioDialog.this.scenarioListPanel, Integer.toString(ScenarioDialog.this.selector.getSelectedIndex()));
                }
                ScenarioDialog.this.MF.MP.repaint();
                return true;
            }
            if (string.equals("Add")) {
                int n = 0;
                try {
                    n = Integer.parseInt(ScenarioDialog.this.count.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    return true;
                }
                int n2 = ScenarioDialog.this.selector.getSelectedIndex();
                int n3 = ScenarioDialog.this.MF.MP.m.createScenario(n2, n);
                ScenarioDialog.this.scenarioLists[n2].add(ScenarioDialog.this.genScenarioListString(ScenarioDialog.this.MF.MP.m, n2, n3));
                return true;
            }
            if (string.equals("Delete")) {
                int n = ScenarioDialog.this.selector.getSelectedIndex();
                int n4 = ScenarioDialog.this.scenarioLists[n].getSelectedIndex();
                if (n4 < 0) {
                    return true;
                }
                ScenarioDialog.this.MF.MP.m.deleteScenario(n, n4);
                ScenarioDialog.this.scenarioLists[n].remove(n4);
                return true;
            }
            if (string.equals("Update")) {
                int n = ScenarioDialog.this.selector.getSelectedIndex();
                int n5 = ScenarioDialog.this.scenarioLists[n].getSelectedIndex();
                if (n5 < 0) {
                    return true;
                }
                int n6 = 0;
                try {
                    n6 = Integer.parseInt(ScenarioDialog.this.count.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    return true;
                }
                ScenarioDialog.this.MF.MP.m.setScenario(n, n5, n6);
                ScenarioDialog.this.scenarioLists[n].replaceItem(ScenarioDialog.this.genScenarioListString(ScenarioDialog.this.MF.MP.m, n, n5), n5);
                return true;
            }
            if (string.equals("Done!")) {
                ScenarioDialog.this.MF.editingScenarios = null;
                ScenarioDialog.this.MF.MP.repaint();
                ((Component)this.parent).hide();
                this.parent.dispose();
                ScenarioDialog.this.MF.CP.refreshScenarioSelector();
                return true;
            }
            return false;
        }
    }
}

