/*
 * Decompiled with CFR 0.152.
 */
package cgedit;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class MultiLineLabel
extends Canvas {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected String[] lines;
    protected int numLines;
    protected int marginWidth;
    protected int marginHeight;
    protected int lineHeight;
    protected int lineAscent;
    protected int[] lineWidths;
    protected int maxWidth;
    protected int alignment = 0;

    protected void newLabel(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        this.numLines = stringTokenizer.countTokens();
        this.lines = new String[this.numLines];
        this.lineWidths = new int[this.numLines];
        int n = 0;
        while (n < this.numLines) {
            this.lines[n] = stringTokenizer.nextToken();
            ++n;
        }
    }

    protected void measure() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics == null) {
            return;
        }
        this.lineHeight = fontMetrics.getHeight();
        this.lineAscent = fontMetrics.getAscent();
        this.maxWidth = 0;
        int n = 0;
        while (n < this.numLines) {
            this.lineWidths[n] = fontMetrics.stringWidth(this.lines[n]);
            if (this.lineWidths[n] > this.maxWidth) {
                this.maxWidth = this.lineWidths[n];
            }
            ++n;
        }
    }

    public MultiLineLabel(String string, int n, int n2, int n3) {
        this.newLabel(string);
        this.marginWidth = n;
        this.marginHeight = n2;
        this.alignment = n3;
    }

    public MultiLineLabel(String string, int n, int n2) {
        this(string, n, n2, 0);
    }

    public MultiLineLabel(String string, int n) {
        this(string, 10, 10, n);
    }

    public MultiLineLabel(String string) {
        this(string, 10, 10, 0);
    }

    public void setLabel(String string) {
        this.newLabel(string);
        this.measure();
        this.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.measure();
        this.repaint();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void setAlignment(int n) {
        this.alignment = n;
        this.repaint();
    }

    public void setMarginWidth(int n) {
        this.marginWidth = n;
        this.repaint();
    }

    public void setMarginHeight(int n) {
        this.marginHeight = n;
        this.repaint();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getMarginWidth() {
        return this.marginWidth;
    }

    public int getMarginHeight() {
        return this.marginHeight;
    }

    public void addNotify() {
        super.addNotify();
        this.measure();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.maxWidth + 2 * this.marginWidth, this.numLines * this.lineHeight + 2 * this.marginHeight);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.maxWidth, this.numLines * this.lineHeight);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = this.lineAscent + (dimension.height - this.numLines * this.lineHeight) / 2;
        int n2 = 0;
        while (n2 < this.numLines) {
            int n3;
            switch (this.alignment) {
                case 0: {
                    n3 = this.marginWidth;
                    break;
                }
                default: {
                    n3 = (dimension.width - this.lineWidths[n2]) / 2;
                    break;
                }
                case 2: {
                    n3 = dimension.width - this.marginWidth - this.lineWidths[n2];
                }
            }
            graphics.drawString(this.lines[n2], n3, n);
            ++n2;
            n += this.lineHeight;
        }
    }
}

