/*
 * Decompiled with CFR 0.152.
 */
package cgedit;

import cgedit.GUIUtils;
import cgedit.InfoDialog;
import cgedit.MainFrame;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.TextArea;

public class MissionTextDialog
extends Dialog {
    private MainFrame MF;
    private TextArea TA;

    public MissionTextDialog(MainFrame mainFrame) {
        super(mainFrame, "Mission Text", true);
        this.MF = mainFrame;
        this.TA = new TextArea(15, 70);
        this.TA.setText(mainFrame.MP.m.missionText);
        this.setLayout(new GridBagLayout());
        GUIUtils.constrain(this, this.TA, 0, 0, 3, 1, 1.0, 1.0);
        GUIUtils.constrain(this, new Button("Cancel"), 0, 1, 1, 1, 1.0, 0.0);
        GUIUtils.constrain(this, new Button("OK"), 2, 1, 1, 1, 1.0, 0.0);
        this.pack();
        Dimension dimension = mainFrame.getSize();
        Dimension dimension2 = this.getSize();
        Point point = mainFrame.getLocation();
        ((Component)this).setLocation((dimension.width - dimension2.width) / 2 + point.x, (dimension.height - dimension2.height) / 2 + point.y);
    }

    private void commit() {
        String string = this.TA.getText();
        if (MissionTextDialog.countLines(string) > 15) {
            InfoDialog infoDialog = new InfoDialog((Frame)this.MF, "Map Text Error", "Map text too long! 15 line max!");
            infoDialog.show();
            return;
        }
        System.err.println("Counted " + MissionTextDialog.countLines(string) + " of map text. Good.");
        this.MF.MP.m.missionText = string;
    }

    public static int countLines(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 >= 0 && n2 < string.length()) {
            ++n;
            n2 = string.indexOf("\n", n2 + 1);
        }
        return n;
    }

    public boolean handleEvent(Event event) {
        if (event.id == 1001 && event.arg instanceof String) {
            String string = (String)event.arg;
            if (string.equals("Cancel")) {
                ((Component)this).hide();
                this.dispose();
            } else if (string.equals("OK")) {
                this.commit();
                ((Component)this).hide();
                this.dispose();
            } else {
                return false;
            }
            return true;
        }
        return false;
    }
}

