/*
 * Decompiled with CFR 0.152.
 */
package cgedit;

import cgedit.Background;
import cgedit.MainFrame;
import cgedit.Mission;
import cgedit.widgets.Baddie;
import cgedit.widgets.Building;
import cgedit.widgets.Generator;
import cgedit.widgets.Helicopter;
import cgedit.widgets.ImpObject;
import cgedit.widgets.Mine;
import cgedit.widgets.Plane;
import cgedit.widgets.RedHelicopter;
import cgedit.widgets.RedPlane;
import cgedit.widgets.Scenery;
import cgedit.widgets.Turret;
import cgedit.widgets.Unit;
import cgedit.widgets.Widget;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.util.Vector;

public class MissionPane
extends Canvas {
    public Mission m;
    public static final int HEIGHT = 480;
    public static final int GROUNDLEVEL = 440;
    private boolean isMouseDown = false;
    private int refX;
    private int refY;
    private MainFrame parent;
    public Widget targeted;
    private Widget dragging;
    private boolean dragged = false;
    private Dimension lastsize;
    private Image offscreen;
    private Graphics buffer;

    public MissionPane(Mission mission, MainFrame mainFrame) {
        this.m = mission;
        this.parent = mainFrame;
        this.setSize(mission.width, 480);
        this.setBackground(Color.black);
        this.addAllWidgets(mission);
    }

    private void addAllWidgets(Mission mission) {
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.size();
        if (this.offscreen == null || dimension.width != this.lastsize.width || dimension.height != this.lastsize.height) {
            this.lastsize = dimension;
            this.offscreen = this.createImage(dimension.width, dimension.height);
            this.buffer = this.offscreen.getGraphics();
        }
        Image image = Background.getImage(this.m.backgroundType);
        int n = 0;
        while (n < this.m.width) {
            this.buffer.drawImage(image, n, 0, this);
            n += image.getWidth(this);
        }
        this.paintVector(this.m.ground, this.buffer);
        this.paintVector(this.m.scenery, this.buffer);
        this.paintVector(this.m.buildings, this.buffer);
        this.paintVector(this.m.generators, this.buffer);
        this.paintVector(this.m.friendlies, this.buffer);
        this.paintVector(this.m.baddies, this.buffer);
        if (this.targeted != null) {
            Dimension dimension2 = this.targeted.getSize();
            Point point = this.targeted.getLocation();
            this.buffer.setColor(Color.yellow);
            this.buffer.drawRect(point.x, point.y, dimension2.width, dimension2.height);
        }
        if (this.parent.editingScenarios != null) {
            int n2 = this.parent.editingScenarios.selector.getSelectedIndex();
            int n3 = this.parent.editingScenarios.scenarioLists[n2].getSelectedIndex();
            if (n2 >= 0 && n3 >= 0) {
                Vector vector = this.m.getScenarioMembers(n2, n3);
                this.buffer.setColor(Color.red);
                int n4 = 0;
                while (n4 < vector.size()) {
                    Widget widget = (Widget)vector.elementAt(n4);
                    Dimension dimension3 = widget.getSize();
                    Point point = widget.getLocation();
                    this.buffer.drawRect(point.x, point.y, dimension3.width, dimension3.height);
                    ++n4;
                }
            }
        }
        graphics.drawImage(this.offscreen, 0, 0, this);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void paintVector(Vector vector, Graphics graphics) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            Widget widget = (Widget)vector.elementAt(n2);
            widget.paint(graphics);
            ++n2;
        }
    }

    public Dimension preferredSize() {
        return new Dimension(this.m.width, 480);
    }

    public Dimension maximumSize() {
        return this.preferredSize();
    }

    public Widget getCollision(int n, int n2) {
        Widget widget = this.getCollisionVector(this.m.baddies, n, n2);
        if (widget != null) {
            return widget;
        }
        widget = this.getCollisionVector(this.m.friendlies, n, n2);
        if (widget != null) {
            return widget;
        }
        widget = this.getCollisionVector(this.m.generators, n, n2);
        if (widget != null) {
            return widget;
        }
        widget = this.getCollisionVector(this.m.buildings, n, n2);
        if (widget != null) {
            return widget;
        }
        widget = this.getCollisionVector(this.m.scenery, n, n2);
        if (widget != null) {
            return widget;
        }
        return null;
    }

    private Widget getCollisionVector(Vector vector, int n, int n2) {
        int n3 = vector.size() - 1;
        while (n3 >= 0) {
            Widget widget = (Widget)vector.elementAt(n3);
            Dimension dimension = widget.getSize();
            Point point = widget.getLocation();
            if (point.x <= n && n <= point.x + dimension.width && point.y <= n2 && n2 <= point.y + dimension.height) {
                return widget;
            }
            --n3;
        }
        return null;
    }

    public boolean add(Widget widget) {
        if (widget instanceof Scenery) {
            this.m.scenery.addElement(widget);
            return true;
        }
        if (widget instanceof Generator) {
            this.m.generators.addElement(widget);
            return true;
        }
        if (widget instanceof Building) {
            this.m.buildings.addElement(widget);
            return true;
        }
        if (widget instanceof ImpObject) {
            this.m.baddies.addElement(widget);
            return true;
        }
        return false;
    }

    public void toggleScenario(ImpObject impObject) {
        int n = this.parent.editingScenarios.selector.getSelectedIndex();
        if (n < 0) {
            return;
        }
        int n2 = this.parent.editingScenarios.scenarioLists[n].getSelectedIndex();
        if (n2 < 0) {
            return;
        }
        if (impObject.scenario[n] == n2) {
            impObject.scenario[n] = -1;
            return;
        }
        impObject.scenario[n] = n2;
    }

    public boolean remove(Widget widget) {
        if (widget == this.targeted) {
            this.targeted = null;
            this.parent.CP.PP.setTarget(null);
        }
        if (widget instanceof Scenery) {
            return this.m.scenery.removeElement(widget);
        }
        if (widget instanceof Generator) {
            return this.m.generators.removeElement(widget);
        }
        if (widget instanceof Building) {
            return this.m.buildings.removeElement(widget);
        }
        if (widget instanceof ImpObject) {
            return this.m.baddies.removeElement(widget);
        }
        return false;
    }

    public boolean mouseDown(Event event, int n, int n2) {
        this.isMouseDown = true;
        this.refX = n;
        this.refY = n2;
        this.dragging = this.getCollision(n, n2);
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.dragging == null) {
            return true;
        }
        Point point = this.dragging.getLocation();
        int n3 = n - this.refX;
        int n4 = n2 - this.refY;
        int n5 = point.x + n3;
        int n6 = point.y + n4;
        this.dragging.setLocation(n5, n6);
        this.refX = n;
        this.refY = n2;
        this.dragged = true;
        Dimension dimension = this.dragging.getSize();
        int n7 = Math.min(point.x, n5);
        int n8 = Math.max(point.x, n5) + dimension.width;
        int n9 = Math.min(point.y, n6);
        int n10 = Math.max(point.y, n6) + dimension.height;
        this.repaint(n7, n9, n8 - n7 + 1, n10 - n9 + 1);
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.isMouseDown) {
            Object object;
            this.isMouseDown = false;
            if (this.dragged) {
                this.dragged = false;
                this.dragging = null;
                return true;
            }
            if (this.parent.editingScenarios != null) {
                Widget widget = this.getCollision(n, n2);
                if (widget instanceof ImpObject) {
                    this.toggleScenario((ImpObject)widget);
                    this.repaint();
                    this.parent.editingScenarios.refreshData();
                }
                return true;
            }
            String string = this.parent.CP.selector.getSelectedItem();
            Widget widget = null;
            if (string.equals("Scenery")) {
                widget = new Scenery(this.parent.CP.scenerySel.getSelectedIndex() + 7);
            } else if (string.equals("Buildings")) {
                object = this.parent.CP.buildingsSel.getSelectedItem();
                int n3 = ImpObject.typeForImpName((String)object);
                widget = new Building(n3);
            } else if (string.equals("Air Units")) {
                object = this.parent.CP.airUnitsSel.getSelectedItem();
                int n4 = ImpObject.typeForImpName((String)object);
                switch (n4) {
                    default: {
                        widget = new Baddie(n4);
                        break;
                    }
                    case 48: {
                        widget = new Plane();
                        break;
                    }
                    case 49: {
                        widget = new RedPlane();
                        break;
                    }
                    case 44: {
                        widget = new Helicopter();
                        break;
                    }
                    case 45: {
                        widget = new RedHelicopter();
                        break;
                    }
                    case 50: {
                        widget = new Mine();
                        break;
                    }
                }
            } else if (string.equals("Ground Units")) {
                object = this.parent.CP.groundUnitsSel.getSelectedItem();
                int n5 = ImpObject.typeForImpName((String)object);
                widget = new Unit(n5);
            } else if (string.equals("Turrets")) {
                object = this.parent.CP.turretsSel.getSelectedItem();
                int n6 = ImpObject.typeForImpName((String)object);
                widget = new Turret(n6);
            } else {
                if (string.equals("Delete")) {
                    widget = this.getCollision(n, n2);
                    if (widget == null) {
                        return true;
                    }
                    this.remove(widget);
                    this.repaint();
                    return true;
                }
                if (string.equals("Properties")) {
                    this.targeted = this.getCollision(n, n2);
                    this.parent.CP.PP.setTarget(this.targeted);
                    this.repaint();
                    return true;
                }
                return true;
            }
            object = widget.getSize();
            widget.setLocation(n - ((Dimension)object).width / 2, n2 - ((Dimension)object).height / 2);
            this.add(widget);
            this.repaint();
        }
        return true;
    }
}

