/*
 * Decompiled with CFR 0.152.
 */
package cgedit;

import cgedit.IntelInputStream;
import cgedit.IntelOutputStream;
import cgedit.MissionTextDialog;
import cgedit.widgets.Baddie;
import cgedit.widgets.Building;
import cgedit.widgets.Generator;
import cgedit.widgets.Ground;
import cgedit.widgets.Helicopter;
import cgedit.widgets.ImpObject;
import cgedit.widgets.MapObject;
import cgedit.widgets.Plane;
import cgedit.widgets.RedPlane;
import cgedit.widgets.Scenery;
import cgedit.widgets.Turret;
import cgedit.widgets.Unit;
import java.awt.Point;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class Mission {
    public int width;
    public Vector[] scenarios = new Vector[4];
    public int backgroundType = 168;
    public int groundType = 3;
    public Vector scenery = new Vector();
    public Vector ground = new Vector();
    public Vector buildings = new Vector();
    public Vector friendlies = new Vector();
    public Vector generators = new Vector();
    public Vector baddies = new Vector();
    public String missionText = "(HAHA!)";

    public Mission(int n) {
        this.width = n;
        this.setGround(this.groundType);
        int n2 = 0;
        while (n2 < 4) {
            this.scenarios[n2] = new Vector();
            ++n2;
        }
    }

    public Vector getScenarioMembers(int n, int n2) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("Illegal scenario type!");
        }
        if (n2 >= this.scenarios[n].size()) {
            throw new IllegalArgumentException("Illegal scenario index!");
        }
        Vector<ImpObject> vector = new Vector<ImpObject>();
        int n3 = 0;
        while (n3 < this.buildings.size()) {
            ImpObject impObject = (ImpObject)this.buildings.elementAt(n3);
            if (impObject.getScenarioIndex(n) == n2) {
                vector.addElement(impObject);
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.generators.size()) {
            ImpObject impObject = (ImpObject)this.generators.elementAt(n4);
            if (impObject.getScenarioIndex(n) == n2) {
                vector.addElement(impObject);
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.friendlies.size()) {
            ImpObject impObject = (ImpObject)this.friendlies.elementAt(n5);
            if (impObject.getScenarioIndex(n) == n2) {
                vector.addElement(impObject);
            }
            ++n5;
        }
        int n6 = 0;
        while (n6 < this.baddies.size()) {
            ImpObject impObject = (ImpObject)this.baddies.elementAt(n6);
            if (impObject.getScenarioIndex(n) == n2) {
                vector.addElement(impObject);
            }
            ++n6;
        }
        return vector;
    }

    public int getScenarioMemberCount(int n, int n2) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("Illegal scenario type!");
        }
        if (n2 >= this.scenarios[n].size()) {
            throw new IllegalArgumentException("Illegal scenario index!");
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.buildings.size()) {
            ImpObject impObject = (ImpObject)this.buildings.elementAt(n4);
            if (impObject.getScenarioIndex(n) == n2) {
                ++n3;
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < this.generators.size()) {
            ImpObject impObject = (ImpObject)this.generators.elementAt(n5);
            if (impObject.getScenarioIndex(n) == n2) {
                ++n3;
            }
            ++n5;
        }
        int n6 = 0;
        while (n6 < this.friendlies.size()) {
            ImpObject impObject = (ImpObject)this.friendlies.elementAt(n6);
            if (impObject.getScenarioIndex(n) == n2) {
                ++n3;
            }
            ++n6;
        }
        int n7 = 0;
        while (n7 < this.baddies.size()) {
            ImpObject impObject = (ImpObject)this.baddies.elementAt(n7);
            if (impObject.getScenarioIndex(n) == n2) {
                ++n3;
            }
            ++n7;
        }
        return n3;
    }

    public int createScenario(int n) {
        return this.createScenario(n, 0);
    }

    public int createScenario(int n, int n2) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("Illegal scenario type!");
        }
        this.scenarios[n].addElement(new Integer(n2));
        return this.scenarios[n].size() - 1;
    }

    public int getScenarioCount(int n) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("Illegal scenario type!");
        }
        return this.scenarios[n].size();
    }

    public void setScenario(int n, int n2, int n3) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("Illegal scenario type!");
        }
        if (n2 >= this.scenarios[n].size()) {
            throw new IllegalArgumentException("Illegal scenario index!");
        }
        this.scenarios[n].setElementAt(new Integer(n3), n2);
    }

    public int getScenario(int n, int n2) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("Illegal scenario type!");
        }
        if (n2 >= this.scenarios[n].size()) {
            throw new IllegalArgumentException("Illegal scenario index!");
        }
        Integer n3 = (Integer)this.scenarios[n].elementAt(n2);
        return n3;
    }

    public void deleteScenario(int n, int n2) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("Illegal scenario type!");
        }
        if (n2 >= this.scenarios[n].size()) {
            throw new IllegalArgumentException("Illegal scenario index!");
        }
        this.removeScenario(n, n2);
        int n3 = n2 + 1;
        while (n3 < this.scenarios[n].size()) {
            Vector vector = this.getScenarioMembers(n, n3);
            int n4 = 0;
            while (n4 < vector.size()) {
                ImpObject impObject = (ImpObject)vector.elementAt(n4);
                impObject.setScenarioIndex(n, n3 - 1);
                ++n4;
            }
            ++n3;
        }
    }

    private void removeScenario(int n, int n2) {
        if (n < 0 || n >= 4) {
            throw new IllegalArgumentException("Illegal scenario type!");
        }
        if (n2 >= this.scenarios[n].size()) {
            throw new IllegalArgumentException("Illegal scenario index!");
        }
        Vector vector = this.getScenarioMembers(n, n2);
        int n3 = 0;
        while (n3 < vector.size()) {
            ImpObject impObject = (ImpObject)vector.elementAt(n3);
            impObject.clearScenario(n);
            ++n3;
        }
        this.scenarios[n].removeElementAt(n2);
    }

    public void setGround(int n) {
        if (n < 3 || n > 6) {
            throw new IllegalArgumentException("Illegal ground type!");
        }
        this.groundType = n;
        this.ground.removeAllElements();
        int n2 = 0;
        while (n2 < this.width) {
            Ground ground = new Ground(n);
            ground.setLocation(n2, 440);
            this.ground.addElement(ground);
            n2 += 640;
        }
    }

    public void setBackground(int n) {
        if (n < 168 || n > 172) {
            throw new IllegalArgumentException("Illegal background type!");
        }
        this.backgroundType = n;
    }

    public Building getLandingPad() {
        int n = 0;
        while (n < this.buildings.size()) {
            Building building = (Building)this.buildings.elementAt(n);
            if (building.getType() == 130) {
                return building;
            }
            ++n;
        }
        return null;
    }

    public void write(File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        IntelOutputStream intelOutputStream = new IntelOutputStream(bufferedOutputStream);
        intelOutputStream.writeIntelInt(1936744813);
        intelOutputStream.writeIntelInt(1);
        int n = MissionTextDialog.countLines(this.missionText);
        int[] nArray = new int[n + 1];
        int n2 = 0;
        int n3 = -1;
        while (n2 < n) {
            nArray[n2] = n3 + 1;
            ++n2;
            n3 = this.missionText.indexOf("\n", n3 + 1);
        }
        nArray[nArray.length - 1] = this.missionText.length();
        intelOutputStream.writeIntelInt(n);
        System.err.println("Linecount: " + n);
        intelOutputStream.writeIntelString(this.missionText.replace('\n', '\u0000'));
        int n4 = 0;
        while (n4 < nArray.length) {
            intelOutputStream.writeIntelInt(nArray[n4]);
            System.err.print("[" + nArray[n4] + "]");
            ++n4;
        }
        System.err.print("\n");
        intelOutputStream.writeIntelInt(1);
        intelOutputStream.writeIntelInt(this.backgroundType);
        intelOutputStream.writeIntelInt(0);
        intelOutputStream.writeIntelInt(0);
        intelOutputStream.writeIntelInt(0);
        intelOutputStream.writeIntelInt(640);
        intelOutputStream.writeIntelInt(this.width);
        intelOutputStream.writeIntelInt(this.scenery.size());
        int n5 = 0;
        while (n5 < this.scenery.size()) {
            MapObject mapObject = (MapObject)this.scenery.elementAt(n5);
            mapObject.write(intelOutputStream);
            ++n5;
        }
        intelOutputStream.writeIntelInt(this.ground.size());
        int n6 = 0;
        while (n6 < this.ground.size()) {
            MapObject mapObject = (MapObject)this.ground.elementAt(n6);
            mapObject.write(intelOutputStream);
            ++n6;
        }
        int n7 = 0;
        while (n7 < 3) {
            intelOutputStream.writeIntelInt(0);
            ++n7;
        }
        intelOutputStream.writeIntelInt(this.width);
        intelOutputStream.writeIntelInt(this.baddies.size() + this.buildings.size() + this.generators.size() + this.friendlies.size());
        int n8 = 0;
        while (n8 < this.buildings.size()) {
            ImpObject impObject = (ImpObject)this.buildings.elementAt(n8);
            impObject.write(intelOutputStream);
            ++n8;
        }
        int n9 = 0;
        while (n9 < this.generators.size()) {
            ImpObject impObject = (ImpObject)this.generators.elementAt(n9);
            impObject.write(intelOutputStream);
            ++n9;
        }
        int n10 = 0;
        while (n10 < this.friendlies.size()) {
            ImpObject impObject = (ImpObject)this.friendlies.elementAt(n10);
            impObject.write(intelOutputStream);
            ++n10;
        }
        int n11 = 0;
        while (n11 < this.baddies.size()) {
            ImpObject impObject = (ImpObject)this.baddies.elementAt(n11);
            impObject.write(intelOutputStream);
            ++n11;
        }
        intelOutputStream.writeIntelInt(0);
        intelOutputStream.writeIntelInt(0);
        intelOutputStream.writeIntelInt(0);
        intelOutputStream.writeIntelInt(0);
        intelOutputStream.writeIntelInt(-1);
        intelOutputStream.writeIntelInt(-1);
        int n12 = 0;
        while (n12 < 4) {
            int n13 = this.scenarios[n12].size();
            intelOutputStream.writeIntelInt(n13);
            int n14 = 0;
            while (n14 < n13) {
                Integer n15 = (Integer)this.scenarios[n12].elementAt(n14);
                intelOutputStream.writeIntelInt(n15);
                ++n14;
            }
            if (n12 == 3) {
                int n16 = 0;
                while (n16 < n13) {
                    intelOutputStream.writeIntelString("Shame shame.");
                    ++n16;
                }
            }
            if (n12 == 1) {
                int n17 = 0;
                while (n17 < n13) {
                    intelOutputStream.writeIntelString("Shame shame.");
                    ++n17;
                }
            }
            ++n12;
        }
        Building building = this.getLandingPad();
        Point point = building.getLocation();
        intelOutputStream.writeIntelInt(point.x);
        intelOutputStream.writeIntelInt(point.y);
        System.err.println("Landing pad at: [" + point.x + ", " + point.y + "]");
        intelOutputStream.flush();
        intelOutputStream.close();
    }

    public Mission(InputStream inputStream) throws IOException {
        int n;
        int n2;
        IntelInputStream intelInputStream = new IntelInputStream(inputStream);
        intelInputStream.readIntelInt();
        intelInputStream.readIntelInt();
        int n3 = intelInputStream.readIntelInt();
        this.missionText = intelInputStream.readIntelString();
        this.missionText = this.missionText.replace('\u0000', '\n');
        byte[] byArray = this.missionText.getBytes();
        byArray[byArray.length - 1] = 0;
        this.missionText = new String(byArray);
        int n4 = 0;
        while (n4 < n3 + 1) {
            intelInputStream.readIntelInt();
            ++n4;
        }
        int n5 = intelInputStream.readIntelInt();
        if (n5 != 1) {
            throw new IOException("More than one background!!");
        }
        this.setBackground(intelInputStream.readIntelInt());
        int n6 = 0;
        while (n6 < 5) {
            intelInputStream.readIntelInt();
            ++n6;
        }
        int n7 = intelInputStream.readIntelInt();
        int n8 = 0;
        while (n8 < n7) {
            this.scenery.addElement(new Scenery(intelInputStream));
            ++n8;
        }
        int n9 = intelInputStream.readIntelInt();
        int n10 = 0;
        while (n10 < n9) {
            this.ground.addElement(new Ground(intelInputStream));
            ++n10;
        }
        int n11 = 0;
        while (n11 < 3) {
            n2 = intelInputStream.readIntelInt();
            if (n2 != 0) {
                throw new IOException("Error: item found in layer " + (n11 + 1));
            }
            ++n11;
        }
        this.width = intelInputStream.readIntelInt();
        n2 = intelInputStream.readIntelInt();
        int n12 = 0;
        while (n12 < n2) {
            ImpObject impObject = Mission.getImpObject(intelInputStream);
            if (impObject instanceof Generator) {
                this.generators.addElement(impObject);
            } else if (impObject instanceof Building) {
                this.buildings.addElement(impObject);
            } else {
                this.baddies.addElement(impObject);
            }
            ++n12;
        }
        int n13 = 0;
        while (n13 < 6) {
            intelInputStream.readIntelInt();
            ++n13;
        }
        int n14 = 0;
        while (n14 < 4) {
            this.scenarios[n14] = new Vector();
            ++n14;
        }
        int n15 = 0;
        while (n15 < 4) {
            n = intelInputStream.readIntelInt();
            int n16 = 0;
            while (n16 < n) {
                this.createScenario(n15, intelInputStream.readIntelInt());
                ++n16;
            }
            if (n15 == 3 || n15 == 1) {
                int n17 = 0;
                while (n17 < n) {
                    intelInputStream.readIntelString();
                    ++n17;
                }
            }
            ++n15;
        }
        n = 0;
        while (n < 2) {
            intelInputStream.readIntelInt();
            ++n;
        }
        intelInputStream.close();
    }

    private static ImpObject getImpObject(IntelInputStream intelInputStream) throws IOException {
        ImpObject impObject;
        Vector<Integer> vector = new Vector<Integer>();
        int n = intelInputStream.readIntelInt();
        int n2 = intelInputStream.readIntelInt();
        int n3 = intelInputStream.readIntelInt();
        int n4 = intelInputStream.readIntelInt();
        int n5 = intelInputStream.readIntelInt();
        int n6 = intelInputStream.readIntelInt();
        int n7 = intelInputStream.readIntelInt();
        int n8 = intelInputStream.readIntelInt();
        int n9 = intelInputStream.readIntelInt();
        int n10 = 0;
        while (n10 < n9) {
            vector.addElement(new Integer(intelInputStream.readIntelInt()));
            ++n10;
        }
        intelInputStream.readIntelInt();
        switch (n2) {
            default: {
                return null;
            }
            case 2: 
            case 32: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: {
                impObject = new Unit(n, n2, n3, n4, n5, n6, n7, n8, vector);
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                impObject = new Turret(n, n2, n3, n4, n5, n6, n7, n8, vector);
                break;
            }
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                impObject = new Baddie(n, n2, n3, n4, n5, n6, n7, n8, vector);
                break;
            }
            case 44: {
                impObject = new Helicopter(n, n2, n3, n4, n5, n6, n7, n8, vector);
                break;
            }
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: {
                impObject = new Building(n, n2, n3, n4, n5, n6, n7, n8, vector);
                break;
            }
            case 137: {
                impObject = new Generator(n, n2, n3, n4, n5, n6, n7, n8, vector);
                break;
            }
            case 48: {
                impObject = new Plane(n, n2, n3, n4, n5, n6, n7, n8, vector);
                break;
            }
            case 49: {
                impObject = new RedPlane(n, n2, n3, n4, n5, n6, n7, n8, vector);
            }
        }
        return impObject;
    }
}

