/*
 * Decompiled with CFR 0.152.
 */
package cgedit;

import cgedit.BackgroundDialog;
import cgedit.ControlPane;
import cgedit.GUIUtils;
import cgedit.GetOneLineDialog;
import cgedit.GroundDialog;
import cgedit.InfoDialog;
import cgedit.Mission;
import cgedit.MissionPane;
import cgedit.MissionTextDialog;
import cgedit.ScenarioDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.ScrollPane;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import netscape.security.PrivilegeManager;

public class MainFrame
extends Frame {
    private static int windowCount;
    public MissionPane MP;
    public ControlPane CP;
    private MissionScrollPane MSP;
    public ScenarioDialog editingScenarios;

    public MainFrame(Mission mission) {
        super("Cobra Gunship Level Editor");
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        menu.add("New");
        menu.add("Load");
        menu.add("Save");
        menu.addSeparator();
        menu.add("Close");
        try {
            Class.forName("netscape.security.PrivilegeManager");
        }
        catch (ClassNotFoundException classNotFoundException) {
            menu.addSeparator();
            menu.add("Quit");
        }
        Menu menu2 = new Menu("Set");
        menu2.add("Background..");
        menu2.add("Ground..");
        menu2.add("Scenarios..");
        menu2.add("Mission Text..");
        Menu menu3 = new Menu("Help");
        menu3.add("About Cobra Gunship Level Editor..");
        menuBar.add(menu);
        menuBar.add(menu2);
        menuBar.setHelpMenu(menu3);
        this.setMenuBar(menuBar);
        this.MP = new MissionPane(mission, this);
        this.CP = new ControlPane(this.MP);
        this.MSP = new MissionScrollPane(this.MP);
        this.setLayout(new GridBagLayout());
        GUIUtils.constrain(this, this.MSP, 0, 0, 1, 1, 1.0, 1.0);
        GUIUtils.constrain(this, this.CP, 0, 1, 1, 1, 1.0, 0.0);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        ((Component)this).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        MainFrame.incrWindowCount();
    }

    public MainFrame(int n) {
        this(new Mission(n));
    }

    private static synchronized void incrWindowCount() {
        ++windowCount;
    }

    private static synchronized void decrWindowCount() {
        if (--windowCount <= 0) {
            try {
                Class.forName("netscape.security.PrivilegeManager");
                return;
            }
            catch (ClassNotFoundException classNotFoundException) {
                MainFrame.doQuit();
                return;
            }
        }
    }

    public boolean handleEvent(Event event) {
        if (event.id == 1001) {
            String string = (String)event.arg;
            if (string.equals("Quit")) {
                MainFrame.doQuit();
            }
            if (string.equals("Close")) {
                ((Component)this).hide();
                this.dispose();
                MainFrame.decrWindowCount();
                return true;
            }
            if (string.equals("New")) {
                GetOneLineDialog getOneLineDialog = new GetOneLineDialog((Frame)this, "New", "Enter a mission width:", "5000");
                getOneLineDialog.show();
                try {
                    int n = Integer.parseInt(getOneLineDialog.getText());
                    if (n < 1000 || n > 12000) {
                        InfoDialog infoDialog = new InfoDialog((Frame)this, "Invalid Width", "Width must be between 1000 and 12000. Try again.");
                        infoDialog.show();
                    } else {
                        this.doNew(n);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    InfoDialog infoDialog = new InfoDialog((Frame)this, "Number Error", "Invalid number! Try again.");
                    infoDialog.show();
                }
                return true;
            }
            if (string.equals("Load")) {
                GetOneLineDialog getOneLineDialog = new GetOneLineDialog((Frame)this, "Load..", "Enter the file path for the saved file:", "");
                GUIUtils.centerOn(getOneLineDialog, this);
                getOneLineDialog.show();
                File file = new File(getOneLineDialog.getText());
                try {
                    Class.forName("netscape.security.PrivilegeManager");
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (ClassNotFoundException classNotFoundException) {}
                if (!file.exists()) {
                    InfoDialog infoDialog = new InfoDialog((Frame)this, "Invalid File", "No such file! Try again.");
                    GUIUtils.centerOn(infoDialog, this);
                    infoDialog.show();
                    return true;
                }
                this.doLoad(file);
                return true;
            }
            if (string.equals("Save")) {
                if (this.MP.m.getLandingPad() == null) {
                    InfoDialog infoDialog = new InfoDialog((Frame)this, "Save Error", "Need a landing pad before you save!");
                    infoDialog.show();
                    return true;
                }
                GetOneLineDialog getOneLineDialog = new GetOneLineDialog((Frame)this, "Save as..", "Enter filename to save as:", "mylevel.dat");
                GUIUtils.centerOn(getOneLineDialog, this);
                getOneLineDialog.show();
                File file = new File(getOneLineDialog.getText());
                try {
                    Class.forName("netscape.security.PrivilegeManager");
                    PrivilegeManager.enablePrivilege((String)"UniversalFileAccess");
                }
                catch (ClassNotFoundException classNotFoundException) {}
                if (file.exists()) {
                    InfoDialog infoDialog = new InfoDialog((Frame)this, "File Exists", "File exists.. cannot save over it.");
                    GUIUtils.centerOn(infoDialog, this);
                    infoDialog.show();
                    return true;
                }
                this.doSave(file);
                return true;
            }
            if (string.equals("About Cobra Gunship Level Editor..")) {
                InfoDialog infoDialog = new InfoDialog((Frame)this, "About Cobra Gunship Level Editor", "This game editor is brought to you by\nElysium Digital, L.L.C, and Paul Mattal\nCopyright 1998\nVersion 0.8 (beta)");
                infoDialog.show();
                return true;
            }
            if (string.equals("Scenarios..")) {
                ScenarioDialog scenarioDialog;
                if (this.editingScenarios != null) {
                    return true;
                }
                this.editingScenarios = scenarioDialog = new ScenarioDialog(this);
                scenarioDialog.show();
                this.MP.repaint();
                return true;
            }
            if (string.equals("Background..")) {
                BackgroundDialog backgroundDialog = new BackgroundDialog(this);
                backgroundDialog.show();
                return true;
            }
            if (string.equals("Ground..")) {
                GroundDialog groundDialog = new GroundDialog(this);
                groundDialog.show();
                return true;
            }
            if (string.equals("Mission Text..")) {
                MissionTextDialog missionTextDialog = new MissionTextDialog(this);
                missionTextDialog.show();
                return true;
            }
        }
        return false;
    }

    public void doSave(File file) {
        try {
            this.MP.m.write(file);
            return;
        }
        catch (IOException iOException) {
            System.err.println("Could not write file!: " + iOException.getMessage());
            return;
        }
    }

    public void doLoad(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            Mission mission = new Mission(bufferedInputStream);
            ((FilterInputStream)bufferedInputStream).close();
            MainFrame mainFrame = new MainFrame(mission);
            mainFrame.show();
            return;
        }
        catch (IOException iOException) {
            InfoDialog infoDialog = new InfoDialog((Frame)this, "Load Error", "Error loading: " + iOException.getMessage());
            infoDialog.show();
            return;
        }
    }

    public void doNew(int n) {
        MainFrame mainFrame = new MainFrame(n);
        ((Component)mainFrame).setSize(mainFrame.preferredSize());
        mainFrame.show();
    }

    public static void doQuit() {
        System.exit(0);
    }

    class MissionScrollPane
    extends ScrollPane {
        MissionPane MP;

        public MissionScrollPane(MissionPane missionPane) {
            super(0);
            MainFrame.this = MainFrame.this;
            this.MP = missionPane;
            this.add(missionPane);
        }

        public Dimension preferredSize() {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.MP.preferredSize();
            int n = 3 * dimension.width / 4;
            int n2 = dimension2.height;
            return new Dimension(n + this.getVScrollbarWidth(), n2 + this.getHScrollbarHeight());
        }

        public Dimension minimumSize() {
            return this.MP.preferredSize();
        }

        public Dimension maximumSize() {
            return this.MP.maximumSize();
        }

        public boolean mouseDown(Event event, int n, int n2) {
            return this.MP.mouseDown(event, n, n2);
        }

        public boolean mouseUp(Event event, int n, int n2) {
            return this.MP.mouseUp(event, n, n2);
        }
    }
}

