;
; "CHAMPIONSHIP WAVE RACER"
; By Eric Park
; 2003 Park Productions
;

; Screenshot: Press F12

AppTitle "Championship Wave Racer"
If GfxModeExists(320,240,16)=1 Then Graphics 320,240,16,1 Else Text 10,10,"Graphics Mode Not Found. (320x240x16)" : Delay 1000 : WaitKey : End
SetBuffer BackBuffer()
FlushKeys : FlushJoy  : FlushMouse
TFormFilter 0 : HidePointer

; Load Graphics
Global RACERS=LoadAnimImage ("Graphics/RACERS.bmp",8,8,0,64) : MaskImage RACERS,96,0,184
Global RACERSJP=LoadAnimImage ("Graphics/RACERSJP.bmp",16,16,0,64) : MaskImage RACERSJP,96,0,184
Global PAUSEGFX=LoadAnimImage ("Graphics/PAUSE.bmp",46,8,0,2)
Global JETPICGFX=LoadAnimImage ("Graphics/WRSMALL.bmp",57,29,0,2)
Global CONTROLSGFX=LoadAnimImage ("Graphics/CONTROLS.bmp",66,8,0,8)
Global GOGFX=LoadAnimImage ("Graphics/321GO.bmp",16,8,0,4)
Global FONT=LoadAnimImage ("Graphics/FONT.bmp",8,8,0,37)
Global FONTWHITE=LoadAnimImage ("Graphics/FONTWHITE.bmp",8,8,0,37)
Global FONTSMALL=LoadAnimImage ("Graphics/FONTSMALL.bmp",3,5,0,37)
Global LAPGFX=LoadAnimImage ("Graphics/LAPS.bmp",19,4,0,20)
Global TIMEGFX=LoadAnimImage ("Graphics/TIME.bmp",10,15,0,12)
Global TIMEQUALIFY=LoadAnimImage ("Graphics/TIMEQUALIFY.bmp",39,5,0,2)
Global TRCKTILE=LoadAnimImage ("Graphics/TRCKTILE.bmp",20,20,0,110) : MaskImage TRCKTILE,0,0,248
Global SMALLTILE=LoadAnimImage ("Graphics/TRCKTILE.bmp",20,20,0,110)  : MaskImage SMALLTILE,0,0,248 : ScaleImage SMALLTILE,0.5,0.5
Global BUOYDETECT=LoadAnimImage ("Graphics/BUOYDETECT.bmp",52,52,0,6) : MaskImage BUOYDETECT,0,0,248
Global TITLEA=LoadImage ("Graphics/WRTITLEA.bmp")
Global TITLEB=LoadImage ("Graphics/WRTITLEB.bmp")
Global TITLEC=LoadImage ("Graphics/WRTITLEC.bmp")

; Load Audio
Global THEME=LoadSound ("Audio/theme.mp3") : LoopSound THEME
Global ENGINESFX=LoadSound ("Audio/engine.wav")
Global CRASHSFX=LoadSound ("Audio/crash.wav")
Global READYSFX=LoadSound ("Audio/getready.wav")
Global GOSFX=LoadSound ("Audio/go.wav")
Global BUOYSFX=LoadSound ("Audio/buoy.wav")
Global TIMESFX=LoadSound ("Audio/time.wav")

; Set Variables
Dim TRACKTILE(149)
Dim JETX(3),JETY(3),JETF(3),JETS(3),JETL(3),JETD(3),JETD2(3),JETSTEP(3),JETSTEER(3)
Dim PKEY(3),JETSLOW(3),JETJ(3),OLDJETX(3),OLDJETY(3)
Dim WAVEX(3,40),WAVEY(3,40),WAVEF(3,40),WAVED(3,40)
Dim PLYLAP(3),PLYNAME$(3),BUOYPASSED(3)
Dim LAPTIMES(3,3,1),TOTALTIME(3,1),RACEPOINTS(3),CHAMP_POINTS(3),SAVELAPTIMES(3,3,1)
Dim BUOYTYPE(4),BUOYX(4),BUOYY(4)
Dim ENGINECHANNEL(3),CRASHCHANNEL(3),BUOYCHANNEL(3)
Dim PCONTROL(3),PLYNAME$(3)
Global TIMER,FPS=25,TIME1,TIME2,OLDTIME,QTIME1,QTIME2,NUMBEROFLAPS,TRACKNUMBER,MUSIC
Global TIMECODE,REPLAY,OPTION

; Record Input
Dim RECORDKEY(3,250),RECORDTIME(3,250),RECORDSLOT(3)

; Set Default Title Options
PCONTROL(0)=2 : PCONTROL(1)=7 : PCONTROL(2)=7 : PCONTROL(3)=7
PLYNAME$(0)="PL1" : PLYNAME$(1)="PL2" : PLYNAME$(2)="PL3" : PLYNAME$(3)="PL4"
;

;
; FRONTEND
;
.FRONTEND
FlushKeys : FlushJoy  : FlushMouse
Repeat
	OPTION=0
	TITLE
	Repeat
		MENU()
		If OPTION=1 Then CREDITS(1)
		If OPTION=2 Then CHANGENAMES
		If OPTION=3 Then PLAYERSETUP
		If OPTION=4 Then CREDITS(0)
	Until OPTION=0 Or OPTION=5 
Until OPTION=0

;
; GAME
;
TRACKNUMBER=1 : REPLAY=0
For n=0 To 3 : CHAMP_POINTS(n)=0 : Next

.STARTRACE
For n=0 To 3
	PKEY(n)=0 : JETX(n)=100 : JETY(n)=100 : JETF(n)=0 : JETS(n)=0
	JETL(n)=0 : JETD(n)=0 : JETD2(n)=0 : JETSLOW(n)=0 : JETSTEP(n)=0 : JETSTEER(n)=0
	JETJ(n)=-6 : BUOYPASSED(n)=0
Next
JETY(0)=100 : JETY(1)=130 : JETY(2)=160 : JETY(3)=190
For n=0 To 3
	For n2=0 To 40 : WAVEX(n,n2)=0 : WAVEY(n,n2)=0 : WAVEF(n,n2)=0 : WAVED(n,n2)=-1 : Next
	PLYLAP(n)=-2
	LAPTIMES(n,0,0)=0 : LAPTIMES(n,0,1)=0
	LAPTIMES(n,1,0)=0 : LAPTIMES(n,1,1)=0
	LAPTIMES(n,2,0)=0 : LAPTIMES(n,2,1)=0
	LAPTIMES(n,3,0)=0 : LAPTIMES(n,3,1)=0
	TOTALTIME(n,0)=0 : TOTALTIME(n,1)=0
	RACEPOINTS(n)=0
	If REPLAY=0
		RECORDSLOT(n)=-1
		For n2=0 To 250 : RECORDKEY(n,n2)=0 : RECORDTIME(n,n2)=0 : Next
	End If
Next
TIME1=0 : TIME2=0 : OLDTIME=0
QTIME1=0 : QTIME2=0 : TIMECODE=-1
If TRACKNUMBER=1 Then Restore TRK1
If TRACKNUMBER=2 Then Restore TRK2
If TRACKNUMBER=3 Then Restore TRK3
If TRACKNUMBER=4 Then Restore TRK4
If TRACKNUMBER=5 Then Restore TRK5
If TRACKNUMBER=6 Then Restore TRK6
If TRACKNUMBER=7 Then Restore TRK7
If TRACKNUMBER=8 Then Restore TRK8
If TRACKNUMBER=9 Then Restore TRK9
If TRACKNUMBER=10 Then Restore TRK10
Read NUMBEROFLAPS
Read QTIME1
Read QTIME2
For n=0 To 149 : Read TRACKTILE(n) : Next
GETBUOYPOS
; Add 2 Seconds To Qualifying Time Per Human Player
For n=0 To 3
	If PCONTROL(n)<7 Then QTIME1=QTIME1+2
Next


; Start Engines
If REPLAY=0 Then TRACKOVERVIEW
If REPLAY=1 Then ClsColor 0,0,0 : Cls : Flip 
GETJETSTARTPOS
LoopSound(ENGINESFX)
For n=0 To 3 : ENGINECHANNEL(n)=PlaySound(ENGINESFX) : ENGINEAUDIO(n) : ChannelVolume(ENGINECHANNEL(n),0) : Delay 800 : Next
If REPLAY=0
	Delay 2000 : ClsColor 0,0,0 : Cls : Flip
	Delay 2000
End If

For n=0 To 3 : ChannelVolume(ENGINECHANNEL(n),1) : Next
For n=-20 To 85
	TIME2=-1 : WAVES : DISPLAY
	If n=0 Then PlaySound(READYSFX)
	If n=25 Then PlaySound(READYSFX)
	If n=50 Then PlaySound(READYSFX)
	If n=75 Then PlaySound(GOSFX)
	If n>=0 And n<=20 Then DrawImage GOGFX,152,20,0
	If n>=25 And n<=45 Then DrawImage GOGFX,152,20,1
	If n>=50 And n<=70 Then DrawImage GOGFX,152,20,2
	If n>=75 Then DrawImage GOGFX,152,20,3 
	Flip
	Delay 50
Next

; Game Loop
FlushKeys : FlushJoy : FlushMouse
TIMER=CreateTimer(FPS)
endgame=0
Repeat
	TIMECODE=TIMECODE+1
	frames=WaitTimer(TIMER)
	For framecount=1 To frames
		For n=0 To 3
			If REPLAY=0 Then PINPUT(n) Else PLAYBACK(n)
			DRIVEJET(n)
			DETECTION(n)
			DETECTIONTRACK(n)
			DETECTIONBUOY(n)
			ENGINEAUDIO(n)
		Next
	Next
	DISPLAY
	Flip
	If REPLAY=0 Then PAUSE
	If KeyHit(1) Then endgame=1 : PlaySound(CRASHSFX) : Exit
Until TIME1>=QTIME1 And TIME2>=QTIME2

If REPLAY=1 Then endgame=0
For n=0 To 3 : StopChannel(ENGINECHANNEL(n)) : RECORDKEY(n,250)=-1 : RECORDTIME(n,250)=-1 : Next
			
If endgame=0
	PlaySound(READYSFX) : Delay 700 : PlaySound(READYSFX) : Delay 700 : PlaySound(READYSFX)
	FreeTimer(TIMER)
	Delay 1000
	;SAVERECORD
	RACERESULTS
End If
If REPLAY=1 Then Goto STARTRACE
If endgame=1 Then GAMEOVER : Goto FRONTEND

; If A Human Player Is Still In Championship Then Goto Next Race.
n2=0
For n=0 To 3
	If PCONTROL(n)<7
		If TOTALTIME(n,0)>QTIME1 Then n2=1
		If TOTALTIME(n,0)=QTIME1 And TOTALTIME(n,1)>QTIME2 Then n2=1
	End If
Next
TRACKNUMBER=TRACKNUMBER+1
If n2=1 Then GAMEOVER : Goto FRONTEND
If TRACKNUMBER<11 Then Goto STARTRACE
n2=0
If PCONTROL(0)<7 And CHAMP_POINTS(0)>CHAMP_POINTS(1) And CHAMP_POINTS(0)>CHAMP_POINTS(2) And CHAMP_POINTS(0)>CHAMP_POINTS(3) Then n2=1
If PCONTROL(1)<7 And CHAMP_POINTS(1)>CHAMP_POINTS(0) And CHAMP_POINTS(1)>CHAMP_POINTS(2) And CHAMP_POINTS(1)>CHAMP_POINTS(3) Then n2=1
If PCONTROL(2)<7 And CHAMP_POINTS(2)>CHAMP_POINTS(0) And CHAMP_POINTS(2)>CHAMP_POINTS(1) And CHAMP_POINTS(2)>CHAMP_POINTS(3) Then n2=1
If PCONTROL(3)<7 And CHAMP_POINTS(3)>CHAMP_POINTS(0) And CHAMP_POINTS(3)>CHAMP_POINTS(1) And CHAMP_POINTS(3)>CHAMP_POINTS(2) Then n2=1
If n2=1 Then GAMECOMPLETE
GAMEOVER
Goto FRONTEND
End

;
; ****** FUNCTIONS ETC. ******
;

;
; ****** Frontend Functions. ******
;

;
; Title Screen
;
Function TITLE()
	MUSIC=PlaySound(THEME)
	n=0 : count=0 : screen=0
	Repeat
		count=count+1
		If count<249
			n=n+1
			Cls
			DrawBlock TITLEA,31,19 : DrawBlock TITLEB,47,75
			txt$="COPYRIGHT PARK PRODUCTIONS 2003" : DRAWFONTMENU(txt$,228,1)
			If n>8 Then DrawBlock TITLEC,98,204
			If n>19 Then n=0
			Flip
		End If
		If count=249 Then CREDITS(screen) : screen=screen+1 : count=0 : n=0
		If screen>1 Then screen=0
		Delay 50
		If KeyHit(1)=1 Then ClsColor 0,0,0 : Cls : Flip : Cls : Flip : StopChannel(MUSIC) : Delay 1000 : End
		If KeyHit(28) Or KeyHit(57)=1 Or JoyHit(1,0) Or JoyHit(1,1) Or MouseHit(1) Then Exit
	Forever
	StopChannel(MUSIC)
	ClsColor 0,0,0 : Cls : Flip : Cls : Flip : Delay 1000
End Function

;
; Menu
;
Function MENU()
	FlushKeys : FlushJoy  : FlushMouse
	Repeat
		Cls
		DrawBlock TITLEA,31,19
		txt$="MENU" : DRAWFONTMENU(txt$,65,1)
		txt$="CHAMPIONSHIP"
			If OPTION=0 Then colour=1 Else colour=0
			DRAWFONTMENU(txt$,85,colour)
		txt$="INSTRUCTIONS"
			If OPTION=1 Then colour=1 Else colour=0
			DRAWFONTMENU(txt$,100,colour)
		txt$="CHANGE NAMES"
			If OPTION=2 Then colour=1 Else colour=0
			DRAWFONTMENU(txt$,115,colour)
		txt$="PLAYER SETUP"
			If OPTION=3 Then colour=1 Else colour=0
			DRAWFONTMENU(txt$,130,colour)
		txt$="CREDITS"
			If OPTION=4 Then colour=1 Else colour=0
			DRAWFONTMENU(txt$,145,colour)
		txt$="EXIT"
			If OPTION=5 Then colour=1 Else colour=0
			DRAWFONTMENU(txt$,160,colour)
		txt$="SPACE TO SELECT" : DRAWFONTMENU(txt$,185,1)
		txt$="ENTER TO ACCEPT" : DRAWFONTMENU(txt$,200,1)
		txt$="COPYRIGHT PARK PRODUCTIONS 2003" : DRAWFONTMENU(txt$,228,0)
		DrawImage JETPICGFX,25,110,1 : DrawImage JETPICGFX,238,110,0
		Flip
		Delay 50
		If KeyHit(57)=1 Then OPTION=OPTION+1 : PlaySound(BUOYSFX)
		If OPTION>5 Then OPTION=0
		If KeyHit(1)=1 Then OPTION=5 : Exit
	Until KeyHit(28)
	PlaySound(CRASHSFX)
	If OPTION=0 Or OPTION=5 Then ClsColor 0,0,0 : Cls : Flip : Cls : Flip : Delay 1000
End Function

;
; Credits Page
;
Function CREDITS(screen)
	ClsColor 0,0,0 : Cls : Flip : Cls : Flip : Delay 1000
	Cls
	If screen=0
		txt$="PROGRAMMING" : DRAWFONTMENU(txt$,24,1)
		txt$="ERIC PARK" : DRAWFONTMENU(txt$,44,0)
		txt$="TRACK DESIGN" : DRAWFONTMENU(txt$,84,1)
		txt$="BRIAN PARK" : DRAWFONTMENU(txt$,104,0)
		txt$="ALLAN PARK" : DRAWFONTMENU(txt$,119,0)
		txt$="MUSIC" : DRAWFONTMENU(txt$,159,1)
		txt$="DAVE LOWE" : DRAWFONTMENU(txt$,179,0)
		txt$="FROM POWER DRIFT" : DRAWFONTMENU(txt$,194,0)
		txt$="SEGA ACTIVISION" : DRAWFONTMENU(txt$,209,0)
	End If
	If screen=1
		For n=20 To 230 Step 10
			If n=30 Then txt$="INSTRUCTIONS" : DRAWFONTMENU(txt$,n,1)
			
			If n=60 Then txt$="RACE YOUR JETSKI AGAINST 3 OTHER" : DRAWFONTMENU(txt$,n,0)
			If n=70 Then txt$="OPPONENTS OVER THE 10 TRACK     " : DRAWFONTMENU(txt$,n,0)
			If n=80 Then txt$="CHAMPIONSHIP.                   " : DRAWFONTMENU(txt$,n,0)
			
			If n=100 Then  txt$="DRIVE THROUGH THE NUMBERED BUOYS" : DRAWFONTMENU(txt$,n,0)
			If n=110 Then txt$="IN ASCENDING ORDER THEN BACK    " : DRAWFONTMENU(txt$,n,0)
			If n=120 Then txt$="OVER THE START FINISH LINE TO   " : DRAWFONTMENU(txt$,n,0)
			If n=130 Then txt$="COMPLETE A LAP.                 " : DRAWFONTMENU(txt$,n,0)
						
			If n=150 Then txt$="POINTS ARE AWARDED FOR FINISHING" : DRAWFONTMENU(txt$,n,0)
			If n=160 Then txt$="FIRST SECOND AND THIRD IN RACE. " : DRAWFONTMENU(txt$,n,0)
			
			If n=180 Then txt$="CHAMPION WILL BE THE RACER WITH " : DRAWFONTMENU(txt$,n,0)
			If n=190 Then txt$="THE HIGHEST CHAMPIONSHIP POINTS." : DRAWFONTMENU(txt$,n,0)
		Next 
	End If
	Flip
	FlushKeys : FlushJoy : FlushMouse
	Delay 1000
	n=0
	Repeat
		n=n+1 : Delay 50
	Until n>300 Or KeyHit(28) Or KeyHit(57) Or JoyHit(1,0) Or JoyHit(1,1) Or MouseHit(1)
	Cls : Flip : Delay 1000 : Cls : Flip
	FlushKeys : FlushJoy : FlushMouse
End Function

;
; Controls
;
Function PLAYERSETUP()
	FlushKeys : FlushJoy  : FlushMouse
	SELECTCONTROL=5
	Repeat
		Cls
		DrawBlock TITLEA,31,19
		txt$="PLAYER SETUP" : DRAWFONTMENU(txt$,65,1)
		txt$="JET 1          "
			If SELECTCONTROL=0 Then colour=1 Else colour=0
			DRAWFONTMENU(txt$,85,colour)
		txt$="JET 2          "
			If SELECTCONTROL=1 Then colour=1 Else colour=0
			DRAWFONTMENU(txt$,100,colour)
		txt$="JET 3          "
			If SELECTCONTROL=2 Then colour=1 Else colour=0
			DRAWFONTMENU(txt$,115,colour)
		txt$="JET 4          "
			If SELECTCONTROL=3 Then colour=1 Else colour=0
			DRAWFONTMENU(txt$,130,colour)
		txt$="DEFAULT"
			If SELECTCONTROL=4 Then colour=1 Else colour=0
			DRAWFONTMENU(txt$,145,colour)
		txt$="EXIT"
			If SELECTCONTROL=5 Then colour=1 Else colour=0
			DRAWFONTMENU(txt$,160,colour)
		txt$="SPACE TO SELECT" : DRAWFONTMENU(txt$,185,1)
		txt$="ENTER TO CHANGE" : DRAWFONTMENU(txt$,200,1)
		txt$="COPYRIGHT PARK PRODUCTIONS 2003" : DRAWFONTMENU(txt$,228,0)
		DrawImage JETPICGFX,25,110,1 : DrawImage JETPICGFX,238,110,0
		DrawImage CONTROLSGFX,154,85,PCONTROL(0) : DrawImage CONTROLSGFX,154,100,PCONTROL(1)
		DrawImage CONTROLSGFX,154,115,PCONTROL(2) : DrawImage CONTROLSGFX,154,130,PCONTROL(3)
		Flip
		Delay 50
		If KeyHit(57)=1 Then SELECTCONTROL=SELECTCONTROL+1 : PlaySound(BUOYSFX)
		If SELECTCONTROL>5 Then SELECTCONTROL=0

		If KeyHit(28)=1
			If SELECTCONTROL>-1 And SELECTCONTROL<4
				PlaySound(CRASHSFX)
				Repeat
					n2=0
					PCONTROL(SELECTCONTROL)=PCONTROL(SELECTCONTROL)+1
					If PCONTROL(SELECTCONTROL)>7 Then PCONTROL(SELECTCONTROL)=0
					;
					If SELECTCONTROL<>0 And PCONTROL(SELECTCONTROL)<7 And PCONTROL(SELECTCONTROL)=PCONTROL(0) Then n2=1
					If SELECTCONTROL<>1 And PCONTROL(SELECTCONTROL)<7 And PCONTROL(SELECTCONTROL)=PCONTROL(1) Then n2=1
					If SELECTCONTROL<>2 And PCONTROL(SELECTCONTROL)<7 And PCONTROL(SELECTCONTROL)=PCONTROL(2) Then n2=1
					If SELECTCONTROL<>3 And PCONTROL(SELECTCONTROL)<7 And PCONTROL(SELECTCONTROL)=PCONTROL(3) Then n2=1
					;
				Until n2=0
				If PCONTROL(0)=7 And PCONTROL(1)=7 And PCONTROL(2)=7 And PCONTROL(3)=7 Then PCONTROL(SELECTCONTROL)=0
			End If
			If SELECTCONTROL=4 Then PlaySound(CRASHSFX) : PCONTROL(0)=2 : PCONTROL(1)=7 : PCONTROL(2)=7 : PCONTROL(3)=7
			If SELECTCONTROL=5 Then Exit
		End If

	Until KeyHit(1)
	PlaySound(CRASHSFX)
End Function

;
; Name Entry
;
Function CHANGENAMES()
	FlushKeys : FlushJoy  : FlushMouse
	SELECTCONTROL=5
	Repeat
		Cls
		DrawBlock TITLEA,31,19
		txt$="CHANGE NAMES" : DRAWFONTMENU(txt$,65,1)
		txt$="JET 1  "+PLYNAME$(0)
		If Len(PLYNAME$(0))=0 Then txt$=txt$+"   "
		If Len(PLYNAME$(0))=1 Then txt$=txt$+"  "
		If Len(PLYNAME$(0))=2 Then txt$=txt$+" "
		If SELECTCONTROL=0 Then colour=1 Else colour=0
		DRAWFONTMENU(txt$,85,colour)
		
		txt$="JET 2  "+PLYNAME$(1)
		If Len(PLYNAME$(1))=0 Then txt$=txt$+"   "
		If Len(PLYNAME$(1))=1 Then txt$=txt$+"  "
		If Len(PLYNAME$(1))=2 Then txt$=txt$+" "		
		If SELECTCONTROL=1 Then colour=1 Else colour=0
		DRAWFONTMENU(txt$,100,colour)
		
		txt$="JET 3  "+PLYNAME$(2)
		If Len(PLYNAME$(2))=0 Then txt$=txt$+"   "
		If Len(PLYNAME$(2))=1 Then txt$=txt$+"  "
		If Len(PLYNAME$(2))=2 Then txt$=txt$+" "		
		If SELECTCONTROL=2 Then colour=1 Else colour=0
		DRAWFONTMENU(txt$,115,colour)
		
		txt$="JET 4  "+PLYNAME$(3)
		If Len(PLYNAME$(3))=0 Then txt$=txt$+"   "
		If Len(PLYNAME$(3))=1 Then txt$=txt$+"  "
		If Len(PLYNAME$(3))=2 Then txt$=txt$+" "		
		If SELECTCONTROL=3 Then colour=1 Else colour=0
		DRAWFONTMENU(txt$,130,colour)
		
		txt$="DEFAULT"
		If SELECTCONTROL=4 Then colour=1 Else colour=0
		DRAWFONTMENU(txt$,145,colour)
		
		txt$="EXIT"
		If SELECTCONTROL=5 Then colour=1 Else colour=0
		DRAWFONTMENU(txt$,160,colour)
		
		txt$="SPACE TO SELECT" : DRAWFONTMENU(txt$,185,1)
		txt$="ENTER TO ACCEPT" : DRAWFONTMENU(txt$,200,1)
		txt$="COPYRIGHT PARK PRODUCTIONS 2003" : DRAWFONTMENU(txt$,228,0)
		DrawImage JETPICGFX,25,110,1 : DrawImage JETPICGFX,238,110,0
		Flip
		Delay 50
		If KeyHit(57)=1 Then SELECTCONTROL=SELECTCONTROL+1 : PlaySound(BUOYSFX)
		If SELECTCONTROL>5 Then SELECTCONTROL=0

		If SELECTCONTROL>-1 And SELECTCONTROL<4
			If KeyHit(28)=1 Then PlaySound(CRASHSFX)
			If KeyHit(14)=1 Or KeyHit(211)=1
				If Len(PLYNAME$(SELECTCONTROL))>0 Then PlaySound(CRASHSFX)
				If Len(PLYNAME$(SELECTCONTROL))<=1 Then PLYNAME$(SELECTCONTROL)=""
				If Len(PLYNAME$(SELECTCONTROL))=2 Then PLYNAME$(SELECTCONTROL)=Left$(PLYNAME$(SELECTCONTROL),1)
				If Len(PLYNAME$(SELECTCONTROL))>=3 Then PLYNAME$(SELECTCONTROL)=Left$(PLYNAME$(SELECTCONTROL),2)			
			End If
			 
			CHAR=GetKey()
			If CHAR>96 And CHAR<123 Or CHAR=46
				PLYNAME$(SELECTCONTROL)=Upper$(PLYNAME$(SELECTCONTROL)+Chr$(CHAR)) : PlaySound(CRASHSFX)
				If Len(PLYNAME$(SELECTCONTROL))>3
					If CHAR>96 And CHAR<123
						PLYNAME$(SELECTCONTROL)=""+Chr$(CHAR-32)
						Else
						PLYNAME$(SELECTCONTROL)=""+Chr$(CHAR)
					End If
				End If
			End If
		End If


		If KeyHit(28)=1
			If SELECTCONTROL=4 Then PlaySound(CRASHSFX) : PLYNAME$(0)="PL1" : PLYNAME$(1)="PL2" : PLYNAME$(2)="PL3" : PLYNAME$(3)="PL4"
			If SELECTCONTROL=5 Then Exit
		End If

	Until KeyHit(1)
	PlaySound(CRASHSFX)
End Function

;
; ****** Game Functions. ******
;

;
; Draw Jets And Waves etc.
;
Function DISPLAY()
	ClsColor 0,0,0 : Cls
	Viewport 10,8,300,200
	ClsColor 0,0,248 : Cls

	TRACK
	; Draw Buoy Detection Lines.
	DrawImage BUOYDETECT,BUOYX(0),BUOYY(0),BUOYTYPE(0)
	WAVES
		
	; Jet Ski
	If JETJ(0)<1 Then DrawImage RACERS,JETX(0),JETY(0),JETF(0)
	If JETJ(1)<1 Then DrawImage RACERS,JETX(1),JETY(1),JETF(1)+16
	If JETJ(2)<1 Then DrawImage RACERS,JETX(2),JETY(2),JETF(2)+32
	If JETJ(3)<1 Then DrawImage RACERS,JETX(3),JETY(3),JETF(3)+48
	
	TRACKTOP
	
	If JETJ(0)>0 Then DrawImage RACERSJP,JETX(0)-4,JETY(0)-4,JETF(0)
	If JETJ(1)>0 Then DrawImage RACERSJP,JETX(1)-4,JETY(1)-4,JETF(1)+16
	If JETJ(2)>0 Then DrawImage RACERSJP,JETX(2)-4,JETY(2)-4,JETF(2)+32
	If JETJ(3)>0 Then DrawImage RACERSJP,JETX(3)-4,JETY(3)-4,JETF(3)+48
	
	If REPLAY=1
		If TIME2<5 Then DrawImage PAUSEGFX,263,198,1
	End If

	Viewport 0,0,320,240
	
	; Score Board
	DrawBlock TIMEQUALIFY,25,211,0
	DrawBlock TIMEQUALIFY,269,211,1
	DrawBlock JETPICGFX,200,211,0
	
	n4=72
	For n=0 To 3
		; Laps & Racers
		If PLYLAP(n)>-2 Then DrawBlock LAPGFX,(n4-5),229,PLYLAP(n)+(n*5)+1 Else DrawBlock LAPGFX,(n4-5),229,PLYLAP(n)+(n*5)+2
		DrawImage RACERS,(n4-6),209,n*16
		Color 0,0,0 : Rect (n4-5)+(NUMBEROFLAPS*5),229,19-(NUMBEROFLAPS*5),4,1
		
		; Names
		For n2=1 To 3
			If PCONTROL(n)<7 Then n3=Asc(Mid$(PLYNAME$(n),n2,1)) Else n3=Asc(Mid$("CPU",n2,1))
			If n3<46 Or n3>90 Then n3=32
			If n3>47 And n3<58 Then n3=n3+7
			If n3=46 Then n3=91
			If n3<>32 Then DrawBlock FONTSMALL,n4+(n2*4),211,n3-55
		Next
		
		; Lap Times
		For n2=1 To 4
			txt$="00.0"
			If PLYLAP(n)>-1
				If LAPTIMES(n,PLYLAP(n),0)>-1 And LAPTIMES(n,PLYLAP(n),0)<10 Then txt$="0"+LAPTIMES(n,PLYLAP(n),0)+"."+LAPTIMES(n,PLYLAP(n),1)
				If LAPTIMES(n,PLYLAP(n),0)>9 Then txt$=LAPTIMES(n,PLYLAP(n),0)+"."+LAPTIMES(n,PLYLAP(n),1)
			End If
			n3=Asc(Mid$(txt$,n2,1))
			If n3<47 Or n3>90 Then n3=91
			If n3>47 And n3<58 Then n3=n3+7
			DrawBlock FONTSMALL,(n4-7)+(n2*4),220,n3-55
		Next
		n4=n4+35
	Next
	
	; Qualifying Time.
	If QTIME1<10
		n=0 : n2=QTIME1
	Else
		n=Asc(Left$(QTIME1,1))-48
		n2=Asc(Right$(QTIME1,1))-48
	End If
	DrawBlock TIMEGFX,267,218,n : DrawBlock TIMEGFX,279,218,n2 : DrawBlock TIMEGFX,289,218,10 : DrawBlock TIMEGFX,299,218,QTIME2
	
	; Time
	If TIME1<>QTIME1 Or TIME2<>QTIME2
		NEWTIME=MilliSecs()
		If TIME1<99 And NEWTIME-OLDTIME>100 Then TIME2=TIME2+1 : OLDTIME=NEWTIME
		If TIME2>9
			TIME2=0
			If TIME1<99
				TIME1=TIME1+1
				If QTIME1-TIME1<5 Then PlaySound(TIMESFX)
			End If
		End If
	End If
	If TIME1<10
		n=0 : n2=TIME1
	Else
		n=Asc(Left$(TIME1,1))-48
		n2=Asc(Right$(TIME1,1))-48
	End If
	If TIME2<0 Then TIME2=0
	DrawBlock TIMEGFX,11,218,n : DrawBlock TIMEGFX,23,218,n2 : DrawBlock TIMEGFX,43,218,TIME2
	n=0
	If TIME2=0 Then n=0
	If TIME2=1 Then n=1
	If TIME2=2 Then n=0
	If TIME2=3 Then n=1
	If TIME2=4 Then n=0
	If TIME2=5 Then n=1
	If TIME2=6 Then n=0
	If TIME2=7 Then n=1
	If TIME2=8 Then n=0
	If TIME2=9 Then n=1
	If n=1 Then DrawBlock TIMEGFX,33,218,10 Else DrawBlock TIMEGFX,33,218,11
End Function


;
; Track
;
Function TRACK()
	n=-1
	For y=8 To 193 Step 20
		For x=10 To 290 Step 20
			n=n+1
			If TRACKTILE(n)>-1 Then DrawBlock TRCKTILE,x,y,TRACKTILE(n)
		Next
	Next
End Function

;
; Track Top (Items Of Track That JetSki Go Under)
;
Function TRACKTOP()
	n=-1
	For y=8 To 193 Step 20
		For x=10 To 290 Step 20
			n=n+1
			If TRACKTILE(n)=58 Then DrawImage TRCKTILE,x,y,58
			If TRACKTILE(n)=57 Or TRACKTILE(n)=59 Then DrawImage TRCKTILE,x,y,27
			If TRACKTILE(n)=60 Or TRACKTILE(n)=62 Then DrawImage TRCKTILE,x,y,29
			If TRACKTILE(n)=61 Then DrawImage TRCKTILE,x,y,28
			If TRACKTILE(n)>=36 And TRACKTILE(n)<=44 Then DrawImage TRCKTILE,x,y,TRACKTILE(n)-9
		Next
	Next
End Function

;
;	Waves
;
Function WAVES()
	For player=0 To 3
		For wavecount=0 To 40
		
			If JETS(player)<1 And WAVEF(player,wavecount)>10 Then WAVEF(player,wavecount)=WAVEF(player,wavecount)+1

			; Get Wave Start Pos.
			Restore WAVEDATA
			If WAVEF(player,wavecount)=0 And JETJ(player)<1
				For n=0 To JETF(player) : Read WAVEX(player,wavecount),WAVEY(player,wavecount) : Next
				WAVEX(player,wavecount)=WAVEX(player,wavecount)+JETX(player) : WAVEY(player,wavecount)=WAVEY(player,wavecount)+JETY(player)
				WAVEF(player,wavecount)=Rand(0,40)
				WAVED(player,wavecount)=JETF(player)
			End If

			; Draw Waves
			If JETS(player)>0 Or Rand(0,2)=0

				WAVEF(player,wavecount)=WAVEF(player,wavecount)+1
				If WAVEF(player,wavecount)>40 Then WAVEF(player,wavecount)=0
				
				; Frame 0
				If WAVED(player,wavecount)=0
					n=Rand(0,6) : n2=Rand(0,1)
					If n2=0 Then WAVEX(player,wavecount)=WAVEX(player,wavecount)-1 
					If wavecount<21
						If n=0 Then WAVEY(player,wavecount)=WAVEY(player,wavecount)-1
						Else
						If n=0 Then WAVEY(player,wavecount)=WAVEY(player,wavecount)+1
					End If
				End If
				; Frame 1,2,3
				If WAVED(player,wavecount)>0 And WAVED(player,wavecount)<4
					n=Rand(0,6) : n2=Rand(0,1)
					If n2=0 Then WAVEX(player,wavecount)=WAVEX(player,wavecount)-1 : WAVEY(player,wavecount)=WAVEY(player,wavecount)-1 
					If wavecount<21
						If n=0 Then WAVEY(player,wavecount)=WAVEY(player,wavecount)-1
						Else
						If n=0 Then WAVEY(player,wavecount)=WAVEY(player,wavecount)+1
					End If
				End If
				; Frame 4
				If WAVED(player,wavecount)=4
					n=Rand(0,6) : n2=Rand(0,1)
					If n2=0 Then WAVEY(player,wavecount)=WAVEY(player,wavecount)-1 
					If wavecount<21
						If n=0 Then WAVEX(player,wavecount)=WAVEX(player,wavecount)-1
						Else
						If n=0 Then WAVEX(player,wavecount)=WAVEX(player,wavecount)+1
					End If
				End If
				; Frame 5,6,7
				If WAVED(player,wavecount)>4 And WAVED(player,wavecount)<8
					n=Rand(0,6) : n2=Rand(0,1)
					If n2=0 Then WAVEX(player,wavecount)=WAVEX(player,wavecount)+1 : WAVEY(player,wavecount)=WAVEY(player,wavecount)-1 
					If wavecount<21
						If n=0 Then WAVEX(player,wavecount)=WAVEX(player,wavecount)-1
						Else
						If n=0 Then WAVEX(player,wavecount)=WAVEX(player,wavecount)+1
					End If
				End If
				; Frame 8
				If WAVED(player,wavecount)=8
					n=Rand(0,6) : n2=Rand(0,1)
					If n2=0 Then WAVEX(player,wavecount)=WAVEX(player,wavecount)+1 
					If wavecount<21
						If n=0 Then WAVEY(player,wavecount)=WAVEY(player,wavecount)-1
						Else
						If n=0 Then WAVEY(player,wavecount)=WAVEY(player,wavecount)+1
					End If
				End If
				; Frame 9,10,11
				If WAVED(player,wavecount)>8 And WAVED(player,wavecount)<12
					n=Rand(0,6) : n2=Rand(0,1)
					If n2=0 Then WAVEX(player,wavecount)=WAVEX(player,wavecount)+1 : WAVEY(player,wavecount)=WAVEY(player,wavecount)+1 
					If wavecount<21
						If n=0 Then WAVEX(player,wavecount)=WAVEX(player,wavecount)-1
						Else
						If n=0 Then WAVEX(player,wavecount)=WAVEX(player,wavecount)+1
					End If
				End If
				; Frame 12
				If WAVED(player,wavecount)=12
					n=Rand(0,6) : n2=Rand(0,1)
					If n2=0 Then WAVEY(player,wavecount)=WAVEY(player,wavecount)+1 
					If wavecount<21
						If n=0 Then WAVEX(player,wavecount)=WAVEX(player,wavecount)-1
						Else
						If n=0 Then WAVEX(player,wavecount)=WAVEX(player,wavecount)+1
					End If
				End If
				; Frame 13,14,15
				If WAVED(player,wavecount)>12 And WAVED(player,wavecount)<16
					n=Rand(0,6) : n2=Rand(0,1)
					If n2=0 Then WAVEX(player,wavecount)=WAVEX(player,wavecount)-1 : WAVEY(player,wavecount)=WAVEY(player,wavecount)+1 
					If wavecount<21
						If n=0 Then WAVEX(player,wavecount)=WAVEX(player,wavecount)-1
						Else
						If n=0 Then WAVEX(player,wavecount)=WAVEX(player,wavecount)+1
					End If
				End If
			End If

			; Keep Waves Inside Level
			If WAVEX(player,wavecount)<10 Then WAVEX(player,wavecount)=10 : WAVED(player,wavecount)=8
			If WAVEX(player,wavecount)>310 Then WAVEX(player,wavecount)=310 : WAVED(player,wavecount)=0
			If WAVEY(player,wavecount)<8 Then WAVEY(player,wavecount)=8 : WAVED(player,wavecount)=12
			If WAVEY(player,wavecount)>208 Then WAVEY(player,wavecount)=208 : WAVED(player,wavecount)=4


			If Rand(0,1)=0 Color 248,252,248 Else Color 0,252,248
			If WAVED(player,wavecount)>-1
				detectcolour=ReadPixel(WAVEX(player,wavecount),WAVEY(player,wavecount))
				If detectcolour=-16776968 Or detectcolour=-16777216
					Plot WAVEX(player,wavecount),WAVEY(player,wavecount)
					Else
					WAVEBOUNCE(player,wavecount)
				End If
			End If
		Next
	Next
End Function

;
; Wave Bounce
;
Function WAVEBOUNCE(player,wavecount)
	; Cancel Bounce If Touching Own Wave
	n2=0
	For n=0 To 40
		If n<>wavecount
			If WAVEX(player,wavecount)=WAVEX(player,n) And WAVEY(player,wavecount)=WAVEY(player,n) Then n2=1
		End If
	Next
	If n2=1 Then Return

	; Bounce In Opposite Direction
	WAVED(player,wavecount)=WAVED(player,wavecount)+8
	If WAVED(player,wavecount)>15 Then WAVED(player,wavecount)=WAVED(player,wavecount)-16
	
End Function

;
; Drive Jetski
;
Function DRIVEJET(player)
	OLDJETX(player)=JETX(player)
	OLDJETY(player)=JETY(player)

	If JETJ(player)>-6 Then JETJ(player)=JETJ(player)+1
	If JETJ(player)>(JETS(player)*2)+25 Then JETJ(player)=-6

	If JETJ(player)=-6
		If PKEY(player)=1 Or PKEY(player)=3 And JETF(player)=JETD(player) Then JETSTEER(player)=0
		If PKEY(player)=2 Or PKEY(player)=4 And JETF(player)=JETD(player) Then JETSTEER(player)=1

		JETL(player)=JETL(player)+1
	
		slowdown=10
		If JETS(player)=1 And PKEY(player)<>5 Then slowdown=80
		If JETSLOW(player)<slowdown Then JETSLOW(player)=JETSLOW(player)+1 Else JETSLOW(player)=0

		; Turn
		n=0
		If JETS(player)<1 Then n=4
		If JETL(player)>JETS(player)+n
			JETL(player)=0
			If PKEY(player)=1 Or PKEY(player)=3 Then JETF(player)=JETF(player)-1
			If PKEY(player)=2 Or PKEY(player)=4 Then JETF(player)=JETF(player)+1
			If JETF(player)<0 Then JETF(player)=15
			If JETF(player)>15 Then JETF(player)=0
		End If
	
		; Speed
		If JETSLOW(player)=slowdown
			If PKEY(player)>2 Then JETS(player)=JETS(player)+1
			If PKEY(player)<3 Then JETS(player)=JETS(player)-1
			If JETS(player)<0 Then JETS(player)=0
			If JETS(player)>4 Then JETS(player)=4
		End If
	
		; Drive
		If JETD(player)<>JETF(player) Then JETD2(player)=JETD2(Player)+1
		If JETD2(player)>(JETS(player)*2)+1
			JETD2(player)=0
			If JETD(player)<JETF(player)
				If JETF(player)-JETD(player)>4 Then n=2 Else n=1
				If JETSTEER(player)=0 Then JETD(player)=JETD(player)-n
				If JETSTEER(player)=1 Then JETD(player)=JETD(player)+n
			End If
			If JETD(player)>JETF(player)
				If JETD(player)-JETF(player)>4 Then n=2 Else n=1
				If JETSTEER(player)=0 Then JETD(player)=JETD(player)-n
				If JETSTEER(player)=1 Then JETD(player)=JETD(player)+n
			End If
			If JETD(player)<0 Then JETD(player)=15
			If JETD(player)>15 Then JETD(player)=0
		End If
	End If	
	
	If JETS(player)=0 Then JETD(player)=JETF(player)
	
	If JETS(player)>0
		speed2=JETS(player)
		If JETS(player)=1 And PKEY(player)<>5 Then speed2=0
		If speed2>1 Then speed2=1

		For speed=0 To speed2
			If JETD(player)=0 Then Restore DIR0
			If JETD(player)=1 Then Restore DIR1
			If JETD(player)=2 Then Restore DIR2
			If JETD(player)=3 Then Restore DIR3
			If JETD(player)=4 Then Restore DIR4
			If JETD(player)=5 Then Restore DIR5
			If JETD(player)=6 Then Restore DIR6
			If JETD(player)=7 Then Restore DIR7
			If JETD(player)=8 Then Restore DIR8
			If JETD(player)=9 Then Restore DIR9
			If JETD(player)=10 Then Restore DIR10
			If JETD(player)=11 Then Restore DIR11
			If JETD(player)=12 Then Restore DIR12
			If JETD(player)=13 Then Restore DIR13
			If JETD(player)=14 Then Restore DIR14
			If JETD(player)=15 Then Restore DIR15
				
			For n=0 To JETSTEP(player) : Read JETMOVE : Next
			If JETSTEP(player)<6 Then JETSTEP(player)=JETSTEP(player)+1 Else JETSTEP(player)=0
			
			If JETMOVE=1 Then JETX(player)=JETX(player)-1 : JETY(player)=JETY(player)+1
			If JETMOVE=2 Then JETY(player)=JETY(player)+1
			If JETMOVE=3 Then JETX(player)=JETX(player)+1 : JETY(player)=JETY(player)+1
			If JETMOVE=4 Then JETX(player)=JETX(player)-1
			If JETMOVE=6 Then JETX(player)=JETX(player)+1
			If JETMOVE=7 Then JETX(player)=JETX(player)-1 : JETY(player)=JETY(player)-1
			If JETMOVE=8 Then JETY(player)=JETY(player)-1
			If JETMOVE=9 Then JETX(player)=JETX(player)+1 : JETY(player)=JETY(player)-1
		Next
	End If
End Function

;
; Detection
;
Function DETECTION(player)
	; 300 x 200
	If JETX(player)<9 Then JETX(player)=9 : CRASHAUDIO(player)
	If JETX(player)>303 Then JETX(player)=303 : CRASHAUDIO(player)
	If JETY(player)<7 Then JETY(player)=7 : CRASHAUDIO(player)
	If JETY(player)>201 Then JETY(player)=201 : CRASHAUDIO(player)

	; Other Ski`s
	For n=0 To 3
		If n=player Then n=n+1

		n2=n
		; Cancel Detection When Either Jet Is Jumping.
		If n2<4
			If JETJ(player)>0 Or JETJ(n)>0 Then n2=9
			If JETJ(player)>0 And JETJ(n)>0 Then n2=n
			; Cancel Detection When Jet Is CPU Controlled
			If PCONTROL(player)=7 Or PCONTROL(n)=7 Then n2=9
		End If
		
		If n2<4
			detect=0
			If JETJ(player)=-6 And JETJ(n)=-6 Then detect=ImagesCollide(RACERS,JETX(player),JETY(player),JETF(player),RACERS,JETX(n),JETY(n),JETF(n))
			If JETJ(player)>-6 And JETJ(n)>-6 Then detect=ImagesCollide(RACERSJP,JETX(player),JETY(player),JETF(player),RACERSJP,JETX(n),JETY(n),JETF(n))
			If JETJ(player)=-6 And JETJ(n)>-6 Then detect=ImagesCollide(RACERS,JETX(player),JETY(player),JETF(player),RACERSJP,JETX(n),JETY(n),JETF(n))
			If JETJ(player)>-6 And JETJ(n)=-6 Then detect=ImagesCollide(RACERSJP,JETX(player),JETY(player),JETF(player),RACERS,JETX(n),JETY(n),JETF(n))
			If detect=1
				JETS(player)=1
				If JETSTEER(player)=0
					JETF(player)=JETF(player)-1
					If JETF(player)<0 Then JETF(player)=15
				End If
				If JETSTEER(player)=1
					JETF(player)=JETF(player)+1
					If JETF(player)>15 Then JETF(player)=0
				End If
				CRASHAUDIO(player)
			End If
		End If
	Next 
End Function

;
; Detection Track
;
Function DETECTIONTRACK(player)
	; If Jet Jumping Then Return
	If JETJ(player)>-6 Then Return

	; Any Piece Of Track Thats Not Water.
	x=-12 : y=10
	For n=0 To 149
		x=x+20
		If x>290 Then x=10 : y=y+20
		If TRACKTILE(n)>-1
			detect=ImagesCollide(RACERS,JETX(player),JETY(player),JETF(player),TRCKTILE,x,y,TRACKTILE(n))
			If TRACKTILE(n)=36 Or TRACKTILE(n)=37 Then detect=0
			If detect=1
				; Jump
				If TRACKTILE(n)=71 And JETD(player)=8 And JETJ(player)=-6 And JETS(player)>=2 And JETY(player)>y+4 Then JETS(player)=4 : JETJ(player)=-5 : Exit
				If TRACKTILE(n)=72 And JETD(player)=8 And JETJ(player)=-6 And JETS(player)>=2 And JETY(player)<y+4 Then JETS(player)=4 : JETJ(player)=-5 : Exit
				If TRACKTILE(n)=73 And JETD(player)=0 And JETJ(player)=-6 And JETS(player)>=2 And JETY(player)>y+4 Then JETS(player)=4 : JETJ(player)=-5 : Exit
				If TRACKTILE(n)=74 And JETD(player)=0 And JETJ(player)=-6 And JETS(player)>=2 And JETY(player)<y+4 Then JETS(player)=4 : JETJ(player)=-5 : Exit
				If TRACKTILE(n)=75 And JETD(player)=4 And JETJ(player)=-6 And JETS(player)>=2 And JETX(player)>x+4 Then JETS(player)=4 : JETJ(player)=-5 : Exit
				If TRACKTILE(n)=76 And JETD(player)=4 And JETJ(player)=-6 And JETS(player)>=2 And JETX(player)<x+4 Then JETS(player)=4 : JETJ(player)=-5 : Exit
				If TRACKTILE(n)=77 And JETD(player)=12 And JETJ(player)=-6 And JETS(player)>=2 And JETX(player)>x+4 Then JETS(player)=4 : JETJ(player)=-5 : Exit
				If TRACKTILE(n)=78 And JETD(player)=12 And JETJ(player)=-6 And JETS(player)>=2 And JETX(player)<x+4 Then JETS(player)=4 : JETJ(player)=-5 : Exit
				; Moss
				If TRACKTILE(n)>=21 And TRACKTILE(n)<=25 Then JETS(player)=1 : Exit
				; Crash
				JETS(player)=1
				JETX(player)=OLDJETX(player)
				JETY(player)=OLDJETY(player)
				CRASHAUDIO(player)
			End If
		End If
	Next 
End Function

;
; Detection Buoy Checkpoints
;
Function DETECTIONBUOY(player)
	For n=0 To 4
		detect=ImagesCollide(RACERS,JETX(player),JETY(player),JETF(player),BUOYDETECT,BUOYX(n),BUOYY(n),BUOYTYPE(n))
		If detect=1 And BUOYPASSED(player)=n
			BUOYAUDIO(player)
			BUOYPASSED(player)=BUOYPASSED(player)+1
			If BUOYPASSED(player)=1
				PLYLAP(player)=PLYLAP(player)+1
				If PLYLAP(player)>2 Then PLYLAP(player)=3
				;
				If PLYLAP(player)>-1 And PLYLAP(player)<4
					T1=TIME1 : T2=TIME2
					
					A1=LAPTIMES(player,0,0)+LAPTIMES(player,1,0)+LAPTIMES(player,2,0)+LAPTIMES(player,3,0)
					A2=LAPTIMES(player,0,1)+LAPTIMES(player,1,1)+LAPTIMES(player,2,1)+LAPTIMES(player,3,1)
					If A2>9
						Repeat : A2=A2-10 : A1=A1+1 : Until A2<10	
					End If		
					T1=T1-A1
					T2=T2-A2
					If T2<0
						T1=T1-1
						T2=10+T2
					End If					
					LAPTIMES(player,PLYLAP(player),0)=T1
					LAPTIMES(player,PLYLAP(player),1)=T2
				End If
			End If
			If BUOYPASSED(player)>4 Then BUOYPASSED(player)=0
		End If
	Next
End Function

;
; Player Input Controls
;
Function PINPUT(player)
	; PCONTROL=7 FOR CPU JETSKI.
	If PCONTROL(player)<7 Then PKEY(player)=0
	; Keys 1 - Z X C
	If PCONTROL(player)=0
		If KeyDown(46) Then PKEY(player)=5
		If KeyDown(44) Then PKEY(player)=1
		If KeyDown(45) Then PKEY(player)=2
		If KeyDown(44) And KeyDown(46) Then PKEY(player)=3
		If KeyDown(45) And KeyDown(46) Then PKEY(player)=4
	End If
	; Keys 1 - M , .
	If PCONTROL(player)=1
		If KeyDown(52) Then PKEY(player)=5
		If KeyDown(50) Then PKEY(player)=1
		If KeyDown(51) Then PKEY(player)=2
		If KeyDown(50) And KeyDown(52) Then PKEY(player)=3
		If KeyDown(51) And KeyDown(52) Then PKEY(player)=4
	End If
	; Keys 2 - CURSORS
	If PCONTROL(player)=2
		If KeyDown(200) Then PKEY(player)=5
		If KeyDown(203) Then PKEY(player)=1
		If KeyDown(205) Then PKEY(player)=2
		If KeyDown(203) And KeyDown(200) Then PKEY(player)=3
		If KeyDown(205) And KeyDown(200) Then PKEY(player)=4
	End If
	; Keys 1 - (- + ENTER) (Keypad)
	If PCONTROL(player)=3
		If KeyDown(156) Then PKEY(player)=5
		If KeyDown(74) Then PKEY(player)=1
		If KeyDown(78) Then PKEY(player)=2
		If KeyDown(74) And KeyDown(156) Then PKEY(player)=3
		If KeyDown(78) And KeyDown(156) Then PKEY(player)=4
	End If
	; Joystick 1
	If PCONTROL(player)=4
		If JoyDown(1,0) Then PKEY(player)=5
		If JoyXDir(0)=-1 Then PKEY(player)=1
		If JoyXDir(0)=1 Then PKEY(player)=2
		If JoyXDir(0)=-1 And JoyDown(1,0) Then PKEY(player)=3
		If JoyXDir(0)=1 And JoyDown(1,0) Then PKEY(player)=4
	End If
	; Joystick 2
	If PCONTROL(player)=5
		If JoyDown(1,1) Then PKEY(player)=5
		If JoyXDir(1)=-1 Then PKEY(player)=1
		If JoyXDir(1)=1 Then PKEY(player)=2
		If JoyXDir(1)=-1 And JoyDown(1,1) Then PKEY(player)=3
		If JoyXDir(1)=1 And JoyDown(1,1) Then PKEY(player)=4
	End If
	; Mouse
	If PCONTROL(player)=6
		mx=MouseX()
		If MouseDown(1) Then PKEY(player)=5
		If mx<160 Then PKEY(player)=1 : MoveMouse 160,200
		If mx>160 Then PKEY(player)=2 : MoveMouse 160,200
		If mx<160 And MouseDown(1) Then PKEY(player)=3 : MoveMouse 160,200
		If mx>160 And MouseDown(1) Then PKEY(player)=4 : MoveMouse 160,200
	End If

	; CPU Control
	If PCONTROL(player)=7
		; Restore Data Point
		If TRACKNUMBER=1
			If player=0 Then Restore CPU0_TRK1
			If player=1 Then Restore CPU1_TRK1
			If player=2 Then Restore CPU2_TRK1
			If player=3 Then Restore CPU3_TRK1
		End If
		If TRACKNUMBER=2
			If player=0 Then Restore CPU0_TRK2
			If player=1 Then Restore CPU1_TRK2
			If player=2 Then Restore CPU2_TRK2
			If player=3 Then Restore CPU3_TRK2
		End If
		If TRACKNUMBER=3
			If player=0 Then Restore CPU0_TRK3
			If player=1 Then Restore CPU1_TRK3
			If player=2 Then Restore CPU2_TRK3
			If player=3 Then Restore CPU3_TRK3
		End If
		If TRACKNUMBER=4
			If player=0 Then Restore CPU0_TRK4
			If player=1 Then Restore CPU1_TRK4
			If player=2 Then Restore CPU2_TRK4
			If player=3 Then Restore CPU3_TRK4
		End If
		If TRACKNUMBER=5
			If player=0 Then Restore CPU0_TRK5
			If player=1 Then Restore CPU1_TRK5
			If player=2 Then Restore CPU2_TRK5
			If player=3 Then Restore CPU3_TRK5
		End If
		If TRACKNUMBER=6
			If player=0 Then Restore CPU0_TRK6
			If player=1 Then Restore CPU1_TRK6
			If player=2 Then Restore CPU2_TRK6
			If player=3 Then Restore CPU3_TRK6
		End If
		If TRACKNUMBER=7
			If player=0 Then Restore CPU0_TRK7
			If player=1 Then Restore CPU1_TRK7
			If player=2 Then Restore CPU2_TRK7
			If player=3 Then Restore CPU3_TRK7
		End If
		If TRACKNUMBER=8
			If player=0 Then Restore CPU0_TRK8
			If player=1 Then Restore CPU1_TRK8
			If player=2 Then Restore CPU2_TRK8
			If player=3 Then Restore CPU3_TRK8
		End If
		If TRACKNUMBER=9
			If player=0 Then Restore CPU0_TRK9
			If player=1 Then Restore CPU1_TRK9
			If player=2 Then Restore CPU2_TRK9
			If player=3 Then Restore CPU3_TRK9
		End If									
		If TRACKNUMBER=10
			If player=0 Then Restore CPU0_TRK10
			If player=1 Then Restore CPU1_TRK10
			If player=2 Then Restore CPU2_TRK10
			If player=3 Then Restore CPU3_TRK10
		End If
		; Read CPU Next Move
		Repeat
			Read CP,CPUKEY
		Until CP=TIMECODE Or CP=-1 
		If CP>-1 Then PKEY(player)=CPUKEY
	End If

	If REPLAY=0 Then RECORD(player)
		
	; Turn Keys Allowed Only After Crossing Finish Line.
	If PLYLAP(player)=NUMBEROFLAPS-1
		If PKEY(player)=3 Then PKEY(player)=1
		If PKEY(player)=4 Then PKEY(player)=2
		If PKEY(player)=5 Then PKEY(player)=0
	End If
End Function

;
; Playback Replay
;
Function PLAYBACK(player)
	n=-1
	Repeat
		n=n+1
		PLYTIME=RECORDTIME(player,n) : PLYKEY=RECORDKEY(player,n)
	Until PLYTIME=TIMECODE Or PLYTIME=-1 
	If PLYTIME>-1 Then PKEY(player)=PLYKEY
	
	; Turn Keys Allowed Only After Crossing Finish Line.
	If PLYLAP(player)=NUMBEROFLAPS-1
		If PKEY(player)=3 Then PKEY(player)=1
		If PKEY(player)=4 Then PKEY(player)=2
		If PKEY(player)=5 Then PKEY(player)=0
	End If
End Function

;
; Record
;
Function RECORD(player)
	If RECORDSLOT(player)<250
		If RECORDKEY(player,RECORDSLOT(player))<>PKEY(player)
			RECORDSLOT(player)=RECORDSLOT(player)+1
			RECORDKEY(player,RECORDSLOT(player))=PKEY(player) : RECORDTIME(player,RECORDSLOT(player))=TIMECODE
		End If
	End If
End Function

;
; Save Recorded Data
;
Function SAVERECORD()
; Used To Save Drive Data For CPU Controlled Jet Ski.
; Only Used While Coding. Not Used During Real Game.
		Color 0,0,0
		For n2=0 To 207 Step 2
			For n=0 To 320 Step 2 : Plot n,n2 : Next
			For n=1 To 319 Step 2 : Plot n,n2+1 : Next
		Next
		txt$="SAVE RECORDED DATA"
		DRAWFONTMENU(txt$,101,1)
		Flip
		Repeat
			If KeyHit(21)=1
				TRACKFILE=WriteFile("TrackData/RecordTrack"+TRACKNUMBER+".rec")
				For player=0 To 3
					WriteLine(TRACKFILE,"--------------------------")
					WriteLine(TRACKFILE,"(Track "+Str$(TRACKNUMBER)+")")
					WriteLine(TRACKFILE,"(Player "+Str$(player)+")")
					txt$=""
					For n=0 To 250
						txt$=txt$+","+Str$(RECORDTIME(player,n))+","+Str$(RECORDKEY(player,n))
						If n=29 Then WriteLine(TRACKFILE,"Data "+txt$) : txt$=""
						If n=59 Then WriteLine(TRACKFILE,"Data "+txt$) : txt$=""
						If n=89 Then WriteLine(TRACKFILE,"Data "+txt$) : txt$=""
						If n=119 Then WriteLine(TRACKFILE,"Data "+txt$) : txt$=""
						If n=149 Then WriteLine(TRACKFILE,"Data "+txt$) : txt$=""
						If n=179 Then WriteLine(TRACKFILE,"Data "+txt$) : txt$=""
						If n=209 Then WriteLine(TRACKFILE,"Data "+txt$) : txt$=""
						If n=239 Then WriteLine(TRACKFILE,"Data "+txt$) : txt$=""
					Next
				Next
				CloseFile TRACKFILE
				Exit
			End If
		Until KeyHit(49)=1
End Function

;
; PAUSE
;
Function PAUSE()
	If KeyHit(88)=1
		; Get file number to save
		ScreenDir=ReadDir("Screenshots")
		num=0
		Repeat
			file$=NextFile$(ScreenDir)
			If Left$(file$,10)="Screenshot" Then num=num+1
		Until file$=""
		file$="Screenshots/Screenshot"+Str$(num)+".bmp"
		CloseDir ScreenDir
		SaveBuffer (FrontBuffer(),file$)
		Delay 500
		FreeTimer TIMER
		TIMER=CreateTimer(FPS)
	End If
	If KeyHit(25)=1
		PlaySound(CRASHSFX)
		SetBuffer FrontBuffer()
		DrawImage PAUSEGFX,140,20,0
		For n=0 To 3 : ChannelVolume(ENGINECHANNEL(n),0) : Next
		Repeat
		Until KeyHit(25)=1
		PlaySound(CRASHSFX)
		FlushKeys : FlushJoy : FlushMouse
		For n=0 To 3 : ChannelVolume(ENGINECHANNEL(n),1) : Next
		SetBuffer BackBuffer()
		FreeTimer TIMER
		TIMER=CreateTimer(FPS)
	End If
End Function

;
; Engine Audio, Alter Depending On Speed And Position Of JetSki.
;
Function ENGINEAUDIO(player)
	n=JETS(player)
	If JETJ(player)>0 Then n=5
	
	; Pitch
	If n=0 Then ChannelPitch(ENGINECHANNEL(player),5000)
	If n=1 Then ChannelPitch(ENGINECHANNEL(player),13000)
	If n=2 Then ChannelPitch(ENGINECHANNEL(player),17000)
	If n=3 Then ChannelPitch(ENGINECHANNEL(player),21000)
	If n=4 Then ChannelPitch(ENGINECHANNEL(player),24000)
	If n=5 Then ChannelPitch(ENGINECHANNEL(player),32000)

	; Pan
	xpos=JETX(player)
	If xpos<=44 Then ChannelPan(ENGINECHANNEL(player),-1)
	If xpos>=45 And xpos<=75 Then ChannelPan(ENGINECHANNEL(player),-.75)
	If xpos>=76 And xpos<=106 Then ChannelPan(ENGINECHANNEL(player),-.50)
	If xpos>=107 And xpos<=137 Then ChannelPan(ENGINECHANNEL(player),-.25)
	If xpos>=138 And xpos<=168 Then ChannelPan(ENGINECHANNEL(player),0)
	If xpos>=169 And xpos<=199 Then ChannelPan(ENGINECHANNEL(player),.25)
	If xpos>=200 And xpos<=230 Then ChannelPan(ENGINECHANNEL(player),.50)
	If xpos>=231 And xpos<=261 Then ChannelPan(ENGINECHANNEL(player),.75)
	If xpos>=262 Then ChannelPan(ENGINECHANNEL(player),1)
End Function

;
; Crash Audio
;
Function CRASHAUDIO(player)
	If ChannelPlaying(CRASHCHANNEL(player))=0 Then CRASHCHANNEL(player)=PlaySound(CRASHSFX)
	xpos=JETX(player)
	If xpos<=44 Then ChannelPan(CRASHCHANNEL(player),-1)
	If xpos>=45 And xpos<=75 Then ChannelPan(CRASHCHANNEL(player),-.75)
	If xpos>=76 And xpos<=106 Then ChannelPan(CRASHCHANNEL(player),-.50)
	If xpos>=107 And xpos<=137 Then ChannelPan(CRASHCHANNEL(player),-.25)
	If xpos>=138 And xpos<=168 Then ChannelPan(CRASHCHANNEL(player),0)
	If xpos>=169 And xpos<=199 Then ChannelPan(CRASHCHANNEL(player),.25)
	If xpos>=200 And xpos<=230 Then ChannelPan(CRASHCHANNEL(player),.50)
	If xpos>=231 And xpos<=261 Then ChannelPan(CRASHCHANNEL(player),.75)
	If xpos>=262 Then ChannelPan(CRASHCHANNEL(player),1)
End Function

;
; Buoy Audio
;
Function BUOYAUDIO(player)
	If ChannelPlaying(BUOYCHANNEL(player))=0 Then BUOYCHANNEL(player)=PlaySound(BUOYSFX)
	xpos=JETX(player)
	If xpos<=44 Then ChannelPan(BUOYCHANNEL(player),-1)
	If xpos>=45 And xpos<=75 Then ChannelPan(BUOYCHANNEL(player),-.75)
	If xpos>=76 And xpos<=106 Then ChannelPan(BUOYCHANNEL(player),-.50)
	If xpos>=107 And xpos<=137 Then ChannelPan(BUOYCHANNEL(player),-.25)
	If xpos>=138 And xpos<=168 Then ChannelPan(BUOYCHANNEL(player),0)
	If xpos>=169 And xpos<=199 Then ChannelPan(BUOYCHANNEL(player),.25)
	If xpos>=200 And xpos<=230 Then ChannelPan(BUOYCHANNEL(player),.50)
	If xpos>=231 And xpos<=261 Then ChannelPan(BUOYCHANNEL(player),.75)
	If xpos>=262 Then ChannelPan(BUOYCHANNEL(player),1)
End Function

;
; Track Overview
;
Function TRACKOVERVIEW()
	ClsColor 0,0,0 : Cls : Flip : Delay 1000
	Cls
	DrawBlock TITLEA,31,19
	x=75 : y=64
	Color 0,0,248 : Rect x+10,y,150,100
	For n=0 To 149
		x=x+10
		If x>230 Then x=85 : y=y+10
		If TRACKTILE(n)>-1 Then DrawImage SMALLTILE,x,y,TRACKTILE(n)
		If TRACKTILE(n)=57 Or TRACKTILE(n)=59 Then DrawImage SMALLTILE,x,y,27
		If TRACKTILE(n)=60 Or TRACKTILE(n)=62 Then DrawImage SMALLTILE,x,y,29
		If TRACKTILE(n)=61 Then DrawImage SMALLTILE,x,y,28
		If TRACKTILE(n)>=36 And TRACKTILE(n)<=44 Then DrawImage SMALLTILE,x,y,TRACKTILE(n)-9
		If TRACKTILE(n)>=16 And TRACKTILE(n)<=20 Then DrawImage SMALLTILE,x,y,16
	Next
	txt$="TRACK "+Str$(TRACKNUMBER) : DRAWFONTMENU(txt$,180,1)
	txt$="LAPS "+Str$(NUMBEROFLAPS) : DRAWFONTMENU(txt$,195,1)
	txt$="TIME "+Str$(QTIME1)+"."+Str$(QTIME2) : DRAWFONTMENU(txt$,210,1)
	Flip
End Function

;
; Draw Text
;
Function DRAWFONTSMALL(txt$,x,y)
	For n=1 To Len(txt$)
		char$=Mid$(txt$,n,1)
		n2=Asc(char$)
		If n2=46 Then DrawBlock FONTSMALL,x+(n*4),y,36
		If n2>=48 And n2<=57 Then DrawBlock FONTSMALL,x+(n*4),y,n2-48
		If n2>=65 And n<=90 Then DrawBlock FONTSMALL,x+(n*4),y,n2-55
	Next
End Function

;
; Draw Text Menu Centered
;
Function DRAWFONTMENU(txt$,y,colour)
	x=(304-Len(txt$)*8)/2
	For n=1 To Len(txt$)
		char$=Mid$(txt$,n,1)
		n2=Asc(char$)
		If colour=0
			If n2>=48 And n2<=57 Then DrawBlock FONT,x+(n*8),y,n2-48
			If n2>=65 And n<=90 Then DrawBlock FONT,x+(n*8),y,n2-55
			If n2=46 Then DrawBlock FONT,x+(n*8),y,36
			Else
			If n2>=48 And n2<=57 Then DrawBlock FONTWHITE,x+(n*8),y,n2-48
			If n2>=65 And n<=90 Then DrawBlock FONTWHITE,x+(n*8),y,n2-55
			If n2=46 Then DrawBlock FONTWHITE,x+(n*8),y,36
		End If
	Next
End Function

;
; Race Results
;
Function RACERESULTS()
	
	For n=0 To 3
		For n2=0 To 3
			If REPLAY=0
				; Save Laptimes In Another Variable Before Starting Replay.
				SAVELAPTIMES(n,n2,0)=LAPTIMES(n,n2,0)
				SAVELAPTIMES(n,n2,1)=LAPTIMES(n,n2,1)
				; Reload Correct Laptimes After A Replay Has Been Watched Or Quit From.
				Else
				LAPTIMES(n,n2,0)=SAVELAPTIMES(n,n2,0)
				LAPTIMES(n,n2,1)=SAVELAPTIMES(n,n2,1)
			End If
		Next
	Next

	ClsColor 0,0,0 : Cls : Flip : Delay 1000
	Cls 
	DrawBlock TITLEA,31,19
	If TRACKNUMBER=10
		txt$="CHAMPIONSHIP RESULTS" : DRAWFONTMENU(txt$,64,1)
		Else
		txt$="RACE RESULTS "+Str$(TRACKNUMBER) : DRAWFONTMENU(txt$,64,1)
	End If
	If TRACKNUMBER=10
		txt$="PRESS SPACE OR FIRE" : DRAWFONTMENU(txt$,216,1)
		Else
		txt$="PRESS SPACE OR FIRE TO CONTINUE" : DRAWFONTMENU(txt$,216,1)
	End If
	txt$="R FOR REPLAY" : DRAWFONTMENU(txt$,200,0)
	txt$="PLAYERS" : DRAWFONTSMALL(txt$,50,90)
	txt$="LAPTIME 1" : DRAWFONTSMALL(txt$,50,105)
	txt$="LAPTIME 2" : DRAWFONTSMALL(txt$,50,115)
	txt$="LAPTIME 3" : DRAWFONTSMALL(txt$,50,125)
	txt$="LAPTIME 4" : DRAWFONTSMALL(txt$,50,135)
	txt$="TOTAL TIME" : DRAWFONTSMALL(txt$,50,150)
	txt$="RACE POINTS" : DRAWFONTSMALL(txt$,50,170)
	txt$="CHAMPIONSHIP" : DRAWFONTSMALL(txt$,50,180)
	x=80
	For n=0 To 3
		If PCONTROL(n)<7 Then txt$=PLYNAME$(n) Else txt$="CPU"
		x=x+40 : DRAWFONTSMALL(txt$,x,90)
	Next

	; Display All Lap Times
	y=103
	For n5=0 To NUMBEROFLAPS-1
		n4=106
		For n=0 To 3
			If LAPTIMES(n,n5,0)>0
			txt$="00.0"
			If LAPTIMES(n,n5,0)>-1 And LAPTIMES(n,n5,0)<10 Then txt$="0"+LAPTIMES(n,n5,0)+"."+LAPTIMES(n,n5,1)
			If LAPTIMES(n,n5,0)>9 Then txt$=LAPTIMES(n,n5,0)+"."+LAPTIMES(n,n5,1)
			For n2=1 To 4
				n3=Asc(Mid$(txt$,n2,1))
				If n3<47 Or n3>90 Then n3=91
				If n3>47 And n3<58 Then n3=n3+7
				DrawBlock FONT,n4+(n2*8),y,n3-55
			Next
			Else
			txt$="FAILED" : DRAWFONTSMALL(txt$,n4+9,y+2)
			End If
			n4=n4+40
		Next
		y=y+10
	Next
	
	; Total Times
	For n=0 To 3
		For n2=0 To NUMBEROFLAPS-1
			If LAPTIMES(n,n2,0)=0 And LAPTIMES(n,n2,1)=0
				LAPTIMES(n,0,0)=999 : LAPTIMES(n,1,0)=999 : LAPTIMES(n,2,0)=999 : LAPTIMES(n,3,0)=999
				LAPTIMES(n,0,1)=999 : LAPTIMES(n,1,1)=999 : LAPTIMES(n,2,1)=999 : LAPTIMES(n,3,1)=999
			End If
		Next
	Next
	n4=106
	For n=0 To 3
			txt$="00.0"
			A1=LAPTIMES(n,0,0)+LAPTIMES(n,1,0)+LAPTIMES(n,2,0)+LAPTIMES(n,3,0)
			A2=LAPTIMES(n,0,1)+LAPTIMES(n,1,1)+LAPTIMES(n,2,1)+LAPTIMES(n,3,1)
			If LAPTIMES(n,0,0)=999 Then A1=999 : A2=999
			If A2>9 And A2<>999
				Repeat : A2=A2-10 : A1=A1+1 : Until A2<10	
			End If
			If A1>-1 And A1<10 Then txt$="0"+A1+"."+A2
			If A1>9 Then txt$=A1+"."+A2
		For n2=1 To 4
			n3=Asc(Mid$(txt$,n2,1))
			If n3<47 Or n3>90 Then n3=91
			If n3>47 And n3<58 Then n3=n3+7
			If A1=999 Or A1>99 Then txt$="OUT" : DRAWFONTSMALL(txt$,n4+14,150) : Else DrawBlock FONTWHITE,n4+(n2*8),148,n3-55
		Next
		TOTALTIME(n,0)=A1 : TOTALTIME(n,1)=A2
		n4=n4+40
	Next

	; Determine Which Points Each Player Gets.
	For n=0 To 3 : RACEPOINTS(n)=0 : Next

	For n2=0 To 3
		For n=0 To 3
			If TOTALTIME(n2,0)=TOTALTIME(n,0)
				If TOTALTIME(n2,1)<TOTALTIME(n,1) Then RACEPOINTS(n2)=RACEPOINTS(n2)+1
				Else
				If TOTALTIME(n2,0)<TOTALTIME(n,0) Then RACEPOINTS(n2)=RACEPOINTS(n2)+1
			End If
		Next
	Next

	; Race Points
	n4=128
	For n=0 To 3
		DrawBlock FONT,n4,168,Asc(Str(RACEPOINTS(n)))-48
		n4=n4+40
	Next
	
	; Championship Points
	If REPLAY=0
		For n=0 To 3 : CHAMP_POINTS(n)=CHAMP_POINTS(n)+RACEPOINTS(n) : Next
	End If
	n4=124
	For n=0 To 3
		If Len(Str(CHAMP_POINTS(n)))=1
			DrawBlock FONTWHITE,n4+4,178,Asc(Str(CHAMP_POINTS(n)))-48
		End If
		If Len(Str(CHAMP_POINTS(n)))=2
			DrawBlock FONTWHITE,n4,178,Asc(Left$(Str(CHAMP_POINTS(n)),1))-48
			DrawBlock FONTWHITE,n4+8,178,Asc(Right$(Str(CHAMP_POINTS(n)),1))-48
		End If
		n4=n4+40
	Next
	
	MUSIC=PlaySound(THEME)
	Flip
	FlushKeys : FlushJoy : FlushMouse
	Delay 1000
	REPLAY=0
	Repeat
		If KeyHit(19)=1 Then REPLAY=1 : Exit
	Until KeyHit(28) Or KeyHit(57) Or JoyHit(1,0) Or JoyHit(1,1) Or MouseHit(1)
	StopChannel(MUSIC)
End Function

;
; Game Complete
;
Function GAMECOMPLETE()
	StopChannel(MUSIC)
	ClsColor 0,0,0 : Cls : Flip : Delay 1000
	MUSIC=PlaySound(THEME)
	n=260 : n2=0
	Repeat 
		Cls
		n2=n2+1
		If n2>4 Then n2=0 : n=n-1
		txt$="CHAMPIONSHIP WAVE RACER" : DRAWFONTMENU(txt$,n,1)
		txt$="CREDITS" : DRAWFONTMENU(txt$,n+50,0)
		txt$="PROGRAMMING" : DRAWFONTMENU(txt$,n+90,1)
		txt$="ERIC PARK" : DRAWFONTMENU(txt$,n+110,0)
		txt$="TRACK DESIGN" : DRAWFONTMENU(txt$,n+150,1)
		txt$="BRIAN PARK" : DRAWFONTMENU(txt$,n+170,0)
		txt$="ALLAN PARK" : DRAWFONTMENU(txt$,n+185,0)
		txt$="MUSIC" : DRAWFONTMENU(txt$,n+225,1)
		txt$="DAVE LOWE" : DRAWFONTMENU(txt$,n+245,0)
		txt$="FROM POWER DRIFT" : DRAWFONTMENU(txt$,n+260,0)
		txt$="SEGA ACTIVISION" : DRAWFONTMENU(txt$,n+275,0)
		txt$="2003 PARK PRODUCTIONS" : DRAWFONTMENU(txt$,n+335,1)
		VWait
		Flip
	Until n<-380
	DrawBlock TITLEB,47,65
	txt$="CONGRATULATIONS" : DRAWFONTMENU(txt$,35,1)
	Flip
	FlushKeys : FlushJoy : FlushMouse
	Delay 1000
	Repeat
	Until KeyHit(57) Or JoyHit(1,0) Or JoyHit(1,1) Or MouseHit(1)
	StopChannel(MUSIC)
End Function

;
; Game Over
;
Function GAMEOVER()
	StopChannel(MUSIC)
	ClsColor 0,0,0 : Cls : Flip : Delay 1000
	Cls
	txt$="GAME OVER" : DRAWFONTMENU(txt$,116,1)
	Flip
	FlushKeys : FlushJoy  : FlushMouse
	Delay 4000
	ClsColor 0,0,0 : Cls : Flip
	ClsColor 0,0,0 : Cls : Flip
	Delay 2000
End Function

;
; Get Jet Start Positions
;
Function GETJETSTARTPOS()
	n=-1
	For y=8 To 193 Step 20
		For x=10 To 290 Step 20
			n=n+1
			If TRACKTILE(n)=0 Then JETD(2)=2 : JETF(2)=2 : JETD(3)=2 : JETF(3)=2 : JETX(2)=x+13 : JETY(2)=y : JETX(3)=x+6 : JETY(3)=y+7 : TRACKTILE(n)=-1
			If TRACKTILE(n)=1 Then JETD(0)=2 : JETF(0)=2 : JETD(1)=2 : JETF(1)=2 : JETX(0)=x+7 : JETY(0)=y+6 : JETX(1)=x : JETY(1)=y+13 : TRACKTILE(n)=-1
			If TRACKTILE(n)=2 Then JETD(3)=6 : JETF(3)=6 : JETD(2)=6 : JETF(2)=6 : JETX(3)=x+5 : JETY(3)=y+6 : JETX(2)=x+12 : JETY(2)=y+13 : TRACKTILE(n)=-1
			If TRACKTILE(n)=3 Then JETD(1)=6 : JETF(1)=6 : JETD(0)=6 : JETF(0)=6 : JETX(1)=x-1 : JETY(1)=y : JETX(0)=x+6 : JETY(0)=y+7 : TRACKTILE(n)=-1
			If TRACKTILE(n)=4 Then JETD(0)=14 : JETF(0)=14 : JETD(1)=14 : JETF(1)=14 : JETX(0)=x+6 : JETY(0)=y+5 : JETX(1)=x+13 : JETY(1)=y+12 : TRACKTILE(n)=-1
			If TRACKTILE(n)=5 Then JETD(2)=14 : JETF(2)=14 : JETD(3)=14 : JETF(3)=14 : JETX(2)=x : JETY(2)=y-1 : JETX(3)=x+7 : JETY(3)=y+6 : TRACKTILE(n)=-1
			If TRACKTILE(n)=6 Then JETD(0)=10 : JETF(0)=10 : JETD(1)=10 : JETF(1)=10 : JETX(0)=x+5 : JETY(0)=y+6 : JETX(1)=x+12 : JETY(1)=y-1 : TRACKTILE(n)=-1
			If TRACKTILE(n)=7 Then JETD(2)=10 : JETF(2)=10 : JETD(3)=10 : JETF(3)=10 : JETX(2)=x-1 : JETY(2)=y+12 : JETX(3)=x+6 : JETY(3)=y+5 : TRACKTILE(n)=-1
			If TRACKTILE(n)=8 Then JETD(0)=0 : JETF(0)=0 : JETD(1)=0 : JETF(1)=0 : JETX(0)=x+6 : JETY(0)=y+4 : JETX(1)=x+6 : JETY(1)=y+12 : TRACKTILE(n)=-1
			If TRACKTILE(n)=9 Then JETD(2)=0 : JETF(2)=0 : JETD(3)=0 : JETF(3)=0 : JETX(2)=x+6 : JETY(2)=y : JETX(3)=x+6 : JETY(3)=y+8 : TRACKTILE(n)=-1
			If TRACKTILE(n)=10 Then JETD(3)=8 : JETF(3)=8 : JETD(2)=8 : JETF(2)=8 : JETX(3)=x+6 : JETY(3)=y+4 : JETX(2)=x+6 : JETY(2)=y+12 : TRACKTILE(n)=-1
			If TRACKTILE(n)=11 Then JETD(1)=8 : JETF(1)=8 : JETD(0)=8 : JETF(0)=8 : JETX(1)=x+6 : JETY(1)=y : JETX(0)=x+6 : JETY(0)=y+8 : TRACKTILE(n)=-1
			If TRACKTILE(n)=12 Then JETD(0)=12 : JETF(0)=12 : JETD(1)=12 : JETF(1)=12 : JETX(0)=x+4 : JETY(0)=y+6 : JETX(1)=x+12 : JETY(1)=y+6 : TRACKTILE(n)=-1
			If TRACKTILE(n)=13 Then JETD(2)=12 : JETF(2)=12 : JETD(3)=12 : JETF(3)=12 : JETX(2)=x : JETY(2)=y+6 : JETX(3)=x+8 : JETY(3)=y+6 : TRACKTILE(n)=-1
			If TRACKTILE(n)=14 Then JETD(3)=4 : JETF(3)=4 : JETD(2)=4 : JETF(2)=4 : JETX(3)=x+4 : JETY(3)=y+6 : JETX(2)=x+12 : JETY(2)=y+6 : TRACKTILE(n)=-1
			If TRACKTILE(n)=15 Then JETD(1)=4 : JETF(1)=4 : JETD(0)=4 : JETF(0)=4 : JETX(1)=x : JETY(1)=y+6 : JETX(0)=x+8 : JETY(0)=y+6 : TRACKTILE(n)=-1
		Next
	Next
End Function

;
; Get Buoy Positions And Type.
;
Function GETBUOYPOS()
	; Set x,y positions of buoy detect line to that of each buoy.
	x=-12 : y=10
	For n=0 To 149
		x=x+20
		If x>290 Then x=10 : y=y+20
		If TRACKTILE(n)=16 Then B0=n : BUOYX(0)=x : BUOYY(0)=y
		If TRACKTILE(n)=17 Then B1=n : BUOYX(1)=x : BUOYY(1)=y
		If TRACKTILE(n)=18 Then B2=n : BUOYX(2)=x : BUOYY(2)=y
		If TRACKTILE(n)=19 Then B3=n : BUOYX(3)=x : BUOYY(3)=y
		If TRACKTILE(n)=20 Then B4=n : BUOYX(4)=x : BUOYY(4)=y
	Next
	
	; Determine detect line type, eg. leftbig, downbig, leftsmall, downsmall, or each diagonal.
	; b0
	If B0-3>-1
		If TRACKTILE(B0-3)=16 Then BUOYTYPE(0)=0
	End If
	If B0-45>-1
		If TRACKTILE(B0-45)=16 Then BUOYTYPE(0)=1
	End If
	If B0-2>-1
		If TRACKTILE(B0-2)=16 Then BUOYTYPE(0)=2
	End If
	If B0-30>-1
		If TRACKTILE(B0-30)=16 Then BUOYTYPE(0)=3
	End If
	If B0-28>-1
		If TRACKTILE(B0-28)=16 Then BUOYTYPE(0)=4
	End If
	If B0-32>-1
		If TRACKTILE(B0-32)=16 Then BUOYTYPE(0)=5
	End If
	; b1
	If B1-3>-1
		If TRACKTILE(B1-3)=17 Then BUOYTYPE(1)=0
	End If
	If B1-45>-1
		If TRACKTILE(B1-45)=17 Then BUOYTYPE(1)=1
	End If
	If B1-2>-1
		If TRACKTILE(B1-2)=17 Then BUOYTYPE(1)=2
	End If
	If B1-30>-1
		If TRACKTILE(B1-30)=17 Then BUOYTYPE(1)=3
	End If
	If B1-28>-1
		If TRACKTILE(B1-28)=17 Then BUOYTYPE(1)=4
	End If
	If B1-32>-1
		If TRACKTILE(B1-32)=17 Then BUOYTYPE(1)=5
	End If
	; b2
	If B2-3>-1
		If TRACKTILE(B2-3)=18 Then BUOYTYPE(2)=0
	End If
	If B2-45>-1
		If TRACKTILE(B2-45)=18 Then BUOYTYPE(2)=1
	End If
	If B2-2>-1
		If TRACKTILE(B2-2)=18 Then BUOYTYPE(2)=2
	End If
	If B2-30>-1
		If TRACKTILE(B2-30)=18 Then BUOYTYPE(2)=3
	End If
	If B2-28>-1
		If TRACKTILE(B2-28)=18 Then BUOYTYPE(2)=4
	End If
	If B2-32>-1
		If TRACKTILE(B2-32)=18 Then BUOYTYPE(2)=5
	End If
	; b3
	If B3-3>-1
		If TRACKTILE(B3-3)=19 Then BUOYTYPE(3)=0
	End If
	If B3-45>-1
		If TRACKTILE(B3-45)=19 Then BUOYTYPE(3)=1
	End If
	If B3-2>-1
		If TRACKTILE(B3-2)=19 Then BUOYTYPE(3)=2
	End If
	If B3-30>-1
		If TRACKTILE(B3-30)=19 Then BUOYTYPE(3)=3
	End If
	If B3-28>-1
		If TRACKTILE(B3-28)=19 Then BUOYTYPE(3)=4
	End If
	If B3-32>-1
		If TRACKTILE(B3-32)=19 Then BUOYTYPE(3)=5
	End If
	; b4
	If B4-3>-1
		If TRACKTILE(B4-3)=20 Then BUOYTYPE(4)=0
	End If
	If B4-45>-1
		If TRACKTILE(B4-45)=20 Then BUOYTYPE(4)=1
	End If
	If B4-2>-1
		If TRACKTILE(B4-2)=20 Then BUOYTYPE(4)=2
	End If
	If B4-30>-1
		If TRACKTILE(B4-30)=20 Then BUOYTYPE(4)=3
	End If
	If B4-28>-1
		If TRACKTILE(B4-28)=20 Then BUOYTYPE(4)=4
	End If
	If B4-32>-1
		If TRACKTILE(B4-32)=20 Then BUOYTYPE(4)=5
	End If
	
	; Edit x,y positions of buoy detect line to correct positions from the buoy.
	For n=0 To 4
		If BUOYTYPE(n)=0 Then BUOYX(n)=BUOYX(n)-46 : BUOYY(n)=BUOYY(n)+7
		If BUOYTYPE(n)=1 Then BUOYX(n)=BUOYX(n)+9 : BUOYY(n)=BUOYY(n)-48
		If BUOYTYPE(n)=2 Then BUOYX(n)=BUOYX(n)-26 : BUOYY(n)=BUOYY(n)+7
		If BUOYTYPE(n)=3 Then BUOYX(n)=BUOYX(n)+9 : BUOYY(n)=BUOYY(n)-28
		If BUOYTYPE(n)=4 Then BUOYX(n)=BUOYX(n)+12 : BUOYY(n)=BUOYY(n)-30
		If BUOYTYPE(n)=5 Then BUOYX(n)=BUOYX(n)-28 : BUOYY(n)=BUOYY(n)-30
	Next
End Function

;
; ****** Data Statements ******
;

; Position Of Engine On Jetski, Where Wave Should Start.
.WAVEDATA
Data 0,3,1,2,1,1,2,1,4,0,5,1,6,1,6,2,7,3,6,5,6,6,5,6,3,7,2,6,1,6,1,5

; Direction Of Travel Of JetSki
.DIR0
Data 6,6,6,6,6,6,6
.DIR1
Data 6,6,3,6,3,6,6
.DIR2
Data 6,3,2,6,3,2,3
.DIR3
Data 2,2,3,2,3,2,2
.DIR4
Data 2,2,2,2,2,2,2
.DIR5
Data 2,2,1,2,1,2,2
.DIR6
Data 4,1,2,4,1,2,1
.DIR7
Data 4,4,1,4,1,4,4
.DIR8
Data 4,4,4,4,4,4,4
.DIR9
Data 4,4,7,4,7,4,4
.DIR10
Data 4,7,8,4,7,8,7
.DIR11
Data 8,8,7,8,7,8,8
.DIR12
Data 8,8,8,8,8,8,8
.DIR13
Data 8,8,9,8,9,8,8
.DIR14
Data 6,9,8,6,9,8,9
.DIR15
Data 6,6,9,6,9,6,6

; Track Data
.TRK1
Data 2
Data 32
Data 0
Data 20,-1,-1,-1,-1,-1,36,-1,-1,16,24,102,105,109,88,51,-1,-1,-1,-1,-1,36,8,-1,-1,-1,101,90,84,103
Data 52,-1,20,57,58,59,36,9,-1,-1,-1,-1,-1,-1,54,52,-1,42,60,61,62,40,37,41,16,85,86,-1,-1,82
Data 53,-1,-1,36,66,-1,-1,-1,92,93,105,88,-1,-1,82,37,37,37,40,37,37,41,-1,89,107,108,103,-1,-1,56
Data 51,-1,-1,19,-1,-1,-1,-1,65,99,52,17,-1,-1,17,52,-1,-1,-1,-1,-1,18,92,93,105,52,-1,-1,-1,25
Data 52,19,-1,-1,-1,-1,-1,89,90,90,103,-1,-1,23,21,106,49,49,49,49,50,18,-1,-1,-1,-1,-1,23,21,21

.TRK2
Data 3
Data 48
Data 5
Data 80,108,103,-1,42,39,69,69,39,37,37,37,40,37,41,108,103,-1,-1,17,40,37,37,40,20,-1,-1,-1,-1,98
Data 52,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,99,52,-1,17,-1,-1,-1,-1,48,-1,-1,-1,20,-1,-1,100
Data 52,-1,98,51,-1,-1,85,109,86,-1,-1,26,19,-1,19,52,-1,100,53,-1,-1,87,109,88,-1,-1,-1,-1,-1,98
Data 53,-1,-1,16,-1,-1,-1,90,-1,-1,-1,-1,-1,102,105,-1,-1,-1,7,-1,-1,-1,-1,-1,-1,-1,18,-1,99,109
Data 51,16,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,99,79,106,50,-1,-1,-1,-1,-1,-1,-1,18,-1,-1,102,105,80

.TRK3
Data 2
Data 28
Data 9
Data 79,108,46,47,20,99,108,90,90,90,90,90,90,90,107,108,103,-1,-1,-1,99,106,104,71,-1,-1,-1,-1,19,99
Data 52,-1,-1,-1,-1,99,108,103,72,-1,-1,-1,-1,-1,99,106,104,-1,-1,20,99,106,104,64,-1,-1,19,-1,-1,99
Data 80,52,-1,102,93,105,108,103,102,49,104,26,-1,-1,100,108,103,-1,101,107,108,103,102,105,80,81,-1,18,-1,18
Data 52,-1,-1,16,99,106,49,105,109,108,103,-1,-1,-1,-1,52,-1,8,-1,101,90,90,90,90,103,17,-1,-1,-1,67
Data 106,104,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,85,86,79,106,50,16,48,49,49,49,49,50,17,48,50,87,88

.TRK4
Data 1
Data 20
Data 4
Data 18,-1,-1,-1,57,58,59,14,15,-1,-1,-1,-1,-1,20,-1,-1,-1,-1,60,61,62,37,37,37,37,39,41,-1,43
Data -1,-1,18,-1,36,-1,16,-1,-1,16,-1,36,20,-1,36,37,37,37,37,38,37,37,37,37,39,37,38,39,-1,36
Data -1,-1,-1,65,36,-1,-1,-1,-1,57,58,58,59,-1,36,-1,-1,-1,68,38,39,37,37,37,60,61,61,62,37,38
Data 37,37,39,37,40,40,41,-1,-1,40,64,64,40,37,38,-1,-1,36,-1,17,-1,-1,-1,-1,-1,19,-1,-1,-1,36
Data -1,-1,36,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,36,37,37,40,37,41,-1,17,43,19,-1,-1,-1,42,37,40

.TRK5
Data 4
Data 67
Data 2
Data 108,90,90,90,91,17,89,107,109,79,109,80,108,107,109,52,-1,-1,-1,-1,-1,-1,101,90,90,90,90,103,101,107
Data 52,-1,-1,102,104,17,-1,-1,-1,-1,-1,18,-1,18,99,52,-1,-1,99,106,49,104,-1,-1,-1,-1,-1,-1,102,105
Data 52,-1,-1,99,79,109,52,19,-1,-1,48,49,49,105,79,53,-1,-1,101,107,109,52,-1,-1,-1,89,90,90,107,109
Data 16,-1,-1,16,99,80,52,-1,-1,19,-1,-1,-1,101,107,51,-1,-1,-1,101,90,103,-1,-1,-1,-1,-1,20,-1,99
Data 52,12,13,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,100,106,50,102,83,83,83,83,83,83,83,83,83,83,50,20

.TRK6
Data 2
Data 36
Data 3
Data 108,91,18,89,90,90,90,90,90,90,90,90,90,107,80,53,-1,-1,-1,-1,-1,-1,19,-1,-1,-1,-1,-1,101,107
Data 49,104,18,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,100,79,106,49,49,49,49,104,19,102,49,104,20,-1,-1,20
Data 90,90,107,109,109,109,106,49,105,80,52,-1,-1,-1,98,77,78,99,80,108,90,90,90,90,90,103,-1,-1,-1,99
Data 104,-1,101,90,103,17,-1,-1,-1,-1,16,-1,-1,-1,101,52,-1,-1,-1,-1,-1,70,64,64,71,-1,-1,-1,-1,10
Data 52,-1,-1,-1,-1,-1,69,69,69,72,-1,-1,-1,-1,11,106,49,49,49,104,17,48,49,49,104,16,92,93,93,93

.TRK7
Data 4
Data 40
Data 1
Data 80,80,80,80,80,80,108,90,107,80,80,80,80,108,103,80,79,108,90,90,90,103,18,101,107,109,79,80,52,43
Data 79,108,103,-1,-1,-1,-1,-1,-1,101,107,109,80,52,36,108,103,-1,-1,-1,-1,-1,18,-1,-1,101,90,107,52,36
Data 52,17,-1,17,42,37,39,37,41,19,-1,19,99,52,36,106,104,-1,-1,16,70,44,20,-1,-1,-1,102,105,52,36
Data 80,52,-1,-1,-1,-1,10,-1,-1,-1,-1,101,90,103,36,80,52,-1,-1,-1,-1,11,-1,-1,20,-1,39,37,37,40
Data 80,106,104,-1,16,102,49,49,49,104,65,57,58,58,58,80,80,106,49,49,105,79,80,80,52,42,60,61,61,61

.TRK8
Data 4
Data 37
Data 8
Data 80,79,80,108,46,90,90,90,91,36,89,90,90,107,80,79,80,108,103,-1,-1,73,-1,22,36,-1,-1,18,99,79
Data 108,46,103,-1,-1,-1,74,-1,23,36,-1,-1,-1,101,107,52,-1,-1,-1,-1,102,83,83,104,44,18,-1,-1,-1,99
Data 52,17,-1,17,-1,101,107,80,81,-1,-1,-1,-1,-1,99,52,-1,-1,-1,-1,16,101,84,103,-1,-1,19,-1,19,99
Data 106,104,-1,-1,-1,-1,10,-1,-1,20,-1,-1,-1,102,105,107,106,104,-1,-1,-1,11,22,-1,-1,-1,-1,-1,99,80
Data 101,107,106,104,-1,16,22,24,24,20,-1,-1,-1,99,79,68,101,107,106,49,49,49,49,49,49,49,49,93,105,80

.TRK9
Data 1
Data 20
Data 6
Data 88,17,-1,89,90,90,90,90,90,90,90,91,16,101,107,52,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,99
Data 52,-1,-1,17,43,-1,-1,-1,-1,-1,-1,-1,-1,11,99,52,-1,-1,18,40,37,37,39,37,37,37,41,16,102,105
Data 52,-1,-1,-1,-1,-1,-1,36,-1,-1,-1,19,69,82,109,53,18,-1,-1,-1,-1,-1,36,-1,-1,-1,-1,-1,101,107
Data 37,37,37,41,20,42,37,40,39,19,-1,-1,-1,-1,99,51,-1,-1,-1,-1,-1,-1,-1,44,-1,-1,-1,-1,102,105
Data 52,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,102,93,105,109,106,49,49,50,20,48,49,49,49,49,49,105,109,80,109

.TRK10
Data 4
Data 52
Data 7
Data 19,89,90,90,90,90,90,90,90,90,90,90,90,91,18,51,-1,-1,23,21,21,21,21,21,21,21,22,-1,-1,98
Data 52,-1,19,102,49,49,49,49,49,49,49,104,18,-1,99,52,-1,102,105,109,109,109,109,109,109,109,106,104,-1,99
Data 52,-1,99,109,80,80,80,80,80,80,80,109,52,-1,99,52,-1,99,109,109,109,108,90,107,109,109,109,52,-1,99
Data 52,-1,101,107,109,108,103,16,101,107,109,108,103,-1,99,52,-1,20,101,90,103,8,-1,-1,101,90,103,17,-1,99
Data 53,-1,-1,-1,-1,-1,9,-1,-1,-1,-1,-1,-1,-1,100,20,48,49,49,49,49,50,16,48,49,49,49,49,50,17

; CPU Control
.CPU0_TRK1
Data 0,5,26,4,31,5,52,4,75,5,82,3,88,5,108,4,113,5,132,4,146,5,216,4,239,5,243,3,262,5,266,4,278,2,292,5,303,3,311,5,321,4,327,5,334,3,339,5,352,4,368,5,378,3,381,5,395,3
Data 405,5,413,4,422,2,439,0,440,5,446,3,451,5,457,4,460,5,490,4,507,5,526,3,531,5,577,4,585,5,603,4,607,5,614,4,618,5,622,4,626,5,654,0,657,2,663,0,671,5,674,0,680,5,685,4,690,5,695,4
Data 702,5,722,4,726,5,733,3,741,5,745,3,749,5,762,4,766,5,778,4,780,5,785,4,788,2,795,0,813,1,815,0,830,2,832,0,-1,-1
.CPU1_TRK1
Data 0,0,6,5,20,0,25,5,37,4,41,5,57,4,59,2,82,0,87,1,96,0,97,5,104,4,112,5,118,3,121,5,128,4,132,5,142,4,144,5,201,4,217,5,223,3,227,5,239,4,244,5,252,4,258,5,266,3,272,5
Data 278,4,279,2,295,0,299,5,304,4,312,5,319,3,324,5,332,4,336,5,358,3,362,5,385,4,397,5,408,4,413,5,442,4,455,5,456,4,461,5,465,4,472,5,482,3,489,5,498,4,504,5,512,3,519,5,537,4,546,5
Data 567,4,571,5,615,4,647,5,664,3,676,5,684,4,694,5,707,4,711,5,720,3,724,5,734,0,774,1,780,0,792,2,796,0,804,1,809,0,813,1,831,0,-1,-1
.CPU2_TRK1
Data 0,0,10,5,50,4,77,5,82,3,89,5,96,4,104,5,109,3,118,5,125,4,144,5,148,3,157,5,168,4,171,5,217,0,223,2,226,0,231,5,245,4,249,5,251,0,258,5,261,2,266,0,270,2,273,0,279,5,303,0
Data 307,5,316,2,328,0,333,2,341,0,344,5,353,3,354,1,360,0,367,2,371,0,375,5,380,3,383,5,398,3,402,5,428,0,435,2,439,0,444,2,454,0,457,5,461,3,467,5,475,4,479,5,493,4,505,5,513,4,527,5
Data 555,3,560,5,565,3,570,5,575,4,583,5,598,4,608,5,642,4,648,5,653,4,663,5,675,4,683,5,690,3,697,5,706,4,720,5,735,0,750,1,753,0,785,2,789,0,800,1,803,0,-1,-1
.CPU3_TRK1
Data 0,0,10,5,18,0,25,5,31,0,32,2,36,0,45,5,50,3,54,5,61,3,66,5,73,4,75,5,93,4,121,5,136,3,140,5,146,4,150,5,163,4,168,5,175,4,179,5,188,3,191,5,200,3,204,5,211,4,215,5
Data 244,4,249,5,258,4,275,5,278,0,289,5,302,0,303,1,308,0,314,2,317,0,321,5,327,0,328,2,334,0,343,1,344,0,345,5,366,3,370,5,375,4,379,5,386,4,389,5,422,4,426,5,457,4,461,5,472,4,482,5
Data 489,4,494,5,522,4,535,5,609,4,620,5,673,4,688,5,691,4,710,5,715,3,721,5,726,3,730,5,766,4,769,5,776,4,783,5,795,0,811,2,818,0,825,1,827,0,-1,-1

.CPU0_TRK2
Data 0,5,18,4,24,5,29,3,33,5,40,4,42,5,51,4,55,5,61,4,84,5,89,4,95,5,102,4,118,5,122,3,127,5,139,3,154,5,205,3,210,5,215,3,228,1,236,0,243,2,246,0,256,1,258,0,262,5,280,3
Data 287,5,290,3,332,5,338,4,370,5,395,4,401,5,414,4,419,5,427,4,430,5,438,4,442,5,449,4,452,5,483,4,485,2,515,5,538,3,544,5,552,3,556,5,564,4,571,5,581,3,590,5,595,4,599,5,607,3,611,5
Data 619,3,624,5,637,3,642,5,644,3,662,5,672,4,680,5,694,3,723,5,727,3,754,5,758,4,771,5,776,4,802,5,843,4,847,5,867,3,876,5,888,4,900,5,917,4,938,5,941,3,952,5,976,4,982,5,997,4,1016,5
Data 1022,3,1028,5,1044,3,1051,1,1070,0,1071,5,1080,4,1083,5,1089,3,1094,5,1103,3,1107,5,1119,3,1121,1,1135,0,1140,5,1149,4,1152,5,1167,3,1170,5,1175,3,1198,5,1204,4,1209,5,1223,4,1261,5,1272,4,1284,5,1291,3,1296,5
Data 1306,4,1310,5,1316,3,1320,5,1362,0,-1,-1
.CPU1_TRK2
Data 0,5,22,4,27,5,59,4,92,5,99,4,104,5,124,3,128,5,152,4,155,5,166,3,175,5,194,4,197,5,212,3,217,1,220,0,222,1,233,0,236,5,241,4,247,5,250,4,255,5,257,0,267,1,271,0,274,5,286,4
Data 291,5,296,3,301,5,309,3,321,5,325,4,332,5,335,3,349,5,353,4,359,5,389,4,406,5,445,4,453,5,461,4,466,5,471,4,475,5,479,4,482,5,505,4,520,2,532,0,536,5,547,4,558,5,577,3,594,5,648,3
Data 649,1,656,0,662,5,665,3,666,1,687,0,688,5,692,4,696,2,705,0,707,5,716,4,720,5,724,3,733,5,753,3,798,5,826,4,842,5,853,4,856,5,885,4,893,5,900,4,912,5,920,4,933,5,942,3,944,5,958,4
Data 998,5,1010,4,1016,5,1027,3,1045,5,1051,3,1057,5,1064,4,1069,5,1073,3,1076,5,1081,4,1084,5,1100,0,1106,1,1122,0,1124,5,1155,3,1173,5,1183,0,1184,1,1205,0,1206,5,1215,4,1222,5,1230,3,1234,5,1249,4,1260,5,1301,4
Data 1306,5,1311,4,1314,5,1323,4,1325,5,1336,0,-1,-1
.CPU2_TRK2
Data 0,5,20,4,22,5,25,4,28,5,34,3,41,5,46,4,89,5,95,4,101,5,109,3,114,5,121,0,129,5,138,3,141,5,147,0,150,2,152,4,155,5,156,0,162,1,167,0,170,5,194,0,198,1,201,0,205,5,208,0
Data 210,1,218,0,222,5,227,4,232,5,252,3,253,1,268,0,273,5,275,0,276,2,279,0,285,5,295,3,298,5,305,3,308,5,320,0,332,1,335,5,339,0,340,1,349,0,354,5,369,3,380,5,395,4,400,5,405,4,407,5
Data 415,4,424,2,433,0,444,5,485,4,498,5,505,4,509,5,526,3,529,5,535,3,540,5,545,0,546,2,569,0,575,5,587,4,593,5,595,0,598,5,604,0,613,5,632,3,636,5,642,3,647,5,658,3,662,5,668,4,670,5
Data 674,3,678,5,696,1,707,0,713,1,716,0,724,2,728,0,733,5,743,3,748,5,751,0,752,5,761,4,766,5,771,3,779,5,789,3,791,1,812,0,817,1,820,0,826,2,831,0,833,5,839,3,844,5,865,4,873,5,877,4
Data 886,5,938,4,947,5,955,4,959,5,964,4,968,5,995,4,998,2,1020,0,1026,5,1032,4,1040,5,1052,3,1068,5,1079,3,1082,5,1094,4,1100,5,1123,0,1126,1,1131,0,1144,1,1151,0,1155,5,1161,4,1164,5,1178,3,1184,5,1191,3
Data 1201,1,1215,0,1219,1,1233,0,1245,2,1249,0,1255,2,1258,0,1263,5,1276,3,1278,5,1296,0,1308,2,1315,0,1318,2,1326,0,1333,5,1341,3,1344,5,1365,4,1377,5,1393,0,-1,-1
.CPU3_TRK2
Data 0,5,35,4,41,5,48,4,57,5,62,4,76,5,80,4,83,5,87,4,96,5,101,4,107,5,121,0,122,5,144,3,152,5,155,3,159,5,162,3,166,5,171,3,174,5,187,3,190,5,195,3,199,5,214,3,220,5,229,3
Data 241,5,248,4,253,5,263,4,268,5,287,3,288,1,314,0,322,5,353,0,354,1,359,0,365,5,383,4,388,5,392,4,409,5,418,0,438,5,454,0,462,2,469,0,491,5,503,4,507,5,512,4,518,5,539,4,557,5,567,4
Data 576,5,582,3,588,5,595,4,600,5,609,3,612,5,663,3,669,5,673,3,677,5,690,0,693,2,697,0,704,1,721,0,727,2,732,0,735,5,744,4,745,5,753,0,757,1,764,0,768,5,786,0,790,1,799,0,802,5,808,4
Data 812,5,818,3,825,5,830,3,852,5,870,4,878,5,883,4,890,5,910,4,921,5,967,0,970,2,978,0,982,5,987,4,991,5,997,4,1005,5,1014,4,1017,5,1031,4,1035,5,1040,3,1045,5,1051,4,1057,5,1060,4,1064,5,1069,4
Data 1087,5,1097,4,1107,5,1116,3,1136,5,1188,3,1208,5,1228,3,1231,5,1244,3,1288,5,1302,3,1315,5,1331,4,1353,5,1372,4,1376,5,1381,0,1399,2,1407,0,1408,2,1413,0,1419,1,1424,0,1425,5,1432,4,1436,5,1446,0,1458,2,1461,0
Data 1470,2,1472,0,-1,-1

.CPU0_TRK3
Data 0,5,3,4,7,5,21,0,34,1,36,0,44,5,56,4,58,5,72,3,76,5,89,3,93,5,97,0,102,1,110,0,117,5,122,3,123,1,127,0,134,1,138,0,149,5,156,4,159,5,163,0,166,5,170,0,171,1,176,0
Data 182,5,202,0,207,5,217,3,219,5,245,0,271,1,278,0,282,1,284,0,291,1,294,0,300,1,303,0,307,5,315,4,321,5,327,3,340,5,355,4,359,5,368,3,372,5,379,3,384,5,430,3,436,5,448,3,456,5,472,3
Data 479,5,502,3,533,1,535,0,546,2,550,0,561,5,564,0,566,2,567,0,570,5,591,0,624,1,648,0,656,5,661,4,672,5,689,0,704,1,707,0,714,5,723,3,725,5,746,0,-1,-1
.CPU1_TRK3
Data 0,5,31,4,34,5,48,3,51,5,83,3,91,5,109,3,115,5,144,3,164,5,245,3,262,5,265,3,280,5,289,4,296,5,315,3,329,5,397,3,403,5,422,3,426,5,449,3,453,5,461,3,470,1,492,0,497,2,509,0
Data 512,5,515,3,518,5,552,0,582,5,588,0,589,1,614,0,617,5,626,4,633,5,640,3,644,5,661,3,666,5,669,3,678,5,721,0,-1,-1
.CPU2_TRK3
Data 0,5,20,0,25,2,28,0,38,5,68,3,77,5,83,4,86,5,116,3,123,5,139,3,144,5,149,3,161,5,197,3,227,5,248,4,255,5,297,3,324,5,370,3,389,5,401,4,407,5,429,3,433,5,455,3,464,5,472,3
Data 479,5,490,3,494,5,517,3,553,5,571,4,583,5,626,3,655,5,664,4,669,5,686,3,706,5,726,0,738,2,740,0,764,1,765,0,773,1,776,0,785,2,787,0,799,2,800,0,813,1,815,0,-1,-1
.CPU3_TRK3
Data 0,5,23,4,28,5,40,3,45,5,67,3,77,5,89,3,92,5,102,3,109,5,118,4,143,5,148,3,159,1,167,0,170,5,189,3,217,5,258,3,270,5,274,3,277,5,283,4,291,2,305,0,308,5,342,4,343,2,359,0
Data 360,5,374,0,385,2,409,0,411,5,416,3,424,5,481,3,507,5,550,3,565,5,633,3,645,5,666,3,679,5,686,3,691,5,694,3,708,5,784,3,820,5,852,3,859,5,911,3,914,5,-1,-1

.CPU0_TRK4
Data 0,5,60,4,85,5,108,3,113,5,122,4,129,5,143,4,159,5,181,4,187,5,210,4,218,2,238,0,240,5,245,3,254,5,270,4,273,5,278,3,280,5,289,4,294,5,302,4,306,5,315,4,323,5,338,3,360,5,374,3
Data 383,5,412,3,431,5,439,4,451,5,455,3,460,5,467,3,470,5,478,3,482,5,488,3,493,5,500,4,507,5,511,3,522,5,531,3,534,5,543,4,547,5,555,3,563,5,594,3,597,5,608,4,610,5,628,0,-1,-1
.CPU1_TRK4
Data 0,5,58,4,71,5,74,4,76,5,117,4,120,5,125,4,130,5,133,4,146,5,153,3,158,5,168,3,172,5,179,4,192,2,201,0,208,5,217,2,222,0,226,5,230,3,234,5,242,4,248,5,255,4,258,5,291,3,297,5
Data 305,3,308,5,317,4,319,5,328,3,332,1,347,0,353,5,366,3,373,5,379,3,384,5,389,4,397,5,405,0,406,1,419,0,427,2,431,0,434,5,438,3,441,1,452,0,456,5,476,3,480,5,500,3,511,5,515,3,521,5
Data 534,0,-1,-1
.CPU2_TRK4
Data 0,5,19,4,22,5,29,3,36,5,43,4,47,5,77,4,80,2,98,0,123,5,132,3,135,5,141,4,145,5,148,4,151,5,160,0,163,2,169,0,180,5,190,0,193,5,220,4,227,5,230,4,235,2,252,0,261,2,265,0
Data 273,1,289,0,291,2,304,0,309,1,312,0,319,5,343,4,348,5,353,4,358,5,365,3,381,5,386,3,393,5,412,3,417,5,437,0,439,1,440,0,443,2,449,0,451,1,474,0,476,2,489,0,494,1,500,0,503,5,521,3
Data 524,5,528,4,533,5,546,3,549,5,570,0,575,1,579,0,583,1,597,0,598,5,610,3,613,5,629,3,632,5,637,3,640,5,644,3,653,5,-1,-1
.CPU3_TRK4
Data 0,5,70,4,102,5,110,3,119,5,123,4,129,5,144,3,156,5,160,4,166,5,172,4,202,5,231,3,236,5,247,4,264,5,273,4,278,5,307,4,310,5,315,3,320,5,333,4,345,5,354,4,356,5,372,3,389,5,395,4
Data 398,5,408,3,411,5,417,3,422,5,429,3,462,5,471,4,473,5,485,3,489,5,492,4,499,5,506,3,510,5,538,3,556,5,575,3,594,5,599,0,611,2,613,0,-1,-1

.CPU0_TRK5
Data 0,5,51,4,67,5,75,4,82,5,88,4,91,5,103,3,108,5,166,0,167,2,197,0,199,5,214,3,220,5,235,3,239,5,245,3,252,1,275,0,278,5,282,4,291,5,296,3,300,5,304,4,308,5,312,4,332,5,336,3
Data 337,5,343,4,360,5,374,3,379,5,436,4,445,5,453,4,461,5,475,4,484,5,490,3,494,5,502,4,505,5,512,4,537,5,606,1,641,0,642,5,645,4,651,5,659,3,674,5,682,3,689,5,719,3,738,5,754,4,757,2
Data 786,4,787,5,876,4,886,5,891,4,895,5,904,4,906,5,933,4,942,5,948,4,961,5,1047,4,1048,2,1076,0,1077,5,1085,3,1092,5,1098,4,1102,5,1107,3,1110,5,1116,3,1134,5,1144,3,1166,5,1180,3,1189,5,1192,4,1205,5
Data 1209,4,1213,2,1247,5,1254,3,1258,5,1335,4,1356,5,1364,3,1370,5,1388,4,1401,5,1423,4,1439,5,1479,4,1482,5,1493,3,1494,5,1500,3,1502,5,1527,2,1556,4,1558,5,1567,3,1576,5,1580,4,1585,5,1590,3,1593,5,1597,3,1609,5
Data 1618,3,1631,1,1651,0,1654,5,1661,4,1666,5,1670,4,1677,5,1682,4,1684,5,1691,4,1694,2,1721,0,1722,5,1731,3,1733,5,1802,4,1807,5,1825,4,1835,5,1838,4,1843,5,1873,4,1883,5,1888,3,1895,5,1898,0,-1,-1
.CPU1_TRK5
Data 0,5,28,0,35,5,63,4,77,5,80,0,84,2,98,0,103,5,107,3,114,5,135,4,142,5,153,3,162,5,168,3,172,5,181,4,185,5,195,2,224,0,225,5,242,3,249,5,261,3,269,5,272,3,276,1,301,0,304,5
Data 310,4,317,5,324,3,328,5,336,4,345,5,355,4,365,5,376,0,377,1,391,0,392,5,405,4,408,5,411,4,412,2,424,0,425,5,438,3,440,5,446,3,450,5,504,4,522,5,563,4,584,5,618,4,629,5,638,3,644,5
Data 654,3,658,5,667,1,704,0,707,5,710,4,717,5,724,3,740,5,745,4,749,5,779,3,806,5,827,3,843,1,866,0,869,5,879,3,886,5,902,3,906,5,916,4,929,5,962,4,976,5,986,4,990,5,1017,4,1035,5,1047,3
Data 1051,5,1058,4,1071,5,1089,4,1091,5,1112,0,1118,1,1135,0,1137,2,1153,0,1154,5,1163,3,1165,5,1166,3,1168,1,1179,0,1184,5,1190,3,1197,5,1201,4,1205,5,1208,3,1216,5,1235,4,1239,5,1245,3,1252,1,1281,0,1282,5,1291,4
Data 1296,5,1300,4,1305,5,1308,4,1312,2,1340,0,1342,5,1425,4,1432,5,1438,4,1445,5,1453,4,1457,5,1491,4,1511,5,1539,4,1542,5,1594,2,1624,0,1628,1,1637,0,1638,5,1650,4,1652,5,1660,3,1664,5,1668,3,1672,5,1676,3,1681,5
Data 1684,3,1685,1,1715,0,1717,5,1723,4,1727,5,1741,4,1747,5,1751,4,1756,2,1778,0,1788,2,1791,0,1796,5,1803,3,1806,5,1883,4,1901,5,1913,4,1916,5,1923,4,1927,5,1934,0,1946,2,1951,0,1969,1,1971,0,1986,2,1994,0,2010,1
Data 2013,0,-1,-1
.CPU2_TRK5
Data 0,0,15,5,73,4,94,2,103,0,114,1,119,0,126,2,130,0,133,5,152,3,157,5,186,3,188,5,194,3,197,1,221,0,226,1,229,0,233,5,242,3,247,5,272,3,302,5,344,3,345,1,366,0,376,5,382,3,388,5
Data 397,3,402,5,408,4,418,5,427,3,430,5,443,4,446,5,494,4,521,5,542,3,550,5,561,4,572,5,580,4,596,5,669,0,671,1,700,0,703,5,706,4,710,5,714,3,719,5,724,3,753,5,781,4,787,5,792,4,794,5
Data 798,3,803,1,828,0,832,5,838,4,842,5,847,4,848,2,872,0,874,5,886,4,889,5,892,4,911,5,930,3,934,5,997,4,1007,5,1018,4,1026,5,1065,4,1082,5,1113,4,1123,5,1128,3,1132,5,1142,4,1145,5,1164,3,1165,1
Data 1196,0,1198,5,1208,3,1213,5,1218,4,1222,5,1232,3,1235,5,1240,3,1250,5,1257,4,1259,5,1267,3,1273,5,1278,3,1290,5,1302,3,1308,5,1316,4,1320,5,1327,0,1329,1,1357,5,1378,3,1383,5,1391,4,1394,5,1415,3,1418,5,1436,4
Data 1440,5,1467,4,1480,5,1510,4,1530,5,1557,4,1562,5,1573,4,1577,5,1589,3,1592,5,1600,3,1604,5,1610,3,1614,5,1629,4,1639,2,1663,0,1666,5,1702,3,1705,5,1710,4,1715,5,1722,3,1726,5,1733,3,1737,5,1741,3,1746,5,1748,3
Data 1752,5,1756,3,1761,1,1788,0,1792,5,1797,4,1803,5,1806,4,1816,5,1827,4,1831,5,1843,3,1846,5,1850,4,1854,2,1865,0,1867,1,1882,5,1892,2,1908,0,1909,5,1991,4,2005,5,2037,0,2045,2,2050,0,-1,-1
.CPU3_TRK5
Data 0,5,53,0,55,2,59,0,70,5,80,4,83,2,97,0,105,5,109,3,119,5,122,4,127,5,138,4,144,5,152,3,157,5,164,3,169,5,191,2,220,0,224,5,226,1,228,3,230,5,248,3,253,5,258,3,262,5,274,3
Data 285,1,310,0,311,5,316,4,331,5,335,4,348,2,361,0,363,1,372,0,373,5,379,4,389,5,396,4,400,5,408,3,411,5,440,4,443,5,454,3,457,5,462,3,466,5,484,4,495,5,500,4,505,5,508,4,516,5,542,4
Data 557,5,565,4,575,5,585,3,589,5,652,4,654,2,680,0,682,5,690,4,698,5,710,3,715,5,728,3,733,5,741,3,745,5,749,3,755,1,781,0,783,5,796,4,800,5,813,4,814,2,843,0,846,5,928,4,936,5,954,4
Data 962,5,994,4,1014,5,1020,4,1022,5,1036,3,1040,5,1073,3,1076,5,1081,3,1087,1,1106,0,1109,2,1122,0,1123,5,1133,0,1135,1,1149,0,1152,5,1166,3,1170,5,1180,4,1185,5,1191,3,1200,5,1204,4,1208,5,1216,4,1220,5,1236,3
Data 1237,1,1257,0,1258,5,1267,3,1272,5,1295,3,1298,5,1303,4,1306,5,1315,3,1347,5,1355,3,1360,5,1371,3,1381,5,1396,4,1402,5,1410,4,1415,5,1456,4,1472,5,1478,4,1482,5,1518,4,1523,5,1528,4,1544,5,1575,4,1580,5,1595,3
Data 1602,5,1616,4,1621,5,1627,4,1635,5,1642,4,1644,5,1648,2,1654,0,1658,1,1669,0,1671,5,1675,1,1685,0,1688,5,1696,1,1707,0,1715,5,1719,3,1724,5,1737,3,1741,5,1770,3,1773,1,1798,0,1799,5,1807,4,1810,5,1822,4,1829,2
Data 1855,0,1856,5,1869,4,1879,5,1892,3,1899,5,1903,3,1908,5,1938,4,1942,5,1981,4,2004,5,2008,0,-1,-1

.CPU0_TRK6
Data 0,5,16,4,19,5,27,3,30,5,125,0,126,2,150,0,155,1,158,0,160,5,167,3,170,5,195,0,209,2,244,0,245,5,250,3,254,5,272,3,274,5,291,3,295,5,343,2,364,0,368,1,374,0,377,5,388,4,395,5
Data 398,4,402,5,406,4,412,5,416,4,419,5,427,3,429,5,494,3,498,5,505,4,513,2,530,4,531,5,537,3,540,5,561,0,570,2,596,5,609,4,612,5,629,4,632,5,637,3,647,5,651,4,655,5,667,4,670,5,682,4
Data 685,5,700,3,706,5,724,4,730,5,739,4,760,5,784,4,803,5,810,3,814,5,832,3,833,1,843,0,885,1,887,0,903,1,907,0,935,2,942,0,958,2,961,0,-1,-1
.CPU1_TRK6
Data 0,0,20,5,88,0,120,5,131,0,133,2,154,0,158,1,163,0,166,5,171,4,173,5,189,0,198,2,235,0,238,5,246,4,248,5,257,3,262,5,274,4,277,5,290,3,294,5,329,4,346,5,360,4,371,5,380,4,384,2
Data 403,0,415,1,417,0,424,5,434,3,437,5,446,4,450,5,457,3,466,5,470,4,473,5,488,4,496,5,510,4,513,2,528,0,532,5,550,0,568,2,597,0,602,5,607,3,612,5,622,3,626,5,687,4,689,2,700,0,721,5
Data 740,4,741,2,752,0,764,2,787,4,788,5,799,4,815,5,823,0,835,1,843,0,851,2,855,0,881,1,883,0,891,1,898,0,-1,-1
.CPU2_TRK6
Data 0,0,20,5,28,0,32,1,34,0,42,5,62,3,66,5,72,4,75,5,80,4,89,5,99,3,102,5,109,3,112,5,126,3,129,5,134,4,138,5,153,3,156,5,162,4,166,5,197,4,215,5,224,3,228,5,246,0,264,2
Data 287,4,289,5,298,4,303,5,313,3,326,5,338,4,343,5,402,4,411,5,417,4,423,5,429,0,438,2,443,0,448,2,451,0,473,2,481,0,483,5,488,3,491,5,496,4,500,5,511,3,513,5,528,3,534,5,557,4,558,2
Data 572,0,576,1,582,0,584,2,593,0,601,2,614,4,616,5,641,4,642,2,661,0,663,5,668,3,670,5,689,0,696,2,715,0,719,2,740,4,749,2,775,0,776,5,819,3,824,5,862,4,868,5,872,4,878,5,886,4,906,5
Data 912,4,917,5,932,3,935,5,939,3,942,5,947,3,956,5,965,0,978,2,987,0,994,2,999,0,1012,1,1033,0,1058,1,1060,0,-1,-1
.CPU3_TRK6
Data 0,4,16,5,20,3,40,5,47,4,56,5,60,3,64,5,72,4,76,5,79,4,82,5,87,4,89,5,115,3,117,5,118,4,131,5,142,3,163,5,166,4,171,5,221,0,224,2,243,0,255,5,281,0,284,1,290,0,297,2
Data 302,0,304,5,329,0,343,2,377,0,378,5,385,3,386,5,389,3,391,5,397,3,399,5,416,3,419,5,465,4,476,5,491,4,497,5,506,4,514,5,519,4,524,5,528,4,531,5,535,4,547,5,619,3,628,5,631,4,638,2
Data 664,5,675,3,679,5,695,3,699,5,706,4,709,5,718,0,737,2,763,4,764,5,770,3,774,5,803,3,807,5,863,4,869,5,875,4,879,5,886,4,891,5,911,4,931,5,975,0,-1,-1

.CPU0_TRK7
Data 0,5,23,4,31,5,36,4,42,5,50,4,66,5,71,4,79,5,89,4,95,5,103,3,110,5,123,4,128,2,132,0,136,5,142,4,148,5,157,4,160,5,168,2,183,0,184,5,192,3,196,5,201,4,204,5,210,4,216,5
Data 221,3,225,5,231,4,243,5,255,3,259,5,271,4,280,5,291,4,310,5,321,4,332,5,350,3,354,5,367,4,375,5,392,4,398,5,402,4,407,2,416,0,420,2,423,0,428,2,432,0,435,5,443,3,447,5,482,4,500,5
Data 505,4,515,5,519,4,525,5,531,4,542,5,547,3,558,5,563,3,572,5,575,4,591,5,618,0,619,1,620,3,624,5,627,2,653,0,655,5,662,3,667,1,673,0,675,5,682,4,688,5,695,3,699,5,708,4,715,5,724,3
Data 727,5,742,4,745,5,760,4,765,5,770,4,797,5,858,4,865,5,872,4,879,5,883,4,892,2,904,0,909,5,914,4,935,5,954,4,955,5,957,4,960,5,964,3,975,5,979,4,984,5,1005,4,1010,5,1021,4,1026,5,1033,4
Data 1044,5,1064,0,-1,-1
.CPU1_TRK7
Data 0,5,23,4,42,5,47,3,52,5,55,4,75,5,98,3,103,5,109,4,114,5,118,4,123,5,133,4,137,5,142,4,146,2,157,0,160,5,165,4,181,5,220,4,238,5,250,3,252,5,259,4,295,5,305,3,318,5,325,4
Data 345,5,354,4,358,5,366,3,371,5,375,4,378,2,397,0,398,5,404,3,407,5,448,4,457,5,460,4,467,2,485,0,486,5,496,4,500,5,551,4,552,2,562,0,564,2,570,0,577,5,578,0,580,2,588,0,589,2,593,0
Data 597,1,600,0,602,5,611,3,618,5,623,4,631,5,637,4,641,5,651,3,654,5,663,3,667,5,679,4,709,5,713,3,718,5,759,4,769,5,775,4,781,5,785,4,820,5,843,3,847,5,882,0,883,2,897,0,-1,-1
.CPU2_TRK7
Data 0,5,21,4,28,5,36,4,46,5,51,4,72,5,116,4,121,5,132,4,139,5,147,4,152,5,159,4,189,5,212,4,217,5,221,3,233,5,242,4,246,5,250,4,251,5,285,4,320,5,381,4,387,5,395,4,404,5,406,4
Data 440,5,447,3,460,5,464,4,471,5,492,4,499,5,515,4,520,5,524,4,552,5,593,4,597,5,602,4,610,5,619,4,630,5,633,4,655,5,668,3,669,5,690,4,695,5,718,4,733,5,736,4,748,5,754,4,756,5,764,4
Data 768,5,817,4,823,5,839,4,881,5,886,3,895,5,900,4,908,5,923,3,930,5,952,2,977,0,985,1,991,0,1006,2,1010,0,1026,1,1029,0,1035,1,1038,0,1061,2,1063,0,-1,-1
.CPU3_TRK7
Data 0,5,17,3,24,5,31,4,43,5,47,0,53,5,67,4,71,5,75,4,87,5,96,4,105,5,107,0,113,5,117,3,122,5,146,0,152,2,156,0,164,2,167,0,176,5,187,4,194,5,198,4,209,5,227,0,248,2,251,0
Data 254,5,281,4,285,5,289,4,293,5,301,4,335,5,363,3,368,5,374,4,384,5,391,3,397,5,401,4,405,5,413,3,416,5,422,4,425,5,436,4,439,5,445,4,450,5,452,4,461,2,474,0,477,5,485,4,491,5,499,3
Data 502,5,515,4,520,5,540,4,547,5,551,4,570,5,585,4,598,5,622,3,626,5,637,4,644,5,647,4,650,5,654,4,660,2,669,0,674,5,684,4,694,5,702,4,705,5,714,0,737,5,749,0,750,1,752,3,754,5,762,4
Data 774,2,792,4,793,5,810,3,813,5,826,4,837,5,841,4,846,5,899,4,907,5,914,4,918,5,923,4,927,5,930,4,939,2,952,0,958,5,962,3,965,5,1008,4,1013,2,1017,0,1026,2,1035,0,1041,2,1047,0,-1,-1

.CPU0_TRK8
Data 0,5,20,4,29,5,34,3,38,5,57,4,85,5,91,4,95,5,102,3,105,5,114,4,117,5,134,4,137,5,181,4,193,5,204,4,211,5,219,4,238,5,248,3,251,5,259,3,262,5,270,3,273,5,296,4,303,5,319,4
Data 356,5,361,3,365,5,374,3,378,5,396,3,403,5,406,4,416,5,429,4,434,5,442,3,454,5,463,4,467,5,475,3,480,5,486,4,493,5,507,4,521,5,528,4,531,5,548,4,557,5,568,4,572,5,633,4,646,5,651,3
Data 652,5,665,4,675,5,683,4,699,5,737,4,785,5,793,4,796,5,801,4,810,5,813,4,818,5,829,4,836,5,895,4,903,5,907,4,913,5,919,4,928,5,944,4,950,5,955,4,963,5,984,4,991,5,1005,4,1008,5,1011,3
Data 1021,5,1040,4,1044,5,1068,4,1076,5,1083,4,1097,5,1105,4,1119,5,1125,4,1128,5,1134,4,1140,5,1146,3,1153,5,1160,3,1165,5,-1,-1
.CPU1_TRK8
Data 0,5,21,4,29,5,41,4,45,5,61,4,70,5,74,4,82,5,149,4,179,5,197,4,199,5,225,4,229,5,282,4,293,5,315,4,326,5,331,4,345,5,412,4,432,5,444,4,455,5,465,4,469,5,489,4,495,5,535,4
Data 540,5,548,3,554,5,565,4,576,5,592,4,601,5,607,4,611,5,621,4,625,5,632,4,636,5,641,3,644,5,691,4,725,5,753,4,765,5,823,4,828,5,840,4,846,5,850,4,861,5,870,4,880,5,887,4,896,5,904,4
Data 907,5,963,4,988,5,992,3,997,5,1003,4,1006,5,1018,4,1021,5,1022,4,1039,5,1043,3,1052,5,1076,4,1088,5,1092,3,1102,5,1107,4,1110,5,1114,0,1123,2,1127,0,1135,4,1136,2,1139,5,1140,0,1146,4,1147,2,1167,5,1168,0
Data 1173,4,1174,2,1182,5,1183,0,-1,-1
.CPU2_TRK8
Data 0,5,23,4,28,5,37,4,58,5,66,4,68,5,93,4,102,5,164,4,183,5,189,3,194,5,198,4,218,5,282,4,297,5,304,3,307,5,327,4,342,5,348,4,362,5,378,3,392,5,397,4,406,5,446,4,453,5,459,4
Data 461,5,468,4,472,5,479,4,525,5,531,3,544,5,550,3,557,5,581,4,589,5,604,4,615,5,624,4,629,5,634,4,649,5,671,4,674,5,721,4,731,5,738,4,744,5,748,4,752,5,759,4,768,5,778,4,782,5,798,3
Data 804,5,811,4,817,5,847,4,876,5,908,4,913,5,931,4,936,5,953,4,956,5,961,3,964,5,969,4,975,5,979,3,989,5,997,4,1001,5,1030,4,1049,5,1062,4,1067,5,1074,4,1089,5,1099,3,1103,5,1128,3,1132,5,1143,4
Data 1149,5,1164,0,1166,2,1170,0,1176,2,1181,0,-1,-1
.CPU3_TRK8
Data 0,5,21,4,24,5,32,4,61,5,74,4,78,5,157,4,185,5,212,4,223,5,254,3,259,5,277,4,283,5,317,4,342,5,384,4,388,5,406,4,419,5,451,4,463,5,465,4,477,5,491,4,498,5,570,4,580,5,589,4
Data 594,5,612,4,637,5,646,4,655,5,661,3,671,5,673,4,684,5,692,4,695,5,697,3,711,5,715,4,720,5,728,3,732,5,741,4,744,5,756,4,760,5,777,4,807,5,812,4,822,5,827,3,837,5,841,4,851,5,867,3
Data 874,5,879,4,886,5,893,3,896,5,928,4,940,5,945,4,954,5,964,4,974,5,981,4,988,5,991,4,994,5,1000,4,1005,5,1054,4,1076,5,1097,4,1102,5,1107,4,1111,5,1114,4,1127,5,1172,4,1176,5,-1,-1

.CPU0_TRK9
Data 0,4,5,5,19,3,23,5,31,4,35,5,47,3,49,5,80,4,82,5,101,3,105,1,112,3,114,5,118,3,121,1,133,0,135,5,215,4,221,2,225,0,228,2,245,0,246,5,313,0,314,2,322,0,328,2,341,0,344,5
Data 350,2,358,0,361,5,363,0,365,5,371,3,376,1,381,0,384,5,387,3,390,5,396,4,397,2,404,0,408,5,426,4,429,5,475,0,494,1,512,0,538,5,543,0,551,2,560,0,601,2,615,0,-1,-1
.CPU1_TRK9
Data 0,5,40,4,44,5,54,4,58,5,77,3,81,5,93,3,98,5,110,3,120,5,122,3,124,1,132,0,143,1,149,0,153,1,156,0,164,5,166,4,170,5,181,3,184,5,196,0,199,5,237,4,246,5,254,4,256,2,277,0
Data 280,5,290,4,295,5,304,4,307,5,327,3,331,5,340,0,344,5,351,0,360,2,371,0,375,5,381,0,382,2,387,4,389,5,397,3,399,1,407,0,408,5,414,0,415,2,419,0,420,5,425,0,426,2,429,0,430,5,438,3
Data 443,0,446,5,462,2,480,4,483,5,492,3,495,5,503,0,508,5,514,3,517,5,538,3,542,5,550,3,555,5,562,4,566,5,571,4,580,5,587,0,593,1,597,0,-1,-1
.CPU2_TRK9
Data 0,5,38,4,40,5,48,3,51,5,74,4,78,5,83,3,87,5,98,3,102,5,111,3,119,5,125,3,134,1,147,0,149,1,158,3,161,5,167,4,168,2,174,5,205,4,209,5,244,4,245,2,268,4,269,5,279,4,284,2
Data 285,0,286,5,306,3,310,5,319,3,323,5,350,4,352,2,358,0,364,2,373,0,376,5,380,4,381,2,391,0,392,5,408,3,409,1,427,5,446,2,464,4,468,5,477,3,488,5,494,4,502,5,510,3,513,5,531,3,539,5
Data 549,3,554,5,559,4,564,5,573,4,579,5,605,0,-1,-1
.CPU3_TRK9
Data 0,5,16,4,23,5,27,3,32,5,34,3,35,1,38,0,40,5,46,4,49,5,115,0,116,1,133,5,139,3,144,5,158,3,165,5,176,3,180,1,184,0,188,5,191,4,193,5,202,4,205,5,228,3,230,5,241,4,242,2
Data 247,4,249,2,254,0,256,5,265,4,279,2,288,5,300,4,304,5,315,4,320,5,351,3,355,5,393,4,395,2,405,0,411,2,418,4,420,5,427,3,429,5,435,4,439,5,445,4,446,2,455,0,459,1,465,3,467,5,472,4
Data 474,2,487,4,488,5,493,3,496,5,521,3,524,5,532,4,536,5,544,4,550,5,559,4,565,5,584,0,-1,-1

.CPU0_TRK10
Data 0,5,19,4,23,5,32,3,38,5,44,4,47,5,57,4,60,5,70,3,102,5,117,4,121,5,127,3,130,5,151,3,179,5,193,4,197,5,272,3,280,5,289,3,294,5,337,3,360,5,369,4,373,5,449,3,471,5,512,3
Data 529,5,634,3,649,5,688,4,692,5,700,4,702,5,710,3,735,5,743,4,755,5,806,3,813,5,816,3,829,5,833,4,839,5,875,3,897,5,994,3,1027,5,1042,4,1057,5,1062,3,1072,5,1076,3,1101,5,1115,4,1120,5,1191,3
Data 1221,5,1240,4,1243,5,1247,4,1256,5,1261,3,1303,5,1309,4,1315,5,1400,3,1414,5,1418,3,1428,5,1440,4,1444,5,1474,3,1503,5,1510,4,1518,5,1586,0,-1,-1
.CPU1_TRK10
Data 0,5,29,4,33,5,59,3,67,1,86,0,87,5,93,4,99,5,106,3,109,5,123,4,128,5,133,3,134,1,154,0,155,5,170,4,172,5,254,3,275,5,280,3,285,5,305,4,310,5,315,3,321,5,329,4,333,5,339,3
Data 345,5,357,3,362,5,366,3,369,5,379,4,383,5,399,4,401,5,406,3,409,5,436,4,440,5,461,3,468,5,477,3,490,5,529,3,554,5,562,4,565,5,651,3,681,5,690,4,699,5,723,3,745,5,841,3,863,5,876,4
Data 880,5,910,3,939,5,944,4,951,5,963,4,966,5,1035,3,1042,5,1047,4,1050,5,1053,3,1056,5,1062,3,1066,5,1101,3,1124,5,1151,4,1155,5,1217,3,1247,5,1251,4,1258,5,1268,4,1273,5,1284,3,1312,5,1320,4,1323,5,1330,4
Data 1334,5,1348,3,1352,5,1359,4,1362,5,1406,3,1411,5,1427,4,1430,5,1435,3,1443,5,1454,3,1456,5,1475,3,1495,5,1565,0,-1,-1
.CPU2_TRK10
Data 0,5,56,3,60,5,63,3,88,5,96,4,100,5,126,3,144,5,240,3,245,5,258,3,263,5,303,3,328,5,358,4,363,5,412,3,416,5,422,3,451,5,476,4,481,5,495,3,504,5,508,3,517,5,627,3,655,5,662,4
Data 669,5,705,3,724,5,730,3,735,5,752,4,757,5,825,3,838,5,842,3,848,5,891,3,922,5,936,4,940,5,1018,3,1026,5,1036,3,1043,5,1048,3,1052,5,1093,3,1120,5,1128,4,1136,5,1210,3,1234,5,1268,3,1271,5,1281,4
Data 1285,5,1295,3,1324,5,1349,4,1353,5,1361,3,1364,5,1429,3,1436,5,1439,3,1459,5,1488,4,1497,5,1511,0,1513,1,1532,5,1560,4,1563,5,1595,0,-1,-1
.CPU3_TRK10
Data 0,5,23,4,26,5,39,3,42,5,51,3,55,5,60,3,81,5,100,4,104,5,108,3,112,5,115,4,130,5,134,0,144,4,148,5,151,3,171,5,174,4,181,5,188,3,190,5,248,4,250,5,260,4,264,5,268,3,274,5
Data 284,3,294,5,298,4,302,5,314,4,316,5,329,3,334,5,336,3,360,5,374,4,377,5,383,4,388,5,400,3,404,5,412,4,416,5,429,4,432,5,456,3,484,5,497,4,504,5,515,3,538,5,646,3,669,5,692,4,698,5
Data 711,3,737,5,749,4,753,5,820,3,827,5,835,4,838,5,841,3,848,5,852,3,866,5,875,4,879,5,895,3,910,5,916,3,920,5,927,3,931,5,1019,3,1027,5,1029,3,1046,5,1073,4,1080,5,1098,3,1111,5,1202,3,1226,5
Data 1253,4,1256,5,1268,3,1278,5,1281,3,1293,5,1394,3,1427,5,1442,4,1449,5,1455,3,1460,5,1468,4,1472,5,1478,3,1481,5,1493,3,1512,5,1535,4,1538,5,1554,4,1558,5,1561,4,1568,2,1571,0,1616,1,1618,0,-1,-1